/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.x509_certificate_gui;

import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.net.URL;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Pair;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CertificatePanel
extends BorderPane
implements Initializable {
    private static Logger LOG = LoggerFactory.getLogger(X509CertificatePanel.class);
    private String certificatePEMString;
    private X509Certificate certificate;
    private boolean showPemCertificate = true;
    @FXML
    private Label pemLabel;
    @FXML
    private TextArea pemText;
    @FXML
    private TextArea subjectText;
    @FXML
    private Label subjectAltLabel;
    @FXML
    private TextArea subjectAltText;
    @FXML
    private TextArea issuerText;
    @FXML
    private Label issuerAltLabel;
    @FXML
    private TextArea issuerAltText;
    @FXML
    private TextField validFromText;
    @FXML
    private TextField validToText;
    @FXML
    private TextArea pubKeyOpenSSHText;
    private static Stage x509certificateStage = null;
    private static X509CertificatePanel x509certificatePanel = null;

    public X509CertificatePanel() {
        FXMLUtil.injectFXML((Object)this);
    }

    public void setCertificatePEMString(String certificatePEMString) {
        this.certificatePEMString = certificatePEMString;
        this.showCertificate();
    }

    private static String altIntToString(int altNr) {
        switch (altNr) {
            case 0: {
                return "otherName";
            }
            case 1: {
                return "rfc822Name";
            }
            case 2: {
                return "dNSName";
            }
            case 3: {
                return "x400Address";
            }
            case 4: {
                return "directoryName";
            }
            case 5: {
                return "ediPartyName";
            }
            case 6: {
                return "uniformResourceIdentifier";
            }
            case 7: {
                return "iPAddress";
            }
            case 8: {
                return "registeredID";
            }
        }
        return "invalid alt name type (" + altNr + ")";
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.pemLabel.managedProperty().bind((ObservableValue)this.pemLabel.visibleProperty());
        this.pemText.managedProperty().bind((ObservableValue)this.pemText.visibleProperty());
        this.subjectAltLabel.managedProperty().bind((ObservableValue)this.subjectAltLabel.visibleProperty());
        this.issuerAltLabel.managedProperty().bind((ObservableValue)this.issuerAltLabel.visibleProperty());
        this.subjectAltText.managedProperty().bind((ObservableValue)this.subjectAltText.visibleProperty());
        this.issuerAltText.managedProperty().bind((ObservableValue)this.issuerAltText.visibleProperty());
        this.pubKeyOpenSSHText.managedProperty().bind((ObservableValue)this.pubKeyOpenSSHText.visibleProperty());
        this.pemLabel.visibleProperty().bind((ObservableValue)this.pemText.visibleProperty());
        this.subjectAltLabel.visibleProperty().bind((ObservableValue)this.subjectAltText.visibleProperty());
        this.issuerAltLabel.visibleProperty().bind((ObservableValue)this.issuerAltText.visibleProperty());
    }

    public void setPemVisible(boolean showPemCertificate) {
        this.showPemCertificate = showPemCertificate;
        this.pemLabel.setVisible(this.showPemCertificate);
    }

    public void showCertificate() {
        this.certificate = KeyUtil.pemToX509Certificate((String)this.certificatePEMString);
        this.pemText.setText(this.certificatePEMString);
        if (this.certificate == null) {
            this.subjectText.setText("");
            this.issuerText.setText("");
            this.validFromText.setText("");
            this.validToText.setText("");
            this.pubKeyOpenSSHText.setText("");
            this.subjectAltText.setVisible(false);
            this.issuerAltText.setVisible(false);
        } else {
            Integer nameType;
            Object alts2;
            this.subjectText.setText(this.certificate.getSubjectX500Principal().toString());
            this.issuerText.setText(this.certificate.getIssuerX500Principal().toString());
            this.validFromText.setText(this.certificate.getNotBefore().toString());
            this.validToText.setText(this.certificate.getNotAfter().toString());
            this.pubKeyOpenSSHText.setText("");
            this.subjectAltText.setVisible(false);
            this.issuerAltText.setVisible(false);
            Collection<List<?>> altNames = null;
            try {
                altNames = this.certificate.getSubjectAlternativeNames();
            }
            catch (CertificateParsingException certificateParsingException) {
                // empty catch block
            }
            if (altNames != null && !altNames.isEmpty()) {
                this.subjectAltText.setVisible(true);
                alts2 = "";
                for (List<?> altName : altNames) {
                    nameType = (Integer)altName.get(0);
                    if (((String)alts2).length() > 0) {
                        alts2 = (String)alts2 + "\n";
                    }
                    alts2 = (String)alts2 + X509CertificatePanel.altIntToString(nameType) + " -> " + altName.get(1).toString();
                }
                this.subjectAltText.setText((String)alts2);
            } else {
                this.subjectAltText.setVisible(false);
            }
            altNames = null;
            try {
                altNames = this.certificate.getIssuerAlternativeNames();
            }
            catch (CertificateParsingException alts2) {
                // empty catch block
            }
            if (altNames != null && !altNames.isEmpty()) {
                this.issuerAltText.setVisible(true);
                alts2 = "";
                for (List<?> altName : altNames) {
                    nameType = (Integer)altName.get(0);
                    if (((String)alts2).length() > 0) {
                        alts2 = (String)alts2 + "\n";
                    }
                    alts2 = (String)alts2 + X509CertificatePanel.altIntToString(nameType) + " -> " + altName.get(1).toString();
                }
                this.issuerAltText.setText((String)alts2);
            } else {
                this.issuerAltText.setVisible(false);
            }
            if (this.certificate.getPublicKey() instanceof RSAPublicKey) {
                this.pubKeyOpenSSHText.setText(KeyUtil.rsaPublicKeyToOpenSshAuthorizedKeysFormat((RSAPublicKey)((RSAPublicKey)this.certificate.getPublicKey())));
            } else {
                this.pubKeyOpenSSHText.setText("(not an RSA key)");
            }
        }
    }

    public static Pair<Stage, X509CertificatePanel> showX509Certificate(String x509CertificatePem) {
        return X509CertificatePanel.showX509Certificate(x509CertificatePem, null);
    }

    private static Pair<Stage, X509CertificatePanel> showX509Certificate(@Nullable String x509CertificatePem, @Nullable Stage stage) {
        try {
            if (x509certificateStage == null) {
                x509certificatePanel = new X509CertificatePanel();
                x509certificatePanel.setCertificatePEMString(x509CertificatePem);
                Scene scene = new Scene((Parent)x509certificatePanel);
                x509certificateStage = stage != null ? stage : new Stage();
                x509certificateStage.setScene(scene);
            }
            if (stage != null) assert (x509certificateStage == stage);
            assert (x509certificateStage != null);
            x509certificateStage.show();
            return new Pair((Object)x509certificateStage, (Object)x509certificatePanel);
        }
        catch (Exception e) {
            throw new RuntimeException("Something went wrong showing the X509certificate: " + e.getMessage(), e);
        }
    }
}

