/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.connection;

import be.iminds.ilabt.jfed.lowlevel.connection.HttpInfoXmlRpcTransportFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcHttpClientConfig;
import org.apache.xmlrpc.client.XmlRpcHttpTransport;
import org.apache.xmlrpc.client.XmlRpcStreamTransport;
import org.apache.xmlrpc.client.XmlRpcTransport;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.util.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class CommonsHttpClientXmlRpcTransportFactory
implements HttpInfoXmlRpcTransportFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CommonsHttpClientXmlRpcTransportFactory.class);
    private final XmlRpcClient xmlRpcClient;
    private String httpResult = null;
    private String httpSent = null;
    private String httpRequestHeaders = null;
    private String httpResponseHeaders = null;
    private List<Header> rawHttpResponseHeaders = null;
    private StatusLine httpResultStatusLine = null;
    private String httpRequestLine = null;
    private final MyXmlRpcTransport transport;

    public CommonsHttpClientXmlRpcTransportFactory(XmlRpcClient xmlRpcClient, HttpClientBuilder httpClientBuilder, HttpContext httpContext) {
        this.xmlRpcClient = xmlRpcClient;
        this.transport = new MyXmlRpcTransport(httpClientBuilder, httpContext);
    }

    @Override
    public String getHttpReceivedHistory() {
        return this.httpResult;
    }

    @Override
    public String getHttpSentHistory() {
        return this.httpSent;
    }

    @Override
    public StatusLine getHttpStatusLine() {
        return this.httpResultStatusLine;
    }

    @Override
    public String getHttpRequestLine() {
        return this.httpRequestLine;
    }

    @Override
    public String getHttpRequestHeaders() {
        return this.httpRequestHeaders;
    }

    @Override
    public String getHttpResponseHeaders() {
        return this.httpResponseHeaders;
    }

    @Override
    public List<Header> getRawHttpResponseHeaders() {
        if (this.rawHttpResponseHeaders == null) {
            return null;
        }
        return this.rawHttpResponseHeaders;
    }

    private void resetHttpHistory() {
        this.httpResult = null;
        this.httpRequestHeaders = null;
        this.httpResultStatusLine = null;
        this.httpRequestLine = null;
        this.httpResponseHeaders = null;
        this.rawHttpResponseHeaders = null;
        this.httpSent = null;
    }

    @Override
    public void clearLastCallData() {
        this.resetHttpHistory();
    }

    @Override
    public void close() {
        try {
            this.transport.close();
        }
        catch (XmlRpcClientException ignored) {
            LOG.info("Error while closing transport: {}", (Object)ignored.getMessage(), (Object)ignored);
        }
        this.resetHttpHistory();
    }

    public XmlRpcTransport getTransport() {
        return this.transport;
    }

    @Override
    public void setProperty(String s, Object o) {
    }

    @Nonnull
    private static String logHeaders(Header[] allHeaders) {
        StringBuilder headers = new StringBuilder();
        for (Header header : allHeaders) {
            headers.append(header.toString()).append("\n");
        }
        headers.append("\n");
        return headers.toString();
    }

    class MyXmlRpcTransport
    extends XmlRpcHttpTransport {
        private final HttpClientBuilder httpClientBuilder;
        private final HttpContext httpContext;
        private CredentialsProvider credsProvider;
        private CloseableHttpClient httpClient;
        private HttpPost method;
        private int contentLength;
        private CloseableHttpResponse response;
        private InputStream responseInputStream;

        public MyXmlRpcTransport(HttpClientBuilder httpClientBuilder, HttpContext httpContext) {
            super(CommonsHttpClientXmlRpcTransportFactory.this.xmlRpcClient, null);
            this.credsProvider = null;
            this.httpClient = null;
            this.method = null;
            this.httpClientBuilder = httpClientBuilder;
            this.httpContext = httpContext;
        }

        protected void initHttpHeaders(XmlRpcRequest pRequest) throws XmlRpcClientException {
            XmlRpcHttpClientConfig config = (XmlRpcHttpClientConfig)pRequest.getConfig();
            this.method = new HttpPost(config.getServerURL().toString());
            super.initHttpHeaders(pRequest);
        }

        protected void setRequestHeader(String pHeader, String pValue) {
            if (!Objects.equals(pHeader, "User-Agent")) {
                this.method.setHeader(pHeader, pValue);
            }
        }

        protected void close() throws XmlRpcClientException {
            try {
                if (this.response != null) {
                    this.response.close();
                }
            }
            catch (IOException e) {
                throw new XmlRpcClientException("Error while closing HttpClient", (Throwable)e);
            }
        }

        protected boolean isResponseGzipCompressed(XmlRpcStreamRequestConfig pConfig) {
            Header h = this.response.getFirstHeader("Content-Encoding");
            return h != null && HttpUtil.isUsingGzipEncoding((String)h.getValue());
        }

        protected InputStream getInputStream() throws XmlRpcException {
            return this.responseInputStream;
        }

        protected void setContentLength(int pLength) {
            this.contentLength = pLength;
        }

        protected void writeRequest(XmlRpcStreamTransport.ReqWriter pWriter) throws XmlRpcException, IOException, SAXException {
            ByteArrayOutputStream bOutRequest = new ByteArrayOutputStream(this.contentLength);
            pWriter.write((OutputStream)bOutRequest);
            CommonsHttpClientXmlRpcTransportFactory.this.httpSent = bOutRequest.toString();
            BasicHttpEntity requestEntity = new BasicHttpEntity();
            requestEntity.setContent((InputStream)new ByteArrayInputStream(bOutRequest.toByteArray()));
            requestEntity.setContentLength((long)this.contentLength);
            this.method.setEntity((HttpEntity)requestEntity);
            CommonsHttpClientXmlRpcTransportFactory.this.httpRequestLine = this.method.getRequestLine().toString();
            CommonsHttpClientXmlRpcTransportFactory.this.httpRequestHeaders = CommonsHttpClientXmlRpcTransportFactory.logHeaders(this.method.getAllHeaders());
            if (this.credsProvider != null) {
                LOG.info("Setting CredentialsProvider to {}", (Object)this.credsProvider);
                this.httpClientBuilder.setDefaultCredentialsProvider(this.credsProvider);
            }
            this.httpClient = this.httpClientBuilder.build();
            try {
                this.response = this.httpClient.execute((HttpUriRequest)this.method, this.httpContext);
                if (this.response.getStatusLine() != null) {
                    CommonsHttpClientXmlRpcTransportFactory.this.httpResultStatusLine = this.response.getStatusLine();
                }
                if (this.response.getAllHeaders() != null) {
                    CommonsHttpClientXmlRpcTransportFactory.this.httpResponseHeaders = CommonsHttpClientXmlRpcTransportFactory.logHeaders(this.response.getAllHeaders());
                    CommonsHttpClientXmlRpcTransportFactory.this.rawHttpResponseHeaders = Arrays.asList(this.response.getAllHeaders());
                }
                if (this.response.getEntity() != null) {
                    ByteArrayOutputStream bOutResponse = new ByteArrayOutputStream();
                    this.response.getEntity().writeTo((OutputStream)bOutResponse);
                    CommonsHttpClientXmlRpcTransportFactory.this.httpResult = bOutResponse.toString();
                    this.responseInputStream = new ByteArrayInputStream(bOutResponse.toByteArray());
                }
                if (this.response.getStatusLine() != null && (this.response.getStatusLine().getStatusCode() == 500 || this.response.getStatusLine().getStatusCode() == 503)) {
                    throw new HttpInfoXmlRpcTransportFactory.HttpServerErrorException(this.response.getStatusLine().getStatusCode(), this.response.getStatusLine().getReasonPhrase());
                }
            }
            catch (SSLPeerUnverifiedException ex) {
                throw new XmlRpcClientException("The server certificate for '" + this.method.getURI() + "' could not be verified. Error message \"" + ex.getMessage() + "\". Possible causes:\n  - The server's self-signed certificate is not in our trust store. \n  - The server's certificate \"CN\" field is not the server hostname or a known alias. \n  - The server is not accepting our client login certificate+key pair (perhaps is is not federated with our \"login provider\"). \n  - If the server's certificate is not self signed, we might not have the root certificate of the trust chain in our trust store.", (Throwable)ex);
            }
            catch (SSLException ex) {
                this.method.abort();
                throw new XmlRpcClientException("SSLException: " + ex.getMessage(), (Throwable)ex);
            }
            catch (HttpInfoXmlRpcTransportFactory.HttpServerErrorException ex) {
                this.method.abort();
                throw new XmlRpcClientException("HTTP Server error", (Throwable)ex);
            }
        }

        protected void setCredentials(XmlRpcHttpClientConfig pConfig) throws XmlRpcClientException {
            if (pConfig.getBasicUserName() != null) {
                int port = pConfig.getServerURL().getPort() <= 0 ? pConfig.getServerURL().getDefaultPort() : pConfig.getServerURL().getPort();
                this.credsProvider = new BasicCredentialsProvider();
                this.credsProvider.setCredentials(new AuthScope(pConfig.getServerURL().getHost(), port), (Credentials)new UsernamePasswordCredentials(pConfig.getBasicUserName(), pConfig.getBasicPassword()));
            }
        }
    }
}

