/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.connection;

import be.iminds.ilabt.jfed.lowlevel.connection.HandleUntrustedCallback;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import be.iminds.ilabt.jfed.util.library.LoginInfo;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.annotation.Nullable;

public class ConnectionConfig {
    private final String serverUrlString;
    private final URL serverUrl;
    @Nullable
    private final JFedConnection.DebugInfo debugInfo;
    private final JFedConnection.ProxyInfo proxyInfo;
    private final Authentication authentication;
    private final LoginInfo login;
    private final List<X509Certificate> clientCertChain;
    private final PrivateKey privateKey;
    private final Protocol protocol;
    private final JFedTrustStore conTrustStore;
    private final HandleUntrustedCallback handleUntrustedCallback;
    private final Type type;

    public ConnectionConfig(String serverUrlString, @Nullable JFedConnection.DebugInfo debugInfo, JFedConnection.ProxyInfo proxyInfo, Authentication authentication, LoginInfo login, List<X509Certificate> clientCertChain, PrivateKey privateKey, Protocol protocol, JFedTrustStore conTrustStore, HandleUntrustedCallback handleUntrustedCallback, Type type) throws MalformedURLException {
        this.serverUrlString = serverUrlString;
        this.serverUrl = serverUrlString == null ? null : new URL(serverUrlString);
        this.debugInfo = debugInfo;
        this.proxyInfo = proxyInfo;
        this.authentication = authentication;
        this.login = login;
        this.clientCertChain = clientCertChain;
        this.privateKey = privateKey;
        this.protocol = protocol;
        this.conTrustStore = conTrustStore;
        this.handleUntrustedCallback = handleUntrustedCallback;
        this.type = type;
    }

    public ConnectionConfig(URL serverUrl, @Nullable JFedConnection.DebugInfo debugInfo, JFedConnection.ProxyInfo proxyInfo, Authentication authentication, LoginInfo login, List<X509Certificate> clientCertChain, PrivateKey privateKey, Protocol protocol, JFedTrustStore conTrustStore, HandleUntrustedCallback handleUntrustedCallback, Type type) {
        this.serverUrl = serverUrl;
        this.serverUrlString = serverUrl == null ? null : serverUrl.toExternalForm();
        this.debugInfo = debugInfo;
        this.proxyInfo = proxyInfo;
        this.authentication = authentication;
        this.login = login;
        this.clientCertChain = clientCertChain;
        this.privateKey = privateKey;
        this.protocol = protocol;
        this.conTrustStore = conTrustStore;
        this.handleUntrustedCallback = handleUntrustedCallback;
        this.type = type;
    }

    public String getServerUrlString() {
        return this.serverUrlString;
    }

    public URL getServerUrl() {
        return this.serverUrl;
    }

    @Nullable
    public JFedConnection.DebugInfo getDebugInfo() {
        return this.debugInfo;
    }

    public JFedConnection.ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public LoginInfo getLogin() {
        return this.login;
    }

    public List<X509Certificate> getClientCertChain() {
        return this.clientCertChain;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public JFedTrustStore getConTrustStore() {
        return this.conTrustStore;
    }

    public HandleUntrustedCallback getHandleUntrustedCallback() {
        return this.handleUntrustedCallback;
    }

    public Type getType() {
        return this.type;
    }

    public static enum Authentication {
        NONE,
        HTTP_BASIC,
        SSL_CLIENT_AUTH;

    }

    public static enum Protocol {
        HTTP,
        HTTPS;

    }

    public static enum Type {
        HTTP,
        SFA;

    }
}

