/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.library;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.ElementProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtil {
    private static final Logger LOG = LoggerFactory.getLogger(XmlUtil.class);

    public static String formatXmlFromString(String unformattedXmlString) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setAttribute("indent-number", 4);
            Transformer t = tf.newTransformer();
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("omit-xml-declaration", "no");
            t.setOutputProperty("encoding", "UTF-8");
            t.setOutputProperty("doctype-public", "yes");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            StringWriter out = new StringWriter();
            t.transform(new StreamSource(new StringReader(unformattedXmlString)), new StreamResult(out));
            return ((Object)out).toString();
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public static String formatXmlFromString_alwaysSafe(String unformattedXmlString) {
        try {
            return XmlUtil.formatXmlFromString(unformattedXmlString);
        }
        catch (Exception e) {
            return unformattedXmlString;
        }
    }

    public static String elementToXmlString(Element el) {
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            StringWriter buffer = new StringWriter();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(el), new StreamResult(buffer));
            return buffer.toString();
        }
        catch (TransformerConfigurationException e) {
            LOG.error("TransformerConfigurationException in getCurrentRequestRspec()", (Throwable)e);
        }
        catch (TransformerException e) {
            LOG.error("TransformerException in getCurrentRequestRspec()", (Throwable)e);
        }
        return "error converting DOM element to Xml";
    }

    public static Document parseXmlFromStringMakeExceptionsRuntime(String in) {
        return XmlUtil.parseXmlFromStringMakeExceptionsRuntime(in, false);
    }

    public static Document parseXmlFromStringMakeExceptionsRuntime(String in, boolean namespaceAware) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(namespaceAware);
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(in));
            return db.parse(is);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public static Document parseXmlFromString(String in, boolean namespaceAware) throws SAXException, IOException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(namespaceAware);
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(in));
            return db.parse(is);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static String signXml(Document doc, String elementToSignId, String elementToAddSignatureToName, X509Certificate cert, Key privateKey) throws TransformerException, XMLSecurityException {
        doc.normalizeDocument();
        if (cert.getPublicKey() instanceof RSAPublicKey && privateKey instanceof RSAPrivateKey) {
            assert (Objects.equals(((RSAPublicKey)cert.getPublicKey()).getModulus(), ((RSAPrivateKey)privateKey).getModulus()));
            if (LOG.isDebugEnabled()) {
                boolean same = Objects.equals(((RSAPublicKey)cert.getPublicKey()).getModulus(), ((RSAPrivateKey)privateKey).getModulus());
                LOG.debug("signXml input cert and privateKey have same modulus");
            }
        } else {
            LOG.debug("not Rsa private and/or public key: no check done. cert.getPublicKey() is " + cert.getPublicKey().getClass().getName() + " privateKey is " + privateKey.getClass().getName());
        }
        return XmlUtil.signXmlWithSanturio(doc, elementToSignId, elementToAddSignatureToName, cert, privateKey);
    }

    public static String signXmlWithoutSanturio(Document doc, String elementToSignId, String elementToAddSignatureToName, X509Certificate cert, Key privateKey) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, KeyException, MarshalException, XMLSignatureException, TransformerException {
        Element elementToAddSignatureTo = (Element)doc.getElementsByTagName(elementToAddSignatureToName).item(0);
        assert (elementToAddSignatureTo != null);
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        Reference ref = fac.newReference("#" + elementToSignId, fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null)), null, null);
        SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(ref));
        KeyInfoFactory kif = fac.getKeyInfoFactory();
        KeyValue kv = kif.newKeyValue(cert.getPublicKey());
        ArrayList<X509Certificate> x509DataList = new ArrayList<X509Certificate>();
        x509DataList.add(cert);
        X509Data x509Data = kif.newX509Data(x509DataList);
        ArrayList<XMLStructure> kiList = new ArrayList<XMLStructure>();
        kiList.add(kv);
        kiList.add(x509Data);
        KeyInfo ki = kif.newKeyInfo(kiList);
        DOMSignContext dsc = new DOMSignContext(privateKey, (Node)elementToAddSignatureTo);
        XMLSignature signature = fac.newXMLSignature(si, ki);
        signature.sign(dsc);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.setOutputProperty("omit-xml-declaration", "no");
        trans.setOutputProperty("encoding", "utf-8");
        trans.setOutputProperty("indent", "no");
        StringWriter stringWriter = new StringWriter();
        trans.transform(new DOMSource(doc), new StreamResult(stringWriter));
        return stringWriter.getBuffer().toString();
    }

    public static String signXmlWithSanturio(Document doc, String elementToSignId, String elementToAddSignatureToName, X509Certificate cert, Key privateKey) throws XMLSecurityException, TransformerException {
        Init.init();
        ElementProxy.setDefaultPrefix((String)"http://www.w3.org/2000/09/xmldsig#", (String)"");
        org.apache.xml.security.signature.XMLSignature sig = new org.apache.xml.security.signature.XMLSignature(doc, null, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2001/10/xml-exc-c14n#");
        Element elementToAddSignatureTo = (Element)doc.getElementsByTagName(elementToAddSignatureToName).item(0);
        Attr idAttr = doc.createAttribute("xml:id");
        String credentialId = "Sig_" + elementToSignId;
        idAttr.setValue(credentialId);
        sig.getElement().setAttributeNode(idAttr);
        sig.getElement().setIdAttributeNode(idAttr, true);
        elementToAddSignatureTo.appendChild(sig.getElement());
        Transforms transforms = new Transforms(doc);
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
        sig.addDocument("#" + elementToSignId, transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
        sig.addKeyInfo(cert);
        sig.addKeyInfo(cert.getPublicKey());
        sig.sign(privateKey);
        StringWriter stringWriter = new StringWriter();
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.setOutputProperty("indent", "no");
        transformer.transform(new DOMSource(doc), new StreamResult(stringWriter));
        String res = stringWriter.getBuffer().toString();
        res = res.replaceFirst(Pattern.quote("<SignatureValue>\n"), Matcher.quoteReplacement("<SignatureValue>"));
        res = res.replaceFirst(Pattern.quote("<X509Certificate>\n"), Matcher.quoteReplacement("<X509Certificate>"));
        res = res.replaceFirst(Pattern.quote("\n</SignatureValue>"), Matcher.quoteReplacement("</SignatureValue>"));
        res = res.replaceFirst(Pattern.quote("\n</X509Certificate>"), Matcher.quoteReplacement("</X509Certificate>"));
        return res;
    }

    public static void markXmlIdsAsXmlId(Document doc) {
        NodeList allNodes = doc.getElementsByTagName("*");
        for (int j = 0; j < allNodes.getLength(); ++j) {
            Node n = allNodes.item(j);
            if (n.getNodeType() != 1) continue;
            Element credentialEl = (Element)n;
            NamedNodeMap l = credentialEl.getAttributes();
            for (int i = 0; i < l.getLength(); ++i) {
                Attr a = (Attr)l.item(i);
                if (!Objects.equals(a.getName(), "xml:id")) continue;
                credentialEl.setIdAttributeNode(a, true);
            }
        }
    }

    public static List<Element> getDomElementChildElements(Element e, String tagName) {
        assert (e != null);
        assert (tagName != null);
        NodeList resList = e.getElementsByTagName(tagName);
        ArrayList<Element> resElements = new ArrayList<Element>();
        for (int i = 0; i < resList.getLength(); ++i) {
            Node resNode = resList.item(i);
            assert (resNode != null);
            assert (resNode.getNodeType() == 1);
            Element resElement = (Element)resNode;
            resElements.add(resElement);
        }
        return resElements;
    }

    public static List<Element> getDomElementChildElementsNS(Element e, String namespace, String tagName) {
        assert (e != null);
        assert (tagName != null);
        NodeList resList = e.getElementsByTagNameNS(namespace, tagName);
        ArrayList<Element> resElements = new ArrayList<Element>();
        for (int i = 0; i < resList.getLength(); ++i) {
            Node resNode = resList.item(i);
            assert (resNode != null);
            assert (resNode.getNodeType() == 1);
            Element resElement = (Element)resNode;
            resElements.add(resElement);
        }
        return resElements;
    }

    public static Element getDomElementFirstChildElement(Element e, String tagName) {
        NodeList resList = e.getElementsByTagName(tagName);
        assert (resList.getLength() == 1);
        Node resNode = resList.item(0);
        assert (resNode != null);
        assert (resNode.getNodeType() == 1);
        return (Element)resNode;
    }

    public static Element getDomElementFirstChildElementNS(Element e, String namespace, String tagName) {
        NodeList resList = e.getElementsByTagNameNS(namespace, tagName);
        assert (resList.getLength() == 1);
        Node resNode = resList.item(0);
        assert (resNode != null);
        assert (resNode.getNodeType() == 1);
        return (Element)resNode;
    }

    public static String getDomElementFirstChildElementText(Element e, String tagName) {
        NodeList resList = e.getElementsByTagName(tagName);
        if (resList == null || resList.getLength() < 1) {
            return null;
        }
        assert (resList.getLength() == 1);
        Node resNode = resList.item(0);
        if (resNode == null) {
            return null;
        }
        if (resNode.getNodeType() != 1) {
            return null;
        }
        return resNode.getTextContent();
    }

    public static boolean couldBeXmlVeryQuickTest(String s) {
        return s.startsWith("<");
    }

    public static boolean isXmlLikeQuickTest(String s) {
        return XmlUtil.isXmlQuickTestHelper(s, 10);
    }

    public static boolean isWellFormedXmlQuickTest(String s) {
        return XmlUtil.isXmlQuickTestHelper(s, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isXmlQuickTestHelper(String s, int eventLimit) {
        if (!XmlUtil.couldBeXmlVeryQuickTest(s)) {
            return false;
        }
        int eventCount = 0;
        XMLStreamReader reader = null;
        try {
            XMLInputFactory xif = XMLInputFactory.newFactory();
            StreamSource xml = new StreamSource(new StringReader(s));
            reader = xif.createXMLStreamReader(xml);
            reader.next();
            while (reader.hasNext()) {
                reader.next();
                if (eventLimit <= 0 || ++eventCount < eventLimit) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (XMLStreamException e) {
            LOG.debug("isXmlQuickTest caught a parsing exception: not well formed XML. XMLStreamException=" + e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
    }
}

