/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.model;

import be.iminds.ilabt.jfed.bugreport.model.Sliver;
import be.iminds.ilabt.jfed.json.util.JsonInstantRFC3339Deserializer;
import be.iminds.ilabt.jfed.json.util.JsonInstantRFC3339Serializer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Instant;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
public class Slice {
    private static final Logger LOG = LoggerFactory.getLogger(Slice.class);
    private final String sliceUrn;
    private final String status;
    private final Instant expirationDate;
    private final List<Sliver> slivers;

    @JsonCreator
    public Slice(@JsonProperty(value="sliceUrn") String sliceUrn, @JsonProperty(value="status") String status, @JsonProperty(value="expirationDate") Instant expirationDate, @JsonProperty(value="slivers") List<Sliver> slivers) {
        this.sliceUrn = sliceUrn;
        this.status = status;
        this.expirationDate = expirationDate;
        this.slivers = slivers;
    }

    @JsonProperty
    public String getSliceUrn() {
        return this.sliceUrn;
    }

    @JsonProperty
    public String getStatus() {
        return this.status;
    }

    @JsonProperty
    public List<Sliver> getSlivers() {
        return this.slivers;
    }

    @JsonProperty
    @JsonSerialize(using=JsonInstantRFC3339Serializer.class)
    @JsonDeserialize(using=JsonInstantRFC3339Deserializer.class)
    public Instant getExpirationDate() {
        return this.expirationDate;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting " + this.getClass().getName() + " to JSON", (Throwable)e);
            return "Exception converting Testbed " + this.getClass().getName() + " to JSON: " + e.getMessage();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Slice)) {
            return false;
        }
        Slice slice = (Slice)o;
        if (this.sliceUrn != null ? !this.sliceUrn.equals(slice.sliceUrn) : slice.sliceUrn != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(slice.status) : slice.status != null) {
            return false;
        }
        if (this.expirationDate != null ? !this.expirationDate.equals(slice.expirationDate) : slice.expirationDate != null) {
            return false;
        }
        return this.slivers != null ? this.slivers.equals(slice.slivers) : slice.slivers == null;
    }

    public int hashCode() {
        int result = this.sliceUrn != null ? this.sliceUrn.hashCode() : 0;
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
        result = 31 * result + (this.slivers != null ? this.slivers.hashCode() : 0);
        return result;
    }
}

