/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassRefOrTypeVariableSignature;
import io.github.classgraph.ClassRefTypeSignature;
import io.github.classgraph.ClassTypeSignature;
import io.github.classgraph.MethodTypeSignature;
import io.github.classgraph.ReferenceTypeSignature;
import io.github.classgraph.ScanResult;
import io.github.classgraph.TypeParameter;
import io.github.classgraph.TypeSignature;
import io.github.classgraph.utils.Parser;
import io.github.classgraph.utils.TypeUtils;
import java.util.ArrayList;
import java.util.Set;

public class TypeVariableSignature
extends ClassRefOrTypeVariableSignature {
    private final String name;
    private final String definingClassName;
    MethodTypeSignature containingMethodSignature;

    private TypeVariableSignature(String typeVariableName, String definingClassName) {
        this.name = typeVariableName;
        this.definingClassName = definingClassName;
    }

    public String getName() {
        return this.name;
    }

    public TypeParameter resolve() {
        ClassInfo containingClassInfo;
        if (this.containingMethodSignature != null && this.containingMethodSignature.typeParameters != null && !this.containingMethodSignature.typeParameters.isEmpty()) {
            for (TypeParameter typeParameter : this.containingMethodSignature.typeParameters) {
                if (!typeParameter.name.equals(this.name)) continue;
                return typeParameter;
            }
        }
        if ((containingClassInfo = this.getClassInfo()) == null) {
            throw new IllegalArgumentException("Could not find ClassInfo object for " + this.definingClassName);
        }
        ClassTypeSignature containingClassSignature = containingClassInfo.getTypeSignature();
        if (containingClassSignature != null && containingClassSignature.typeParameters != null && !containingClassSignature.typeParameters.isEmpty()) {
            for (TypeParameter typeParameter : containingClassSignature.typeParameters) {
                if (!typeParameter.name.equals(this.name)) continue;
                return typeParameter;
            }
        }
        throw new IllegalArgumentException("Could not resolve " + this.name + " against parameters of the defining method or enclosing class");
    }

    static TypeVariableSignature parse(Parser parser, String definingClassName) throws Parser.ParseException {
        char peek = parser.peek();
        if (peek == 'T') {
            parser.next();
            if (!TypeUtils.getIdentifierToken(parser)) {
                throw new Parser.ParseException(parser, "Could not parse type variable signature");
            }
            parser.expect(';');
            TypeVariableSignature typeVariableSignature = new TypeVariableSignature(parser.currToken(), definingClassName);
            ArrayList<TypeVariableSignature> typeVariableSignatures = (ArrayList<TypeVariableSignature>)parser.getState();
            if (typeVariableSignatures == null) {
                typeVariableSignatures = new ArrayList<TypeVariableSignature>();
                parser.setState(typeVariableSignatures);
            }
            typeVariableSignatures.add(typeVariableSignature);
            return typeVariableSignature;
        }
        return null;
    }

    @Override
    protected String getClassName() {
        return this.definingClassName;
    }

    @Override
    void setScanResult(ScanResult scanResult) {
        super.setScanResult(scanResult);
    }

    @Override
    void getClassNamesFromTypeDescriptors(Set<String> classNames) {
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TypeVariableSignature)) {
            return false;
        }
        TypeVariableSignature o = (TypeVariableSignature)obj;
        return o.name.equals(this.name);
    }

    @Override
    public boolean equalsIgnoringTypeParams(TypeSignature other) {
        if (other instanceof ClassRefTypeSignature) {
            if (((ClassRefTypeSignature)other).className.equals("java.lang.Object")) {
                return true;
            }
            TypeParameter typeParameter = this.resolve();
            if (typeParameter == null) {
                return true;
            }
            if (typeParameter.classBound == null && (typeParameter.interfaceBounds == null || typeParameter.interfaceBounds.isEmpty())) {
                return true;
            }
            if (typeParameter.classBound != null) {
                if (typeParameter.classBound instanceof ClassRefTypeSignature) {
                    if (typeParameter.classBound.equals(other)) {
                        return true;
                    }
                } else {
                    if (typeParameter.classBound instanceof TypeVariableSignature) {
                        return this.equalsIgnoringTypeParams(typeParameter.classBound);
                    }
                    return false;
                }
            }
            for (ReferenceTypeSignature interfaceBound : typeParameter.interfaceBounds) {
                if (interfaceBound instanceof ClassRefTypeSignature) {
                    if (!interfaceBound.equals(other)) continue;
                    return true;
                }
                if (interfaceBound instanceof TypeVariableSignature) {
                    return this.equalsIgnoringTypeParams(interfaceBound);
                }
                return false;
            }
            return false;
        }
        return this.equals(other);
    }

    public String toStringWithTypeBound() {
        TypeParameter typeParameter = this.resolve();
        if (typeParameter == null) {
            return this.name;
        }
        return typeParameter.toString();
    }

    public String toString() {
        return this.name;
    }
}

