/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph.utils;

import io.github.classgraph.utils.FastPathResolver;
import io.github.classgraph.utils.LogNode;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FileUtils {
    public static final String CURR_DIR_PATH;

    public static ByteArrayOutputStream readAllBytesAsBAOS(InputStream inputStream, long fileSize, LogNode log) throws IOException {
        int bytesRead;
        if (fileSize > Integer.MAX_VALUE || fileSize < 0L && fileSize != -1L) {
            throw new IOException("File larger that 2GB, cannot read contents into a Java array");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(fileSize <= 0L ? 16384 : (int)fileSize);
        byte[] buf = new byte[4096];
        int totBytesRead = 0;
        while ((bytesRead = inputStream.read(buf)) != -1) {
            baos.write(buf, 0, bytesRead);
            totBytesRead += bytesRead;
        }
        if ((long)totBytesRead != fileSize && log != null) {
            log.log("File length expected to be " + fileSize + " bytes, but read " + totBytesRead + " bytes");
        }
        return baos;
    }

    public static byte[] readAllBytesAsArray(InputStream inputStream, long fileSize, LogNode log) throws IOException {
        return FileUtils.readAllBytesAsBAOS(inputStream, fileSize, log).toByteArray();
    }

    public static String readAllBytesAsString(InputStream inputStream, long fileSize, LogNode log) throws IOException {
        return FileUtils.readAllBytesAsBAOS(inputStream, fileSize, log).toString("UTF-8");
    }

    public static boolean isClassfile(String path) {
        int len = path.length();
        return len > 6 && path.regionMatches(true, len - 6, ".class", 0, 6);
    }

    public static InputStream byteBufferToInputStream(final ByteBuffer byteBuffer) {
        return new InputStream(){
            final ByteBuffer buf;
            {
                this.buf = byteBuffer;
            }

            @Override
            public int read() throws IOException {
                if (!this.buf.hasRemaining()) {
                    return -1;
                }
                return this.buf.get() & 0xFF;
            }

            @Override
            public int read(byte[] bytes, int off, int len) throws IOException {
                if (!this.buf.hasRemaining()) {
                    return -1;
                }
                int bytesRead = Math.min(len, this.buf.remaining());
                this.buf.get(bytes, off, bytesRead);
                return bytesRead;
            }
        };
    }

    public static boolean canRead(File file) {
        try {
            return file.canRead();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    static {
        String currDirPathStr = "";
        try {
            Path currDirPath = Paths.get("", new String[0]).toAbsolutePath();
            currDirPathStr = currDirPath.toString();
            currDirPath = currDirPath.normalize();
            currDirPathStr = currDirPath.toString();
            currDirPath = currDirPath.toRealPath(LinkOption.NOFOLLOW_LINKS);
            currDirPathStr = currDirPath.toString();
            currDirPathStr = FastPathResolver.resolve(currDirPathStr);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not resolve current directory: " + currDirPathStr, e);
        }
        CURR_DIR_PATH = currDirPathStr;
    }
}

