/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.config;

import be.iminds.ilabt.jfed.experimenter_gui.config.UserInfoProvider;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientDirect;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientPropertiesConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.JFedExperimenterGuiConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.JFedExperimenterGuiConfigBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.ThreadFactoryUtil;
import be.iminds.ilabt.jfed.util.lib.ConnectivityDetector;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import be.iminds.ilabt.jfed.util.library.JFedUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.inject.name.Named;
import io.dropwizard.jackson.Jackson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JFedExperimenterGuiConfigProvider
implements Provider<JFedExperimenterGuiConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(JFedExperimenterGuiConfigProvider.class);
    @Nonnull
    private final ConnectivityDetector connectivityDetector;
    @Nonnull
    private final URL webApiUrl;
    @Nonnull
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();
    @Nullable
    private final String userPreference;
    @Nonnull
    private final UserInfoProvider userInfoProvider;
    @Nonnull
    private final GeniUserProvider geniUserProvider;
    @Nonnull
    private final JFedPreferences jFedPreferences;
    @Nonnull
    private final be.iminds.ilabt.jfed.log.Logger logger;
    private final boolean saveToCache;
    private JFedExperimenterGuiConfig configWithUser = null;
    private JFedExperimenterGuiConfig configWithoutUser = null;
    @Nonnull
    private final ExecutorService prefetchExecutorService = Executors.newSingleThreadExecutor(ThreadFactoryUtil.getFactory((String)"Prefetch-UserConfig"));
    @Nullable
    private ConfigPrefetcher currentConfigPrefetcher = null;

    @Nullable
    public static File getCacheDir() {
        String userDataDir = JFedUtils.getUserDataDirectory();
        if (userDataDir == null) {
            return null;
        }
        return new File(userDataDir, "guiConfigCache");
    }

    @Nullable
    public static File getCacheFile(@Nonnull UserInfo userInfo) {
        File dir = JFedExperimenterGuiConfigProvider.getCacheDir();
        Object suffix = "";
        if (userInfo.getExtra() != null && !userInfo.getExtra().isEmpty()) {
            suffix = (String)suffix + "_E_";
            suffix = (String)suffix + String.join((CharSequence)"-", userInfo.getExtra());
        }
        if (userInfo.getUrn() != null) {
            if (!((String)suffix).isEmpty()) {
                suffix = (String)suffix + "_";
            }
            suffix = (String)suffix + "_U_";
            GeniUrn urn = GeniUrn.parse((String)userInfo.getUrn());
            if (urn != null) {
                suffix = (String)suffix + urn.getEncodedTopLevelAuthority() + "_" + urn.getEncodedResourceName();
            }
        }
        return new File(dir, "userconfig_json_" + (String)suffix + ".cache");
    }

    @Nullable
    public static File getExtraGuiConfigDir() {
        String userDataDir = JFedUtils.getUserDataDirectory();
        if (userDataDir == null) {
            return null;
        }
        return new File(userDataDir, "extra_guiConfig");
    }

    @Nullable
    public static File getOverwriteGuiConfigDir() {
        String userDataDir = JFedUtils.getUserDataDirectory();
        if (userDataDir == null) {
            return null;
        }
        return new File(userDataDir, "overwrite_guiConfig");
    }

    @Nonnull
    public static List<File> getExtraGuiConfigFiles() {
        File extraGuiConfigsDir = JFedExperimenterGuiConfigProvider.getExtraGuiConfigDir();
        if (extraGuiConfigsDir == null || !extraGuiConfigsDir.exists() || !extraGuiConfigsDir.isDirectory()) {
            return Collections.emptyList();
        }
        File[] extraFiles = extraGuiConfigsDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".json"));
        return extraFiles == null ? Collections.emptyList() : Arrays.asList(extraFiles);
    }

    @Nonnull
    public static List<File> getOverwriteGuiConfigFiles() {
        File overwriteGuiConfigsDir = JFedExperimenterGuiConfigProvider.getOverwriteGuiConfigDir();
        if (overwriteGuiConfigsDir == null || !overwriteGuiConfigsDir.exists() || !overwriteGuiConfigsDir.isDirectory()) {
            return Collections.emptyList();
        }
        File[] overwriteFiles = overwriteGuiConfigsDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".json"));
        return overwriteFiles == null ? Collections.emptyList() : Arrays.asList(overwriteFiles);
    }

    @Inject
    public JFedExperimenterGuiConfigProvider(@Nonnull GeniUserProvider geniUserProvider, @Nonnull JFedPreferences jFedPreferences, @Nonnull ConnectivityDetector connectivityDetector, @Nonnull UserInfoProvider userInfoProvider, @Nonnull @Named(value="noClientAuthWebApiUrl") URL webApiUrl, @Nonnull be.iminds.ilabt.jfed.log.Logger logger) {
        this(geniUserProvider, jFedPreferences, connectivityDetector, userInfoProvider, webApiUrl, logger, true);
    }

    public JFedExperimenterGuiConfigProvider(@Nonnull GeniUserProvider geniUserProvider, @Nonnull JFedPreferences jFedPreferences, @Nonnull ConnectivityDetector connectivityDetector, @Nonnull UserInfoProvider userInfoProvider, @Nonnull URL webApiUrl, @Nonnull be.iminds.ilabt.jfed.log.Logger logger, boolean saveToCache) {
        assert (userInfoProvider != null);
        assert (geniUserProvider != null);
        assert (jFedPreferences != null);
        assert (connectivityDetector != null);
        this.userInfoProvider = userInfoProvider;
        this.geniUserProvider = geniUserProvider;
        this.jFedPreferences = jFedPreferences;
        this.userPreference = jFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_GUICONFIG_SOURCE);
        this.connectivityDetector = connectivityDetector;
        this.webApiUrl = webApiUrl;
        this.saveToCache = saveToCache;
        this.logger = logger;
    }

    private static JFedExperimenterGuiConfig getUsingUrl(@Nonnull URL url, @Nonnull UserInfo userInfo, @Nonnull be.iminds.ilabt.jfed.log.Logger logger) throws FedmonWebApiClient.FedmonWebApiClientException {
        assert (userInfo != null);
        Properties fedmonWebApiClientConfigProperties = new Properties();
        fedmonWebApiClientConfigProperties.setProperty("webapi_client_url_read_base", url.toExternalForm());
        fedmonWebApiClientConfigProperties.setProperty("webapi_client_url_write_base", "https://localhost/");
        JFedTrustStore bootstrapTrustStore = new JFedTrustStore();
        FedmonWebApiClientPropertiesConfig fedmonWebApiClientConfig = new FedmonWebApiClientPropertiesConfig(fedmonWebApiClientConfigProperties, bootstrapTrustStore, null, null, logger);
        FedmonWebApiClientDirect fedmonWebApiClient = new FedmonWebApiClientDirect((FedmonWebApiClientConfig)fedmonWebApiClientConfig);
        JFedExperimenterGuiConfig res = fedmonWebApiClient.getJFedExperimenterGuiConfig(userInfo);
        res = new JFedExperimenterGuiConfigBuilder(res).setUser(userInfo).create();
        return res;
    }

    @Nonnull
    private static JFedExperimenterGuiConfig getFromFile(@Nonnull File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("File \"" + file.getPath() + "\" not found");
        }
        return JFedExperimenterGuiConfigProvider.getFromStream(new FileInputStream(file));
    }

    @Nonnull
    private static JFedExperimenterGuiConfig getFromStream(@Nonnull InputStream is) throws IOException {
        return (JFedExperimenterGuiConfig)MAPPER.readValue(is, JFedExperimenterGuiConfig.class);
    }

    private static boolean hasServer(@Nullable Collection<Server> servers, @Nonnull Server target) {
        assert (target != null);
        assert (target.getId() != null);
        if (servers == null) {
            return false;
        }
        for (Server s : servers) {
            if (s.getId() == null || target.getId() == null || !Objects.equals(s.getId(), target.getId())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static ResourceClass getResourceClass(@Nullable Collection<ResourceClass> rcs, @Nonnull String id) {
        assert (id != null);
        if (rcs == null) {
            return null;
        }
        for (ResourceClass rc : rcs) {
            if (!Objects.equals(rc.getId(), id)) continue;
            return rc;
        }
        return null;
    }

    private static void mergeConfig(@Nonnull JFedExperimenterGuiConfigBuilder target, @Nonnull JFedExperimenterGuiConfig toAdd, boolean overwrite) {
        assert (target != null);
        assert (toAdd != null);
        if (toAdd.getBindableServers() != null) {
            if (overwrite) {
                target.setBindableServers((Collection)toAdd.getBindableServers());
            } else {
                for (Server server : toAdd.getBindableServers()) {
                    if (JFedExperimenterGuiConfigProvider.hasServer(target.getBindableServers(), server)) continue;
                    target.addBindableServer(server);
                }
            }
        }
        if (toAdd.getHideServers() != null) {
            if (overwrite) {
                target.setHideServers((Collection)toAdd.getHideServers());
            } else {
                for (Server server : toAdd.getHideServers()) {
                    if (JFedExperimenterGuiConfigProvider.hasServer(target.getHideServers(), server)) continue;
                    target.addHideServer(server);
                }
            }
        }
        if (toAdd.getFlags() != null) {
            for (Map.Entry entry : toAdd.getFlags().entrySet()) {
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                if (overwrite) {
                    target.setFlag(key, val);
                    continue;
                }
                if (target.getFlags().containsKey(key)) continue;
                target.setFlag(key, val);
            }
        }
        if (toAdd.getResourceClasses() != null) {
            for (ResourceClass resourceClass : toAdd.getResourceClasses()) {
                ResourceClass existing;
                assert (resourceClass.getId() != null);
                ResourceClass resourceClass2 = existing = target.getResourceClasses() == null ? null : JFedExperimenterGuiConfigProvider.getResourceClass(target.getResourceClasses(), (String)resourceClass.getId());
                if (existing != null && !overwrite) continue;
                target.addResourceClass(resourceClass);
            }
        }
    }

    @Nonnull
    public JFedExperimenterGuiConfig get() {
        if (!this.geniUserProvider.isUserLoggedIn()) {
            if (this.configWithoutUser == null) {
                ArrayList<String> extraflags = new ArrayList<String>();
                extraflags.add("login-site-buttons-default-new");
                extraflags.add("slices-login-button");
                if (this.jFedPreferences.getStringList((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_GUICONFIG_EXTRA_FLAGS).contains("nextportal")) {
                    extraflags.add("login-site-buttons-nextportal");
                }
                UserInfo userInfo = this.userInfoProvider.createUserInfo(null, extraflags.toArray(new String[2]));
                this.configWithoutUser = JFedExperimenterGuiConfigProvider.initConfig(userInfo, this.userPreference, this.connectivityDetector, this.webApiUrl, this.logger, this.saveToCache);
            }
            assert (this.configWithoutUser == null || this.configWithoutUser.getUser() == null || this.configWithoutUser.getUser().getUrn() == null);
            if (this.configWithoutUser == null) {
                throw new RuntimeException("Could not get JFedExperimenterGuiConfig");
            }
            return this.configWithoutUser;
        }
        GeniUrn userUrn = this.geniUserProvider.getLoggedInGeniUser().getUserUrn();
        assert (userUrn != null);
        if (this.configWithUser == null || this.configWithUser.getUser() != null && this.configWithUser.getUser().getUrn() != null && !Objects.equals(userUrn.toString(), this.configWithUser.getUser().getUrn())) {
            this.configWithUser = JFedExperimenterGuiConfigProvider.initConfig(this.userInfoProvider.createUserInfo(userUrn, new String[0]), this.userPreference, this.connectivityDetector, this.webApiUrl, this.logger, this.saveToCache);
        }
        if (this.configWithUser == null) {
            throw new RuntimeException("Could not get JFedExperimenterGuiConfig");
        }
        assert (this.configWithUser.getUser() == null || this.configWithUser.getUser().getUrn() != null);
        return this.configWithUser;
    }

    public ConfigPrefetcher prefetchConfig(@Nonnull UserInfo userInfo) {
        if (this.currentConfigPrefetcher != null && Objects.equals(this.currentConfigPrefetcher.getUserInfo(), userInfo)) {
            return this.currentConfigPrefetcher;
        }
        if (this.currentConfigPrefetcher != null) {
            this.currentConfigPrefetcher.cancel(true);
        }
        this.currentConfigPrefetcher = new ConfigPrefetcher(userInfo);
        this.prefetchExecutorService.execute(this.currentConfigPrefetcher);
        return this.currentConfigPrefetcher;
    }

    @Nullable
    private static JFedExperimenterGuiConfig initConfig(@Nonnull UserInfo userInfo, @Nullable String userPreference, @Nonnull ConnectivityDetector connectivityDetector, @Nonnull URL webApiUrl, @Nonnull be.iminds.ilabt.jfed.log.Logger logger, boolean saveToCache) {
        boolean tryCache;
        String testbedsSourcePref;
        JFedExperimenterGuiConfigBuilder resBuilder = null;
        String altUrl = null;
        String filename = null;
        boolean builtinOnly = false;
        boolean cacheOnly = false;
        if (userPreference != null && !(testbedsSourcePref = userPreference).equalsIgnoreCase("AUTO") && !testbedsSourcePref.equalsIgnoreCase("DEFAULT")) {
            LOG.debug("Skipping default guiConfig method, and using user specified method: \"" + userPreference + "\"");
            if (testbedsSourcePref.equalsIgnoreCase("BUILTIN")) {
                builtinOnly = true;
            } else if (testbedsSourcePref.equalsIgnoreCase("CACHE")) {
                cacheOnly = true;
            } else if (testbedsSourcePref.startsWith("file:")) {
                filename = testbedsSourcePref.substring(5);
            } else {
                altUrl = testbedsSourcePref;
            }
        }
        boolean tryFile = !builtinOnly && !cacheOnly && filename != null;
        boolean tryUrl = !builtinOnly && !cacheOnly;
        boolean tryBuiltIn = true;
        boolean bl = tryCache = !builtinOnly;
        if (tryFile) {
            File userFile = new File(filename);
            try {
                resBuilder = new JFedExperimenterGuiConfigBuilder(JFedExperimenterGuiConfigProvider.getFromFile(userFile));
                LOG.debug("Successfully read guiConfig at " + String.valueOf(userFile));
            }
            catch (AssertionError | Exception e) {
                LOG.error("Something went wrong while trying to read guiConfig at " + String.valueOf(userFile), (Throwable)e);
                resBuilder = null;
            }
        }
        if (resBuilder == null && tryUrl) {
            boolean urlSuccess = false;
            if (!connectivityDetector.isNoInternet()) {
                try {
                    try {
                        URL url = altUrl != null ? new URL(altUrl) : webApiUrl;
                        resBuilder = new JFedExperimenterGuiConfigBuilder(JFedExperimenterGuiConfigProvider.getUsingUrl(url, userInfo, logger));
                        urlSuccess = true;
                        LOG.debug("Successfully read guiConfig from " + url.toExternalForm());
                    }
                    catch (MalformedURLException e) {
                        LOG.error("Invalid URL for testbedInfoSource", (Throwable)e);
                        urlSuccess = false;
                    }
                }
                catch (AssertionError e) {
                    LOG.error("Something went wrong while trying to fetch Fed4Fire guiConfig: ", (Throwable)((Object)e));
                    urlSuccess = false;
                    resBuilder = null;
                }
                catch (Exception e) {
                    LOG.error("Something went wrong while trying to fetch Fed4Fire guiConfig: ", (Throwable)e);
                    urlSuccess = false;
                    resBuilder = null;
                }
                if (!urlSuccess) {
                    if (altUrl == null) {
                        LOG.warn("Something went wrong trying to load the default guiConfig URL");
                    } else {
                        LOG.warn("Something went wrong trying to load guiConfig from " + altUrl);
                    }
                    LOG.debug("Will use cache and builtin as backup");
                    tryBuiltIn = true;
                    tryCache = true;
                }
            } else {
                LOG.debug("Not trying to get guiConfig from URL, because connectivityDetector detected no internet connection");
            }
        }
        File cachedGuiConfigFile = JFedExperimenterGuiConfigProvider.getCacheFile(userInfo);
        if (resBuilder == null && tryCache) {
            if (cachedGuiConfigFile != null && cachedGuiConfigFile.exists()) {
                try {
                    resBuilder = new JFedExperimenterGuiConfigBuilder(JFedExperimenterGuiConfigProvider.getFromFile(cachedGuiConfigFile));
                    LOG.debug("Successfully read guiConfig from cache at " + String.valueOf(cachedGuiConfigFile));
                }
                catch (AssertionError | Exception e) {
                    LOG.error("Something went wrong while trying to read guiConfig at " + String.valueOf(cachedGuiConfigFile), (Throwable)e);
                    resBuilder = null;
                }
            } else {
                LOG.debug("No cached guiConfig file. " + String.valueOf(cachedGuiConfigFile));
            }
        }
        if (resBuilder == null && tryBuiltIn) {
            try {
                GeniUrn userUrn = userInfo.getUrn() == null ? null : GeniUrn.parse((String)userInfo.getUrn());
                String suffix = userUrn == null ? "" : "_" + userUrn.getEncodedTopLevelAuthority_withoutSubAuth();
                InputStream is = JFedExperimenterGuiConfigProvider.class.getResourceAsStream("defaultGuiConfig" + suffix + ".json");
                resBuilder = new JFedExperimenterGuiConfigBuilder(JFedExperimenterGuiConfigProvider.getFromStream(is));
            }
            catch (AssertionError | Exception e) {
                LOG.error("Something went wrong while using Builtin guiConfig: ", (Throwable)e);
                resBuilder = null;
            }
            if (resBuilder == null) {
                try {
                    InputStream is = JFedExperimenterGuiConfigProvider.class.getResourceAsStream("defaultGuiConfig.json");
                    resBuilder = new JFedExperimenterGuiConfigBuilder(JFedExperimenterGuiConfigProvider.getFromStream(is));
                }
                catch (AssertionError | Exception e) {
                    LOG.error("Something went wrong while using Builtin guiConfig: ", (Throwable)e);
                    resBuilder = null;
                }
            }
            if (resBuilder == null) {
                LOG.error("No builtin guiConfig could be read.");
            } else {
                LOG.info("Successfully read a builtin guiConfig");
            }
        }
        if (resBuilder != null) {
            for (File extraFile : JFedExperimenterGuiConfigProvider.getExtraGuiConfigFiles()) {
                try {
                    JFedExperimenterGuiConfig extraGuiConfig = JFedExperimenterGuiConfigProvider.getFromFile(extraFile);
                    JFedExperimenterGuiConfigProvider.mergeConfig(resBuilder, extraGuiConfig, false);
                }
                catch (AssertionError | Exception e) {
                    LOG.error("Something went wrong while trying to read extra guiConfig from " + String.valueOf(extraFile), (Throwable)e);
                }
            }
            for (File overwriteFile : JFedExperimenterGuiConfigProvider.getOverwriteGuiConfigFiles()) {
                try {
                    JFedExperimenterGuiConfig overwriteGuiConfig = JFedExperimenterGuiConfigProvider.getFromFile(overwriteFile);
                    JFedExperimenterGuiConfigProvider.mergeConfig(resBuilder, overwriteGuiConfig, true);
                }
                catch (AssertionError | Exception e) {
                    LOG.error("Something went wrong while trying to read overwrite guiConfig from " + String.valueOf(overwriteFile), (Throwable)e);
                }
            }
        } else {
            LOG.warn("Will ignore extra and overwrite guiConfigs, because no base guiConfig could be found.");
        }
        if (resBuilder != null) {
            JFedExperimenterGuiConfig config = resBuilder.create();
            LOG.info("jFed initialised GuiConfig with " + String.valueOf(config.getResourceClasses() == null ? "null" : Integer.valueOf(config.getResourceClasses().size())) + " resourceClasses.");
            if (saveToCache && cachedGuiConfigFile != null) {
                JFedExperimenterGuiConfigProvider.saveCacheInBackground(config, cachedGuiConfigFile);
            }
            return config;
        }
        LOG.error("No method to get testbed info worked!");
        return null;
    }

    private static void saveCacheInBackground(@Nonnull JFedExperimenterGuiConfig guiConfig, @Nonnull File targetFile) {
        Runnable r = () -> {
            try {
                File cacheDir = JFedExperimenterGuiConfigProvider.getCacheDir();
                if (cacheDir != null && !cacheDir.exists()) {
                    cacheDir.mkdir();
                }
                JFedExperimenterGuiConfigProvider.save(guiConfig, targetFile);
            }
            catch (AssertionError | Exception e) {
                LOG.error("Something went wrong while trying to write testbeds to cache " + String.valueOf(targetFile), (Throwable)e);
            }
        };
        new Thread(null, r, "UserConfigCacheSaver").start();
    }

    public static void save(@Nonnull JFedExperimenterGuiConfig guiConfig, @Nonnull File targetFile) throws IOException {
        LOG.info("Saving jFed guiConfig to file \"" + String.valueOf(targetFile) + "\"");
        File dir = targetFile.getParentFile();
        if (dir != null) {
            if (!dir.exists()) {
                dir.mkdir();
            }
            if (!dir.exists()) {
                LOG.warn("could not save authorities to \"" + targetFile.getName() + "\", as dir \"" + dir.getName() + "\" could not be created.");
                return;
            }
        }
        MAPPER.writer().with(SerializationFeature.INDENT_OUTPUT).writeValue(targetFile, (Object)guiConfig);
    }

    public class ConfigPrefetcher
    extends FutureTask<JFedExperimenterGuiConfig> {
        @Nonnull
        private final UserInfo userInfo;

        private ConfigPrefetcher(final UserInfo userInfo) {
            super(new Callable<JFedExperimenterGuiConfig>(){

                @Override
                public JFedExperimenterGuiConfig call() throws Exception {
                    if (JFedExperimenterGuiConfigProvider.this.configWithUser == null || !Objects.equals(userInfo, JFedExperimenterGuiConfigProvider.this.configWithUser.getUser())) {
                        JFedExperimenterGuiConfigProvider.this.configWithUser = JFedExperimenterGuiConfigProvider.initConfig(userInfo, JFedExperimenterGuiConfigProvider.this.userPreference, JFedExperimenterGuiConfigProvider.this.connectivityDetector, JFedExperimenterGuiConfigProvider.this.webApiUrl, JFedExperimenterGuiConfigProvider.this.logger, JFedExperimenterGuiConfigProvider.this.saveToCache);
                    }
                    return JFedExperimenterGuiConfigProvider.this.configWithUser;
                }
            });
            this.userInfo = userInfo;
        }

        @Nonnull
        public UserInfo getUserInfo() {
            return this.userInfo;
        }
    }
}

