/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.config;

import be.iminds.ilabt.jfed.experimenter_gui.config.ImageMap;
import be.iminds.ilabt.jfed.experimenter_gui.config.TestbedSiteInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.AdvertisementCounts;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.MaintenanceInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TriggeredMessage;
import be.iminds.ilabt.jfed.rspec.model.DiskImage;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.NodeLocation;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.rspec_source.AdvertisementRspecSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.collections.ObservableList;
import javafx.scene.paint.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface JFedGuiConfig {
    public static final String FLAG_ESPEC = "espec";
    public static final String FLAG_SHOW_TUTORIAL_BUTTON = "showTutorialButton";
    public static final String FLAG_SLA_AVAILABLE = "slaAvailable";
    public static final String FLAG_QOE_REPORTING = "reportQOE";
    public static final String FLAG_SHOW_REPUTATION = "showReputation";
    public static final String FLAG_DISABLE_EXP_DELETE = "disableExperimentDelete";
    public static final String FLAG_DISABLE_EXP_ACTION = "disableExperimentAction";
    public static final String FLAG_DISABLE_EXP_RENEW = "disableExperimentRenew";
    public static final String FLAG_DISABLE_EXP_START = "disableExperimentStart";
    public static final String FLAG_DISABLE_PREFERENCES = "disablePreferences";
    public static final String RESOURCE_CLASS_ID_OTHER_SERVERS = "other-servers";
    public static final Comparator<ComponentInfo> COMPONENT_INFO_BY_ID_COMPARATOR = new Comparator<ComponentInfo>(){

        @Override
        public int compare(ComponentInfo o1, ComponentInfo o2) {
            String s2;
            String s1 = o1.getName() == null ? o1.getUrn().toString() : o1.getName();
            String string = s2 = o2.getName() == null ? o2.getUrn().toString() : o2.getName();
            if (s1 == null || s2 == null) {
                throw new NullPointerException("ComponentInfo must always have some ID");
            }
            return s1.compareTo(s2);
        }
    };

    public boolean hasFlag(String var1);

    @Nullable
    public Boolean getBooleanFlag(String var1);

    @Nullable
    public String getStringFlag(String var1);

    @Nullable
    public Integer getIntegerFlag(String var1);

    @Nullable
    public Long getLongFlag(String var1);

    default public boolean isShowTutorialButtonEnabled() {
        return Objects.equals(Boolean.TRUE, this.getBooleanFlag(FLAG_SHOW_TUTORIAL_BUTTON));
    }

    default public boolean isEspecEnabled() {
        return Objects.equals(Boolean.TRUE, this.getBooleanFlag(FLAG_ESPEC));
    }

    default public boolean isSlaAvailable() {
        return Objects.equals(Boolean.TRUE, this.getBooleanFlag(FLAG_SLA_AVAILABLE));
    }

    default public boolean isQOEReportingEnabled() {
        return Objects.equals(Boolean.TRUE, this.getBooleanFlag(FLAG_QOE_REPORTING));
    }

    default public boolean isShowReputationEnabled() {
        return Objects.equals(Boolean.TRUE, this.getBooleanFlag(FLAG_SHOW_REPUTATION));
    }

    default public boolean isExperimentDeleteDisabled() {
        return Objects.equals(Boolean.TRUE, this.getBooleanFlag(FLAG_DISABLE_EXP_DELETE));
    }

    default public boolean isExperimentActionDisabled() {
        return Objects.equals(Boolean.TRUE, this.getBooleanFlag(FLAG_DISABLE_EXP_ACTION));
    }

    default public boolean isExperimentRenewDisabled() {
        return Objects.equals(Boolean.TRUE, this.getBooleanFlag(FLAG_DISABLE_EXP_RENEW));
    }

    default public boolean isExperimentStartDisabled() {
        return Objects.equals(Boolean.TRUE, this.getBooleanFlag(FLAG_DISABLE_EXP_START));
    }

    default public boolean isPreferencesDisabled() {
        return Objects.equals(Boolean.TRUE, this.getBooleanFlag(FLAG_DISABLE_PREFERENCES));
    }

    @Nullable
    public ResourceClass getResourceClass(String var1);

    @Nonnull
    public Collection<ResourceClass> getResourceClasses();

    @Nonnull
    public List<TriggeredMessage> getTriggeredMessages();

    @Nonnull
    public ResourceType getResourceType(@Nonnull ResourceClass var1);

    @Nonnull
    public Collection<ResourceClass> getResourceClassesByType(@Nonnull ResourceType var1);

    @Nullable
    public ResourceClass getDefaultResourceClass();

    @Nonnull
    public List<Server> getBindableServers();

    @Nonnull
    public List<Server> getAllServersInVisibleResources();

    @Nonnull
    public List<Server> getHiddenServers();

    @Nullable
    public ResourceClass findBestResourceClass(@Nonnull RspecNode var1);

    @Nonnull
    public List<ResourceClass> findAllPossibleResourceClasses(@Nonnull RspecNode var1);

    @Nonnull
    public List<Resource> findAllPossibleResources(@Nonnull Server var1);

    @Nonnull
    public List<ResourceClass> findAllPossibleResourceClasses(@Nonnull Server var1);

    @Nullable
    public Resource findBestResource(@Nullable ResourceClass var1, @Nonnull RspecNode var2, @Nullable Server var3);

    @Nonnull
    public List<Resource> findAllPossibleResources(@Nullable ResourceClass var1, @Nonnull RspecNode var2, @Nullable Server var3);

    @Nullable
    default public Resource findBestResource(@Nullable ResourceClass resourceClass, RspecNode node) {
        return this.findBestResource(resourceClass, node, null);
    }

    @Nonnull
    default public List<Resource> findAllPossibleResource(@Nullable ResourceClass resourceClass, RspecNode node) {
        return this.findAllPossibleResources(resourceClass, node, null);
    }

    @Nullable
    default public Resource findBestResource(RspecNode node, @Nullable Server overrideComponentManager) {
        return this.findBestResource(null, node, overrideComponentManager);
    }

    @Nonnull
    default public List<Resource> findAllPossibleResource(RspecNode node, @Nullable Server overrideComponentManager) {
        return this.findAllPossibleResources(null, node, overrideComponentManager);
    }

    @Nullable
    default public Resource findBestResource(RspecNode node) {
        return this.findBestResource(null, node, null);
    }

    @Nonnull
    default public List<Resource> findAllPossibleResource(RspecNode node) {
        return this.findAllPossibleResources(null, node, null);
    }

    @Nullable
    public Resource getDefaultResource(ResourceClass var1);

    @Nullable
    public Boolean getNodeExclusivity(GeniUrn var1, String var2);

    public boolean hasUpToDateComponentInfo(@Nonnull Server var1, @Nonnull Scope var2);

    public ObservableList<ComponentInfo> getComponentInfo(@Nonnull Server var1, @Nonnull Scope var2, @Nullable Resource var3);

    public ObservableList<String> getSliverTypeNames(@Nonnull Server var1);

    public List<String> getAdvertisedSliverTypeNames(@Nonnull Server var1);

    public ObservableList<HardwareTypeInfo> getHardwareTypes(@Nonnull Server var1, @Nonnull Scope var2, @Nullable Resource var3);

    public ReadOnlyListProperty<DiskImage> getDiskImages(@Nonnull Server var1, @Nullable String var2);

    public ReadOnlyListProperty<String> getFlavors(@Nonnull Server var1, @Nullable String var2);

    default public ReadOnlyListProperty<DiskImage> getDiskImages(@Nonnull Server server) {
        return this.getDiskImages(server, null);
    }

    default public ReadOnlyListProperty<DiskImage> getDiskImages(@Nonnull Resource resource) {
        return this.getDiskImages(resource.getServer(), resource.getSliverType());
    }

    default public ReadOnlyListProperty<String> getFlavors(@Nonnull Resource resource) {
        return this.getFlavors(resource.getServer(), resource.getSliverType());
    }

    default public ReadOnlyListProperty<String> getFlavors(@Nonnull Server server) {
        return this.getFlavors(server, null);
    }

    @Nonnull
    public ObjectProperty<Integer> getServerReputation(@Nonnull Server var1);

    @Nonnull
    public ObservableList<MaintenanceInfo> getServerMaintenance(@Nonnull Server var1);

    @Nonnull
    public ObjectProperty<ServerGlimpse.HealthInfo> getServerHealthInfo(@Nonnull Server var1);

    @Nonnull
    public ObjectProperty<ServerGlimpse.AdvertisementInfo.HardwareTypeInfo> getHardwareTypeInfo(@Nonnull Server var1);

    @Nonnull
    public ObservableList<TestbedSiteInfo> getTestbedSiteInfo(@Nonnull Server var1);

    @Nonnull
    public ReadOnlyObjectProperty<? extends AdvertisementCounts> getServerNodeCounts(@Nonnull Server var1);

    public ReadOnlyObjectProperty<AdvertisementRspecSource> getAdvertisement(Server var1, @Nullable Boolean var2);

    public NodesVisualization getNodesVisualization(Server var1);

    public ImageMap<GeniUrn> getImageMap(Server var1);

    @Nullable
    public ServerGlimpse getServerGlimpse(Server var1);

    public void refreshServerGlimpsesIfNeeded();

    public void forceRefreshServerGlimpses();

    @Nonnull
    public Color getColor(Server var1);

    @Nonnull
    public Color getColor(Testbed var1);

    @Nonnull
    public Color getColor(String var1);

    public void setAdvertisementRspec(Integer var1, boolean var2, ModelRspec var3, Date var4);

    public void setServerGlimpse(Integer var1, ServerGlimpse var2);

    public void setFedmonNodeTestInfo(Integer var1, Map<GeniUrn, Result> var2);

    public void initResourceClassAdvertisementInfo();

    @Nonnull
    public ComponentInfo addUserComponentInfo(Integer var1, GeniUrn var2);

    @Nonnull
    public HardwareTypeInfo addUserHardwareTypeInfo(Integer var1, String var2, Boolean var3);

    public void clearUserInfo(Integer var1);

    public static class ComponentInfo
    implements Comparable {
        private static final Logger LOG = LoggerFactory.getLogger(ComponentInfo.class);
        @Nullable
        private final String name;
        @Nullable
        private final GeniUrn urn;
        @Nullable
        private final GeniUrn componentManagerUrn;
        @Nullable
        private final String siteId;
        @Nullable
        private final NodeLocation nodeLocation;
        private final boolean available;
        @Nonnull
        private final Map<ExtraStatusInfoType, Boolean> extraStatusInfo;
        @Nonnull
        private final Map<String, String> extraInfo;
        @Nullable
        private final List<String> hardwareTypeNames;
        @Nullable
        private final List<String> sliverTypeNames;

        public ComponentInfo(@Nullable String name, @Nullable GeniUrn urn, boolean available, @Nullable Map<ExtraStatusInfoType, Boolean> extraStatusInfo, @Nullable Map<String, String> extraInfo, @Nullable NodeLocation nodeLocation, @Nullable Collection<String> hardwareTypeNames, @Nullable Collection<String> sliverTypeNames, @Nullable GeniUrn componentManagerUrn, @Nullable String siteId) {
            assert (name != null || urn != null);
            this.name = name;
            this.urn = urn;
            this.available = available;
            this.nodeLocation = nodeLocation;
            this.hardwareTypeNames = hardwareTypeNames == null ? null : new ArrayList<String>(hardwareTypeNames);
            this.sliverTypeNames = sliverTypeNames == null ? null : new ArrayList<String>(sliverTypeNames);
            this.componentManagerUrn = componentManagerUrn;
            this.siteId = siteId;
            if (extraStatusInfo == null) {
                this.extraStatusInfo = Collections.emptyMap();
            } else {
                EnumMap<ExtraStatusInfoType, Boolean> newExtraStatusInfo = new EnumMap<ExtraStatusInfoType, Boolean>(ExtraStatusInfoType.class);
                newExtraStatusInfo.putAll(extraStatusInfo);
                this.extraStatusInfo = Collections.unmodifiableMap(newExtraStatusInfo);
            }
            this.extraInfo = extraInfo == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, String>(extraInfo));
        }

        @Nonnull
        public static ComponentInfo create(@Nonnull GeniUrn urn, boolean available, @Nonnull ExtraStatusInfoType extraStatusInfoType, boolean status, @Nullable Map<String, String> extraInfo, @Nullable GeniUrn componentManagerUrn, @Nullable String siteId) {
            return new ComponentInfo(null, urn, available, Collections.singletonMap(extraStatusInfoType, status), extraInfo, null, null, null, componentManagerUrn, siteId);
        }

        @Nonnull
        public ComponentInfo copyWithAdditionalStatusInfo(@Nonnull ExtraStatusInfoType extraStatusInfoType, boolean status) {
            EnumMap<ExtraStatusInfoType, Boolean> newExtraStatusInfo = new EnumMap<ExtraStatusInfoType, Boolean>(ExtraStatusInfoType.class);
            newExtraStatusInfo.putAll(this.extraStatusInfo);
            newExtraStatusInfo.put(extraStatusInfoType, status);
            return new ComponentInfo(this.getName(), this.getUrn(), this.available, newExtraStatusInfo, this.extraInfo, this.nodeLocation, this.hardwareTypeNames, this.sliverTypeNames, this.componentManagerUrn, this.siteId);
        }

        @Nonnull
        public ComponentInfo copyWithAdditionalExtraInfo(@Nullable Map<String, String> additionalExtraInfo) {
            Map<String, String> newExtraInfo;
            if (additionalExtraInfo == null) {
                newExtraInfo = Collections.emptyMap();
            } else {
                newExtraInfo = new HashMap<String, String>(this.extraInfo);
                newExtraInfo.putAll(additionalExtraInfo);
            }
            return new ComponentInfo(this.getName(), this.getUrn(), this.available, this.extraStatusInfo, newExtraInfo, this.nodeLocation, this.hardwareTypeNames, this.sliverTypeNames, this.componentManagerUrn, this.siteId);
        }

        @Nonnull
        public ComponentInfo copyWithMergedExtraInfo(@Nonnull ComponentInfo other) {
            EnumMap<ExtraStatusInfoType, Boolean> newExtraStatusInfo = new EnumMap<ExtraStatusInfoType, Boolean>(ExtraStatusInfoType.class);
            newExtraStatusInfo.putAll(this.extraStatusInfo);
            newExtraStatusInfo.putAll(other.extraStatusInfo);
            HashMap<String, String> newExtraInfo = new HashMap<String, String>(this.extraInfo);
            newExtraInfo.putAll(other.extraInfo);
            return new ComponentInfo(this.getName(), this.getUrn(), this.available, newExtraStatusInfo, newExtraInfo, this.nodeLocation, this.hardwareTypeNames, this.sliverTypeNames, this.componentManagerUrn != null ? this.componentManagerUrn : other.componentManagerUrn, this.siteId != null ? this.siteId : other.siteId);
        }

        @Nonnull
        public ComponentInfo copyWithAdditionalExtraInfo(@Nonnull String key, @Nonnull String value) {
            return this.copyWithAdditionalExtraInfo(Collections.singletonMap(key, value));
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        @Nullable
        public GeniUrn getUrn() {
            return this.urn;
        }

        public boolean isAvailableInRspec() {
            return this.available;
        }

        public boolean isAvailable() {
            if (Objects.equals(this.isNodeLoginTestSuccess(), Boolean.FALSE)) {
                return false;
            }
            return this.available;
        }

        public boolean hasExtraStatus(@Nonnull ExtraStatusInfoType type) {
            return this.extraStatusInfo.containsKey((Object)type);
        }

        @Nullable
        public Boolean isSuccess(@Nonnull ExtraStatusInfoType type) {
            if (this.extraStatusInfo.containsKey((Object)type)) {
                return this.extraStatusInfo.get((Object)type);
            }
            return null;
        }

        @Nullable
        public Boolean isNodeLoginTestSuccess() {
            return this.isSuccess(ExtraStatusInfoType.NODE_LOGIN);
        }

        @Nullable
        public String getExtraInfo(@Nonnull String key) {
            return this.extraInfo.get(key);
        }

        @Nullable
        public List<String> getHardwareTypeNames() {
            return this.hardwareTypeNames;
        }

        public boolean hasHardwareType(String hardwareTypeName) {
            boolean res = this.hardwareTypeNames == null ? false : this.hardwareTypeNames.contains(hardwareTypeName);
            return res;
        }

        @Nullable
        public List<String> getSliverTypeNames() {
            return this.sliverTypeNames;
        }

        public boolean hasSliverType(String sliverTypeName) {
            boolean res = this.sliverTypeNames == null ? false : this.sliverTypeNames.contains(sliverTypeName);
            return res;
        }

        @Nullable
        public GeniUrn getComponentManagerUrn() {
            return this.componentManagerUrn;
        }

        @Nullable
        public String getSiteId() {
            return this.siteId;
        }

        public int compareTo(@Nonnull Object o) {
            String s2;
            if (!(o instanceof ComponentInfo)) {
                throw new RuntimeException("Can't compare ComponentInfo to " + o.getClass().getName());
            }
            ComponentInfo ci = (ComponentInfo)o;
            String s1 = this.getName() == null ? this.getUrn().toString() : this.getName();
            String string = s2 = ci.getName() == null ? ci.getUrn().toString() : ci.getName();
            if (s1 == null || s2 == null) {
                throw new NullPointerException("ComponentInfo must always have some ID");
            }
            return s1.compareTo(s2);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComponentInfo that = (ComponentInfo)o;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return !(this.urn != null ? !this.urn.equals((Object)that.urn) : that.urn != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.urn != null ? this.urn.hashCode() : 0);
            return result;
        }

        public String toString() {
            if (this.name != null) {
                return this.name;
            }
            return this.urn.getValue();
        }

        public NodeLocation getLocation() {
            return this.nodeLocation;
        }

        public boolean hasLocation() {
            return this.nodeLocation != null && this.nodeLocation.getLatitude() != null && this.nodeLocation.getLongitude() != null;
        }

        public static enum ExtraStatusInfoType {
            NODE_LOGIN,
            SENSOR;

        }
    }

    public static class HardwareTypeInfo
    implements Comparable {
        private final String hardwareTypeName;
        private final Boolean available;

        public HardwareTypeInfo(String hardwareTypeName) {
            this(hardwareTypeName, null);
        }

        public HardwareTypeInfo(String hardwareTypeName, Boolean available) {
            assert (hardwareTypeName != null);
            this.hardwareTypeName = hardwareTypeName;
            this.available = available;
        }

        public String getHardwareTypeName() {
            return this.hardwareTypeName;
        }

        public Boolean isAvailable() {
            return this.available;
        }

        public int compareTo(@Nonnull Object o) {
            return this.hardwareTypeName.compareTo(((HardwareTypeInfo)o).hardwareTypeName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HardwareTypeInfo that = (HardwareTypeInfo)o;
            return this.hardwareTypeName.equals(that.hardwareTypeName);
        }

        public int hashCode() {
            return this.hardwareTypeName.hashCode();
        }

        public String toString() {
            return this.hardwareTypeName;
        }
    }

    public static enum NodesVisualization {
        MAP,
        IMAGE;

    }

    public static enum Scope {
        ALL,
        AVAILABLE_ONLY;


        public static Scope getScopeForAvailable(boolean available) {
            return available ? AVAILABLE_ONLY : ALL;
        }

        public static Scope getScopeForAll(boolean all) {
            return !all ? AVAILABLE_ONLY : ALL;
        }
    }

    public static enum ResourceType {
        RAW_PC("Bare Metal"),
        VM("VMs"),
        OTHER("Other");

        private final String friendlyName;

        private ResourceType(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }
    }
}

