/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui;

import be.iminds.ilabt.jfed.base_gui.BaseGuiModule;
import be.iminds.ilabt.jfed.base_gui.UncaughtGuiExceptionLogger;
import be.iminds.ilabt.jfed.base_gui.util.GuiceContext;
import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experimenter_gui.ExperimenterGUI;
import be.iminds.ilabt.jfed.experimenter_gui.ExperimenterModule;
import be.iminds.ilabt.jfed.experimenter_gui.ext_requests.EnvironmentParameterHandler;
import be.iminds.ilabt.jfed.experimenter_gui.ext_requests.ExternalUserRequestHandler;
import be.iminds.ilabt.jfed.experimenter_gui.ext_requests.FirstLoginParametersHandler;
import be.iminds.ilabt.jfed.experimenter_gui.ext_requests.JFedEnvironment;
import be.iminds.ilabt.jfed.experimenter_gui.login.UserLoginDirector;
import be.iminds.ilabt.jfed.experimenter_gui.login.UserLoginDirectorFactory;
import be.iminds.ilabt.jfed.experimenter_gui.preferences.PreferencesDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.ui.AcceleratorService;
import be.iminds.ilabt.jfed.experimenter_gui.ui.PasswordInputDialog;
import be.iminds.ilabt.jfed.experimenter_gui.ui.UncaughtGuiExceptionToBugReport;
import be.iminds.ilabt.jfed.experimenter_gui.util.DateTimeUtils;
import be.iminds.ilabt.jfed.experimenter_gui.util.MacOpenURIHandler;
import be.iminds.ilabt.jfed.experimenter_gui.util.URIUtils;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TriggeredMessage;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.gui_preferences.JFedPreferencesApplier;
import be.iminds.ilabt.jfed.highlevel.HighLevelModule;
import be.iminds.ilabt.jfed.highlevel.LowLevelModule;
import be.iminds.ilabt.jfed.highlevel.UserLoginModelModule;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.util.FXPlatformUtil;
import be.iminds.ilabt.jfed.lib.ApplicationParametersModule;
import be.iminds.ilabt.jfed.logging.JFedLoggerManager;
import be.iminds.ilabt.jfed.lowlevel.connection.SshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.GeniUserSshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.PuTTYFilesKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.lowlevel.user.UserLoginInfo;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ssh_terminal_tool.putty.PageantHelper;
import be.iminds.ilabt.jfed.ssh_terminal_tool.putty.SshKeyInfoUnlocker;
import be.iminds.ilabt.jfed.ssh_terminal_tool.unix.SshAgentHelper;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.ui.javafx.glyphs.FAGlyphFont;
import be.iminds.ilabt.jfed.ui.javafx.util.ExtraInfoCallBackGUIs;
import be.iminds.ilabt.jfed.ui.javafx.util.StageUtils;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.OSDetector;
import be.iminds.ilabt.jfed.util.library.HighStrengthCipherUtil;
import be.iminds.ilabt.jfed.util.library.JFedUtils;
import be.iminds.ilabt.jfed.util.library.JFedVersionInfo;
import be.iminds.ilabt.jfed.util.sentry.SentryUtil;
import io.sentry.Sentry;
import java.io.File;
import java.io.IOException;
import java.security.Security;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.stream.XMLInputFactory;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimenterApplication
extends Application
implements Provider<Stage>,
GeniUserProvider,
SshKeyInfoUnlocker {
    private static final int MINIMUM_JAVA_UPDATE_VERSION = 60;
    private static final Logger LOG = LoggerFactory.getLogger(ExperimenterApplication.class);
    private final GuiceContext context = new GuiceContext((Object)this, () -> {
        ArrayList<Object> modules = new ArrayList<Object>();
        Map<String, String> parameters = this.getAllParameters();
        modules.add(new ApplicationParametersModule(parameters));
        modules.add(new LowLevelModule());
        modules.add(new HighLevelModule());
        modules.add(new UserLoginModelModule(true));
        modules.add((Object)new ExperimenterModule(this));
        modules.add(new BaseGuiModule());
        return modules;
    });
    @Inject
    private JFedLoggerManager loggerManager;
    @Inject
    private JFedHLPreferences jFedPreferences;
    @Inject
    private JFedPreferencesApplier jFedPreferencesApplier;
    @Inject
    private TaskThread tt;
    @Inject
    private FXMLLoader loader;
    @Inject
    private PageantHelper pageantHelper;
    @Inject
    private PreferencesDialogFactory preferencesDialogFactory;
    private Stage primaryStage;
    @Inject
    private AcceleratorService acceleratorService;
    @Inject
    private FirstLoginParametersHandler firstLoginParametersHandler;
    @Inject
    private ExternalUserRequestHandler externalUserRequestHandler;
    @Inject
    private EnvironmentParameterHandler environmentParameterHandler;
    @Inject
    private Provider<MacOpenURIHandler> macOpenURIHandlerProvider;
    @Inject
    private JFedEnvironment environment;
    @Inject
    private JFedVersionInfo jFedVersionInfo;
    @Inject
    private UserLoginDirectorFactory userLoginDirectorFactory;
    @Inject
    private UncaughtGuiExceptionToBugReport uncaughtGuiExceptionToBugReport;
    private MacOpenURIHandler macOpenURIHandler = null;
    private ExperimenterGUI experimenterGUI;
    private Scene experimenterGuiScene;
    private GeniUser loggedInGeniUser;

    public static void main(String[] args) {
        SentryUtil.initSentry();
        System.setProperty("jdk.gtk.version", "2");
        ExperimenterApplication.checkBrokenInstall();
        ExperimenterApplication.launch((String[])args);
    }

    private static void checkBrokenInstall() {
        try {
            XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
            if (xmlInputFactory == null) {
                throw new NullPointerException();
            }
        }
        catch (Throwable t) {
            System.out.flush();
            System.err.flush();
            System.err.println("CRITICAL ERROR: one of the required libraries failed to load. \n\nThere is probably something wrong with your install. \n\nUnrecoverable error: Will exit now.");
            t.printStackTrace();
            System.err.flush();
            LOG.error("CRITICAL: one of the required libraries failed to load. There is probably something wrong with your install.", t);
            JOptionPane.showMessageDialog(new JFrame(), "CRITICAL ERROR: one of the required libraries failed to load. \n\nThere is probably something wrong with your install. \n\nUnrecoverable error: Will exit now.", "Broken Installation", 0);
            System.exit(-1);
        }
    }

    public void init() {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)UncaughtGuiExceptionLogger.getInstance(null));
        FAGlyphFont.register();
        this.context.init();
        this.loggerManager.updateLoggers();
        if (OSDetector.findOS() == OSDetector.OS.MAC) {
            this.macOpenURIHandler = (MacOpenURIHandler)this.macOpenURIHandlerProvider.get();
        }
        this.externalUserRequestHandler.handleParameters();
        this.environmentParameterHandler.handleParameters();
    }

    public void start(Stage stage) {
        block15: {
            this.primaryStage = stage;
            LOG.info("jFedVersionInfo=" + String.valueOf(this.jFedVersionInfo));
            if (!this.isRecentJavaVersion()) {
                JFDialogs.create().message("You are currently using a Java-version with known bugs, which can result in unstable behavior of jFed. Please update your Java installation to the latest version.").title("Outdated Java installation detected").masthead("Outdated Java installation detected").showWarning();
            }
            if (!HighStrengthCipherUtil.hasHighStrengthCipher()) {
                LOG.warn("Detected that the user does NOT have high-strength ciphers enabled: " + HighStrengthCipherUtil.getHighStrengthCipherDebugString());
                JFDialogs.create().message("You are currently using a Java-version that does not have high-strength ciphers. They are probably disabled by JCE policy.\n\n jFed requires high-strength ciphers for some features. If you do not fix this, you might experience connection problems, and SSH login problems. The jFed proxy will also not work without them. \n\n(If you think this message is not correct, please send a bugreport.)").title("Java with disabled high-strength ciphers").masthead("Java with disabled high-strength ciphers").showWarning();
            }
            if (!Objects.equals(System.getProperty("jdk.gtk.version"), "2")) {
                JFDialogs.create().message("Java was started with jdk.gtk.version set to \"" + System.getProperty("jdk.gtk.version") + "\", which can result in unstable behavior of some jFed GUI parts. Fix this by adding -Djdk.gtk.version=2 to your command line.").title("Know issues with jdk.gtk.version").masthead("Know issues with jdk.gtk.version").showWarning();
            }
            try {
                if (JFedUtils.getUserDataDirectory() == null) {
                    JFDialogs.create().message("Please verify your security settings and try again.\n\nIf you are trying to run jFed through Safari on OS X, you need to change your Safari security settings.\n(cfr. http://doc.fed4fire.eu/firstexperiment.html#start-up-jfed)").masthead("jFed was unable to access the filesystem.").title("Fatal Error").showError();
                    this.exit();
                    return;
                }
                ExtraInfoCallBackGUIs.prepareExtraInfoCallback((Window)stage);
                UserLoginInfo autoUserLoginInfo = this.firstLoginParametersHandler.handleParameters();
                UserLoginDirector userLoginDirector = this.userLoginDirectorFactory.createUserLoginDirector(this.environment.getLoginUrl(), autoUserLoginInfo);
                UserLoginDirector.UserLoginResult result = userLoginDirector.showAndWait();
                if (result != null && result.getLoggedInUser() != null) {
                    this.loggedInGeniUser = result.getLoggedInUser();
                    if (this.loggedInGeniUser.getPrivateKeyFile() != null && OSDetector.os.hasUnixFilePermissions() && !IOUtils.checkNoPermsForGroupAndOther((File)this.loggedInGeniUser.getPrivateKeyFile())) {
                        LOG.info("Warning user about too open login file permissions");
                        boolean changePermissions = JFDialogs.create().message("The permissions on your login file are too open. This is a security risk and can cause problems when logging in to SSH nodes. Should jFed fix this?").masthead("Login file Permissions").title("Login file Permissions").showConfirm().filter(r -> r != ButtonType.YES).isPresent();
                        if (changePermissions) {
                            LOG.debug("Changing login file permissions for file " + String.valueOf(this.loggedInGeniUser.getPrivateKeyFile()));
                            IOUtils.setUserOnlyPerms((File)this.loggedInGeniUser.getPrivateKeyFile(), (boolean)true, (boolean)false, (boolean)false);
                        }
                    }
                    boolean continueLogin = true;
                    if (!this.loggedInGeniUser.getClientCertificateChain().isEmpty()) {
                        X509Certificate cert = (X509Certificate)this.loggedInGeniUser.getClientCertificateChain().get(0);
                        try {
                            cert.checkValidity();
                        }
                        catch (CertificateExpiredException ex2) {
                            continueLogin = this.showCertificateExpiredDialog(cert);
                        }
                        catch (CertificateNotYetValidException ex2) {
                            continueLogin = this.showCertificateInvalidDialog(cert);
                        }
                    }
                    if (continueLogin) {
                        SentryUtil.setUserContext((GeniUser)this.loggedInGeniUser);
                        Sentry.setExtra((String)"jFedEnvironment.defaultSliceDuration", this.environment.getDefaultSliceDuration() != null ? this.environment.getDefaultSliceDuration().toString() : null);
                        Sentry.setExtra((String)"jFedEnvironment.customConfigurationFile", (String)this.environment.getCustomConfigurationFile());
                        Sentry.setExtra((String)"jFedEnvironment.loginUrl", (String)this.environment.getLoginUrl());
                        this.onSuccessfulLogin(stage);
                    } else {
                        this.exit();
                    }
                    break block15;
                }
                this.exit();
            }
            catch (Throwable ex) {
                LOG.error("Fatal error in jFed Experimenter Main Thread: " + ex.getMessage(), ex);
                JFDialogs.create().message("jFed experimenter will terminate.").masthead("A fatal error occurred!").title("Fatal Error").showException(ex);
                throw new RuntimeException(ex);
            }
        }
    }

    private boolean showCertificateInvalidDialog(X509Certificate cert) {
        Alert alert = new Alert(Alert.AlertType.WARNING);
        alert.setTitle("Login certificate invalid");
        alert.setHeaderText("Login certificate invalid");
        LocalDateTime startDateTime = LocalDateTime.ofInstant(cert.getNotBefore().toInstant(), ZoneId.systemDefault());
        alert.setContentText(String.format("Your login certificate is invalid, as its start date is %s. Please contact your authority for a valid certificate.", DateTimeUtils.DATE_HOUR_MINUTES_FORMATTER.format(startDateTime)));
        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        alert.setResizable(true);
        ButtonType continueButton = new ButtonType("Continue anyway", ButtonBar.ButtonData.CANCEL_CLOSE);
        ButtonType exitButton = new ButtonType("Exit", ButtonBar.ButtonData.OK_DONE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{exitButton, continueButton});
        boolean continueLogin = alert.showAndWait().filter(button -> button == continueButton).isPresent();
        return continueLogin;
    }

    private boolean showCertificateExpiredDialog(X509Certificate cert) {
        Alert alert = new Alert(Alert.AlertType.WARNING);
        alert.setTitle("Login certificate expired");
        alert.setHeaderText("Login certificate expired");
        LocalDateTime endDateTime = LocalDateTime.ofInstant(cert.getNotAfter().toInstant(), ZoneId.systemDefault());
        alert.setContentText(String.format("Your login certificate has expired on %s.\n\nTypically, you can renew your certificate at the website of your authority.\nAt the fed4fire authority, you do this by changing your password.", DateTimeUtils.DATE_HOUR_MINUTES_FORMATTER.format(endDateTime)));
        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        alert.setResizable(true);
        ButtonType continueButton = new ButtonType("Continue anyway", ButtonBar.ButtonData.CANCEL_CLOSE);
        ButtonType exitButton = new ButtonType("Exit", ButtonBar.ButtonData.OK_DONE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{exitButton, continueButton});
        boolean continueLogin = alert.showAndWait().filter(button -> button == continueButton).isPresent();
        return continueLogin;
    }

    public Map<String, String> getAllParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.putAll(this.getParameters().getNamed());
        for (String unnamedParam : this.getParameters().getUnnamed()) {
            Map<String, String> uriResult = URIUtils.processJFedUri(unnamedParam);
            if (uriResult == null) continue;
            parameters.putAll(uriResult);
        }
        return parameters;
    }

    private void onSuccessfulLogin(Stage stage) {
        try {
            if (this.jFedPreferences.getInt((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_FIRSTRUN_VERSION) < 1) {
                if (OSDetector.findOS() == OSDetector.OS.WIN) {
                    JFDialogs.create().message("The default preferences should be okay. The 'jFed proxy' is enabled by default, and typically solves connectivity issues. You can turn the proxy off in the bottom bar, or in the jFed preferences. Next you will see the preferences window, you can always revisit this by clicking the preferences button.\n\nPlease verify that jFed has found the PuTTY SSH software (you should see 4 green checkmarks). If not, first install PuTTY (full suite) or point jFed to the right PuTTY install directory.").masthead("Initial configuration").title("Welcome to the jFed Experimenter Tool!").showInformation();
                } else {
                    JFDialogs.create().message("The default preferences should be okay. The 'jFed proxy' is enabled by default, and typically solves connectivity issues. You can turn the proxy off in the bottom bar, or in the jFed preferences. Next you will see the preferences window, you can always revisit this by clicking the preferences button.").masthead("Initial configuration").title("Welcome to the jFed Experimenter Tool!").showInformation();
                }
                this.preferencesDialogFactory.showDialog();
                this.jFedPreferences.setInt((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_FIRSTRUN_VERSION, 1);
            }
            this.jFedPreferencesApplier.applyPreferences();
            this.loadExperimenterGui();
            this.uncaughtGuiExceptionToBugReport.setStage(stage);
            Thread.setDefaultUncaughtExceptionHandler(this.uncaughtGuiExceptionToBugReport);
            this.showExperimenterGui(stage);
            this.experimenterGUI.getTriggeredMessageHandler().onEvent(TriggeredMessage.GuiTrigger.LOGIN);
        }
        catch (Throwable ex) {
            LOG.error("Fatal error in jFed Experimenter Main Thread: " + ex.getMessage(), ex);
            JFDialogs.create().message("jFed experimenter will terminate.").masthead("A fatal error occurred!").title("Fatal Error").showException(ex);
            throw ex;
        }
    }

    private void registerKeysWithPageant() {
        if (OSDetector.findOS() != OSDetector.OS.WIN) {
            return;
        }
        if (this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SSHAGENT_USE, false)) {
            GeniUser geniUser;
            HashSet<Object> keys = new HashSet<Object>();
            PuTTYFilesKeyInfo sshKeyInfo = this.jFedPreferences.getCustomSshKeyInfo();
            if (sshKeyInfo == null && this.isUserLoggedIn()) {
                geniUser = this.getLoggedInGeniUser();
                sshKeyInfo = SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)geniUser);
            }
            if (sshKeyInfo == null || !sshKeyInfo.hasUnencryptedPrivateKey()) {
                // empty if block
            }
            keys.add(sshKeyInfo);
            if (!this.jFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH).equalsIgnoreCase("NEVER") && this.isUserLoggedIn()) {
                geniUser = this.getLoggedInGeniUser();
                GeniUserSshKeyInfo proxySshKeyInfo = SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)geniUser);
                keys.add(proxySshKeyInfo);
            }
            this.pageantHelper.registerKeys(keys, (SshKeyInfoUnlocker)this);
        }
    }

    private boolean isExperimentActive(Experiment experiment) {
        if (experiment.getSliceOrNull() == null) {
            return false;
        }
        for (Sliver sliver : experiment.getSlice().getSliversCopy()) {
            switch (sliver.getStatus().getGlobalStatus()) {
                case READY: 
                case UNKNOWN: 
                case NOTREADY: 
                case CHANGING: {
                    return true;
                }
            }
        }
        return false;
    }

    private Scene loadExperimenterGui() {
        LOG.debug("Loading ExperimenterGUI");
        try {
            this.loader.setLocation(((Object)((Object)this)).getClass().getResource("ExperimenterGUI.fxml"));
            this.experimenterGuiScene = new Scene((Parent)this.loader.load());
            this.experimenterGUI = (ExperimenterGUI)this.loader.getController();
            this.acceleratorService.registerOnScene(this.experimenterGuiScene);
            return this.experimenterGuiScene;
        }
        catch (IOException ex) {
            LOG.error("Error while loading ExperimenterGUI", (Throwable)ex);
            throw new RuntimeException("Error while loading ExperimenterGUI", ex);
        }
    }

    public void showExperimenterGui(Stage stage) {
        LOG.debug("Showing ExperimenterGUI");
        stage.setScene(this.experimenterGuiScene);
        stage.setMinHeight(600.0);
        stage.setMinWidth(800.0);
        stage.setHeight(800.0);
        stage.setWidth(1200.0);
        stage.setTitle("jFed Experimenter Toolkit");
        StageUtils.setJFedStageIcons((Stage)stage);
        stage.setOnCloseRequest(event -> {
            if (!this.experimenterGUI.onStageCloseRequest()) {
                event.consume();
            } else {
                this.exit();
            }
        });
        stage.setOnShown(windowEvent -> {
            this.registerKeysWithPageant();
            this.externalUserRequestHandler.activate();
        });
        stage.show();
    }

    public void exit() {
        LOG.info("Close was requested. Trying to terminate");
        if (this.experimenterGUI != null && this.experimenterGUI.getTriggeredMessageHandler() != null) {
            this.experimenterGUI.getTriggeredMessageHandler().onEvent(TriggeredMessage.GuiTrigger.EXIT);
        }
        this.tt.requestStop();
        try {
            SshAgentHelper.stopSshAgent();
        }
        catch (SshAgentHelper.SshAgentHelperException e) {
            LOG.error("Failed to stop SSH agent. Will ignore this and continue jFed shutdown.", (Throwable)e);
        }
        System.exit(0);
    }

    public Stage get() {
        return this.primaryStage;
    }

    public boolean isRecentJavaVersion() {
        String versionString = System.getProperty("java.version");
        if (versionString.startsWith("1.7")) {
            return false;
        }
        if (versionString.startsWith("1.8")) {
            int separationCharLocation = versionString.indexOf("_");
            if (separationCharLocation < 0) {
                LOG.warn("Unable to detect update version of Java in version-string {}", (Object)versionString);
                return true;
            }
            try {
                int updateVersion = Integer.parseInt(versionString.substring(separationCharLocation + 1));
                return updateVersion > 60;
            }
            catch (NumberFormatException ex) {
                LOG.warn("Could not determine Java update version in version-string {}", (Object)versionString);
                return true;
            }
        }
        return true;
    }

    @Nonnull
    public GeniUser getLoggedInGeniUser() {
        return this.loggedInGeniUser;
    }

    public boolean isUserLoggedIn() {
        return this.loggedInGeniUser != null;
    }

    public boolean unlock(SshKeyInfo sshKeyInfo) {
        return (Boolean)FXPlatformUtil.runAndWait(() -> {
            boolean success = false;
            boolean cancelled = false;
            while (!success && !cancelled) {
                PasswordInputDialog pid = new PasswordInputDialog();
                pid.setTitle("SSH Agent");
                pid.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.KEY, (Color)Color.GOLDENROD));
                pid.setHeaderText("SSH Agent");
                pid.setContentText("Enter passphrase for key '" + sshKeyInfo.getComment() + "'");
                Optional result = pid.showAndWait();
                if (result.isPresent()) {
                    success = sshKeyInfo.unlock(((String)result.get()).toCharArray());
                    continue;
                }
                cancelled = true;
            }
            return success;
        });
    }

    static {
        System.setProperty("java.awt.headless", "false");
        Security.setProperty("jdk.tls.disabledAlgorithms", "SSLv3, RC4, DES, MD5withRSA, DH keySize < 1024, EC keySize < 224, 3DES_EDE_CBC, anon, NULL");
    }
}

