/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui;

import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.util.ExperimentRestoreInformation;
import be.iminds.ilabt.jfed.experimenter_gui.GeneralRibbonTabController;
import be.iminds.ilabt.jfed.experimenter_gui.TriggeredMessageHandler;
import be.iminds.ilabt.jfed.experimenter_gui.call_gui.TasksWindow;
import be.iminds.ilabt.jfed.experimenter_gui.connectivity_tester.ConnectivityTesterDialog;
import be.iminds.ilabt.jfed.experimenter_gui.editor.EditableRspec;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ExperimentEditorEventHandler;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ExperimentEditorTab;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ribbon_tabs.EditorRibbonTab;
import be.iminds.ilabt.jfed.experimenter_gui.events.OpenESpecEvent;
import be.iminds.ilabt.jfed.experimenter_gui.events.OpenRequestRspecFromFileEvent;
import be.iminds.ilabt.jfed.experimenter_gui.events.OpenRequestRspecFromInputStreamEvent;
import be.iminds.ilabt.jfed.experimenter_gui.events.OpenRequestRspecFromUrlEvent;
import be.iminds.ilabt.jfed.experimenter_gui.events.OpenRequestRspecStringEvent;
import be.iminds.ilabt.jfed.experimenter_gui.events.OpenTutorialFromUrlEvent;
import be.iminds.ilabt.jfed.experimenter_gui.events.RecoverExperimentEvent;
import be.iminds.ilabt.jfed.experimenter_gui.events.RecoverSliceEvent;
import be.iminds.ilabt.jfed.experimenter_gui.events.StartExperimentEvent;
import be.iminds.ilabt.jfed.experimenter_gui.preferences.PreferencesDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.preferences.subsections.ProxyPane;
import be.iminds.ilabt.jfed.experimenter_gui.preferences.subsections.PuttyPane;
import be.iminds.ilabt.jfed.experimenter_gui.preferences.subsections.SshCommandPane;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ExperimentEventHandler;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ExperimentViewController;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ExperimentViewControllerFactory;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ExperimentViewControllerTab;
import be.iminds.ilabt.jfed.experimenter_gui.slice.SliceRibbonTabs;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ribbon_tabs.SliceRibbonTab;
import be.iminds.ilabt.jfed.experimenter_gui.tabs.AskOnCloseRequest;
import be.iminds.ilabt.jfed.experimenter_gui.tabs.RibbonEnabled;
import be.iminds.ilabt.jfed.experimenter_gui.tabs.StatusEnabled;
import be.iminds.ilabt.jfed.experimenter_gui.tasks.OpenESpecTask;
import be.iminds.ilabt.jfed.experimenter_gui.tasks.OpenRequestRspecTask;
import be.iminds.ilabt.jfed.experimenter_gui.tasks.OpenTutorialTask;
import be.iminds.ilabt.jfed.experimenter_gui.tasks.TasksFactory;
import be.iminds.ilabt.jfed.experimenter_gui.ui.ExperimentEditorTabHost;
import be.iminds.ilabt.jfed.experimenter_gui.ui.StatusUpdateListener;
import be.iminds.ilabt.jfed.experimenter_gui.ui.progressbar.TaskService;
import be.iminds.ilabt.jfed.experimenter_gui.ui.progressbar.TasksProgressIndicator;
import be.iminds.ilabt.jfed.experimenter_gui.ui.ribbon.RibbonBar;
import be.iminds.ilabt.jfed.experimenter_gui.ui.ribbon.RibbonTab;
import be.iminds.ilabt.jfed.experimenter_gui.ui.status.TaskStatusIndicator;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.highlevel.controller.JavaFXTaskThread;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecutionFinishedCallback;
import be.iminds.ilabt.jfed.highlevel.controller.TaskFinishedCallback;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.UserSpecHelper;
import be.iminds.ilabt.jfed.highlevel.tasks.EmulabRegistryTask;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.ListSlicesTask;
import be.iminds.ilabt.jfed.highlevel.tasks.ProjectMemberSshKeysTask;
import be.iminds.ilabt.jfed.highlevel.tasks.RecoverSliceTask;
import be.iminds.ilabt.jfed.highlevel.tasks.UserAuthorityGetVersionTask;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsCache;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsRef;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.rspec.generator.RSpecGeneratorFactory;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.ThreadFactoryUtil;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.fxml.FXML;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Window;
import javafx.util.Duration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.controlsfx.glyphfont.Glyph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ExperimenterGUI
implements StatusUpdateListener,
TaskService,
ExperimentEditorTabHost {
    private static final Logger LOG = LoggerFactory.getLogger(ExperimenterGUI.class);
    private final ExecutorService executorService = Executors.newCachedThreadPool(ThreadFactoryUtil.getFactory((String)"ExperimenterGUI"));
    private final UserAuthorityGetVersionTask getVersionTask;
    private final ObservableMap<GeniUrn, ExperimentViewController> experimentViewControllers = FXCollections.observableHashMap();
    private final Provider<ConnectivityTesterDialog> connectivityTesterDialogProvider;
    private final TaskThread taskThread;
    private final JavaFXTaskThread javaFXTaskThread;
    private final HighLevelTaskFactory hltf;
    private final GeniUserProvider geniUserProvider;
    private final SfaModel sfaModel;
    private final TasksFactory tasksFactory;
    private final Provider<TasksWindow> tasksWindowProvider;
    private final JFedHLPreferences jFedPreferences;
    private final SliceRibbonTabs sliceRibbonTabs;
    private final TriggeredMessageHandler triggeredMessageHandler;
    private final ExperimentViewControllerFactory experimentViewControllerFactory;
    private final PreferencesDialogFactory preferencesDialogFactory;
    private final RSpecGeneratorFactory rSpecGeneratorFactory;
    private final ApiCallDetailsCache apiCallDetailsCache;
    private final TestbedInfoSource testbedInfoSource;
    private final EventBus eventBus;
    private final ExperimentEventHandler experimentEventHandler;
    private final ExperimentEditorEventHandler experimentEditorEventHandler;
    @Nonnull
    private final CheckMenuItem proxyForjFedCheckMenu;
    @Nonnull
    private final CheckMenuItem proxyForSSHCheckMenu;
    @FXML
    private BorderPane root;
    @FXML
    private RibbonBar ribbonBar;
    @FXML
    private VBox noTabsOpenBox;
    @FXML
    private TabPane tabPane;
    @FXML
    private Label leftStatus;
    @FXML
    private Label rightStatus;
    @FXML
    private Button connectivityLabel;
    @FXML
    private Glyph connectivityLabelIcon;
    @FXML
    private Button pageantLabel;
    @FXML
    private Glyph pageantLabelIcon;
    @FXML
    private Tooltip pageantLabelTooltip;
    @FXML
    private TaskStatusIndicator callsStatusIndicator;
    @FXML
    private TasksProgressIndicator tasksProgressIndicator;
    @FXML
    private GeneralRibbonTabController generalRibbonTabController;
    private static final double FETCH_USERSPEC_PROGRESS = 0.7;
    private static final double FETCH_GETVERSION_PROGRESS = 0.85;

    @Inject
    public ExperimenterGUI(Provider<ConnectivityTesterDialog> connectivityTesterDialogProvider, TaskThread taskThread, SfaModel sfaModel, HighLevelTaskFactory hltf, JavaFXTaskThread javaFXTaskThread, TasksFactory tasksFactory, GeniUserProvider geniUserProvider, Provider<TasksWindow> tasksWindowProvider, JFedHLPreferences jFedPreferences, SliceRibbonTabs sliceRibbonTabs, EventBus eventBus, ExperimentEventHandler experimentEventHandler, ExperimentEditorEventHandler experimentEditorEventHandler, TriggeredMessageHandler triggeredMessageHandler, ExperimentViewControllerFactory experimentViewControllerFactory, PreferencesDialogFactory preferencesDialogFactory, RSpecGeneratorFactory rSpecGeneratorFactory, ApiCallDetailsCache apiCallDetailsCache, TestbedInfoSource testbedInfoSource) {
        this.connectivityTesterDialogProvider = connectivityTesterDialogProvider;
        this.taskThread = taskThread;
        this.sfaModel = sfaModel;
        this.hltf = hltf;
        this.javaFXTaskThread = javaFXTaskThread;
        this.tasksFactory = tasksFactory;
        this.geniUserProvider = geniUserProvider;
        this.tasksWindowProvider = tasksWindowProvider;
        this.jFedPreferences = jFedPreferences;
        this.sliceRibbonTabs = sliceRibbonTabs;
        this.eventBus = eventBus;
        this.experimentEventHandler = experimentEventHandler;
        this.experimentEditorEventHandler = experimentEditorEventHandler;
        this.triggeredMessageHandler = triggeredMessageHandler;
        this.experimentViewControllerFactory = experimentViewControllerFactory;
        this.preferencesDialogFactory = preferencesDialogFactory;
        this.rSpecGeneratorFactory = rSpecGeneratorFactory;
        this.apiCallDetailsCache = apiCallDetailsCache;
        this.testbedInfoSource = testbedInfoSource;
        this.eventBus.register((Object)this);
        this.getVersionTask = this.hltf.getUserAuthorityGetVersionTask();
        if (!this.getVersionTask.isKnown()) {
            LOG.debug("CreateSliceDialog: getVersion not known. Requesting.");
            this.taskThread.addTask((Task)this.getVersionTask);
        }
        this.proxyForjFedCheckMenu = new CheckMenuItem("Enable Proxy for jFed");
        this.proxyForSSHCheckMenu = new CheckMenuItem("Enable Proxy for SSH");
    }

    @FXML
    private void initialize() {
        this.generalRibbonTabController.registerExperimentsTabPane(this.tabPane);
        this.experimentViewControllers.addListener(change -> {
            if (change.wasRemoved()) {
                ExperimentViewController removedSliceController = (ExperimentViewController)change.getValueRemoved();
                ExperimentViewControllerTab experimentViewControllerTab = null;
                for (Tab tab : this.tabPane.getTabs()) {
                    if (!(tab instanceof ExperimentViewControllerTab) || ((ExperimentViewControllerTab)tab).getExperimentViewController() != removedSliceController) continue;
                    experimentViewControllerTab = (ExperimentViewControllerTab)tab;
                    break;
                }
                if (experimentViewControllerTab != null) {
                    this.tabPane.getTabs().remove(experimentViewControllerTab);
                }
            }
            if (change.wasAdded()) {
                ExperimentViewControllerTab experimentViewControllerTab = new ExperimentViewControllerTab((ExperimentViewController)change.getValueAdded(), this.experimentViewControllers, this.sliceRibbonTabs);
                this.tabPane.getTabs().add((Object)experimentViewControllerTab);
                this.tabPane.getSelectionModel().select((Object)experimentViewControllerTab);
            }
        });
        this.tabPane.getTabs().addListener(change -> this.noTabsOpenBox.setVisible(this.tabPane.getTabs().size() == 0));
        this.tabPane.getTabs().addListener(c -> {
            while (c.next()) {
                c.getAddedSubList().stream().filter(tab -> tab instanceof AskOnCloseRequest).forEach(tab -> tab.setOnCloseRequest(event -> {
                    if (!((AskOnCloseRequest)tab).onTabCloseRequest()) {
                        event.consume();
                    }
                }));
            }
        });
        this.tabPane.getSelectionModel().selectedItemProperty().addListener((observableValue, oldValue, newValue) -> {
            if (oldValue != null && oldValue instanceof StatusEnabled) {
                this.leftStatus.textProperty().unbind();
            }
            if (newValue != null && newValue instanceof StatusEnabled) {
                this.leftStatus.textProperty().bind((ObservableValue)((StatusEnabled)newValue).statusProperty());
            } else {
                this.leftStatus.setText("");
            }
            if (oldValue != null && oldValue instanceof RibbonEnabled) {
                this.ribbonBar.getTabs().removeAll(((RibbonEnabled)oldValue).getRibbonTabs());
            }
            if (newValue != null && newValue instanceof RibbonEnabled) {
                if (newValue instanceof ExperimentEditorTab) {
                    ((ExperimentEditorTab)newValue).getRibbonTabs().stream().filter(rt -> rt instanceof EditorRibbonTab).forEach(rt -> ((EditorRibbonTab)((Object)((Object)rt))).setActiveExperimentEditor(((ExperimentEditorTab)newValue).getExperimentEditor()));
                }
                if (newValue instanceof ExperimentViewControllerTab) {
                    ((ExperimentViewControllerTab)newValue).getRibbonTabs().stream().filter(rt -> rt instanceof SliceRibbonTab).forEach(rt -> ((SliceRibbonTab)((Object)((Object)rt))).setActiveExperimentViewController(((ExperimentViewControllerTab)newValue).getExperimentViewController()));
                }
                this.ribbonBar.getSelectionModel().selectFirst();
                this.ribbonBar.getTabs().addAll(((RibbonEnabled)newValue).getRibbonTabs());
                RibbonTab tabToActivate = ((RibbonEnabled)newValue).getInitialTabToActivate();
                this.ribbonBar.getSelectionModel().select((Object)tabToActivate);
            } else {
                this.ribbonBar.getSelectionModel().select(0);
            }
            this.fixRibbonBar();
        });
        this.javaFXTaskThread.busyProperty().addListener((observableValue, oldValue, newValue) -> this.callsStatusIndicator.setStatus(newValue != false ? TaskStatusIndicator.Status.BUSY : TaskStatusIndicator.Status.SUCCESS));
        this.callsStatusIndicator.setOnMouseClicked(mouseEvent -> this.onOpenCallOverviewAction());
        ListSlicesTask listSlicesTask = this.hltf.listSlices();
        listSlicesTask.addCallback((task, taskExecution, state) -> {
            if (taskExecution.getState() == TaskExecution.TaskState.FAILED) {
                Platform.runLater(() -> JFDialogs.create().masthead("Information call failed").message("jFed could not successfully execute a basic information call to your slice authority. Other calls will fail most likely too.\n\nThis probably indicates an authentication problem. Has your certificate been revoked? Certain actions (like changing your password at your authority) will invalidate all issued certificates.\n\nReview the call log for more information.").showError());
            }
        });
        listSlicesTask.addCallback((TaskFinishedCallback)new TaskExecutionFinishedCallback<ListSlicesTask>(){

            public void onTaskExecutionFinished(ListSlicesTask task, TaskExecution<ListSlicesTask> taskExecution, TaskExecution.TaskState state) {
                if (taskExecution.getApiCallHistory().size() == 0) {
                    return;
                }
                List apiCallHistory = taskExecution.getApiCallHistory();
                ApiCallDetailsRef callRef = (ApiCallDetailsRef)apiCallHistory.get(0);
                SerializableApiCallDetails call = ExperimenterGUI.this.apiCallDetailsCache.getApiCallDetails(callRef);
                if (call == null || call.getHttpResponseHeaders() == null) {
                    return;
                }
                Optional<String> dateLine = Arrays.stream(call.getHttpResponseHeaders().split("\n")).filter(str -> str.startsWith("Date: ")).findFirst();
                if (!dateLine.isPresent()) {
                    LOG.warn("No Date-header found to check");
                } else {
                    String date = dateLine.get().substring("Date: ".length());
                    try {
                        ZonedDateTime serverTime = ZonedDateTime.from(DateTimeFormatter.RFC_1123_DATE_TIME.parse(date));
                        ZonedDateTime userTime = ZonedDateTime.now();
                        long differenceInSeconds = Math.abs(serverTime.toEpochSecond() - userTime.toEpochSecond());
                        LOG.info("Difference between user and server time is {} seconds", (Object)differenceInSeconds);
                        if (differenceInSeconds > 3600L) {
                            Platform.runLater(() -> {
                                Alert alert = new Alert(Alert.AlertType.WARNING);
                                alert.setTitle("Incorrect System Clock");
                                alert.setHeaderText("Incorrect System Clock");
                                alert.setContentText("jFed detected a big discrepancy between your computer's system clock and that of your User Authority server. This will likely cause failures.\n\nPlease make sure that your system's clock is set correctly.");
                                alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
                                alert.showAndWait();
                            });
                        }
                    }
                    catch (DateTimeParseException ex) {
                        LOG.error("Could not parse Date in header of List Slices call. Skipping user clock check", (Throwable)ex);
                    }
                }
            }
        });
        this.taskThread.addTask((Task)listSlicesTask);
        if (Objects.equals(this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer().getDefaultComponentManagerUrn(), "urn:publicid:IDN+emulab.net+authority+cm")) {
            EmulabRegistryTask t = this.hltf.emulabRegistry(this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer());
            this.taskThread.addTask((Task)t);
        }
        ContextMenu proxyContextMenu = new ContextMenu();
        MenuItem proxySettingsMenu = new MenuItem("Proxy Settings...");
        proxyContextMenu.getItems().setAll((Object[])new MenuItem[]{this.proxyForjFedCheckMenu, this.proxyForSSHCheckMenu, new SeparatorMenuItem(), proxySettingsMenu});
        proxySettingsMenu.setOnAction(event -> this.preferencesDialogFactory.showDialog(ProxyPane.class));
        this.proxyForjFedCheckMenu.setOnAction(event -> {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_JFED, this.proxyForjFedCheckMenu.isSelected() ? "ALWAYS" : "NEVER");
            this.updateConnectivityStatusLabel();
        });
        this.proxyForSSHCheckMenu.setOnAction(event -> {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH, this.proxyForSSHCheckMenu.isSelected() ? "ALWAYS" : "NEVER");
            this.updateConnectivityStatusLabel();
        });
        this.connectivityLabel.setOnMouseClicked(event -> proxyContextMenu.show((Node)this.connectivityLabel, Side.TOP, 0.0, 0.0));
        this.pageantLabel.setOnMouseClicked(event -> this.preferencesDialogFactory.showDialog(SshCommandPane.class, PuttyPane.class));
        this.updateConnectivityStatusLabel();
    }

    private Window getDialogOwnerWindow() {
        if (this.getRoot().getScene() != null) {
            return this.getRoot().getScene().getWindow();
        }
        return null;
    }

    private void fetchAndRecoverSlice(String sliceUrnParam) {
        final GeniUrn sliceUrn = GeniUrn.parse((String)sliceUrnParam);
        if (sliceUrn == null) {
            LOG.error("Could not parse '{}' into a valid slice", (Object)sliceUrnParam);
            JFDialogs.create().owner(this.getDialogOwnerWindow()).message(String.format("jFed was unable to recover experiment '%s' because the URN cannot be parsed properly. Please verify your input.", sliceUrnParam)).masthead("Experiment recovery failed").showError();
            return;
        }
        if (!Objects.equals("slice", sliceUrn.getEncodedResourceType())) {
            LOG.error("The given URN '{}' does not have the resource type 'slice'!", (Object)sliceUrn.toString());
            JFDialogs.create().owner(this.getDialogOwnerWindow()).message(String.format("jFed was unable to recover experiment '%s' because the URN has an incorrect resource type: only the resource type 'slice' is supported! Please verify your input.", sliceUrnParam)).masthead("Experiment recovery failed").showError();
            return;
        }
        if (!Objects.equals(sliceUrn.getEncodedTopLevelAuthority_withoutSubAuth(), this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer().getDefaultComponentManagerAsGeniUrn().getEncodedTopLevelAuthority_withoutSubAuth())) {
            LOG.error("Invalid slice {} to recover: authority doesn't match user authority", (Object)sliceUrn.toString());
            JFDialogs.create().owner(this.getDialogOwnerWindow()).message(String.format("You can only open experiments that were shared on your own authority '%s'", this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer().getName())).masthead("Error while recovering shared experiment").title("Error while recovering shared experiment").showError();
            return;
        }
        javafx.concurrent.Task<Slice> fetchAndRecoverSliceTask = new javafx.concurrent.Task<Slice>(){

            protected Slice call() throws Exception {
                this.updateProgress(-1L, 0L);
                this.updateMessage("Fetching available slices");
                ListSlicesTask refreshSlicesTask = ExperimenterGUI.this.hltf.listSlices();
                TaskExecution taskExecution = ExperimenterGUI.this.taskThread.addTask((Task)refreshSlicesTask);
                while (!taskExecution.isCompleted()) {
                    Thread.sleep(100L);
                }
                return ExperimenterGUI.this.sfaModel.getSlice(sliceUrn);
            }

            protected void succeeded() {
                Slice slice = (Slice)this.getValue();
                if (slice == null) {
                    LOG.warn("Could not retrieve '{}' as one of the slices of the current user!", (Object)sliceUrn);
                    Alert alert = new Alert(Alert.AlertType.WARNING);
                    alert.initOwner(ExperimenterGUI.this.getDialogOwnerWindow());
                    alert.setTitle("Slice recovery error");
                    alert.setHeaderText("Could not retrieve slice");
                    alert.setContentText(String.format("jFed was unable to recover slice '%s'. Please check if the slice exists, hasn't expired, and if you have access to this slice.", sliceUrn));
                    alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
                    ButtonType tryAnywayButtonType = new ButtonType("Try anyway", ButtonBar.ButtonData.OTHER);
                    alert.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, tryAnywayButtonType});
                    Optional result = alert.showAndWait();
                    if (!result.isPresent() || result.get() != tryAnywayButtonType) {
                        return;
                    }
                } else {
                    RecoverSliceTask recoverSliceTask = ExperimenterGUI.this.tasksFactory.createRecoverSliceTask(slice);
                    ExperimenterGUI.this.submitTask((javafx.concurrent.Task<?>)recoverSliceTask);
                }
            }
        };
        this.submitTask(fetchAndRecoverSliceTask);
    }

    public void setSecondaryStatus(String status) {
        this.rightStatus.setText(status);
    }

    @FXML
    private void onOpenCallOverviewAction() {
        ((TasksWindow)this.tasksWindowProvider.get()).showTasks();
    }

    @FXML
    public void onOpenConnectivityTestAction() {
        ((ConnectivityTesterDialog)this.connectivityTesterDialogProvider.get()).showDialog();
    }

    public void updateConnectivityStatusLabel() {
        Color color;
        String statusText;
        if (this.connectivityLabel == null) {
            return;
        }
        assert (this.connectivityLabelIcon != null);
        assert (this.pageantLabel != null);
        String jFedProxy = this.jFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_JFED);
        String sshProxy = this.jFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH);
        if (jFedProxy == null) {
            jFedProxy = "NEVER";
        }
        if (sshProxy == null) {
            sshProxy = "NEVER";
        }
        if (Objects.equals(jFedProxy, "NEVER") && Objects.equals(sshProxy, "NEVER")) {
            statusText = "Direct connection";
            color = Color.LAWNGREEN;
            this.proxyForjFedCheckMenu.setSelected(false);
            this.proxyForSSHCheckMenu.setSelected(false);
        } else if (Objects.equals(jFedProxy, "ALWAYS") && Objects.equals(sshProxy, "ALWAYS")) {
            statusText = "Proxy fully enabled";
            color = Color.AQUA;
            this.proxyForjFedCheckMenu.setSelected(true);
            this.proxyForSSHCheckMenu.setSelected(true);
        } else if (Objects.equals(jFedProxy, "ALWAYS") && Objects.equals(sshProxy, "NEVER")) {
            statusText = "Proxy enabled for jFed only";
            color = Color.DARKORANGE;
            this.proxyForjFedCheckMenu.setSelected(true);
            this.proxyForSSHCheckMenu.setSelected(false);
        } else {
            statusText = "Proxy enabled for SSH-sessions only";
            color = Color.YELLOW;
            this.proxyForjFedCheckMenu.setSelected(false);
            this.proxyForSSHCheckMenu.setSelected(true);
        }
        this.connectivityLabel.setText(statusText);
        this.connectivityLabelIcon.setColor(color);
        boolean agentActive = this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SSHAGENT_USE, false);
        this.pageantLabelIcon.setTextFill((Paint)(agentActive ? Color.BLUE : Color.DARKGRAY));
        this.pageantLabelTooltip.setShowDelay(Duration.ZERO);
        this.pageantLabelTooltip.setText(agentActive ? "SSH agent activated" : "No SSH agent");
    }

    @Override
    @Subscribe
    public void submitTask(javafx.concurrent.Task<?> task) {
        this.tasksProgressIndicator.followTaskProgress(task);
        this.executorService.submit((Runnable)task);
    }

    private void fixRibbonBar() {
        ArrayList tabs = new ArrayList(this.ribbonBar.getTabs());
        Tab activeTab = (Tab)this.ribbonBar.getSelectionModel().getSelectedItem();
        this.ribbonBar.getTabs().clear();
        RibbonBar newRibbonBar = new RibbonBar();
        newRibbonBar.getTabs().addAll(tabs);
        newRibbonBar.getSelectionModel().select((Object)activeTab);
        this.root.setTop((Node)newRibbonBar);
        this.ribbonBar = newRibbonBar;
    }

    public BorderPane getRoot() {
        return this.root;
    }

    @Override
    public void setStatus(String status) {
        this.setSecondaryStatus(status);
    }

    @Override
    public void addExperimentEditorTab(ExperimentEditorTab experimentEditorTab) {
        this.tabPane.getTabs().add((Object)experimentEditorTab);
    }

    @Override
    public void showExperimentEditorTab(ExperimentEditorTab experimentEditorTab) {
        this.tabPane.getSelectionModel().select((Object)experimentEditorTab);
    }

    @Override
    public List<ExperimentEditorTab> getExperimentEditorTabs() {
        return this.tabPane.getTabs().stream().filter(tab -> tab instanceof ExperimentEditorTab).map(tab -> (ExperimentEditorTab)tab).collect(Collectors.toList());
    }

    public ObservableList<Tab> getTabs() {
        return this.tabPane.getTabs();
    }

    @Subscribe
    public void startExperiment(StartExperimentEvent event) {
        this.submitTask(new CreateExperimentTask(event));
    }

    @Nonnull
    private Collection<Server> getServers(@Nullable RequestRspecSource rspecSource) {
        if (rspecSource == null) {
            return Collections.emptyList();
        }
        return rspecSource.getAllComponentManagerUrns().stream().filter(Objects::nonNull).map(urn -> this.testbedInfoSource.getByUrn(urn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_TOPLEVEL, TestbedInfoSource.SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY, true)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Subscribe
    public void fetchAndRecoverSlice(RecoverSliceEvent event) {
        this.fetchAndRecoverSlice(event.getSliceUrn());
    }

    @Subscribe
    public void recoverExperiment(RecoverExperimentEvent event) {
        assert (event.getExperiment().getSliceOrNull() != null);
        this.experimentViewControllers.put((Object)event.getExperiment().getSliceOrNull().getUrn(), (Object)this.experimentViewControllerFactory.createExperimentViewController(event.getExperiment()));
    }

    @Subscribe
    public void openRequestRspec(OpenRequestRspecFromUrlEvent event) {
        try {
            OpenRequestRspecTask openRequestRspecTask = this.tasksFactory.createOpenRequestRspecTaskFromUrl(this.getDialogOwnerWindow(), event.getUrlString());
            this.submitTask(openRequestRspecTask);
        }
        catch (IOException e) {
            LOG.error("Could not open request rspec '{}'", (Object)event.getUrlString(), (Object)e);
            new Alert(Alert.AlertType.ERROR, "The RSpec '" + event.getUrlString() + "' could not be opened.", new ButtonType[0]).showAndWait();
        }
    }

    @Subscribe
    public void openRequestRspec(OpenRequestRspecFromFileEvent event) {
        try {
            OpenRequestRspecTask readFileTask = this.tasksFactory.createOpenRequestRspecTask(this.getDialogOwnerWindow(), event.getFile());
            this.submitTask(readFileTask);
        }
        catch (FileNotFoundException e) {
            new Alert(Alert.AlertType.ERROR, "The RSpec-file '" + event.getFile().getAbsolutePath() + "' could not be opened.", new ButtonType[0]).showAndWait();
        }
    }

    @Subscribe
    public void openRequestRspec(OpenRequestRspecStringEvent event) {
        javafx.concurrent.Task<EditableRspec> readFileTask = this.tasksFactory.createOpenRequestRspecTaskFromString(this.getDialogOwnerWindow(), event.getRequestRspec());
        this.submitTask(readFileTask);
    }

    @Subscribe
    public void openRequestRspec(OpenRequestRspecFromInputStreamEvent event) {
        OpenRequestRspecTask readFileTask = this.tasksFactory.createOpenRequestRspecTask(this.getDialogOwnerWindow(), event.getInputStream(), event.getLength(), event.getFileName(), null);
        this.submitTask(readFileTask);
    }

    @Subscribe
    public void openTutorial(OpenTutorialFromUrlEvent event) {
        try {
            OpenTutorialTask openTutorialTask = this.tasksFactory.createOpenTutorialTask(this.getDialogOwnerWindow(), event.getUrlString());
            this.submitTask(openTutorialTask);
        }
        catch (IOException ex) {
            LOG.error("Could not open tutorial '{}'", (Object)event.getUrlString(), (Object)ex);
            new Alert(Alert.AlertType.ERROR, "The tutorial '" + event.getUrlString() + "' could not be opened.", new ButtonType[0]).showAndWait();
        }
    }

    @Subscribe
    public void openExperimentSpecification(OpenESpecEvent event) {
        try {
            OpenESpecTask openESpecTask = this.tasksFactory.createOpenESpecTask(this.getDialogOwnerWindow(), event);
            this.submitTask(openESpecTask);
        }
        catch (IOException ex) {
            LOG.error("Could not open ESpec", (Throwable)ex);
            new Alert(Alert.AlertType.ERROR, "The ESpec could not be opened.", new ButtonType[0]).showAndWait();
        }
    }

    public boolean onStageCloseRequest() {
        ArrayList tabsCopy = new ArrayList(this.tabPane.getTabs());
        for (Tab tab : tabsCopy) {
            if (!(tab instanceof AskOnCloseRequest)) continue;
            this.tabPane.getSelectionModel().select((Object)tab);
            if (((AskOnCloseRequest)tab).onTabCloseRequest()) continue;
            return false;
        }
        return true;
    }

    public TriggeredMessageHandler getTriggeredMessageHandler() {
        return this.triggeredMessageHandler;
    }

    public class CreateExperimentTask
    extends javafx.concurrent.Task<Experiment> {
        private final StartExperimentEvent event;
        private GeniUrn sliceUrn;

        private CreateExperimentTask(StartExperimentEvent event) {
            this.event = event;
            this.updateTitle("Starting experiment '" + event.getSliceName() + "'");
        }

        protected Experiment call() throws Exception {
            Experiment res;
            List userSpecs = null;
            List shareWith = Collections.emptyList();
            if (this.event.isAutoShareExperiment() && this.event.getSubAuthName() != null) {
                ProjectMemberSshKeysTask task = ExperimenterGUI.this.hltf.getProjectMembersSSHKeys(this.event.getSubAuthName());
                LOG.debug("CreateExperimentTask.call: ProjectMemberSshKeysTask.newExecutionNeeded()=" + task.newExecutionNeeded());
                if (task.newExecutionNeeded()) {
                    LOG.info("Requesting project member info before continuing");
                    this.updateMessage("Requesting project members info");
                    TaskExecution taskExecution = ExperimenterGUI.this.taskThread.addTask((Task)task);
                    while (!taskExecution.isCompleted()) {
                        if (task.getTotalMembersCount() != -1) {
                            this.updateMessage(String.format("Requesting project members info (%d/%d)", task.getMemberInfoRequested(), task.getTotalMembersCount()));
                            this.updateProgress(0.7 * (double)task.getMemberInfoRequested() / (double)task.getTotalMembersCount(), 1.0);
                        }
                        Thread.sleep(250L);
                    }
                }
                LOG.debug("CreateExperimentTask.call: ProjectMemberSshKeysTask.getTotalMembersCount()=" + task.getTotalMembersCount() + " ProjectMemberSshKeysTask.getTotalKeyCount()=" + task.getTotalKeyCount());
                userSpecs = UserSpecHelper.getProjectMemberUserSpecs((String)this.event.getSubAuthName(), (SfaModel)ExperimenterGUI.this.sfaModel);
                shareWith = new ArrayList(ExperimenterGUI.this.sfaModel.getUsersBySubAuthority(this.event.getSubAuthName()));
                shareWith.remove(ExperimenterGUI.this.geniUserProvider.getLoggedInGeniUser().getUserUrn());
                LOG.debug("CreateExperimentTask.call: userSpecs.size()={}", (Object)userSpecs.size());
            }
            this.updateMessage("Processing");
            LOG.debug("Starting experiment {} in sub-auth {} (expiration {})", new Object[]{this.event.getSliceName(), this.event.getSubAuthName(), ZonedDateTime.ofInstant(this.event.getExpirationTime(), ZoneId.systemDefault())});
            Server userAuthorityServer = ExperimenterGUI.this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer();
            assert (userAuthorityServer != null);
            Object topLevelAuthority = userAuthorityServer.getDefaultComponentManagerAsGeniUrn().getEncodedTopLevelAuthority();
            if (this.event.getSubAuthName() != null) {
                topLevelAuthority = (String)topLevelAuthority + ":" + this.event.getSubAuthName();
            }
            this.sliceUrn = GeniUrn.createGeniUrnFromEncodedParts((String)topLevelAuthority, (String)"slice", (String)this.event.getSliceName());
            Slice slice = ExperimenterGUI.this.sfaModel.getSlice(this.sliceUrn);
            if (slice == null) {
                ExperimentRestoreInformation sri;
                while (!ExperimenterGUI.this.getVersionTask.isKnown()) {
                    this.updateMessage("Retrieving slice authority information");
                    this.updateProgress(0.85, 1.0);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!ExperimenterGUI.this.getVersionTask.isSupportSliverRegistration() && ExperimentRestoreInformation.exists((GeniUrn)this.sliceUrn) && (sri = new ExperimentRestoreInformation(this.sliceUrn)).getExpirationTime() != null && sri.getExpirationTime().isAfter(Instant.now())) {
                    FutureTask<Boolean> warnForRecoveryFileOverwriteTask = new FutureTask<Boolean>(() -> {
                        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                        alert.setContentText(String.format("There currently exists a recovery file for slice %s. By re-using this slice, this backup will be overwritten. Are you sure you want to continue?", this.event.getSliceName()));
                        alert.setHeaderText("Slice Recovery Data");
                        alert.setTitle("Slice Recovery Data");
                        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
                        alert.setResizable(true);
                        return alert.showAndWait().filter(r -> Objects.equals(r, ButtonType.YES)).isPresent();
                    });
                    Platform.runLater(warnForRecoveryFileOverwriteTask);
                    if (warnForRecoveryFileOverwriteTask.get().booleanValue()) {
                        return null;
                    }
                }
                res = this.event.getESpecBundle() != null ? new Experiment(null, this.event.getSliceName(), this.event.getSubAuthName(), shareWith, this.event.getESpecBundle(), this.event.getStartTime(), this.event.getExpirationTime(), userSpecs, this.event.isRequestSla(), ExperimenterGUI.this.rSpecGeneratorFactory, ExperimenterGUI.this.jFedPreferences.getGitAuthPreferences(ExperimenterGUI.this.geniUserProvider.getLoggedInGeniUser()), this.event.isLinkTestRequested(), null) : new Experiment(this.event.getSliceName(), this.event.getSubAuthName(), shareWith, this.event.getRequestRspecSource(), this.event.getStartTime(), this.event.getExpirationTime(), userSpecs, this.event.isRequestSla(), this.event.isLinkTestRequested(), null);
            } else {
                slice = ExperimenterGUI.this.sfaModel.resetSlice(this.sliceUrn);
                res = this.event.getESpecBundle() != null ? new Experiment(slice, null, null, shareWith, this.event.getESpecBundle(), this.event.getStartTime(), this.event.getExpirationTime(), userSpecs, this.event.isRequestSla(), ExperimenterGUI.this.rSpecGeneratorFactory, ExperimenterGUI.this.jFedPreferences.getGitAuthPreferences(ExperimenterGUI.this.geniUserProvider.getLoggedInGeniUser()), this.event.isLinkTestRequested(), null) : new Experiment(slice, this.event.getRequestRspecSource(), this.event.getStartTime(), this.event.getExpirationTime(), userSpecs, null, this.event.isRequestSla(), this.event.isLinkTestRequested(), null);
            }
            if (ExperimenterGUI.this.getServers(res.getNewRequestRspecSource()).stream().anyMatch(server -> server.hasFlag(Server.Flag.workaroundInsanelyLongProvisionTime))) {
                res.setMaxWaitUntilReady(Experiment.DEFAULT_LONG_MAX_WAIT_UNTIL_READY);
            }
            return res;
        }

        protected void succeeded() {
            Experiment experiment = (Experiment)this.getValue();
            if (experiment != null) {
                LOG.info("CreateExperimentTask.succeeded creates ExperimentViewController");
                ExperimentViewController experimentViewController = ExperimenterGUI.this.experimentViewControllerFactory.createExperimentViewController(experiment);
                ExperimenterGUI.this.experimentViewControllers.put((Object)this.sliceUrn, (Object)experimentViewController);
            } else {
                LOG.debug("No experiment to visualize");
            }
        }

        public <T extends Task> TaskExecution<T> submitTaskAndWait(T task) throws InterruptedException {
            CountDownLatch latch = new CountDownLatch(1);
            TaskExecution taskExecution = ExperimenterGUI.this.taskThread.addTask(task, (t, te, state) -> latch.countDown());
            latch.await();
            return taskExecution;
        }
    }
}

