/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui;

import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experimenter_gui.ExperimenterApplication;
import be.iminds.ilabt.jfed.experimenter_gui.ExperimenterGUI;
import be.iminds.ilabt.jfed.experimenter_gui.config.AdvertisementFetchManager;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedExperimenterGuiConfigProvider;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfigImpl;
import be.iminds.ilabt.jfed.experimenter_gui.config.util.GuiConfigRSpecGenerator;
import be.iminds.ilabt.jfed.experimenter_gui.config.util.GuiConfigStitchingTestRSpecGenerator;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.DialogsFactory;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.DialogsFactoryImpl;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ExperimentViewController;
import be.iminds.ilabt.jfed.experimenter_gui.tasks.TasksFactory;
import be.iminds.ilabt.jfed.experimenter_gui.tasks.TasksFactoryImpl;
import be.iminds.ilabt.jfed.experimenter_gui.ui.ExperimentEditorTabHost;
import be.iminds.ilabt.jfed.experimenter_gui.ui.StatusUpdateListener;
import be.iminds.ilabt.jfed.experimenter_gui.ui.progressbar.TaskService;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartController;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartControllerManager;
import be.iminds.ilabt.jfed.highlevel.jobs.sfa_parts.SfaExperimentPartController;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.rspec.generator.RSpecGenerator;
import be.iminds.ilabt.jfed.rspec.generator.RSpecGeneratorFactory;
import be.iminds.ilabt.jfed.rspec.generator.StitchingTestRSpecGenerator;
import be.iminds.ilabt.jfed.ssh_terminal_tool.putty.SshKeyInfoUnlocker;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import com.google.common.eventbus.DeadEvent;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.eventbus.SubscriberExceptionHandler;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import javafx.application.HostServices;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.stage.Stage;
import javax.annotation.Nonnull;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimenterModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(ExperimenterModule.class);
    private final ObservableMap<GeniUrn, ExperimentViewController> experimentViewControllers = FXCollections.observableHashMap();
    private final Logger eventbusLogger = LoggerFactory.getLogger((String)"Experimenter-EventBus");
    private final ExperimenterApplication launch;

    public ExperimenterModule(ExperimenterApplication launch) {
        this.launch = launch;
    }

    @Provides
    public HostServices provideHostServices(ExperimenterApplication launch) {
        return launch.getHostServices();
    }

    @Provides
    @Singleton
    public ExperimentPartControllerManager getEpcManager(Provider<SfaExperimentPartController> sfaExperimentPartControllerProvider) {
        ExperimentPartControllerManager epcManager = new ExperimentPartControllerManager(true);
        epcManager.registerController(SfaExperimentPart.class, (ExperimentPartController)sfaExperimentPartControllerProvider.get());
        return epcManager;
    }

    @Provides
    @Singleton
    private RSpecGeneratorFactory getRSpecGeneratorFactory(final JFedGuiConfig guiConfig, final AuthorityFinder authorityFinder, final TestbedInfoSource testbedInfoSource) {
        return new RSpecGeneratorFactory(){

            @Nonnull
            public RSpecGenerator createRSpecGenerator() {
                return new GuiConfigRSpecGenerator(guiConfig, authorityFinder, testbedInfoSource);
            }

            @Nonnull
            public StitchingTestRSpecGenerator createStitchingTestRSpecGenerator() {
                return new GuiConfigStitchingTestRSpecGenerator(guiConfig, authorityFinder, testbedInfoSource);
            }
        };
    }

    protected void configure() {
        this.bind(ExperimenterApplication.class).toInstance((Object)this.launch);
        this.bind(GeniUserProvider.class).to(ExperimenterApplication.class);
        this.bind(Stage.class).annotatedWith((Annotation)Names.named((String)"parentStage")).toProvider(ExperimenterApplication.class);
        this.bind(SshKeyInfoUnlocker.class).to(ExperimenterApplication.class);
        this.bind(StatusUpdateListener.class).to(ExperimenterGUI.class);
        this.bind(TaskService.class).to(ExperimenterGUI.class);
        this.bind(ExperimentEditorTabHost.class).to(ExperimenterGUI.class);
        this.bind(DialogsFactory.class).to(DialogsFactoryImpl.class);
        this.bind(TasksFactory.class).to(TasksFactoryImpl.class);
        this.bind(JFedGuiConfig.class).to(JFedGuiConfigImpl.class).in(Singleton.class);
        this.bind(AdvertisementFetchManager.class).in(Singleton.class);
        this.bind(JFedExperimenterGuiConfigProvider.class).in(Singleton.class);
        SubscriberExceptionHandler subscriberExceptionHandler = (exception, context) -> this.eventbusLogger.error("Error while processing event " + String.valueOf(context.getEvent()) + " at " + context.getSubscriber().getClass().toGenericString() + "#" + context.getSubscriberMethod().toGenericString(), exception);
        final EventBus eventBus = new EventBus(subscriberExceptionHandler);
        eventBus.register((Object)this);
        this.bind(EventBus.class).toInstance((Object)eventBus);
        this.bindListener(Matchers.any(), new TypeListener(){

            public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
                typeEncounter.register(arg_0 -> ((EventBus)eventBus).register(arg_0));
            }
        });
    }

    @Subscribe
    public void handleDeadEventBusEvent(DeadEvent deadEvent) {
        this.eventbusLogger.warn("Detected a dead event in eventbus: {}. Submitted by {}", deadEvent.getEvent(), deadEvent.getSource());
    }
}

