/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentState;
import be.iminds.ilabt.jfed.experimenter_gui.TriggeredMessageHandler;
import be.iminds.ilabt.jfed.experimenter_gui.bugreporting.BugReportDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.AboutDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.JFedBrowser;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.OpenESpecDialog;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.RecoverSliceDialog;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.TestbedSiteDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ExperimentEditor;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ExperimentEditorTab;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ExperimentEditorTabFactory;
import be.iminds.ilabt.jfed.experimenter_gui.events.OpenRequestRspecFromFileEvent;
import be.iminds.ilabt.jfed.experimenter_gui.events.OpenRequestRspecFromUrlEvent;
import be.iminds.ilabt.jfed.experimenter_gui.events.OpenTutorialFromUrlEvent;
import be.iminds.ilabt.jfed.experimenter_gui.events.RecoverSliceEvent;
import be.iminds.ilabt.jfed.experimenter_gui.preferences.PreferencesDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ExperimentViewController;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ExperimentViewControllerTab;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.TerminateExperimentEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.UpdateExperimentEvent;
import be.iminds.ilabt.jfed.experimenter_gui.ui.ribbon.RibbonButton;
import be.iminds.ilabt.jfed.experimenter_gui.util.BrowserUtil;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TriggeredMessage;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.util.BindingsUtil;
import com.google.common.eventbus.EventBus;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.controlsfx.glyphfont.FontAwesome;
import org.reactfx.value.Val;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralRibbonTabController {
    private static final Logger LOG = LoggerFactory.getLogger(GeneralRibbonTabController.class);
    @FXML
    private RibbonButton newExperimentButton;
    @FXML
    private RibbonButton openExperimentButton;
    @FXML
    private RibbonButton openExperimentURLButton;
    @FXML
    private RibbonButton saveExperimentButton;
    @FXML
    private RibbonButton preferencesButton;
    @FXML
    private RibbonButton startExperimentButton;
    @FXML
    private RibbonButton updateExperimentButton;
    @FXML
    private RibbonButton stopExperimentButton;
    @FXML
    private RibbonButton recoverExperimentButton;
    @FXML
    private RibbonButton openSharedExperimentButton;
    @FXML
    private RibbonButton openTutorialURLButton;
    @FXML
    private RibbonButton openWilab2ReservationButton;
    @FXML
    private RibbonButton openESpecButton;
    @FXML
    private Menu openReservationMenu;
    private final GeniUserProvider geniUserProvider;
    private final BugReportDialogFactory bugReportDialogFactory;
    private final Provider<RecoverSliceDialog> recoverSliceDialogProvider;
    private final Provider<OpenESpecDialog> openESpecDialogProvider;
    private final PreferencesDialogFactory preferencesDialogFactory;
    private final AboutDialogFactory aboutDialogFactory;
    private final BrowserUtil browserUtil;
    @Named(value="primaryStage")
    private final Provider<Stage> primaryStageProvider;
    private final JFedHLPreferences jFedPreferences;
    private final JFedGuiConfig guiConfig;
    private final ExperimentEditorTabFactory experimentEditorTabFactory;
    private final EventBus eventBus;
    private final TriggeredMessageHandler triggeredMessageHandler;
    private final TestbedSiteDialogFactory testbedSiteDialogFactory;
    private final TestbedInfoSource testbedInfoSource;
    private final boolean isDemo = new JFedHLPreferences().getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_IS_DEMO, false);
    private TabPane tabPane;

    @Inject
    GeneralRibbonTabController(GeniUserProvider geniUserProvider, BugReportDialogFactory bugReportDialogFactory, Provider<RecoverSliceDialog> recoverSliceDialogProvider, Provider<OpenESpecDialog> openESpecDialogProvider, PreferencesDialogFactory preferencesDialogFactory, AboutDialogFactory aboutDialogFactory, BrowserUtil browserUtil, Provider<Stage> primaryStageProvider, JFedHLPreferences jFedPreferences, JFedGuiConfig guiConfig, ExperimentEditorTabFactory experimentEditorTabFactory, EventBus eventBus, TriggeredMessageHandler triggeredMessageHandler, TestbedSiteDialogFactory testbedSiteDialogFactory, TestbedInfoSource testbedInfoSource) {
        this.geniUserProvider = geniUserProvider;
        this.bugReportDialogFactory = bugReportDialogFactory;
        this.recoverSliceDialogProvider = recoverSliceDialogProvider;
        this.openESpecDialogProvider = openESpecDialogProvider;
        this.preferencesDialogFactory = preferencesDialogFactory;
        this.aboutDialogFactory = aboutDialogFactory;
        this.browserUtil = browserUtil;
        this.primaryStageProvider = primaryStageProvider;
        this.jFedPreferences = jFedPreferences;
        this.guiConfig = guiConfig;
        this.experimentEditorTabFactory = experimentEditorTabFactory;
        this.eventBus = eventBus;
        this.triggeredMessageHandler = triggeredMessageHandler;
        this.testbedSiteDialogFactory = testbedSiteDialogFactory;
        this.testbedInfoSource = testbedInfoSource;
    }

    @FXML
    private void initialize() {
        Server userAuth = this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer();
        boolean usersSeeSharedSlices = ApiInfo.findUrl((Server)userAuth, (ApiInfo.ApiName)ApiInfo.ApiName.GENI_CH_SA, (int)2) != null;
        this.openSharedExperimentButton.setVisible(!usersSeeSharedSlices);
        this.openSharedExperimentButton.setManaged(!usersSeeSharedSlices);
        this.preferencesButton.setDisable(this.isDemo || this.guiConfig.isPreferencesDisabled());
        this.openTutorialURLButton.setVisible(this.guiConfig.isShowTutorialButtonEnabled());
        this.openESpecButton.setVisible(true);
        if (JFedBrowser.JFED_BROWSER_WORKS) {
            for (Server server : this.guiConfig.getAllServersInVisibleResources()) {
                for (Service service : server.getServices()) {
                    if (!service.getApi().equalsIgnoreCase(ApiInfo.ApiName.FED4FIRE_RESERVATION_CALENDER_PAGE.getId())) continue;
                    MenuItem menuItem = new MenuItem(server.getName());
                    menuItem.setGraphic((Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.CALENDAR, (Color)Color.BLACK));
                    menuItem.setOnAction(ae -> this.onReservationPageAction((ActionEvent)ae, service, server));
                    this.openReservationMenu.getItems().add((Object)menuItem);
                }
            }
        } else {
            for (Server server : this.guiConfig.getAllServersInVisibleResources()) {
                for (Service service : server.getServices()) {
                    if (!service.getApi().equalsIgnoreCase(ApiInfo.ApiName.FED4FIRE_RESERVATION_CALENDER_PAGE.getId())) continue;
                    MenuItem menuItem = new MenuItem(server.getName());
                    menuItem.setGraphic((Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.CALENDAR, (Color)Color.BLACK));
                    menuItem.setOnAction(ae -> this.browserUtil.openUrlInBrowser(service.getUrl()));
                    this.openReservationMenu.getItems().add((Object)menuItem);
                }
            }
        }
    }

    @FXML
    public void onReservationPageAction(@Nonnull ActionEvent ae, @Nonnull Service service, @Nonnull Server server) {
        Testbed testbed = server.getTestbed();
        try {
            this.testbedSiteDialogFactory.showDialog(testbed, new URL(service.getUrl()), server.getName() + " Reservation");
        }
        catch (MalformedURLException e) {
            LOG.error("Error in URL: '" + service.getUrl() + "'", (Throwable)e);
        }
    }

    void registerExperimentsTabPane(TabPane tabPane) {
        this.tabPane = tabPane;
        BooleanBinding isNoExperimentEditorTabSelectedBinding = Bindings.not((ObservableBooleanValue)BindingsUtil.instanceOfBinding((ObservableValue)tabPane.getSelectionModel().selectedItemProperty(), ExperimentEditorTab.class));
        this.saveExperimentButton.disableProperty().bind((ObservableValue)isNoExperimentEditorTabSelectedBinding);
        this.startExperimentButton.disableProperty().bind((ObservableValue)isNoExperimentEditorTabSelectedBinding);
        Val experimentVal = Val.wrap((ObservableValue)tabPane.getSelectionModel().selectedItemProperty()).filter(tab -> tab instanceof ExperimentViewControllerTab).map(ExperimentViewControllerTab.class::cast).map(ExperimentViewControllerTab::getExperimentViewController).map(ExperimentViewController::getExperiment);
        Val manifestUnavailableVal = experimentVal.flatMap(Experiment::sliceProperty).flatMap(Slice::manifestRspecProperty).map(Objects::isNull).orElseConst((Object)true);
        this.updateExperimentButton.disableProperty().bind((ObservableValue)manifestUnavailableVal);
        if (!this.isDemo && !this.guiConfig.isExperimentDeleteDisabled()) {
            Val terminatedVal = experimentVal.flatMap(Experiment::experimentStateProperty).map(ExperimentState::isTerminated);
            this.stopExperimentButton.disableProperty().bind((ObservableValue)manifestUnavailableVal.orElse((ObservableValue)terminatedVal));
        } else {
            this.stopExperimentButton.setDisable(true);
        }
    }

    @FXML
    public void onNewExperimentAction(ActionEvent actionEvent) {
        try {
            this.triggeredMessageHandler.onEvent(TriggeredMessage.GuiTrigger.DESIGN_EXPERIMENT);
        }
        catch (Exception e) {
            LOG.warn("Exception processing TriggeredMessage (will be ignored)", (Throwable)e);
        }
        ExperimentEditorTab newTab = this.experimentEditorTabFactory.createExperimentEditorTab();
        this.tabPane.getTabs().add((Object)newTab);
        this.tabPane.getSelectionModel().select((Object)newTab);
    }

    @FXML
    private void onOpenExperimentAction() {
        List files;
        File dir;
        FileChooser fc = new FileChooser();
        fc.setTitle("Open Experiment Definition");
        if (System.getProperty("user.home") != null) {
            fc.setInitialDirectory(new File(System.getProperty("user.home")));
        }
        if (this.jFedPreferences.containsPreference((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST) && (dir = new File(this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST))).exists()) {
            fc.setInitialDirectory(dir);
        }
        if ((files = fc.showOpenMultipleDialog(this.openExperimentButton.getScene().getWindow())) == null) {
            return;
        }
        this.jFedPreferences.setString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST, ((File)files.get(0)).getParentFile().getAbsolutePath());
        for (File file : files) {
            this.eventBus.post((Object)new OpenRequestRspecFromFileEvent(file));
        }
    }

    @FXML
    public void onOpenExperimentFromURLAction() {
        VBox vbox = new VBox(5.0);
        Label label = new Label("Please enter the URL:");
        TextField urlTextField = new TextField();
        urlTextField.setPrefColumnCount(40);
        vbox.getChildren().addAll((Object[])new Node[]{label, urlTextField});
        Dialog dialog = new Dialog();
        DialogPane dialogPane = new DialogPane();
        dialogPane.setContent((Node)vbox);
        dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        dialogPane.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.CLOUD_DOWNLOAD, (Color)Color.CHOCOLATE));
        dialog.initOwner(this.openExperimentURLButton.getScene().getWindow());
        dialog.setTitle("Open Experiment Definition");
        dialog.setDialogPane(dialogPane);
        dialog.setResultConverter(param -> {
            if (param == ButtonType.OK) {
                return urlTextField.getText();
            }
            return null;
        });
        dialog.showAndWait().ifPresent(input -> this.eventBus.post((Object)new OpenRequestRspecFromUrlEvent((String)input)));
    }

    @FXML
    public void onOpenTutorialFromURLAction() {
        VBox vbox = new VBox(5.0);
        Label label = new Label("Please enter the URL:");
        TextField urlTextField = new TextField();
        urlTextField.setPrefColumnCount(40);
        String defaultTutorialUrl = this.guiConfig.getStringFlag("defaultTutorialUrl");
        if (defaultTutorialUrl != null) {
            urlTextField.setText(defaultTutorialUrl);
        } else {
            urlTextField.setText("");
        }
        vbox.getChildren().addAll((Object[])new Node[]{label, urlTextField});
        Dialog dialog = new Dialog();
        DialogPane dialogPane = new DialogPane();
        dialogPane.setContent((Node)vbox);
        dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        dialogPane.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.GRADUATION_CAP, (Color)Color.CHOCOLATE));
        dialog.initOwner(this.openExperimentURLButton.getScene().getWindow());
        dialog.setTitle("Open Tutorial");
        dialog.setDialogPane(dialogPane);
        dialog.setResultConverter(param -> {
            if (param == ButtonType.OK) {
                return urlTextField.getText();
            }
            return null;
        });
        dialog.showAndWait().ifPresent(input -> this.eventBus.post((Object)new OpenTutorialFromUrlEvent((String)input)));
    }

    @FXML
    public void onOpenESpecAction() {
        Dialog dialog = (Dialog)this.openESpecDialogProvider.get();
        dialog.initOwner(this.openExperimentURLButton.getScene().getWindow());
        dialog.show();
    }

    @FXML
    private void onRecoverExperimentAction() {
        try {
            this.triggeredMessageHandler.onEvent(TriggeredMessage.GuiTrigger.RECOVER_EXPERIMENT);
        }
        catch (Exception e) {
            LOG.warn("Exception processing TriggeredMessage (will be ignored)", (Throwable)e);
        }
        ((RecoverSliceDialog)((Object)this.recoverSliceDialogProvider.get())).show();
    }

    private ExperimentEditor getActiveExperimentEditor() {
        if (this.tabPane.getSelectionModel().getSelectedItem() instanceof ExperimentEditorTab) {
            return ((ExperimentEditorTab)this.tabPane.getSelectionModel().getSelectedItem()).getExperimentEditor();
        }
        return null;
    }

    @FXML
    private void onSaveExperimentAction() {
        ExperimentEditor activeExperimentEditor = this.getActiveExperimentEditor();
        if (activeExperimentEditor != null) {
            activeExperimentEditor.save();
        } else {
            LOG.error("Unexpected: onSaveExperimentAction with activeExperimentEditor=null (will fall back to doing nothing)");
        }
    }

    private ExperimentViewController getActiveExperimentViewController() {
        if (this.tabPane.getSelectionModel().getSelectedItem() instanceof ExperimentViewControllerTab) {
            return ((ExperimentViewControllerTab)this.tabPane.getSelectionModel().getSelectedItem()).getExperimentViewController();
        }
        return null;
    }

    @FXML
    private void onUpdateExperimentAction() {
        assert (this.getActiveExperimentViewController() != null);
        this.eventBus.post((Object)new UpdateExperimentEvent(this.updateExperimentButton.getScene().getWindow(), this.getActiveExperimentViewController().getExperimentController()));
    }

    @FXML
    private void onStopExperimentAction() {
        assert (this.getActiveExperimentViewController() != null);
        if (this.getActiveExperimentViewController() == null) {
            LOG.error("onStopExperimentAction() when no active experiment view controller");
            return;
        }
        LOG.info("User clicked Terminate button in general ribbon");
        this.eventBus.post((Object)new TerminateExperimentEvent(this.stopExperimentButton.getScene().getWindow(), this.getActiveExperimentViewController().getExperimentController()));
    }

    @FXML
    public void onPreferencesAction() {
        this.preferencesDialogFactory.showDialog();
    }

    @FXML
    private void onReportBugButtonAction() {
        this.bugReportDialogFactory.showDialog();
    }

    @FXML
    private void onAboutAction() {
        this.aboutDialogFactory.showDialog();
    }

    @FXML
    private void onRunExperimentAction(ActionEvent actionEvent) {
        ExperimentEditor activeExperimentEditor = this.getActiveExperimentEditor();
        if (activeExperimentEditor != null) {
            activeExperimentEditor.startExperiment();
        } else {
            LOG.error("Unexpected: onRunExperimentAction with activeExperimentEditor=null (will fall back to doing nothing)");
        }
    }

    @FXML
    private void onOpenSharedExperimentAction() {
        new OpenSharedSliceDialog().showDialog();
    }

    @FXML
    private void onOpenDocumentationAction() throws URISyntaxException {
        this.browserUtil.openUrlInBrowser("http://doc.ilabt.iminds.be/jfed-documentation-5.9/");
    }

    private class OpenSharedSliceDialog
    extends GridPane {
        private final TextField urnTextField;
        private final Dialog<String> textInputDialog = new Dialog();

        public OpenSharedSliceDialog() {
            this.urnTextField = new TextField();
            this.urnTextField.setText("urn:publicid:IDN+wall2.ilabt.iminds.be:PROJECT+slice+EXPERIMENT");
            this.urnTextField.setPrefColumnCount(40);
            this.add((Node)this.urnTextField, 0, 1);
            this.textInputDialog.setTitle("Open shared experiment");
            DialogPane dialogPane = new DialogPane();
            dialogPane.setContent((Node)this);
            dialogPane.setHeaderText("Open shared experiment");
            dialogPane.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.GROUP, (Color)Color.GREEN));
            dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
            this.textInputDialog.setResultConverter(param -> {
                if (param == ButtonType.OK) {
                    return this.urnTextField.getText();
                }
                return null;
            });
            this.textInputDialog.setDialogPane(dialogPane);
        }

        public void showDialog() {
            this.textInputDialog.showAndWait().ifPresent(urn -> GeneralRibbonTabController.this.eventBus.post((Object)new RecoverSliceEvent((String)urn)));
        }
    }
}

