/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TriggeredMessage;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.util.library.JFedUtils;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TriggeredMessageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TriggeredMessageHandler.class);
    public final JFedPreferences jFedPreferences;
    public final File historyFile;
    public List<TriggeredMessage> triggeredMessages;
    public final Map<Integer, TriggeredMessageHistory> triggeredMessagesHistoryById;

    @Inject
    public TriggeredMessageHandler(JFedPreferences jFedPreferences, JFedGuiConfig jFedGuiConfig) {
        this.jFedPreferences = jFedPreferences;
        this.triggeredMessagesHistoryById = new HashMap<Integer, TriggeredMessageHistory>();
        String jFedUserDataDir = JFedUtils.getUserDataDirectory();
        if (jFedUserDataDir != null) {
            File userDataDir = new File(jFedUserDataDir);
            this.historyFile = new File(userDataDir, "triggeredMessagesHistory.json");
            if (this.historyFile.exists()) {
                ObjectMapper mapper = new ObjectMapper();
                try {
                    List triggeredMessageHistoryList = (List)mapper.readValue(this.historyFile, (TypeReference)new TypeReference<List<TriggeredMessageHistory>>(){});
                    for (TriggeredMessageHistory tmh : triggeredMessageHistoryList) {
                        this.triggeredMessagesHistoryById.put(tmh.getTriggeredMessageId(), tmh);
                    }
                }
                catch (IOException e) {
                    LOG.error("Failed to read TriggeredMessageHistory from \"" + this.historyFile.getPath() + "\"", (Throwable)e);
                }
            }
        } else {
            this.historyFile = null;
        }
        assert (jFedGuiConfig != null);
        this.triggeredMessages = new ArrayList<TriggeredMessage>(jFedGuiConfig.getTriggeredMessages());
        for (TriggeredMessage triggeredMessage : this.triggeredMessages) {
            TriggeredMessageHistory history = this.triggeredMessagesHistoryById.computeIfAbsent(triggeredMessage.getId(), id -> new TriggeredMessageHistory(triggeredMessage.getId()));
            if (triggeredMessage.getFrequency() != TriggeredMessage.TriggerFrequency.ONCE_PER_SESSION) continue;
            history.setLastShown(null);
        }
        LOG.debug("initialised with " + this.triggeredMessages.size() + " triggeredMessages");
    }

    public void save() {
        if (this.historyFile == null) {
            return;
        }
        LOG.debug("Saving TriggeredMessageHistory to " + String.valueOf(this.historyFile));
        ObjectMapper mapper = new ObjectMapper();
        try {
            ArrayList<TriggeredMessageHistory> triggeredMessageHistoryList = new ArrayList<TriggeredMessageHistory>(this.triggeredMessagesHistoryById.values());
            mapper.writeValue(this.historyFile, triggeredMessageHistoryList);
        }
        catch (IOException e) {
            LOG.error("Failed to write TriggeredMessageHistory to \"" + this.historyFile.getPath() + "\"", (Throwable)e);
        }
    }

    public void onEvent(TriggeredMessage.GuiTrigger guiTrigger) {
        this.onEvent(guiTrigger, Collections.emptyList());
    }

    public void onEvent(TriggeredMessage.GuiTrigger guiTrigger, List<Server> involvedServers) {
        List involvedServerIds = involvedServers != null ? involvedServers.stream().filter(Objects::nonNull).map(PrimaryIdObject::getId).filter(Objects::nonNull).collect(Collectors.toList()) : Collections.emptyList();
        LOG.debug("onEvent(" + String.valueOf(guiTrigger) + ", " + String.valueOf(involvedServerIds) + ")");
        try {
            for (TriggeredMessage triggeredMessage : this.triggeredMessages) {
                String pref;
                if (guiTrigger != triggeredMessage.getGuiTrigger()) continue;
                TriggeredMessageHistory history = this.triggeredMessagesHistoryById.computeIfAbsent(triggeredMessage.getId(), id -> new TriggeredMessageHistory(triggeredMessage.getId()));
                boolean trigger = true;
                if (triggeredMessage.getOnlyTriggerForServer() != null && !involvedServerIds.contains(triggeredMessage.getOnlyTriggerForServer())) {
                    trigger = false;
                }
                if (triggeredMessage.getOnlyTriggerOnProxyForJFedState() != null) {
                    pref = this.jFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_JFED);
                    if (triggeredMessage.getOnlyTriggerOnProxyForJFedState().booleanValue() && !Objects.equals(pref, "ALWAYS")) {
                        trigger = false;
                    }
                    if (!triggeredMessage.getOnlyTriggerOnProxyForJFedState().booleanValue() && !Objects.equals(pref, "NEVER")) {
                        trigger = false;
                    }
                }
                if (triggeredMessage.getOnlyTriggerOnProxyForSshState() != null) {
                    pref = this.jFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH);
                    if (triggeredMessage.getOnlyTriggerOnProxyForSshState().booleanValue() && !Objects.equals(pref, "ALWAYS")) {
                        trigger = false;
                    }
                    if (!triggeredMessage.getOnlyTriggerOnProxyForSshState().booleanValue() && !Objects.equals(pref, "NEVER")) {
                        trigger = false;
                    }
                }
                if (triggeredMessage.getEnableDoNotShowAgainButton().booleanValue() && history.dontShowAgainClicked) {
                    trigger = false;
                }
                if (triggeredMessage.getFrequency() != null && history.getLastShown() != null) {
                    switch (triggeredMessage.getFrequency()) {
                        case ALWAYS: {
                            break;
                        }
                        case ONCE: {
                            trigger = false;
                            break;
                        }
                        case ONCE_PER_SESSION: {
                            trigger = false;
                            break;
                        }
                        case DAILY: {
                            ZonedDateTime zonedDateTime = ZonedDateTime.now();
                            ZonedDateTime dayStart = zonedDateTime.toLocalDate().atStartOfDay(zonedDateTime.getZone());
                            if (!history.getLastShown().after(Date.from(dayStart.toInstant()))) break;
                            trigger = false;
                            break;
                        }
                    }
                }
                if (!trigger) continue;
                this.doTrigger(triggeredMessage, history);
            }
            if (guiTrigger == TriggeredMessage.GuiTrigger.EXIT) {
                this.save();
            }
        }
        catch (AssertionError e) {
            LOG.error("AssertionError while processing a TriggerMessage event. Will return to caller to prevent GUI problems", (Throwable)((Object)e));
        }
        catch (Exception e) {
            LOG.error("Exception while processing a TriggerMessage event. Will return to caller to prevent GUI problems", (Throwable)e);
        }
    }

    private void doTrigger(TriggeredMessage triggeredMessage, TriggeredMessageHistory history) {
        CheckBox checkBox;
        VBox pane = new VBox();
        pane.setSpacing(5.0);
        Label textLabel = new Label(triggeredMessage.getText());
        textLabel.setWrapText(true);
        pane.getChildren().add((Object)textLabel);
        if (Objects.equals(triggeredMessage.getEnableDoNotShowAgainButton(), Boolean.TRUE)) {
            checkBox = new CheckBox("Do not show this dialog again");
            pane.getChildren().add((Object)checkBox);
        } else {
            checkBox = null;
        }
        DialogPane dialogPane = new DialogPane();
        dialogPane.setHeaderText(triggeredMessage.getTitle());
        TriggeredMessage.MessageType type = triggeredMessage.getType();
        if (type == null) {
            type = TriggeredMessage.MessageType.INFO;
        }
        switch (type) {
            case WARNING: {
                dialogPane.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.WARNING, (Color)Color.ORANGE));
                break;
            }
            case ERROR: {
                dialogPane.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.TIMES_CIRCLE, (Color)Color.RED));
                break;
            }
            case INFO: {
                dialogPane.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.INFO_CIRCLE, (Color)Color.BLUE));
            }
        }
        dialogPane.setContent((Node)pane);
        dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK});
        Dialog dialog = new Dialog();
        dialog.setTitle(triggeredMessage.getTitle());
        dialog.setDialogPane(dialogPane);
        Optional result = dialog.showAndWait();
        if (checkBox != null) {
            history.setDontShowAgainClicked(checkBox.isSelected());
        }
        history.setLastShown(new Date());
    }

    private static class TriggeredMessageHistory {
        private final Integer triggeredMessageId;
        private boolean dontShowAgainClicked;
        private Date lastShown;

        private TriggeredMessageHistory(Integer triggeredMessageId) {
            this.triggeredMessageId = triggeredMessageId;
            this.dontShowAgainClicked = false;
            this.lastShown = null;
        }

        @JsonCreator
        public TriggeredMessageHistory(@JsonProperty(value="triggeredMessageId") Integer triggeredMessageId, @JsonProperty(value="dontShowAgainClicked") boolean dontShowAgainClicked, @JsonProperty(value="lastShown") Date lastShown) {
            this.triggeredMessageId = triggeredMessageId;
            this.dontShowAgainClicked = dontShowAgainClicked;
            this.lastShown = lastShown;
        }

        @JsonProperty
        public Integer getTriggeredMessageId() {
            return this.triggeredMessageId;
        }

        @JsonProperty
        public boolean isDontShowAgainClicked() {
            return this.dontShowAgainClicked;
        }

        @JsonProperty
        public Date getLastShown() {
            return this.lastShown;
        }

        public void setDontShowAgainClicked(boolean dontShowAgainClicked) {
            this.dontShowAgainClicked = dontShowAgainClicked;
        }

        public void setLastShown(Date lastShown) {
            this.lastShown = lastShown;
        }
    }
}

