/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.bugreporting;

import be.iminds.ilabt.jfed.bugreport.model.BugReport;
import be.iminds.ilabt.jfed.bugreport.model.BugReportBuilder;
import be.iminds.ilabt.jfed.bugreport.model.ConnectivityTestResult;
import be.iminds.ilabt.jfed.bugreport.model.ErrorDetails;
import be.iminds.ilabt.jfed.bugreport.model.LogLine;
import be.iminds.ilabt.jfed.bugreport.model.SliceBuilder;
import be.iminds.ilabt.jfed.bugreport.model.StitchingJobReportBuilder;
import be.iminds.ilabt.jfed.bugreport.model.StitchingJobStateReportBuilder;
import be.iminds.ilabt.jfed.bugreport.model.TaskExecutionReport;
import be.iminds.ilabt.jfed.call_log_output.LogOutput;
import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.jfed.connectivity_tester.ConnectivityTest;
import be.iminds.ilabt.jfed.experimenter_gui.connectivity_tester.ConnectivityTester;
import be.iminds.ilabt.jfed.experimenter_gui.util.BugReportExperimentControllerListener;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.highlevel.controller.JavaFXTaskThread;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.jobs.report.JobStateReport;
import be.iminds.ilabt.jfed.highlevel.jobs.report.StitchingJobReport;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.log_cache.AllApiCallsList;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsRef;
import be.iminds.ilabt.jfed.logging.BugReportAppender;
import be.iminds.ilabt.jfed.logging.JFedLoggerManager;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.library.JFedVersionInfo;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import be.iminds.ilabt.jfed.util.library.PublicKeyConvertor;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BugReportComposer {
    private static final Logger LOG = LoggerFactory.getLogger(BugReportComposer.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final int SCREENSHOT_PROGRESS = 100;
    private final JavaFXTaskThread javaFXTaskThread;
    private final GeniUserProvider geniUserProvider;
    private final SfaModel sfaModel;
    private final JFedHLPreferences jFedPreferences;
    private final JFedLoggerManager jFedLoggerManager;
    private final ConnectivityTester connectivityTester;
    private final BugReportExperimentControllerListener bugReportExperimentControllerListener;
    private final AllApiCallsList allApiCallsList;
    private boolean firstRunConnectivityTests;
    private boolean preparationStarted;
    private StringProperty subject = new SimpleStringProperty();
    private SimpleObjectProperty<BugReport.ReportTarget> reportTarget = new SimpleObjectProperty();
    private SimpleObjectProperty<BugReport.ReportType> reportType = new SimpleObjectProperty();
    private ListProperty<GeniUrn> relatedTestbeds = new SimpleListProperty(FXCollections.observableArrayList());
    private BooleanProperty postOnPublicList = new SimpleBooleanProperty();
    private final StringProperty description = new SimpleStringProperty();
    private final StringProperty email = new SimpleStringProperty();
    private final ReadOnlyStringWrapper version = new ReadOnlyStringWrapper();
    private final ReadOnlyStringWrapper environment = new ReadOnlyStringWrapper();
    private final ReadOnlyStringWrapper reporterUrn = new ReadOnlyStringWrapper();
    private final ReadOnlyStringWrapper certificateExpiration = new ReadOnlyStringWrapper();
    private final ObjectProperty<Image> screenshot = new SimpleObjectProperty();
    private static final int PROGRESS_OVERALL_INFO = 7;
    private int totalProgress;
    private int progress;
    private boolean finished = false;
    private final Pattern bugReportPostUrlPattern = Pattern.compile(".*/bugreport/?$");
    private final Pattern bugReportCallPostUrlPattern = Pattern.compile(".*/bugreport/[0-9]*/call/?$");
    private final Pattern bugReportCallPutUrlPattern = Pattern.compile(".*/bugreport/[0-9]*/call/[0-9]*/?$");

    @Inject
    public BugReportComposer(JavaFXTaskThread javaFXTaskThread, GeniUserProvider geniUserProvider, SfaModel sfaModel, ConnectivityTester connectivityTester, JFedHLPreferences jFedPreferences, JFedLoggerManager jFedLoggerManager, BugReportExperimentControllerListener bugReportExperimentControllerListener, JFedVersionInfo jFedVersionInfo, AllApiCallsList allApiCallsList) {
        this.javaFXTaskThread = javaFXTaskThread;
        this.geniUserProvider = geniUserProvider;
        this.sfaModel = sfaModel;
        this.connectivityTester = connectivityTester;
        this.jFedPreferences = jFedPreferences;
        this.jFedLoggerManager = jFedLoggerManager;
        this.bugReportExperimentControllerListener = bugReportExperimentControllerListener;
        this.allApiCallsList = allApiCallsList;
        assert (javaFXTaskThread != null);
        assert (connectivityTester != null);
        this.firstRunConnectivityTests = true;
        this.preparationStarted = false;
        this.version.set(jFedVersionInfo.getFullVersionString());
        this.environment.set(jFedVersionInfo.getEnvironmentString());
        GeniUser loggedInGeniUser = this.geniUserProvider.getLoggedInGeniUser();
        this.reporterUrn.set(loggedInGeniUser.getUserUrnString());
        this.email.set((Object)loggedInGeniUser.getCertEmail());
        Date expirationDate = loggedInGeniUser.getCertExpire();
        if (expirationDate != null) {
            this.certificateExpiration.set(DATE_FORMAT.format(expirationDate));
        }
    }

    public void setFirstRunConnectivityTests(boolean firstRunConnectivityTests) {
        this.firstRunConnectivityTests = firstRunConnectivityTests;
    }

    public void ensurePreparationStarted() {
        if (this.firstRunConnectivityTests && !this.preparationStarted) {
            this.connectivityTester.startTests();
            this.preparationStarted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public BugReport createBugReport() {
        Object lines;
        if (!this.isPreparationFinished()) {
            throw new IllegalStateException("Preparation has not finished!");
        }
        BugReportAppender bugReportAppender = this.jFedLoggerManager.getBugReportMemoryAppender();
        if (bugReportAppender == null) {
            LOG.error("bugReportAppender \"BUGREPORT\" not found! Will not be able to add log entries to bug report.");
        }
        this.progress = 0;
        this.totalProgress = 7 + this.javaFXTaskThread.getCallsCount() * 10 + (bugReportAppender == null ? 0 : bugReportAppender.getLength()) + this.connectivityTester.getTestResults().size() + this.stitchingReportCount() * 50 + (this.screenshot.get() != null ? 100 : 0);
        BugReportBuilder bugReportBuilder = new BugReportBuilder();
        bugReportBuilder.setDescription((String)this.description.get());
        bugReportBuilder.setMail((String)this.email.get());
        bugReportBuilder.setEnvironment(this.environment.get());
        bugReportBuilder.setVersion(this.version.get());
        bugReportBuilder.setReporterUrn(this.reporterUrn.get());
        bugReportBuilder.setLoggedInUserInfo(this.getLoggedInUserInfo());
        bugReportBuilder.setCommitTime(Instant.now());
        bugReportBuilder.setSubject((String)this.subject.get());
        bugReportBuilder.setReportTarget((BugReport.ReportTarget)((Object)this.reportTarget.get()));
        bugReportBuilder.setReportType((BugReport.ReportType)((Object)this.reportType.get()));
        bugReportBuilder.setRelatedTestbeds((List)this.relatedTestbeds.get());
        bugReportBuilder.setPostOnPublicList(false);
        if (this.jFedPreferences.getPropertiesFile() != null) {
            lines = null;
            try {
                void var4_6;
                lines = Files.readAllLines(this.jFedPreferences.getPropertiesFile().toPath(), Charset.defaultCharset());
                String string = "";
                Iterator<String> iterator = lines.iterator();
                while (iterator.hasNext()) {
                    String line = iterator.next();
                    String string2 = (String)var4_6 + line + "\n";
                }
                bugReportBuilder.setPreferences((String)var4_6);
            }
            catch (IOException iOException) {
                LOG.error("Exception reading user preferences file in createBugReport()", (Throwable)iOException);
                bugReportBuilder.setPreferences("Exception reading user preferences file in createBugReport(): " + iOException.getMessage());
            }
        } else {
            bugReportBuilder.setPreferences("No properties file. (User without home dir?)\n");
        }
        this.progress += 7;
        lines = this.javaFXTaskThread;
        synchronized (lines) {
            bugReportBuilder.setApiCallDetailIds(this.allApiCallsList.getCalls().stream().map(ApiCallDetailsRef::getId).collect(Collectors.toList()));
        }
        lines = this.bugReportExperimentControllerListener.getStitchingJobReports();
        synchronized (lines) {
            for (StitchingJobReport stitchingReport : this.bugReportExperimentControllerListener.getStitchingJobReports()) {
                bugReportBuilder.addStitchingJobReport(BugReportComposer.convertJobReport(stitchingReport));
                this.progress += 50;
            }
        }
        for (Map.Entry entry : this.connectivityTester.getTestResults().entrySet()) {
            bugReportBuilder.addConnectivityTestResults(BugReportComposer.convertConnectivityTest((ConnectivityTest)entry.getKey(), (ConnectivityTest.ConnectivityTestResult)entry.getValue()));
            ++this.progress;
        }
        for (Slice slice : this.sfaModel.getSlices()) {
            bugReportBuilder.addSlice(BugReportComposer.convertSlice(slice));
            ++this.progress;
        }
        if (this.screenshot.get() != null) {
            try {
                ByteArrayOutputStream screenshotBuffer = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)((Image)this.screenshot.get()), null), "png", screenshotBuffer);
                byte[] byArray = Base64.encodeBase64((byte[])screenshotBuffer.toByteArray());
                String screenshotString = new String(byArray);
                bugReportBuilder.setScreenshot(screenshotString);
            }
            catch (IOException ex) {
                LOG.warn("Error while writing bugreport screenshot: ignoring!", (Throwable)ex);
            }
            this.progress += 100;
        }
        if (bugReportAppender != null) {
            List loggingEvents = bugReportAppender.getListCopy();
            for (ILoggingEvent loggingEvent : loggingEvents) {
                LogLine logLine = BugReportComposer.convertLogLine(loggingEvent);
                bugReportBuilder.addLogLine(logLine);
                ++this.progress;
            }
        }
        this.finished = true;
        return bugReportBuilder.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterateOverApiCallDetails(ApiCallDetailsIterator it) throws Exception {
        JavaFXTaskThread javaFXTaskThread = this.javaFXTaskThread;
        synchronized (javaFXTaskThread) {
            List allRefs = this.allApiCallsList.getCalls();
            for (ApiCallDetailsRef ref : allRefs) {
                boolean isBugReportCreateCall;
                SerializableApiCallDetails details = this.allApiCallsList.getCache().getApiCallDetails(ref);
                if (details == null) continue;
                if (details.getCallServerUrl() != null) {
                    Matcher bugReportCreateMatch1 = this.bugReportPostUrlPattern.matcher(details.getCallServerUrl());
                    Matcher bugReportCreateMatch2 = this.bugReportCallPostUrlPattern.matcher(details.getCallServerUrl());
                    Matcher bugReportCreateMatch3 = this.bugReportCallPutUrlPattern.matcher(details.getCallServerUrl());
                    isBugReportCreateCall = bugReportCreateMatch1.matches() || bugReportCreateMatch2.matches() || bugReportCreateMatch3.matches();
                } else {
                    isBugReportCreateCall = false;
                }
                if (!isBugReportCreateCall) {
                    it.process(ref, details);
                } else {
                    LOG.debug("Skipping call for BugReport, because it is a call from a previous BugReport");
                }
                this.progress += 10;
            }
        }
    }

    private static be.iminds.ilabt.jfed.bugreport.model.StitchingJobReport convertJobReport(@Nonnull StitchingJobReport stitchingReport) {
        StitchingJobReportBuilder res = new StitchingJobReportBuilder();
        res.setName(stitchingReport.getName());
        for (JobStateReport jobStateReport : stitchingReport.getJobStateReports()) {
            StitchingJobStateReportBuilder jobStateBuilder = new StitchingJobStateReportBuilder();
            jobStateBuilder.setStart(jobStateReport.getStartTime());
            jobStateBuilder.setEnd(jobStateReport.getEndTime());
            jobStateBuilder.setName(jobStateReport.getStateName());
            jobStateBuilder.setStatus(Objects.toString(jobStateReport.getFinalStatus(), null));
            if (jobStateReport.getLogLines() != null) {
                jobStateBuilder.setLogEntries(jobStateReport.getLogLines().stream().map(BugReportComposer::convertLogLine).collect(Collectors.toList()));
            }
            if (jobStateReport.getTaskExecutions() != null) {
                jobStateBuilder.setTaskExecutions(jobStateReport.getTaskExecutions().stream().map(BugReportComposer::convertTaskExecutions).collect(Collectors.toList()));
            }
            res.addStitchingJobStateReport(jobStateBuilder.create());
        }
        return res.create();
    }

    private static be.iminds.ilabt.jfed.bugreport.model.Slice convertSlice(@Nonnull Slice slice) {
        SliceBuilder res = new SliceBuilder();
        res.setSliceUrn(slice.getUrnString());
        res.setExpirationDate(slice.getExpirationDate());
        if (slice.getStatus() != null) {
            res.setStatus(slice.getStatus().detailedToString());
        }
        for (Sliver sliver : slice.getSliversCopy()) {
            List<String> components = sliver.getComponentInfo().stream().filter(Objects::nonNull).map(c -> c.getClientId() == null ? c.getComponentId() : c.getClientId()).filter(Objects::nonNull).collect(Collectors.toList());
            List<ErrorDetails> errorDetails = sliver.getStatus() == null ? null : sliver.getStatus().getAllErrors().stream().filter(Objects::nonNull).map(e -> new ErrorDetails(e.getError(), e.getSliverUrn(), e.getComponentUrn(), Instant.ofEpochMilli(e.getTimestamp()))).collect(Collectors.toList());
            Object sliverUrn = sliver.getUrn() != null ? sliver.getUrn().toString() : "SLIVER-ON: " + sliver.getServer().getDefaultComponentManagerUrn();
            be.iminds.ilabt.jfed.bugreport.model.Sliver bugReportSliver = new be.iminds.ilabt.jfed.bugreport.model.Sliver((String)sliverUrn, sliver.getStatusString(), sliver.getStatus() == null ? null : Objects.toString(sliver.getStatus().getGlobalStatus(), null), sliver.getExpirationDate(), sliver.getManifestRspec() != null, components, errorDetails);
            res.addSliver(bugReportSliver);
        }
        return res.create();
    }

    private static ConnectivityTestResult convertConnectivityTest(@Nonnull ConnectivityTest test, @Nullable ConnectivityTest.ConnectivityTestResult result) {
        ConnectivityTestResult.Status status = null;
        if (result != null) {
            switch (result.getStatus()) {
                case SUCCEEDED: {
                    status = ConnectivityTestResult.Status.SUCCEEDED;
                    break;
                }
                case WARNING: {
                    status = ConnectivityTestResult.Status.WARNING;
                    break;
                }
                case FAILED: {
                    status = ConnectivityTestResult.Status.FAILED;
                    break;
                }
                case SKIPPED: {
                    status = ConnectivityTestResult.Status.SKIPPED;
                    break;
                }
                default: {
                    status = null;
                }
            }
        }
        ConnectivityTestResult res = new ConnectivityTestResult(test.getName(), status, result == null ? null : result.getMessage(), result.getExceptionString());
        return res;
    }

    private static TaskExecutionReport convertTaskExecutions(TaskExecution<?> taskExecution) {
        List<Integer> apiCallDetailIds = taskExecution.getApiCallHistory().stream().filter(Objects::nonNull).map(ApiCallDetailsRef::getId).collect(Collectors.toList());
        TaskExecutionReport res = new TaskExecutionReport(taskExecution.getId(), taskExecution.getName(), taskExecution.getState() == null ? null : taskExecution.getState().name(), taskExecution.getTask() == null || taskExecution.getTask().getClass() == null ? null : taskExecution.getTask().getClass().getName(), taskExecution.getRunStart() == null ? null : taskExecution.getRunStart().toInstant(), taskExecution.getRunStop() == null ? null : taskExecution.getRunStop().toInstant(), apiCallDetailIds, null);
        return res;
    }

    private static LogLine convertLogLine(LogOutput.LogEntry logEntry) {
        return new LogLine(Instant.ofEpochMilli(logEntry.getTimeMs()), null, Objects.toString(logEntry.getType(), null), logEntry.getText(), logEntry.getExceptionStackTrace(), null);
    }

    private static LogLine convertLogLine(@Nonnull ILoggingEvent loggingEvent) {
        return new LogLine(Instant.ofEpochMilli(loggingEvent.getTimeStamp()), loggingEvent.getLoggerName(), Objects.toString(loggingEvent.getLevel(), null), loggingEvent.getFormattedMessage(), loggingEvent.getThrowableProxy() == null ? null : ThrowableProxyUtil.asString((IThrowableProxy)loggingEvent.getThrowableProxy()), loggingEvent.getThreadName());
    }

    public void reset() {
        this.progress = 0;
        this.totalProgress = 0;
        this.finished = false;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public int getTotalProgress() {
        return this.totalProgress;
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean isPreparationFinished() {
        if (this.firstRunConnectivityTests) {
            assert (this.preparationStarted) : "Preparation finish queried, but preparation has not yet started. You'll probably wait forever.";
            return this.connectivityTester.getTestsFinished();
        }
        return true;
    }

    private String getLoggedInUserInfo() {
        Object userInfoStr;
        block11: {
            userInfoStr = null;
            try {
                if (this.geniUserProvider.isUserLoggedIn()) {
                    GeniUser u = this.geniUserProvider.getLoggedInGeniUser();
                    userInfoStr = u.getUserUrnString() + " @ " + u.getUserAuthorityServer().getDefaultComponentManagerUrn();
                    if (u.getPrivateKey() == null) {
                        userInfoStr = (String)userInfoStr + " WARNING, no private key!";
                    }
                    try {
                        String pubkey = PublicKeyConvertor.fromPublicKey((PublicKey)((X509Certificate)u.getClientCertificateChain().get(0)).getPublicKey()).getOpensshFormString();
                        userInfoStr = (String)userInfoStr + " with pubkey " + pubkey;
                    }
                    catch (AssertionError | Exception e) {
                        userInfoStr = (String)userInfoStr + " ERROR getting pubkey " + ((Throwable)e).getMessage();
                    }
                    try {
                        String certInfo = KeyUtil.x509certificateChainToPem((Collection)u.getClientCertificateChain());
                        userInfoStr = (String)userInfoStr + " with cert " + certInfo;
                    }
                    catch (AssertionError | Exception e) {
                        userInfoStr = (String)userInfoStr + " ERROR getting cert " + ((Throwable)e).getMessage();
                    }
                    break block11;
                }
                userInfoStr = "No user logged in";
            }
            catch (AssertionError e) {
                if (userInfoStr == null) {
                    userInfoStr = "NULL then ";
                }
                userInfoStr = (String)userInfoStr + " AssertionError getting user info " + ((Throwable)((Object)e)).getMessage();
            }
            catch (Exception e) {
                if (userInfoStr == null) {
                    userInfoStr = "NULL then ";
                }
                userInfoStr = (String)userInfoStr + " Exception getting user info " + e.getMessage();
            }
        }
        return userInfoStr;
    }

    public String getDescription() {
        return (String)this.description.get();
    }

    public StringProperty descriptionProperty() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description.set((Object)description);
    }

    public String getEmail() {
        return (String)this.email.get();
    }

    public StringProperty emailProperty() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email.set((Object)email);
    }

    public String getVersion() {
        return this.version.get();
    }

    public ReadOnlyStringProperty versionProperty() {
        return this.version.getReadOnlyProperty();
    }

    public String getEnvironment() {
        return this.environment.get();
    }

    public ReadOnlyStringProperty environmentProperty() {
        return this.environment.getReadOnlyProperty();
    }

    public String getReporterUrn() {
        return this.reporterUrn.get();
    }

    public ReadOnlyStringProperty reporterUrnProperty() {
        return this.reporterUrn.getReadOnlyProperty();
    }

    public String getCertificateExpiration() {
        return this.certificateExpiration.get();
    }

    public ReadOnlyStringProperty certificateExpirationProperty() {
        return this.certificateExpiration.getReadOnlyProperty();
    }

    public ReadOnlyIntegerProperty callsCountProperty() {
        return this.allApiCallsList.getObservableCallsSize();
    }

    public int stitchingReportCount() {
        return this.bugReportExperimentControllerListener.getStitchingJobReports().size();
    }

    public Image getScreenshot() {
        return (Image)this.screenshot.get();
    }

    public ObjectProperty<Image> screenshotProperty() {
        return this.screenshot;
    }

    public void setScreenshot(Image screenshot) {
        this.screenshot.set((Object)screenshot);
    }

    public String getSubject() {
        return (String)this.subject.get();
    }

    public StringProperty subjectProperty() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject.set((Object)subject);
    }

    public BugReport.ReportTarget getReportTarget() {
        return (BugReport.ReportTarget)((Object)this.reportTarget.get());
    }

    public SimpleObjectProperty<BugReport.ReportTarget> reportTargetProperty() {
        return this.reportTarget;
    }

    public void setReportTarget(BugReport.ReportTarget reportTarget) {
        this.reportTarget.set((Object)reportTarget);
    }

    public BugReport.ReportType getReportType() {
        return (BugReport.ReportType)((Object)this.reportType.get());
    }

    public SimpleObjectProperty<BugReport.ReportType> reportTypeProperty() {
        return this.reportType;
    }

    public void setReportType(BugReport.ReportType reportType) {
        this.reportType.set((Object)reportType);
    }

    public ObservableList<GeniUrn> getRelatedTestbeds() {
        return (ObservableList)this.relatedTestbeds.get();
    }

    public ListProperty<GeniUrn> relatedTestbedsProperty() {
        return this.relatedTestbeds;
    }

    public void setRelatedTestbeds(@Nonnull List<GeniUrn> relatedTestbeds) {
        this.relatedTestbeds.setAll(relatedTestbeds);
    }

    public boolean isPostOnPublicList() {
        return this.postOnPublicList.get();
    }

    public BooleanProperty postOnPublicListProperty() {
        return this.postOnPublicList;
    }

    public void setPostOnPublicList(boolean postOnPublicList) {
        this.postOnPublicList.set(postOnPublicList);
    }

    public static interface ApiCallDetailsIterator {
        public void process(ApiCallDetailsRef var1, SerializableApiCallDetails var2) throws Exception;
    }
}

