/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.bugreporting;

import be.iminds.ilabt.jfed.bugreport.model.BugReport;
import be.iminds.ilabt.jfed.experimenter_gui.bugreporting.BugReportComposer;
import be.iminds.ilabt.jfed.experimenter_gui.bugreporting.BugReportQuestionButton;
import be.iminds.ilabt.jfed.experimenter_gui.bugreporting.BugReportToFileTask;
import be.iminds.ilabt.jfed.experimenter_gui.bugreporting.BugReportToServerTask;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.SelectAuthoritiesController;
import be.iminds.ilabt.jfed.experimenter_gui.ui.SceneAwareController;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.common.OSDetector;
import com.google.inject.name.Named;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.controlsfx.dialog.CommandLinksDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BugReportDialog
implements SceneAwareController {
    private static final Logger LOG = LoggerFactory.getLogger(BugReportDialog.class);
    private static final String BUGREPORT_EXTENSION = ".xml";
    private final BugReportComposer bugReportComposer;
    private final FedmonWebApiClientConfig fedmonWebApiClientConfig;
    private final JFedHLPreferences jFedPreferences;
    private final JFedGuiConfig jFedGuiConfig;
    private final TestbedInfoSource testbedInfoSource;
    private final Clipboard systemClipboard = Clipboard.getSystemClipboard();
    private final BooleanProperty submitting = new SimpleBooleanProperty(false);
    @FXML
    private BorderPane root;
    @FXML
    private StackPane centerStack;
    @FXML
    private Label titleLabel;
    @FXML
    private Pane reportTypePane1;
    @FXML
    private Pane reportTypePane2;
    @FXML
    private Pane reportTypePane3;
    @FXML
    private Pane reportTypePane4;
    @FXML
    private ScrollPane reportDetailsPane;
    @FXML
    private TextField subjectTextField;
    @FXML
    private Label descriptionLabel;
    @FXML
    private TextArea descriptionTextArea;
    @FXML
    private TextField versionTextField;
    @FXML
    private TextField environmentTextField;
    @FXML
    private TextField credentialsTextField;
    @FXML
    private TextField emailTextField;
    @FXML
    private Button saveToFileButton;
    @FXML
    private Button submitButton;
    @FXML
    private Button cancelButton;
    @FXML
    private Label includedCallsLabel;
    @FXML
    private ProgressIndicator submitProgressIndicator;
    @FXML
    private Label progressLabel;
    @FXML
    private StackPane screenshotStackPane;
    @FXML
    private CheckBox includeScreenshotCheckBox;
    @FXML
    private ImageView screenshotImageView;
    @FXML
    private Button pasteScreenshotButton;
    private Task<Integer> reportTask = null;
    @FXML
    BugReportQuestionButton part1Question;
    @FXML
    BugReportQuestionButton part1Feature;
    @FXML
    BugReportQuestionButton part1Bug;
    @FXML
    BugReportQuestionButton part1Con;
    @FXML
    BugReportQuestionButton part1Other;
    @FXML
    BugReportQuestionButton part2jFed;
    @FXML
    BugReportQuestionButton part2Testbed;
    @FXML
    BugReportQuestionButton part2Other;
    @FXML
    Label part3label;
    @FXML
    SelectAuthoritiesController part3AuthChooserController;
    @FXML
    Button part3ok;
    @FXML
    CheckBox part4AllowPublic;
    @FXML
    Label part4note;
    @FXML
    Button part4ok;
    private int currentPart = 1;
    private String fullChoiceText = "";
    private String subjectChoiceText = "";
    private BugReport.ReportType part1Choice;
    private BugReport.ReportTarget part2Choice;
    private Set<Server> part3Choice;
    private Boolean part4Choice;

    @Inject
    BugReportDialog(BugReportComposer bugReportComposer, JFedHLPreferences jFedPreferences, JFedGuiConfig jFedGuiConfig, TestbedInfoSource testbedInfoSource, @Named(value="clientAuthWebApiConfig") FedmonWebApiClientConfig fedmonWebApiClientConfig) {
        this.bugReportComposer = bugReportComposer;
        this.bugReportComposer.setFirstRunConnectivityTests(true);
        this.bugReportComposer.ensurePreparationStarted();
        this.jFedPreferences = jFedPreferences;
        this.jFedGuiConfig = jFedGuiConfig;
        this.testbedInfoSource = testbedInfoSource;
        this.fedmonWebApiClientConfig = fedmonWebApiClientConfig;
    }

    @FXML
    private void initialize() {
        this.submitButton.disableProperty().bind((ObservableValue)this.submitting);
        this.saveToFileButton.disableProperty().bind((ObservableValue)this.submitting);
        this.submitProgressIndicator.visibleProperty().bind((ObservableValue)this.submitting);
        this.descriptionTextArea.textProperty().bindBidirectional((Property)this.bugReportComposer.descriptionProperty());
        this.emailTextField.textProperty().bindBidirectional((Property)this.bugReportComposer.emailProperty());
        this.versionTextField.textProperty().bind((ObservableValue)this.bugReportComposer.versionProperty());
        this.environmentTextField.textProperty().bind((ObservableValue)this.bugReportComposer.environmentProperty());
        this.credentialsTextField.textProperty().bind((ObservableValue)this.bugReportComposer.reporterUrnProperty());
        this.includedCallsLabel.textProperty().bind((ObservableValue)Bindings.format((String)"%d calls", (Object[])new Object[]{this.bugReportComposer.callsCountProperty()}));
        this.subjectTextField.textProperty().bindBidirectional((Property)this.bugReportComposer.subjectProperty());
        this.part4AllowPublic.selectedProperty().bindBidirectional((Property)this.bugReportComposer.postOnPublicListProperty());
        this.part3AuthChooserController.setHeaderLabelText("");
        this.screenshotImageView.imageProperty().bindBidirectional(this.bugReportComposer.screenshotProperty());
        this.screenshotImageView.fitWidthProperty().bind((ObservableValue)this.screenshotStackPane.widthProperty());
        this.screenshotImageView.fitHeightProperty().bind((ObservableValue)this.screenshotStackPane.heightProperty());
        this.screenshotImageView.imageProperty().addListener(observable -> {
            if (this.screenshotImageView.getImage() != null) {
                this.includeScreenshotCheckBox.setSelected(true);
                this.includeScreenshotCheckBox.setDisable(false);
                this.pasteScreenshotButton.setVisible(false);
            }
        });
        this.includeScreenshotCheckBox.setOnAction(observable -> {
            this.screenshotImageView.setImage(null);
            this.includeScreenshotCheckBox.setDisable(true);
            this.pasteScreenshotButton.setVisible(true);
        });
        this.reportTypePane1.getStylesheets().add((Object)CommandLinksDialog.class.getResource("dialogs.css").toExternalForm());
        this.reportTypePane2.getStylesheets().add((Object)CommandLinksDialog.class.getResource("dialogs.css").toExternalForm());
        this.reportTypePane3.getStylesheets().add((Object)CommandLinksDialog.class.getResource("dialogs.css").toExternalForm());
        this.reportTypePane4.getStylesheets().add((Object)CommandLinksDialog.class.getResource("dialogs.css").toExternalForm());
        this.reportTypePane1.setVisible(true);
        this.reportTypePane2.setVisible(false);
        this.reportTypePane3.setVisible(false);
        this.reportTypePane4.setVisible(false);
        this.reportDetailsPane.setVisible(false);
        this.centerStack.requestLayout();
    }

    private void showPart() {
        if (this.currentPart <= 0 || this.currentPart > 5) {
            throw new RuntimeException("Invalid current part " + this.currentPart);
        }
        if (this.currentPart == 4) {
            this.part4AllowPublic.setSelected(false);
            this.part4Choice = false;
            this.subjectTextField.setText(this.subjectChoiceText + "YOUR SUBJECT HERE");
            this.currentPart = 5;
        }
        if (this.currentPart >= 1 && this.currentPart <= 4) {
            this.reportTypePane1.setVisible(this.currentPart == 1);
            this.reportTypePane2.setVisible(this.currentPart == 2);
            this.reportTypePane3.setVisible(this.currentPart == 3);
            this.reportTypePane4.setVisible(this.currentPart == 4);
            this.reportDetailsPane.setVisible(false);
            this.submitButton.setVisible(false);
        }
        if (this.currentPart == 5) {
            this.reportTypePane1.setVisible(false);
            this.reportTypePane2.setVisible(false);
            this.reportTypePane3.setVisible(false);
            this.reportTypePane4.setVisible(false);
            this.reportDetailsPane.setVisible(true);
            this.submitButton.setVisible(true);
        }
        this.centerStack.requestLayout();
    }

    public void onPartOne(ActionEvent e) {
        if (e.getSource() == this.part1Question) {
            this.part1Choice = BugReport.ReportType.QUESTION;
            this.part4AllowPublic.setSelected(true);
            this.fullChoiceText = "This is a Question.";
            this.subjectChoiceText = "Question: ";
            this.titleLabel.setText("Question");
            this.descriptionLabel.setText("Question:");
            this.part4note.setText("You are totally free in this choice.\nOften, it can be very helpful for others to see your question/answer.");
            this.currentPart = 2;
        }
        if (e.getSource() == this.part1Feature) {
            this.part1Choice = BugReport.ReportType.FEATURE;
            this.fullChoiceText = "This is a jFed Feature Request.";
            this.subjectChoiceText = "jFed Feature Request: ";
            this.part4AllowPublic.setSelected(false);
            this.titleLabel.setText("jFed Feature Request");
            this.descriptionLabel.setText("jFed Feature Request:");
            this.part4note.setText("You are totally free in this choice.\njFed feature requests can sometimes be relevant to share with the list.");
            this.currentPart = 4;
        }
        if (e.getSource() == this.part1Bug) {
            this.part1Choice = BugReport.ReportType.BUG;
            this.fullChoiceText = "This is a Problem and/or Bug Report.";
            this.subjectChoiceText = "Bug/Problem Report: ";
            this.part4AllowPublic.setSelected(false);
            this.titleLabel.setText("Problem/Bug Report");
            this.descriptionLabel.setText("Bug description:\n(Please include: expected outcome, steps to reproduce)");
            this.part4note.setText("You are totally free in this choice.\njFed bug reports and/or testbed problems can sometimes be relevant to share with the list.");
            this.currentPart = 2;
        }
        if (e.getSource() == this.part1Con) {
            this.part1Choice = BugReport.ReportType.CONNECTIVITY;
            this.fullChoiceText = "This is a Connectivity Issue Report.";
            this.subjectChoiceText = "Connectivity Issue: ";
            this.part4AllowPublic.setSelected(false);
            this.titleLabel.setText("Connectivity Issue");
            this.descriptionLabel.setText("Connectivity Issue:\n(Please include if this related to jFed, and/or to SSH connections setup by jFed, and from which network you are connecting)");
            this.part4note.setText("You are totally free in this choice.\nConnectivity issues might in some cases be generic, and thus relevant to share with the list.");
            this.part2Choice = BugReport.ReportTarget.OTHER;
            this.currentPart = 3;
        }
        if (e.getSource() == this.part1Other) {
            this.part1Choice = BugReport.ReportType.OTHER;
            this.subjectChoiceText = "Feedback: ";
            this.part4AllowPublic.setSelected(true);
            this.titleLabel.setText("Feedback");
            this.descriptionLabel.setText("Feedback:");
            this.part4note.setText("You are totally free in this choice.");
            this.currentPart = 2;
        }
        if (this.part1Choice == null) {
            this.part1Choice = BugReport.ReportType.OTHER;
            LOG.error("onPartOne() -> Unknown event source! falling back to part1Choice = Part1Choice.OTHER. e.getSource()={}", e.getSource());
        }
        this.bugReportComposer.setReportType(this.part1Choice);
        this.showPart();
    }

    public void onPartTwo(ActionEvent e) {
        if (e.getSource() == this.part2jFed) {
            this.part2Choice = BugReport.ReportTarget.JFED;
            this.fullChoiceText = this.fullChoiceText + "\nThis is about the jFed Experimenter GUI.";
            if (this.part1Choice == BugReport.ReportType.BUG) {
                this.fullChoiceText = "This is a jFed Bug Report.";
                this.subjectChoiceText = "jFed Bug Report: ";
                this.titleLabel.setText("jFed Bug Report");
                this.descriptionLabel.setText("Bug description:\n(Please include: expected outcome, steps to reproduce)");
            }
            this.currentPart = 4;
        }
        if (e.getSource() == this.part2Testbed) {
            this.part2Choice = BugReport.ReportTarget.TESTBED;
            this.fullChoiceText = this.fullChoiceText + "\nThis is about a Testbed.";
            if (this.part1Choice == BugReport.ReportType.BUG) {
                this.fullChoiceText = "This is a Testbed Problem Report.";
                this.subjectChoiceText = "Testbed Problem Report: ";
                this.titleLabel.setText("Testbed Problem Report");
                this.descriptionLabel.setText("Problem description:\n(Please include: expected outcome, steps to reproduce)");
            }
            this.currentPart = 3;
        }
        if (e.getSource() == this.part2Other) {
            this.part2Choice = BugReport.ReportTarget.OTHER;
            this.currentPart = 3;
        }
        if (this.part2Choice == null) {
            this.part2Choice = BugReport.ReportTarget.OTHER;
            LOG.error("onPartTwo() -> Unknown event source! falling back to part1Choice = Part2Choice.OTHER. e.getSource()={}", e.getSource());
        }
        this.bugReportComposer.setReportTarget(this.part2Choice);
        this.showPart();
    }

    public void onPartThree(ActionEvent e) {
        Set<Server> selectedServers = this.part3AuthChooserController.getSelectedServers();
        LOG.debug("BugReportDialog Part3 selectedServers count = " + (String)(selectedServers == null ? "null" : "" + selectedServers.size()));
        if (selectedServers == null || selectedServers.isEmpty()) {
            this.part3Choice = null;
            this.bugReportComposer.setRelatedTestbeds(Collections.emptyList());
        } else {
            this.part3Choice = selectedServers;
            this.fullChoiceText = this.fullChoiceText + "\nThis is about the " + selectedServers.stream().map(Server::getName).collect(Collectors.joining(" ")) + " Testbed(s)";
            this.bugReportComposer.setRelatedTestbeds(selectedServers.stream().filter(Objects::nonNull).map(Server::getDefaultComponentManagerAsGeniUrn).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        this.currentPart = 4;
        this.showPart();
    }

    public void onPartFour(ActionEvent e) {
        this.part4Choice = this.part4AllowPublic.isSelected();
        this.fullChoiceText = this.part4Choice != false ? this.fullChoiceText + "\nThis information was shared on the public fed4fire experimenter mailinglist." : this.fullChoiceText + "\nThis information was not shared on the public fed4fire experimenter mailinglist.";
        this.subjectTextField.setText(this.subjectChoiceText + "YOUR SUBJECT HERE");
        this.currentPart = 5;
        this.showPart();
    }

    @FXML
    private void onSaveToFileAction() {
        File file;
        File dir;
        if (!this.checkValidity()) {
            return;
        }
        FileChooser fc = new FileChooser();
        fc.setTitle("Save Bug Report");
        fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Bug Report (*..xml)", new String[]{"*.xml"}));
        fc.setInitialFileName(String.format("BugReport-%1$tF-%1$tH-%1$tM.xml", new Date()));
        if (System.getProperty("user.home") != null) {
            fc.setInitialDirectory(new File(System.getProperty("user.home")));
        }
        if (this.jFedPreferences.containsPreference((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST) && (dir = new File(this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST))).exists()) {
            fc.setInitialDirectory(dir);
        }
        if ((file = fc.showSaveDialog(this.submitButton.getScene().getWindow())) != null) {
            BugReportToFileTask bugReportToFileTask = new BugReportToFileTask(this.bugReportComposer, file);
            this.startAndShowBugReportTask(bugReportToFileTask);
        }
    }

    @FXML
    private void onSubmitAction() {
        if (this.checkValidity()) {
            BugReportToServerTask bugReportToServerTask = new BugReportToServerTask(this.bugReportComposer, this.fedmonWebApiClientConfig);
            this.startAndShowBugReportTask(bugReportToServerTask);
        }
    }

    private boolean checkValidity() {
        if (this.subjectTextField.getText().contains("YOUR SUBJECT HERE")) {
            JFDialogs.create().owner(this.submitButton.getScene().getWindow()).message("Please fill in a subject to submit a bug report.").masthead("Subject should be a brief summary of the problem").showError();
            return false;
        }
        if (this.descriptionTextArea == null || this.descriptionTextArea.getText() == null || this.descriptionTextArea.getText().isEmpty()) {
            JFDialogs.create().owner(this.submitButton.getScene().getWindow()).message("Please fill in a description to submit a bug report.").masthead("Description is a mandatory field").showError();
            return false;
        }
        if (this.emailTextField.getText() == null || this.emailTextField.getText().isEmpty()) {
            JFDialogs.create().owner(this.submitButton.getScene().getWindow()).message("You must provide an email address on which we can contact you").masthead("Email is a mandatory field").showError();
            return false;
        }
        if (!BugReportDialog.isValidEmailAddress(this.emailTextField.getText())) {
            JFDialogs.create().owner(this.submitButton.getScene().getWindow()).message("Your email address is invalid. Please check your input!").masthead("Email is a mandatory field").showError();
            return false;
        }
        return true;
    }

    private static boolean isValidEmailAddress(String email) {
        String ePattern = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
        Pattern p = Pattern.compile(ePattern);
        Matcher m = p.matcher(email);
        return m.matches();
    }

    private void startAndShowBugReportTask(Task<Integer> bugReportTask) {
        this.reportTask = bugReportTask;
        this.submitting.set(true);
        this.progressLabel.textProperty().bind((ObservableValue)bugReportTask.messageProperty());
        this.submitProgressIndicator.progressProperty().bind((ObservableValue)bugReportTask.progressProperty());
        bugReportTask.setOnSucceeded(workerStateEvent -> {
            JFDialogs.create().owner(this.submitButton.getScene().getWindow()).message("The bug report was saved with ID " + String.valueOf(bugReportTask.getValue())).masthead("Your bug report was submitted").title("Bug report submitted").showInformation();
            this.reportTask = null;
            this.close();
        });
        bugReportTask.setOnFailed(workerStateEvent -> {
            JFDialogs.create().owner(this.submitButton.getScene().getWindow()).message("An error occurred while sending the bug report. Are you connected to the internet?").masthead("Error while sending bug report").title("Error while sending bug report").showException(bugReportTask.getException());
            this.submitting.set(false);
            this.progressLabel.textProperty().unbind();
            this.progressLabel.setText("Processing bug report failed");
            this.submitProgressIndicator.progressProperty().unbind();
            this.reportTask = null;
        });
        new Thread((Runnable)bugReportTask).start();
    }

    private void close() {
        Stage stage = (Stage)this.cancelButton.getScene().getWindow();
        if (stage != null) {
            stage.close();
        }
    }

    @FXML
    private void onCancelAction() {
        if (this.reportTask != null) {
            this.reportTask.cancel();
        }
        this.close();
    }

    @Override
    public void registerScene(Scene scene) {
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.F10, new KeyCombination.Modifier[0]), () -> this.saveToFileButton.setVisible(!this.saveToFileButton.isVisible()));
    }

    @FXML
    private void fetchScreenshot() {
        if (this.systemClipboard.hasImage()) {
            this.screenshotImageView.setImage(this.systemClipboard.getImage());
        } else {
            String osSpecificHelpmessage = "";
            OSDetector.OS currentOS = OSDetector.findOS();
            osSpecificHelpmessage = currentOS == OSDetector.OS.WIN ? "\t- Press 'Print Screen'/ 'Prnt Scrn' / 'PrtScn',\n\t- Press ALT+'Print Screen' if you only want to make a picture of the active window." : (currentOS == OSDetector.OS.MAC ? "\t- Press Command-Control-Shift-3 for the whole screen,\n\t- Press Command-Control-Shift-4 if you want to select a specific area of your screen first,\n\t- Press Command-Control-Shift-4 followed by Space if you want to select a specific window." : "\t- On Ubuntu: press CTRL+'PrtScn'\n\t- On KDE: press 'PrtScn'\n\t- On Gnome: execute 'gnome-screenshot -a -c'");
            JFDialogs.create().message("The clipboard doesn't contain an image at the moment. To include a screenshot in the bugreport, make a screenshot of the relevant windows, then press the button in the Bug Report dialog.\n\nTo make a screenshot and store it on the clipboard: \n" + osSpecificHelpmessage).masthead("Fetching screenshot from clipboard failed").showError();
        }
    }
}

