/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.bugreporting;

import be.iminds.ilabt.jfed.bugreport.model.BugReport;
import be.iminds.ilabt.jfed.experimenter_gui.bugreporting.BugReportComposer;
import be.iminds.ilabt.jfed.util.common.ThreadFactoryUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javafx.concurrent.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BugReportToFileTask
extends Task<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(BugReportToFileTask.class);
    private final BugReportComposer bugReportComposer;
    protected final File outputFile;

    public BugReportToFileTask(BugReportComposer bugReportComposer, File outputFile) {
        this.bugReportComposer = bugReportComposer;
        this.outputFile = outputFile;
    }

    protected Integer call() throws Exception {
        if (!this.bugReportComposer.isPreparationFinished()) {
            this.updateMessage("Waiting for connectivity tests to finish");
            this.updateProgress(-1L, 0L);
            Object dotsString = "";
            while (!this.bugReportComposer.isPreparationFinished()) {
                if (((String)(dotsString = (String)dotsString + ".")).length() > 3) {
                    dotsString = ".";
                }
                this.updateMessage("Waiting for connectivity tests to finish" + (String)dotsString);
                Thread.sleep(800L);
            }
        }
        this.updateMessage("Writing bug report to file");
        try (FileOutputStream fos = new FileOutputStream(this.outputFile);){
            LOG.debug("Writing bug report to file {}", (Object)this.outputFile.getAbsolutePath());
            if (this.bugReportComposer.isFinished()) {
                this.bugReportComposer.reset();
            }
            FutureTask<Void> writeToOutputStreamTask = new FutureTask<Void>(() -> {
                try {
                    BugReport bugReport = this.bugReportComposer.createBugReport();
                    ObjectMapper mapper = new ObjectMapper();
                    mapper.writerWithDefaultPrettyPrinter().writeValue((OutputStream)fos, (Object)bugReport);
                }
                catch (IOException ex) {
                    throw new IOException("An error occurred while writing the bugreport");
                }
                return null;
            });
            ExecutorService es = Executors.newSingleThreadExecutor(ThreadFactoryUtil.getFactory((String)"BugReportToFile"));
            es.submit(writeToOutputStreamTask);
            es.shutdown();
            while (!es.isTerminated()) {
                this.updateProgress(Math.min(this.bugReportComposer.getProgress(), this.bugReportComposer.getTotalProgress()), this.bugReportComposer.getTotalProgress());
            }
            Void aVoid = writeToOutputStreamTask.get();
            this.updateMessage("Writing bug report finished");
            LOG.debug("Successfully wrote bug report. Size={} KB", (Object)((double)this.outputFile.length() / 1024.0));
            Integer n = 0;
            return n;
        }
    }

    protected void failed() {
        super.failed();
        LOG.error("Writing bugreport to file {} failed: {}", new Object[]{this.outputFile.getAbsolutePath(), this.getException() != null ? this.getException().getMessage() : "no error", this.getException()});
    }
}

