/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.bugreporting;

import be.iminds.ilabt.jfed.bugreport.model.BugReport;
import be.iminds.ilabt.jfed.experimenter_gui.bugreporting.BugReportComposer;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientDirect;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObject;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithUri;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javafx.concurrent.Task;
import org.apache.http.HttpEntity;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BugReportToServerTask
extends Task<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(BugReportToServerTask.class);
    private static final String BUG_REPORT_URL = "https://flsmonitor-api.fed4fire.eu/bugreport";
    private final BugReportComposer bugReportComposer;
    private final FedmonWebApiClientDirect fedmonWebApiClient;

    public BugReportToServerTask(BugReportComposer bugReportComposer, final FedmonWebApiClientConfig origFedmonWebApiClientConfig) {
        this.bugReportComposer = bugReportComposer;
        FedmonWebApiClientConfig noLoggingFedmonWebApiClientConfig = new FedmonWebApiClientConfig(){

            public URIBuilder getUriBuilder(Class<? extends JsonLdObject> aClass, boolean b) {
                return origFedmonWebApiClientConfig.getUriBuilder(aClass, b);
            }

            public URIBuilder getUriBuilder(Class<? extends JsonLdObject> aClass, String s, boolean b) {
                return origFedmonWebApiClientConfig.getUriBuilder(aClass, s, b);
            }

            public JFedTrustStore getTrustStore() {
                return origFedmonWebApiClientConfig.getTrustStore();
            }

            public List<X509Certificate> getUserCertificateChain() {
                return origFedmonWebApiClientConfig.getUserCertificateChain();
            }

            public PrivateKey getUserPrivateKey() {
                return origFedmonWebApiClientConfig.getUserPrivateKey();
            }

            public be.iminds.ilabt.jfed.log.Logger getLogger() {
                return null;
            }
        };
        this.fedmonWebApiClient = new FedmonWebApiClientDirect(noLoggingFedmonWebApiClientConfig);
        this.updateTitle("Submit bugreport '" + bugReportComposer.getSubject() + "'");
    }

    protected void updateProgress(AtomicInteger myWorkDoneAI) {
        long myMax = 100L + 50L * (long)this.bugReportComposer.callsCountProperty().get() + 50L;
        long myWorkDone = myWorkDoneAI.get();
        if (myWorkDone < 0L) {
            super.updateProgress(myWorkDone, myMax);
            return;
        }
        long SCALE = 100L;
        long MY_PART = 75L;
        long COMPOSER_PART = 25L;
        long workDone = (Math.min(myWorkDone, myMax) * 75L + (long)Math.min(this.bugReportComposer.getProgress(), this.bugReportComposer.getTotalProgress()) * 25L) / 100L;
        long max = (myMax * 75L + (long)this.bugReportComposer.getTotalProgress() * 25L) / 100L;
        assert (workDone <= max);
        super.updateProgress(workDone, max);
    }

    protected Integer call() throws Exception {
        if (!this.bugReportComposer.isPreparationFinished()) {
            this.updateMessage("Waiting for connectivity tests to finish");
            super.updateProgress(-1L, 0L);
            Object dotsString = "";
            while (!this.bugReportComposer.isPreparationFinished()) {
                if (((String)(dotsString = (String)dotsString + ".")).length() > 3) {
                    dotsString = ".";
                }
                this.updateMessage("Waiting for connectivity tests to finish" + (String)dotsString);
                Thread.sleep(800L);
            }
        }
        AtomicInteger myProgress = new AtomicInteger(0);
        this.updateMessage("Preparing bug report");
        this.updateProgress(myProgress);
        BugReport bugReport = this.bugReportComposer.createBugReport();
        this.updateProgress(myProgress);
        this.updateMessage("Sending bug report to Server");
        BugReport createdBugReport = (BugReport)this.fedmonWebApiClient.create((JsonLdObjectWithUri)bugReport);
        myProgress.addAndGet(100);
        Integer createdId = (Integer)createdBugReport.getId();
        this.updateProgress(myProgress);
        this.updateMessage("Sending call logs to Server");
        this.bugReportComposer.iterateOverApiCallDetails((id, detail) -> {
            String jsonData;
            URI callCreateUri;
            String callCreateUriString = "https://flsmonitor-api.fed4fire.eu/bugreport/" + createdId + "/call";
            try {
                callCreateUri = new URI(callCreateUriString);
            }
            catch (URISyntaxException e) {
                LOG.error("Failed to create bugreport call URI: \"" + callCreateUriString + "\"", (Throwable)e);
                throw e;
            }
            try {
                jsonData = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)detail);
            }
            catch (JsonProcessingException e) {
                this.failed();
                LOG.error("Error converting call detail to JSON", (Throwable)e);
                throw new RuntimeException("Error converting call detail to JSON", e);
            }
            StringEntity callDataEntity = new StringEntity(jsonData, ContentType.create((String)"application/json", (String)"UTF-8"));
            try {
                this.fedmonWebApiClient.contactServer(callCreateUri, (HttpEntity)callDataEntity, FedmonWebApiClientDirect.HttpMethod.POST, null, null);
                myProgress.addAndGet(50);
            }
            catch (FedmonWebApiClient.FedmonWebApiClientException e) {
                LOG.error("Server error: Failed to create bugreport @ " + callCreateUri.toASCIIString(), (Throwable)e);
                throw e;
            }
            this.updateProgress(myProgress);
        });
        myProgress.addAndGet(50);
        this.updateProgress(myProgress);
        return (Integer)createdBugReport.getId();
    }

    protected void failed() {
        LOG.error("Writing bugreport to server failed: {}", (Object)(this.getException() != null ? this.getException().getMessage() : "no exception"), (Object)this.getException());
    }

    private static class OutputStreamProgress
    extends OutputStream {
        private final OutputStream outstream;
        private final AtomicLong bytesWritten = new AtomicLong(0L);

        public OutputStreamProgress(OutputStream outstream) {
            this.outstream = outstream;
        }

        @Override
        public void write(int b) throws IOException {
            this.outstream.write(b);
            this.bytesWritten.incrementAndGet();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.outstream.write(b);
            this.bytesWritten.addAndGet(b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.outstream.write(b, off, len);
            this.bytesWritten.addAndGet(len);
        }

        @Override
        public void flush() throws IOException {
            this.outstream.flush();
        }

        @Override
        public void close() throws IOException {
            this.outstream.close();
        }

        public long getWrittenLength() {
            return this.bytesWritten.get();
        }
    }

    private static class FileBodyWithProgress
    extends FileBody {
        private OutputStreamProgress outstream;

        private FileBodyWithProgress(File file, String mimeType, String charset) {
            super(file, mimeType, charset);
        }

        public void writeTo(OutputStream outstream) throws IOException {
            this.outstream = new OutputStreamProgress(outstream);
            super.writeTo((OutputStream)this.outstream);
        }

        public int getProgress() {
            if (this.outstream == null) {
                return 0;
            }
            long contentLength = this.getContentLength();
            if (contentLength <= 0L) {
                return 0;
            }
            long writtenLength = this.outstream.getWrittenLength();
            return (int)(100L * writtenLength / contentLength);
        }
    }
}

