/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.bugreporting;

import be.iminds.ilabt.jfed.bugreport.model.ConnectivityTestResult;
import be.iminds.ilabt.jfed.bugreport.model.LogLine;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import javafx.event.EventHandler;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Text;
import javafx.util.Callback;

public class ConnectivityTestTable
extends TableView<ConnectivityTestResult> {
    private final TableColumn nameCol = new TableColumn("Name");
    private final TableColumn statusCol = new TableColumn("Status");
    private final TableColumn messageCol = new TableColumn("Message");
    private final TableColumn throwableCol = new TableColumn("Exception");

    public ConnectivityTestTable() {
        this.setEditable(false);
        final EventHandler cellDoubleClickHandler = event -> {
            if (event.getClickCount() > 1) {
                double targetWidth;
                TableCell c = (TableCell)event.getSource();
                TableColumn col = c.getTableColumn();
                String text = c.getText();
                if (col == this.throwableCol) {
                    System.err.print("\nUser requested print of this stacktrace:\n" + text + "\n");
                }
                if (col == this.messageCol) {
                    JFDialogs.create().message("LOG Message:\n\n" + text).masthead(null).title(null).showInformation();
                }
                if ((targetWidth = c.prefWidthProperty().get()) <= 0.0) {
                    Text javaFXText = new Text(text);
                    targetWidth = javaFXText.getLayoutBounds().getWidth();
                }
                double maxColSize = 0.6 * this.widthProperty().get();
                if (col != this.throwableCol && targetWidth > maxColSize) {
                    targetWidth = maxColSize;
                }
                col.setPrefWidth(targetWidth + 5.0);
                col.setMinWidth(targetWidth + 5.0);
            }
        };
        Callback<TableColumn, TableCell> cellFactory = new Callback<TableColumn, TableCell>(){

            public TableCell call(TableColumn p) {
                TableCell<LogLine, Object> cell = new TableCell<LogLine, Object>(){

                    public void updateItem(Object item, boolean empty) {
                        super.updateItem(item, empty);
                        this.setText(empty ? null : this.getString());
                        this.setGraphic(null);
                        this.setWrapText(true);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : this.getItem().toString();
                    }
                };
                cell.addEventFilter(MouseEvent.MOUSE_CLICKED, cellDoubleClickHandler);
                return cell;
            }
        };
        this.statusCol.setCellFactory((Callback)cellFactory);
        this.nameCol.setCellFactory((Callback)cellFactory);
        this.messageCol.setCellFactory((Callback)cellFactory);
        this.throwableCol.setCellFactory((Callback)cellFactory);
        this.getColumns().addAll((Object[])new TableColumn[]{this.statusCol, this.nameCol, this.messageCol, this.throwableCol});
        this.statusCol.setCellValueFactory((Callback)new PropertyValueFactory("status"));
        this.nameCol.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.messageCol.setCellValueFactory((Callback)new PropertyValueFactory("message"));
        this.throwableCol.setCellValueFactory((Callback)new PropertyValueFactory("exception"));
        this.statusCol.setPrefWidth(50.0);
        this.nameCol.setPrefWidth(100.0);
        this.messageCol.setPrefWidth(400.0);
        this.throwableCol.setPrefWidth(500.0);
    }
}

