/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.bugreporting;

import be.iminds.ilabt.jfed.bugreport.model.StitchingJobReport;
import be.iminds.ilabt.jfed.bugreport.model.StitchingJobStateReport;
import be.iminds.ilabt.jfed.bugreport.model.TaskExecutionReport;
import be.iminds.ilabt.jfed.call_log_output.HtmlLogOutput;
import be.iminds.ilabt.jfed.call_log_output.LogOutput;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsCache;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsRef;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.rendersnake.HtmlCanvas;

public class SerializableStitchingJobReportWriter
extends HtmlLogOutput {
    private final StitchingJobReport jobReport;
    private final ApiCallDetailsCache cache;

    public SerializableStitchingJobReportWriter(StitchingJobReport jobReport, ApiCallDetailsCache cache) {
        super("Start Stitching Experiment Report");
        this.jobReport = jobReport;
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void htmlContent(HtmlCanvas html) throws IOException {
        SerializableStitchingJobReportWriter.addClassVisibleToggle((HtmlCanvas)html, (String)"logline-DEBUG", (String)"Debug Log Lines");
        int index = 0;
        for (StitchingJobStateReport reportState : this.jobReport.getStitchingJobStateReports()) {
            List callsCopy;
            List<TaskExecutionReport> list = reportState.getTaskExecutions();
            synchronized (list) {
                callsCopy = reportState.getTaskExecutions().stream().filter(Objects::nonNull).flatMap(taskExecution -> taskExecution.getApiCallDetailIds().stream()).map(id -> this.cache.getApiCallDetails(new ApiCallDetailsRef(id.intValue()))).filter(Objects::nonNull).collect(Collectors.toList());
            }
            SerializableStitchingJobReportWriter.writeGroup((HtmlCanvas)html, (int)index++, (LogOutput.TestResultState)SerializableStitchingJobReportWriter.convertExperimentTaskStatus(reportState.getStatus()), (String)(reportState.getName() + " calls"), (String)("Executed tasks: " + reportState.getTaskExecutions().stream().map(TaskExecutionReport::getName).collect(Collectors.joining(", "))), (long)Duration.between(reportState.getStart(), reportState.getEnd() != null ? reportState.getEnd() : Instant.now()).toMillis(), (Date)Date.from(reportState.getStart()), (Date)Date.from(reportState.getEnd()), (String)null, callsCopy, null);
        }
    }

    @Nullable
    private static LogOutput.TestResultState convertExperimentTaskStatus(@Nullable String status) {
        if (status == null) {
            return null;
        }
        switch (status) {
            case "SUCCESS": {
                return LogOutput.TestResultState.SUCCESS;
            }
            case "FAILED": {
                return LogOutput.TestResultState.FAILED;
            }
            case "WARNING": {
                return LogOutput.TestResultState.WARN;
            }
        }
        return null;
    }
}

