/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.call_gui;

import be.iminds.ilabt.jfed.highlevel.controller.JavaFXTaskThread;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;
import org.controlsfx.glyphfont.GlyphFont;
import org.controlsfx.glyphfont.GlyphFontRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskLabel
extends HBox {
    private static final Logger LOG = LoggerFactory.getLogger(TaskLabel.class);
    private static final GlyphFont fontAwesome = GlyphFontRegistry.font((String)"FontAwesome");
    private final Label id;
    private final Label name;
    private final ObjectProperty<JavaFXTaskThread.FXTaskExecution> task = new SimpleObjectProperty(null);
    private final ChangeListener<? super TaskExecution.TaskState> stateChangeListener;
    private static final Set<String> allStateStyleClasses = Arrays.stream(TaskExecution.TaskState.values()).map(TaskLabel::taskStateToStyleClass).collect(Collectors.toSet());

    public TaskLabel() {
        this.id = new Label("");
        this.id.getStyleClass().add((Object)"task-label-id");
        this.name = new Label("");
        this.name.getStyleClass().add((Object)"task-label-name");
        this.getStylesheets().add((Object)TaskLabel.class.getResource("calls.css").toExternalForm());
        this.getStyleClass().add((Object)"task-label");
        this.getChildren().addAll((Object[])new Node[]{this.id, this.name});
        this.stateChangeListener = (observableValue, oldTaskState, newTaskState) -> this.changeState((TaskExecution.TaskState)oldTaskState, (TaskExecution.TaskState)newTaskState);
        this.task.addListener((observableValue, oldFXTaskExecution, newFXTaskExecution) -> {
            TaskExecution.TaskState oldTaskState = null;
            if (oldFXTaskExecution != null) {
                oldTaskState = oldFXTaskExecution.getState();
                oldFXTaskExecution.stateProperty().removeListener(this.stateChangeListener);
            }
            if (newFXTaskExecution != null) {
                this.name.setText(newFXTaskExecution.getName());
                this.id.setText(newFXTaskExecution.getId());
                newFXTaskExecution.stateProperty().addListener(this.stateChangeListener);
                this.changeState(oldTaskState, newFXTaskExecution.getState());
            }
        });
    }

    private static String taskStateToStyleClass(TaskExecution.TaskState state) {
        switch (state) {
            case UNSUBMITTED: {
                return "taskstate-unsubmitted";
            }
            case BLOCKED: {
                return "taskstate-blocked";
            }
            case QUEUED: 
            case FUTURE: {
                return "taskstate-queued";
            }
            case RUNNING: {
                return "taskstate-running";
            }
            case FAILED: 
            case CANCELLED: {
                return "taskstate-failed";
            }
            case SUCCESS: {
                return "taskstate-success";
            }
        }
        LOG.debug("Unexpected state: " + String.valueOf(state));
        return "taskstate-unsubmitted";
    }

    private static FontAwesome.Glyph taskStateToIcon(TaskExecution.TaskState state) {
        switch (state) {
            case UNSUBMITTED: {
                return FontAwesome.Glyph.ASTERISK;
            }
            case BLOCKED: {
                return FontAwesome.Glyph.PAUSE;
            }
            case QUEUED: {
                return FontAwesome.Glyph.REORDER;
            }
            case RUNNING: {
                return FontAwesome.Glyph.PLAY;
            }
            case FAILED: {
                return FontAwesome.Glyph.EXCLAMATION_TRIANGLE;
            }
            case SUCCESS: {
                return FontAwesome.Glyph.CHECK_SQUARE;
            }
        }
        throw new RuntimeException("Unexpected state");
    }

    private void changeState(TaskExecution.TaskState oldTaskState, TaskExecution.TaskState newTaskState) {
        if (newTaskState != null) {
            String newStyleClass = TaskLabel.taskStateToStyleClass(newTaskState);
            this.getStyleClass().removeAll(allStateStyleClasses);
            this.getStyleClass().add((Object)newStyleClass);
            Glyph newIcon = fontAwesome.create((Enum)TaskLabel.taskStateToIcon(newTaskState));
            newIcon.setTooltip(new Tooltip(newTaskState.name()));
            this.id.setGraphic((Node)newIcon);
        } else {
            this.id.setGraphic(null);
            this.id.setText("");
            this.name.setText("");
        }
    }

    public void setTask(JavaFXTaskThread.FXTaskExecution t) {
        this.task.set((Object)t);
    }

    public ObjectProperty<JavaFXTaskThread.FXTaskExecution> taskProperty() {
        return this.task;
    }
}

