/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.call_gui;

import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.jfed.experimenter_gui.call_gui.TaskList;
import be.iminds.ilabt.jfed.highlevel.controller.JavaFXTaskThread;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.log_cache.AllApiCallsList;
import be.iminds.ilabt.jfed.ui.javafx.log_gui.LogHistoryPanel;
import be.iminds.ilabt.jfed.ui.javafx.util.TimeUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TasksPanelController {
    private static final Logger LOG = LoggerFactory.getLogger(TasksPanelController.class);
    @FXML
    private LogHistoryPanel logPanel;
    @FXML
    private TaskList allTaskList;
    @FXML
    private VBox taskDetailsPane;
    @FXML
    private TaskList dependingOnTaskList;
    @FXML
    private TaskList dependersTaskList;
    @FXML
    private TextField taskNameField;
    @FXML
    private Parent taskExceptionBox;
    @FXML
    private TextArea taskExceptionArea;
    @FXML
    private TextField taskStateField;
    @FXML
    private TextField startTimeField;
    @FXML
    private TextField stopTimeField;
    @FXML
    private Label durationLabel;
    @FXML
    private Label taskCallsLabel;
    private final JavaFXTaskThread javaFXTaskThread;
    private final AllApiCallsList allApiCallsList;
    private final ObjectProperty<JavaFXTaskThread.FXTaskExecution> selectedSingleTask = new SimpleObjectProperty(null);
    private ChangeListener<Throwable> updateListener = null;

    @Inject
    TasksPanelController(JavaFXTaskThread javaFXTaskThread, AllApiCallsList allApiCallsList) {
        this.javaFXTaskThread = javaFXTaskThread;
        this.allApiCallsList = allApiCallsList;
    }

    @FXML
    private void initialize() {
        this.taskExceptionBox.managedProperty().bind((ObservableValue)this.taskExceptionBox.visibleProperty());
        this.taskDetailsPane.visibleProperty().bind((ObservableValue)this.allTaskList.getSelectionModel().selectedItemProperty().isNotNull());
        this.doAllInit();
    }

    private void doAllInit() {
        assert (this.logPanel != null);
        ObservableList allTasks = this.javaFXTaskThread.getAllTasks();
        this.allTaskList.setItems(allTasks);
        ChangeListener showTimeListener = (observableValue, date, date1) -> this.showTime();
        this.allTaskList.getSelectionModel().selectedItemProperty().addListener((observableValue, oldFXTaskExecution, newFXTaskExecution) -> {
            if (oldFXTaskExecution != null) {
                this.taskStateField.textProperty().unbind();
                oldFXTaskExecution.runStartDateProperty().removeListener(showTimeListener);
                oldFXTaskExecution.runStopDateProperty().removeListener(showTimeListener);
            }
            this.selectedSingleTask.set(newFXTaskExecution);
            if (this.updateListener != null && oldFXTaskExecution != null) {
                oldFXTaskExecution.getException().removeListener(this.updateListener);
                this.updateListener = null;
            }
            if (newFXTaskExecution != null) {
                this.taskNameField.textProperty().set((Object)newFXTaskExecution.getName());
                this.taskStateField.textProperty().bind((ObservableValue)Bindings.convert((ObservableValue)newFXTaskExecution.stateProperty()));
                this.dependingOnTaskList.setItems(newFXTaskExecution.getObservableDependsOn());
                this.dependersTaskList.setItems(newFXTaskExecution.getObservableDependingOnThis());
                this.logPanel.setApiCallHistory(newFXTaskExecution.getApiCallHistory());
                this.updateListener = (observableValue1, oldThrowable, newThrowable) -> this.updateException((JavaFXTaskThread.FXTaskExecution)newFXTaskExecution);
                newFXTaskExecution.getException().addListener(this.updateListener);
                this.updateException((JavaFXTaskThread.FXTaskExecution)newFXTaskExecution);
                newFXTaskExecution.runStartDateProperty().addListener(showTimeListener);
                newFXTaskExecution.runStopDateProperty().addListener(showTimeListener);
                this.showTime();
                this.taskCallsLabel.setText("Task calls");
            } else {
                this.taskExceptionBox.setVisible(false);
                this.dependingOnTaskList.setItems(null);
                this.dependersTaskList.setItems(null);
                this.logPanel.clearApiCallHistory();
                this.logPanel.setApiCallHistory(this.allApiCallsList.getObservablSerializableCalls());
                this.taskCallsLabel.setText("All calls");
            }
        });
        if (!allTasks.isEmpty()) {
            this.allTaskList.getSelectionModel().selectFirst();
        }
    }

    public void showAllCalls() {
        this.allTaskList.getSelectionModel().clearSelection();
    }

    public void updateException(JavaFXTaskThread.FXTaskExecution FXTaskExecution2) {
        if (FXTaskExecution2.getException().get() == null) {
            this.taskExceptionBox.setVisible(false);
            this.taskExceptionArea.setText("");
        } else {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ((Throwable)FXTaskExecution2.getException().get()).printStackTrace(pw);
            pw.close();
            String stacktrace = sw.getBuffer().toString();
            this.taskExceptionBox.setVisible(true);
            this.taskExceptionArea.setText(stacktrace);
        }
    }

    public void printStackTrace() {
        System.err.println("Stacktrace:\n" + this.taskExceptionArea.getText());
        LOG.info("User requested print of stacktrace:\n" + this.taskExceptionArea.getText());
    }

    public void showTime() {
        JavaFXTaskThread.FXTaskExecution task = (JavaFXTaskThread.FXTaskExecution)this.selectedSingleTask.get();
        if (task != null) {
            Date stop;
            Date start = (Date)task.runStartDateProperty().get();
            if (start != null) {
                this.startTimeField.setText(String.valueOf(start));
            }
            if ((stop = (Date)task.runStopDateProperty().get()) != null) {
                assert (start != null);
                this.stopTimeField.setText(String.valueOf(stop));
                long durationMillis = stop.getTime() - start.getTime();
                this.durationLabel.setText(TimeUtils.formatMillis((long)durationMillis, (TimeUnit)TimeUnit.DAYS, (TimeUnit)TimeUnit.MILLISECONDS));
            }
        }
    }

    public void showTaskExecution(TaskExecution taskExecution) {
        JavaFXTaskThread.FXTaskExecution fxTask = taskExecution.getFXTaskExecution();
        this.allTaskList.getSelectionModel().select((Object)fxTask);
    }

    public boolean showApiCall(int callId) {
        for (JavaFXTaskThread.FXTaskExecution taskExecution : this.allTaskList.getItems()) {
            for (SerializableApiCallDetails taskApiCall : taskExecution.getApiCallHistory()) {
                if (taskApiCall.getId() != callId) continue;
                this.allTaskList.getSelectionModel().select((Object)taskExecution);
                this.logPanel.showApiCall(taskApiCall);
                return true;
            }
        }
        return false;
    }
}

