/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.call_gui;

import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.jfed.experimenter_gui.call_gui.TasksPanelController;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsRef;
import be.iminds.ilabt.jfed.ui.javafx.util.StageUtils;
import java.io.IOException;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TasksWindow {
    private static final String TASKS_PANEL_FXML = "Calls.fxml";
    private final Stage callsStage;
    private final TasksPanelController controller;

    @Inject
    TasksWindow(FXMLLoader loader) {
        Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
        this.callsStage = new Stage();
        StageUtils.setJFedStageIcons((Stage)this.callsStage);
        StageUtils.fillPrimaryScreen((Stage)this.callsStage);
        this.callsStage.setTitle("jFed Calls Overview");
        TasksPanelController controller = null;
        try {
            loader.setLocation(TasksWindow.class.getResource(TASKS_PANEL_FXML));
            this.callsStage.setScene(new Scene((Parent)loader.load()));
            controller = (TasksPanelController)loader.getController();
        }
        catch (IOException ex) {
            throw new RuntimeException("Error while loading TasksWindow", ex);
        }
        this.controller = controller;
    }

    public synchronized void showTasks() {
        assert (this.callsStage != null);
        this.callsStage.show();
    }

    public void showTaskExecution(TaskExecution taskExecution) {
        this.controller.showTaskExecution(taskExecution);
        this.callsStage.show();
    }

    public void showApiCall(SerializableApiCallDetails apiCallDetails) {
        this.controller.showApiCall(apiCallDetails.getId());
        this.callsStage.show();
    }

    public void showApiCall(ApiCallDetailsRef apiCallDetailsRef) {
        this.controller.showApiCall(apiCallDetailsRef.getId());
        this.callsStage.show();
    }
}

