/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.canvas;

import be.iminds.ilabt.jfed.experimenter_gui.canvas.CanvasNode;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.ExperimentCanvas;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.NewCanvasLink;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.NewLinkTarget;
import be.iminds.ilabt.jfed.highlevel.util.ExecuteOnNotNull;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEditableCanvas
extends ExperimentCanvas {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEditableCanvas.class);
    protected static final double EDITOR_LOCATION_SHIFT = 15.0;
    protected final ObservableList<CanvasNode> clipboard = FXCollections.observableArrayList();
    private final StringProperty status = new SimpleStringProperty();
    private final NewCanvasLink newCanvasLink = new NewCanvasLink(this);

    public AbstractEditableCanvas() {
        new ExecuteOnNotNull<Scene>(this.sceneProperty()){

            public void run() {
                AbstractEditableCanvas.this.initialize();
            }
        };
    }

    private void initialize() {
        this.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.DELETE, new KeyCombination.Modifier[0]), this::deleteSelectedItem);
    }

    protected abstract void deleteSelectedItem();

    @Override
    protected void canvasNodeOnDragDetected(MouseEvent mouseEvent) {
        super.canvasNodeOnDragDetected(mouseEvent);
        this.newCanvasLink.setVisible(false);
    }

    @Override
    protected void canvasNodeOnMouseDragged(MouseEvent mouseEvent) {
        CanvasNode node = (CanvasNode)((Object)mouseEvent.getSource());
        Bounds canvasOrigin = this.getCanvas().localToScene(this.getCanvas().getBoundsInLocal());
        double newX = mouseEvent.getSceneX() - canvasOrigin.getMinX() - node.getBoundsInParent().getWidth() / 2.0;
        double newY = mouseEvent.getSceneY() - canvasOrigin.getMinY() - node.getBoundsInParent().getHeight() / 2.0;
        node.relocate(newX, newY);
        mouseEvent.consume();
    }

    @Override
    protected void onCanvasMouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isShiftDown() || !this.newCanvasLink.isVisible()) {
            super.onCanvasMouseDragged(mouseEvent);
        } else {
            NewLinkTarget newLinkTarget = this.findNearbyTarget(mouseEvent.getX(), mouseEvent.getY());
            if (newLinkTarget != null && newLinkTarget != this.newCanvasLink.getOrigin()) {
                this.newCanvasLink.setTarget(newLinkTarget);
                this.newCanvasLink.setValid(this.isLegalLink(this.newCanvasLink));
            } else {
                this.newCanvasLink.setNewEnd(mouseEvent.getX(), mouseEvent.getY());
                this.newCanvasLink.setValid(true);
            }
        }
    }

    @Override
    protected void onCanvasMouseReleased(MouseEvent mouseEvent) {
        super.onCanvasMouseReleased(mouseEvent);
        if (this.newCanvasLink.isLinkComplete()) {
            if (!this.isLegalLink(this.newCanvasLink)) {
                this.setStatus("The requested link is illegal and was ignored.");
                LOG.trace("Link is not legal, and is thus rejected.");
            } else {
                this.processNewLinkRequest(this.newCanvasLink);
            }
        }
        this.newCanvasLink.clear();
        this.newCanvasLink.setVisible(false);
    }

    protected abstract boolean isLegalLink(NewCanvasLink var1);

    @Override
    protected void onCanvasMouseMoved(MouseEvent mouseEvent) {
        if (!mouseEvent.isPrimaryButtonDown()) {
            NewLinkTarget newLinkTarget = this.findNearbyTarget(mouseEvent.getX(), mouseEvent.getY());
            if (newLinkTarget != null) {
                this.newCanvasLink.setOrigin(newLinkTarget);
                this.newCanvasLink.setNewEnd(mouseEvent.getX(), mouseEvent.getY());
                this.newCanvasLink.setVisible(true);
                this.setStatus("Click and drag the circle to another item on the canvas to create a new connection");
            } else {
                this.setStatus("");
                this.newCanvasLink.setVisible(false);
            }
        }
    }

    public NewLinkTarget findNearbyTarget(double x, double y) {
        return this.getCanvas().getChildren().stream().filter(child -> child instanceof NewLinkTarget).map(NewLinkTarget.class::cast).min(Comparator.comparingDouble(o -> AbstractEditableCanvas.getMinimumSquareDistanceToXY(o, x, y))).filter(newLinkTarget -> AbstractEditableCanvas.getMinimumSquareDistanceToXY(newLinkTarget, x, y) < 1600.0).orElse(null);
    }

    private static double getMinimumSquareDistanceToXY(NewLinkTarget nc, double x, double y) {
        double nx = nc.getCanvasBounds().getMinX();
        if (x >= nc.getCanvasBounds().getMinX() && x <= nc.getCanvasBounds().getMaxX()) {
            nx = x;
        } else if (x > nc.getCanvasBounds().getMaxX()) {
            nx = nc.getCanvasBounds().getMaxX();
        }
        double ny = nc.getCanvasBounds().getMinY();
        if (y >= nc.getCanvasBounds().getMinY() && y <= nc.getCanvasBounds().getMaxY()) {
            ny = y;
        } else if (y > nc.getCanvasBounds().getMaxY()) {
            ny = nc.getCanvasBounds().getMaxY();
        }
        return AbstractEditableCanvas.squareDistance(x, y, nx, ny);
    }

    private static double squareDistance(double xa, double ya, double xb, double yb) {
        return (xa - xb) * (xa - xb) + (ya - yb) * (ya - yb);
    }

    protected abstract boolean processNewLinkRequest(NewCanvasLink var1);

    public void copySelected() {
        this.clipboard.clear();
        if (!(this.getSelectionProvider().getSelectedObject() instanceof CanvasNode)) {
            JFDialogs.create().owner(this.getScene().getWindow()).message("Nothing to copy!\r\nPlease select an item first.").masthead("Copy action failed").showWarning();
            return;
        }
        this.clipboard.add((Object)((CanvasNode)((Object)this.getSelectionProvider().getSelectedObject())));
    }

    public final void paste() {
        if (this.clipboard.isEmpty()) {
            JFDialogs.create().owner(this.getScene().getWindow()).message("Nothing to paste!\r\nPlease copy an item first.").masthead("Paste action failed").showWarning();
        }
        ArrayList newClipboard = new ArrayList();
        this.clipboard.forEach(canvasNode -> {
            CanvasNode newCanvasNode = this.addCopyOfNodeToCanvas((CanvasNode)((Object)canvasNode));
            if (newCanvasNode != null) {
                newClipboard.add(newCanvasNode);
            }
        });
        this.clipboard.clear();
        this.clipboard.addAll(newClipboard);
    }

    public void duplicateSelected() {
        if (this.getSelectionProvider().getSelectedObject() instanceof CanvasNode) {
            CanvasNode canvasNode = (CanvasNode)((Object)this.getSelectionProvider().getSelectedObject());
            CanvasNode newRspecCanvasNode = this.addCopyOfNodeToCanvas(canvasNode);
            if (newRspecCanvasNode != null) {
                this.getSelectionProvider().setSelectedObject((Object)newRspecCanvasNode);
            }
        } else {
            JFDialogs.create().owner(this.getScene().getWindow()).message("Nothing to duplicate!\r\nPlease select an item first.").masthead("Duplicate action failed").showWarning();
        }
    }

    protected abstract CanvasNode addCopyOfNodeToCanvas(CanvasNode var1);

    public ReadOnlyListProperty<CanvasNode> getClipboard() {
        return new ReadOnlyListWrapper(this.clipboard).getReadOnlyProperty();
    }

    public String getStatus() {
        return (String)this.status.get();
    }

    public StringProperty statusProperty() {
        return this.status;
    }

    public void setStatus(String status) {
        if (Objects.equals(this.status.get(), status)) {
            return;
        }
        LOG.trace("New Status: {}", (Object)status);
        this.status.set((Object)status);
    }
}

