/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.canvas;

import be.iminds.ilabt.jfed.experimenter_gui.canvas.NewLinkTarget;
import java.util.Arrays;
import java.util.HashSet;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.shape.Line;
import javax.annotation.Nonnull;

public class CanvasLink
extends Line {
    private static final String CANVAS_LINK_STYLECLASS = "canvas-link";
    private static final String CANVAS_LINK_SELECTED_STYLECLASS = "canvas-link";
    private static final String CANVAS_LINK_EDITABLE_STYLECLASS = "canvas-link-editable";
    private static final String CANVAS_LINK_TYPE_LAN_STYLECLASS = "canvas-link-type-lan";
    private static final String CANVAS_LINK_TYPE_GRE_STYLECLASS = "canvas-link-type-gre";
    private static final String CANVAS_LINK_TYPE_EGRE_STYLECLASS = "canvas-link-type-gre";
    private static final String CANVAS_LINK_TYPE_STITCH_STYLECLASS = "canvas-link-type-stitch";
    private static final String CANVAS_LINK_TYPE_WIRELESS_STYLECLASS = "canvas-link-type-wireless";
    private static final String CANVAS_LINK_TYPE_OTHER_STYLECLASS = "canvas-link-type-other";
    private final BooleanProperty selected = new SimpleBooleanProperty(false);
    private final BooleanProperty stitched = new SimpleBooleanProperty(false);
    private final StringProperty linkType = new SimpleStringProperty("lan");
    @Nonnull
    private final Node nodeA;
    @Nonnull
    private final Node nodeB;

    public CanvasLink(@Nonnull Node nodeA, @Nonnull Node nodeB) {
        this.selected.addListener((observableValue, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.getStyleClass().remove((Object)"canvas-link");
                this.getStyleClass().add((Object)"canvas-link");
            } else {
                this.getStyleClass().remove((Object)"canvas-link");
                this.getStyleClass().add((Object)"canvas-link");
            }
        });
        this.getStyleClass().add((Object)"canvas-link");
        this.getStyleClass().add((Object)CANVAS_LINK_EDITABLE_STYLECLASS);
        this.getStyleClass().add((Object)CANVAS_LINK_TYPE_LAN_STYLECLASS);
        this.linkType.addListener((observableValue, oldValue, newValue) -> this.updateLinkTypeStyle());
        this.stitched.addListener((observableValue, oldValue, newValue) -> this.updateLinkTypeStyle());
        this.nodeA = nodeA;
        this.nodeB = nodeB;
        this.startXProperty().bind((ObservableValue)NewLinkTarget.createCenterXBinding(nodeA));
        this.startYProperty().bind((ObservableValue)NewLinkTarget.createCenterYBinding(nodeA));
        this.endXProperty().bind((ObservableValue)NewLinkTarget.createCenterXBinding(nodeB));
        this.endYProperty().bind((ObservableValue)NewLinkTarget.createCenterYBinding(nodeB));
    }

    private void updateLinkTypeStyle() {
        String newStyleClass;
        String linkTypeVal = this.linkType.getValue();
        HashSet<String> typesToremove = new HashSet<String>(Arrays.asList(CANVAS_LINK_TYPE_LAN_STYLECLASS, "canvas-link-type-gre", "canvas-link-type-gre", CANVAS_LINK_TYPE_STITCH_STYLECLASS, CANVAS_LINK_TYPE_WIRELESS_STYLECLASS, CANVAS_LINK_TYPE_OTHER_STYLECLASS));
        if (linkTypeVal == null) {
            newStyleClass = CANVAS_LINK_TYPE_LAN_STYLECLASS;
        } else {
            switch (linkTypeVal) {
                case "lan": {
                    newStyleClass = CANVAS_LINK_TYPE_LAN_STYLECLASS;
                    break;
                }
                case "gre-tunnel": {
                    newStyleClass = "canvas-link-type-gre";
                    break;
                }
                case "egre-tunnel": {
                    newStyleClass = "canvas-link-type-gre";
                    break;
                }
                case "wireless": {
                    newStyleClass = CANVAS_LINK_TYPE_WIRELESS_STYLECLASS;
                    break;
                }
                case "stitch": {
                    newStyleClass = CANVAS_LINK_TYPE_STITCH_STYLECLASS;
                    break;
                }
                default: {
                    newStyleClass = CANVAS_LINK_TYPE_OTHER_STYLECLASS;
                }
            }
        }
        if (this.stitched.get()) {
            newStyleClass = CANVAS_LINK_TYPE_STITCH_STYLECLASS;
        }
        typesToremove.remove(newStyleClass);
        this.getStyleClass().removeAll(typesToremove);
        this.getStyleClass().add((Object)newStyleClass);
        ObservableList currentStyleClasses = this.getStyleClass();
        System.out.println("stitched=" + this.stitched.get());
        System.out.println("linkTypeVal=" + linkTypeVal);
        System.out.println("typesToremove=" + String.valueOf(typesToremove));
        System.out.println("newStyleClass=" + newStyleClass);
        System.out.println("currentStyleClasses=" + String.valueOf(currentStyleClasses));
    }

    @Nonnull
    public Node getNodeA() {
        return this.nodeA;
    }

    @Nonnull
    public Node getNodeB() {
        return this.nodeB;
    }

    public boolean isSelected() {
        return this.selected.get();
    }

    public void setSelected(boolean selected) {
        this.selected.set(selected);
    }

    public BooleanProperty selectedProperty() {
        return this.selected;
    }

    public boolean isStitched() {
        return this.stitched.get();
    }

    public BooleanProperty stitchedProperty() {
        return this.stitched;
    }

    public void setStitched(boolean stitched) {
        this.stitched.set(stitched);
    }

    public String getLinkType() {
        return (String)this.linkType.get();
    }

    public StringProperty linkTypeProperty() {
        return this.linkType;
    }

    public void setLinkType(String linkType) {
        this.linkType.set((Object)linkType);
    }
}

