/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.canvas;

import be.iminds.ilabt.jfed.experimenter_gui.canvas.ExperimentCanvas;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ToolboxItem;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanvasNode
extends BorderPane {
    private static final Logger LOG = LoggerFactory.getLogger(CanvasNode.class);
    private final ImageView typeImageView;
    private final Label nameLabel;
    private final StackPane testbedPane;
    private final ImageView testbedImageView;
    private final Tooltip tooltip;
    protected final StringProperty tooltipText;
    protected final StringProperty text;
    protected final ObjectProperty<Image> image;
    protected final ObjectProperty<Color> color = new SimpleObjectProperty((Object)Color.TRANSPARENT);
    protected final ObjectProperty<Image> logo;
    private final BooleanProperty selected = new SimpleBooleanProperty(false);

    public CanvasNode() {
        this.typeImageView = new ImageView();
        this.typeImageView.setFitWidth(25.0);
        this.typeImageView.setFitHeight(25.0);
        this.typeImageView.setPreserveRatio(true);
        this.typeImageView.getStyleClass().add((Object)"canvas-node-image");
        this.image = this.typeImageView.imageProperty();
        this.nameLabel = new Label();
        this.text = this.nameLabel.textProperty();
        this.testbedPane = new StackPane();
        this.testbedPane.setPrefWidth(30.0);
        this.color.addListener(observable -> this.testbedPane.setStyle(String.format("-fx-background-color: linear-gradient(from 0%% 0%% to 100%% 0%%, transparent 0%%, rgb(%s,%s,%s)  100%%)", ((Color)this.color.get()).getRed() * 255.0, ((Color)this.color.get()).getGreen() * 255.0, ((Color)this.color.get()).getBlue() * 255.0)));
        this.testbedPane.getStyleClass().add((Object)"canvas-node-shape");
        BorderPane.setAlignment((Node)this.testbedPane, (Pos)Pos.CENTER);
        this.testbedImageView = new ImageView();
        this.testbedImageView.setFitHeight(25.0);
        this.testbedImageView.setFitWidth(25.0);
        this.testbedPane.getChildren().add((Object)this.testbedImageView);
        this.logo = this.testbedImageView.imageProperty();
        this.tooltip = new Tooltip();
        this.tooltipText = this.tooltip.textProperty();
        Tooltip.install((Node)this.testbedPane, (Tooltip)this.tooltip);
        this.getStylesheets().add((Object)CanvasNode.class.getResource("canvas.css").toExternalForm());
        this.getStyleClass().add((Object)"canvas-node");
        this.nameLabel.getStyleClass().add((Object)"canvas-node-text");
        this.setMinSize(100.0, 30.0);
        this.setLeft((Node)this.typeImageView);
        this.setCenter((Node)this.nameLabel);
        this.setRight((Node)this.testbedPane);
        this.selected.addListener(observable -> this.setFocused(this.selected.get()));
    }

    public CanvasNode(String text, Image image) {
        this();
        this.setText(text);
        this.setImage(image);
    }

    public CanvasNode(CanvasNode item) {
        this(item.nameLabel.getText(), item.getTypeImageView().getImage());
    }

    public CanvasNode(ToolboxItem item) {
        this(item.getText(), item.getImageView().getImage());
    }

    public ImageView getTypeImageView() {
        return this.typeImageView;
    }

    public String getText() {
        return (String)this.text.get();
    }

    public StringProperty textProperty() {
        return this.text;
    }

    public Image getImage() {
        return (Image)this.image.get();
    }

    public ObjectProperty<Image> imageProperty() {
        return this.image;
    }

    public void setText(String text) {
        this.text.set((Object)text);
    }

    public void setImage(@Nullable Image image) {
        this.image.set((Object)image);
    }

    public Bounds getCanvasBounds() {
        return ExperimentCanvas.calculateBoundsInCanvas((Node)this);
    }

    public boolean getSelected() {
        return this.selected.get();
    }

    public BooleanProperty selectedProperty() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected.set(selected);
    }
}

