/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.canvas;

import be.iminds.ilabt.jfed.experimenter_gui.canvas.CanvasLink;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.CanvasNode;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.SelectionProvider;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.RspecCanvasLink;
import be.iminds.ilabt.jfed.experimenter_gui.util.force.DragForce;
import be.iminds.ilabt.jfed.experimenter_gui.util.force.ForceItem;
import be.iminds.ilabt.jfed.experimenter_gui.util.force.ForceSimulator;
import be.iminds.ilabt.jfed.experimenter_gui.util.force.NBodyForce;
import be.iminds.ilabt.jfed.experimenter_gui.util.force.SpringForce;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExperimentCanvas
extends ScrollPane {
    private static final Logger LOG = LoggerFactory.getLogger(ExperimentCanvas.class);
    public static final double MAX_CURSOR_NODE_DISTANCE = 40.0;
    public static final double SQUARED_MAX_CURSOR_TARGET_DISTANCE = 1600.0;
    private static final double MIN_ZOOM = 0.25;
    private static final double MAX_ZOOM = 5.0;
    private static final double ZOOM_FACTOR = 1.5;
    private final Pane pCanvas;
    private final ObjectProperty<CanvasStyle> canvasStyle = new SimpleObjectProperty((Object)CanvasStyle.EDITABLE);
    private Point2D dragOrigin;
    private Point2D scrollPaneStart;
    private final SelectionProvider selectionProvider = new SelectionProvider();
    private double zoom = 1.0;
    private final List<RspecCanvasLink> rspecCanvasLinks = new ArrayList<RspecCanvasLink>();
    private static final int AUTOLAYOUT_ITERATIONS = 100;
    private static final int AUTOLAYOUT_MAXSTEP = 50;
    private static AtomicInteger layouterThreadNumber = new AtomicInteger();

    public ExperimentCanvas() {
        this.getStylesheets().add((Object)ExperimentCanvas.class.getResource("canvas.css").toExternalForm());
        this.pCanvas = new Pane();
        this.pCanvas.getStyleClass().add((Object)"canvas");
        this.setContent((Node)this.pCanvas);
        this.viewportBoundsProperty().addListener((observableValue, oldValue, newValue) -> {
            if (newValue.getWidth() > this.pCanvas.getMinWidth()) {
                this.pCanvas.setMinWidth(newValue.getWidth());
            }
            if (newValue.getHeight() > this.pCanvas.getMinHeight()) {
                this.pCanvas.setMinHeight(newValue.getHeight());
            }
        });
        this.pCanvas.setOnMousePressed(this::onCanvasMousePressed);
        this.pCanvas.setOnMouseDragged(this::onCanvasMouseDragged);
        this.pCanvas.setOnMouseReleased(this::onCanvasMouseReleased);
        this.pCanvas.setOnMouseMoved(this::onCanvasMouseMoved);
        this.pCanvas.getStyleClass().add((Object)((CanvasStyle)((Object)this.canvasStyle.get())).getStyleName());
        this.canvasStyle.addListener((observable, oldValue, newValue) -> {
            LOG.trace("Changing experiment canvas style to {}", (Object)newValue);
            this.pCanvas.getStyleClass().remove((Object)oldValue.getStyleName());
            this.pCanvas.getStyleClass().add((Object)newValue.getStyleName());
        });
        this.selectionProvider.selectedObjectProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue instanceof CanvasNode) {
                ((CanvasNode)((Object)((Object)oldValue))).setSelected(false);
            }
            if (newValue instanceof CanvasNode) {
                ((CanvasNode)((Object)((Object)newValue))).setSelected(true);
            }
        });
    }

    public void registerRspecCanvasLink(RspecCanvasLink link) {
        this.rspecCanvasLinks.add(link);
    }

    public void unregisterRspecCanvasLink(RspecCanvasLink link) {
        this.rspecCanvasLinks.remove(link);
    }

    public void canvasItemOnMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == MouseButton.PRIMARY) {
            if (mouseEvent.getSource() instanceof CanvasNode || mouseEvent.getSource() instanceof CanvasLink) {
                this.getSelectionProvider().setSelectedObject(mouseEvent.getSource());
            } else {
                LOG.warn("unexpected item selected: " + String.valueOf(mouseEvent.getSource()));
            }
            mouseEvent.consume();
        }
    }

    protected void canvasNodeOnDragDetected(MouseEvent mouseEvent) {
        CanvasNode node = (CanvasNode)((Object)mouseEvent.getSource());
        this.getSelectionProvider().setSelectedObject((Object)node);
        mouseEvent.consume();
    }

    protected void canvasNodeOnMouseDragged(MouseEvent mouseEvent) {
    }

    protected void onCanvasMouseReleased(MouseEvent mouseEvent) {
        this.dragOrigin = null;
        this.scrollPaneStart = null;
    }

    protected void onCanvasMouseMoved(MouseEvent mouseEvent) {
    }

    private void onCanvasMousePressed(MouseEvent mouseEvent) {
        this.dragOrigin = new Point2D(mouseEvent.getSceneX(), mouseEvent.getSceneY());
        this.scrollPaneStart = new Point2D(this.getHvalue(), this.getVvalue());
    }

    protected void onCanvasMouseDragged(MouseEvent mouseEvent) {
        if (this.dragOrigin == null) {
            return;
        }
        double dx = this.dragOrigin.getX() - mouseEvent.getSceneX();
        double dy = this.dragOrigin.getY() - mouseEvent.getSceneY();
        this.setHvalue(this.scrollPaneStart.getX() + dx);
        this.setVvalue(this.scrollPaneStart.getY() + dy);
    }

    protected Pane getCanvas() {
        return this.pCanvas;
    }

    @Nonnull
    public static Bounds calculateBoundsInCanvas(@Nonnull Node node) {
        Bounds localBounds = node.getBoundsInLocal();
        return new BoundingBox(node.getLayoutX() + node.getTranslateX() + localBounds.getMinX(), node.getLayoutY() + node.getTranslateY() + localBounds.getMinY(), localBounds.getMinZ(), localBounds.getWidth(), localBounds.getHeight(), localBounds.getDepth());
    }

    public SelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public void arrangeNodesOnCircle() {
        this.arrangeNodesOnCircle(Math.max(this.getViewportBounds().getWidth(), 800.0), Math.max(this.getViewportBounds().getHeight(), 400.0));
    }

    public void arrangeNodesOnCircle(double width, double height) {
        List<CanvasNode> nodesToRearrange = this.getCanvasNodes();
        LOG.debug("Arranging {} nodes on a circle of {}x{}", new Object[]{nodesToRearrange.size(), width, height});
        if (width < 100.0) {
            width = 300.0;
        }
        if (height < 100.0) {
            height = 300.0;
        }
        int size = nodesToRearrange.size();
        double radiusW = width / 3.0;
        double radiusH = height / 3.0;
        double centerX = width / 2.0;
        double centerY = height / 2.0;
        double angle = 0.0;
        double step = Math.PI * 2 / (double)size;
        for (CanvasNode n : nodesToRearrange) {
            double x = Math.cos(angle) * radiusW + centerX;
            double y = Math.sin(angle) * radiusH + centerY;
            n.setLayoutX(x -= 90.0);
            n.setLayoutY(y -= 15.0);
            angle += step;
        }
        this.zoom = 1.0;
    }

    public void autoLayout() {
        Runnable layouter = () -> {
            ForceSimulator forceSimulator = new ForceSimulator();
            forceSimulator.addForce(new NBodyForce());
            forceSimulator.addForce(new SpringForce());
            forceSimulator.addForce(new DragForce());
            HashMap<CanvasNode, ForceItem> nodeToForceItemMap = new HashMap<CanvasNode, ForceItem>();
            for (CanvasNode node : this.getCanvasNodes()) {
                ForceItem nodeForceItem = new ForceItem();
                nodeForceItem.location[0] = (float)(Math.random() * this.getWidth());
                nodeForceItem.location[1] = (float)(Math.random() * this.getHeight());
                nodeForceItem.mass = 1.0f;
                forceSimulator.addItem(nodeForceItem);
                nodeToForceItemMap.put(node, nodeForceItem);
            }
            for (RspecCanvasLink link : this.rspecCanvasLinks) {
                ArrayList<RspecCanvasLink.InterfaceLink> ifaces = new ArrayList<RspecCanvasLink.InterfaceLink>(link.getInterfaceLinks());
                for (int i = 0; i < ifaces.size(); ++i) {
                    for (int j = i + 1; j < ifaces.size(); ++j) {
                        forceSimulator.addSpring((ForceItem)nodeToForceItemMap.get(((RspecCanvasLink.InterfaceLink)((Object)((Object)ifaces.get(i)))).getNodeA()), (ForceItem)nodeToForceItemMap.get(((RspecCanvasLink.InterfaceLink)((Object)((Object)ifaces.get(j)))).getNodeA()));
                    }
                }
            }
            long timestep = 1000L;
            for (int i = 0; i < 100; ++i) {
                timestep = (long)((double)timestep * (1.0 - (double)i / 100.0));
                long step = timestep + 50L;
                forceSimulator.runSimulator(step);
            }
            Platform.runLater(() -> {
                double minX = nodeToForceItemMap.values().stream().mapToDouble(fi -> fi.location[0]).min().orElse(0.0);
                double maxX = nodeToForceItemMap.values().stream().mapToDouble(fi -> fi.location[0]).max().orElse(0.0);
                double minY = nodeToForceItemMap.values().stream().mapToDouble(fi -> fi.location[1]).min().orElse(0.0);
                double maxY = nodeToForceItemMap.values().stream().mapToDouble(fi -> fi.location[1]).max().orElse(0.0);
                double maxWidth = nodeToForceItemMap.keySet().stream().mapToDouble(Region::getWidth).max().orElse(150.0);
                double maxHeight = nodeToForceItemMap.keySet().stream().mapToDouble(Region::getHeight).max().orElse(50.0);
                maxWidth += 50.0;
                maxHeight += 25.0;
                for (Map.Entry entry : nodeToForceItemMap.entrySet()) {
                    ForceItem forceItem = (ForceItem)entry.getValue();
                    CanvasNode node = (CanvasNode)((Object)((Object)((Object)entry.getKey())));
                    double x = ((double)forceItem.location[0] - minX) / (1.0 + maxX - minX) * (this.getViewportBounds().getWidth() - maxWidth) + maxWidth;
                    node.setLayoutX(x - node.getWidth());
                    double y = ((double)forceItem.location[1] - minY) / (1.0 + maxY - minY) * (this.getViewportBounds().getHeight() - maxHeight) + maxHeight;
                    node.setLayoutY(y - node.getHeight());
                }
            });
        };
        Thread layouterThread = new Thread(layouter);
        layouterThread.setName("Layouter-" + layouterThreadNumber.incrementAndGet());
        layouterThread.start();
    }

    private List<CanvasNode> getCanvasNodes() {
        return this.pCanvas.getChildren().stream().filter(child -> child instanceof CanvasNode).map(CanvasNode.class::cast).collect(Collectors.toList());
    }

    public void autoFit() {
        this.autoFit(this.getViewportBounds().getWidth(), this.getViewportBounds().getHeight());
    }

    public void autoFit(double screenWidth, double screenHeight) {
        assert (Platform.isFxApplicationThread());
        this.zoom = 1.0;
        List<CanvasNode> nodesToRearrange = this.getCanvasNodes();
        LOG.debug("Autofitting {} nodes inside window of {}x{}", new Object[]{nodesToRearrange.size(), screenWidth, screenHeight});
        if (nodesToRearrange.isEmpty()) {
            return;
        }
        if (screenWidth == 0.0 || screenHeight == 0.0) {
            try {
                throw new RuntimeException("Capturing stacktrace");
            }
            catch (RuntimeException e) {
                LOG.warn("Autofitting BUG: window of 0x0 -> Showing stacktrace to figure out how this could happen, but safely ignoring request", (Throwable)e);
                return;
            }
        }
        if (nodesToRearrange.size() == 1) {
            CanvasNode n = nodesToRearrange.get(0);
            n.setLayoutX(screenWidth / 2.0);
            n.setLayoutY(screenHeight / 2.0);
            return;
        }
        if (screenWidth < 100.0) {
            screenWidth = 200.0;
        }
        if (screenHeight < 100.0) {
            screenHeight = 200.0;
        }
        double marginsX = 75.0;
        double marginsY = 25.0;
        double minX = nodesToRearrange.stream().map(Node::getLayoutX).min(Comparator.naturalOrder()).orElse(0.0);
        double maxX = nodesToRearrange.stream().map(Node::getLayoutX).max(Comparator.naturalOrder()).orElse(0.0);
        double minY = nodesToRearrange.stream().map(Node::getLayoutY).min(Comparator.naturalOrder()).orElse(0.0);
        double maxY = nodesToRearrange.stream().map(Node::getLayoutY).max(Comparator.naturalOrder()).orElse(0.0);
        if (maxX <= minX + 100.0) {
            maxX = minX + 100.0;
        }
        if (maxY <= minY + 100.0) {
            maxY = minY + 100.0;
        }
        double scaleX = (screenWidth - 2.0 * marginsX) / (maxX - minX);
        double scaleY = (screenHeight - 2.0 * marginsY) / (maxY - minY);
        for (CanvasNode n : nodesToRearrange) {
            double oldX = n.getLayoutX();
            double oldY = n.getLayoutY();
            n.setLayoutX((oldX - minX) * scaleX + marginsX);
            n.setLayoutY((oldY - minY) * scaleY + marginsY);
            LOG.debug("Moved {}x{} to {}x{}   (scale={},{}  margins={},{})", new Object[]{oldX, oldY, n.getLayoutX(), n.getLayoutY(), scaleX, scaleY, marginsX, marginsY});
        }
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        if (zoom < 0.25 || zoom > 5.0) {
            throw new IllegalArgumentException("Zoom must be between 0.25 and 5.0");
        }
        double transform = zoom / this.zoom;
        for (CanvasNode node : this.getCanvasNodes()) {
            node.setLayoutX(node.getLayoutX() * transform);
            node.setLayoutY(node.getLayoutY() * transform);
        }
        this.zoom = zoom;
    }

    public void zoomIn() {
        double newZoom = this.zoom * 1.5;
        if (newZoom > 5.0) {
            newZoom = 5.0;
        }
        this.setZoom(newZoom);
    }

    public void zoomOut() {
        double newZoom = this.zoom / 1.5;
        if (newZoom < 0.25) {
            newZoom = 0.25;
        }
        this.setZoom(newZoom);
    }

    public void addNode(CanvasNode node) {
        assert (node.getParent() == null);
        this.pCanvas.getChildren().add((Object)node);
        node.setOnMouseClicked(this::canvasItemOnMouseClicked);
        node.setOnDragDetected(this::canvasNodeOnDragDetected);
        node.setOnMouseDragged(this::canvasNodeOnMouseDragged);
    }

    public void removeNode(CanvasNode node) {
        assert (this.pCanvas.getChildren().contains((Object)node));
        this.pCanvas.getChildren().remove((Object)node);
        node.setOnMouseClicked(null);
        node.setOnDragDetected(null);
        node.setOnMouseDragged(null);
    }

    public void addLinkCenter(RspecCanvasLink.LinkCenter linkCenter) {
        assert (linkCenter.getParent() == null);
        this.pCanvas.getChildren().add((Object)linkCenter);
        linkCenter.setOnMouseClicked(this::canvasItemOnMouseClicked);
    }

    public void addLink(CanvasLink link) {
        assert (link.getParent() == null);
        this.pCanvas.getChildren().add(0, (Object)link);
        link.setOnMouseClicked(this::canvasItemOnMouseClicked);
    }

    public void removeLink(CanvasLink canvasLink) {
        assert (this.pCanvas.getChildren().contains((Object)canvasLink));
        this.pCanvas.getChildren().remove((Object)canvasLink);
    }

    public void removeLinkCenter(RspecCanvasLink.LinkCenter linkCenter) {
        assert (this.pCanvas.getChildren().contains((Object)linkCenter));
        this.pCanvas.getChildren().remove((Object)linkCenter);
    }

    public CanvasStyle getCanvasStyle() {
        return (CanvasStyle)((Object)this.canvasStyle.get());
    }

    public ObjectProperty<CanvasStyle> canvasStyleProperty() {
        return this.canvasStyle;
    }

    public void setCanvasStyle(CanvasStyle canvasStyle) {
        this.canvasStyle.set((Object)canvasStyle);
    }

    public static enum CanvasStyle {
        EDITABLE("canvas-editable"),
        FIXED("canvas-fixed"),
        FAILED("canvas-failed"),
        FUTURE_RESERVATION("canvas-future-reservation"),
        EXPIRED("canvas-expired");

        private final String styleName;

        private CanvasStyle(String styleName) {
            this.styleName = styleName;
        }

        public String getStyleName() {
            return this.styleName;
        }
    }
}

