/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.canvas;

import be.iminds.ilabt.jfed.experimenter_gui.canvas.ExperimentCanvas;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.NewLinkTarget;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.CacheHint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;

public class NewCanvasLink {
    private static final PseudoClass INVALID_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"invalid");
    private final ExperimentCanvas experimentCanvas;
    private final Line line;
    private final Circle circle;
    private final BooleanProperty visible = new SimpleBooleanProperty(false);
    private final BooleanProperty valid = new SimpleBooleanProperty(true);
    private NewLinkTarget origin;
    private NewLinkTarget target;

    public NewCanvasLink(ExperimentCanvas experimentCanvas) {
        this.experimentCanvas = experimentCanvas;
        this.line = new Line();
        this.line.getStyleClass().add((Object)"new-canvas-link-line");
        this.line.setCache(true);
        this.line.setCacheHint(CacheHint.SPEED);
        this.line.visibleProperty().bind((ObservableValue)this.visible);
        experimentCanvas.getCanvas().getChildren().add(0, (Object)this.line);
        this.circle = new Circle();
        this.circle.setRadius(3.5);
        this.circle.getStyleClass().add((Object)"new-canvas-link-end");
        this.circle.setCache(true);
        this.circle.setCacheHint(CacheHint.SPEED);
        this.circle.visibleProperty().bind((ObservableValue)this.visible);
        experimentCanvas.getCanvas().getChildren().add(0, (Object)this.circle);
        this.setVisible(false);
        this.valid.addListener(observable -> {
            this.line.pseudoClassStateChanged(INVALID_PSEUDO_CLASS, !this.valid.get());
            this.circle.pseudoClassStateChanged(INVALID_PSEUDO_CLASS, !this.valid.get());
        });
    }

    public boolean isVisible() {
        return this.visible.get();
    }

    public void setVisible(boolean visible) {
        this.visible.set(visible);
    }

    public BooleanProperty visibleProperty() {
        return this.visible;
    }

    public NewLinkTarget getOrigin() {
        return this.origin;
    }

    public NewLinkTarget getTarget() {
        return this.target;
    }

    public void setOrigin(NewLinkTarget newOrigin) {
        this.origin = newOrigin;
        this.line.setStartX(newOrigin.getCenterPosition().getX());
        this.line.setStartY(newOrigin.getCenterPosition().getY());
    }

    public void setTarget(NewLinkTarget newTarget) {
        this.target = newTarget;
        this.setNewEnd(newTarget.getCenterPosition().getX(), newTarget.getCenterPosition().getY());
    }

    public void clear() {
        this.origin = null;
        this.target = null;
    }

    public void setNewEnd(double x, double y) {
        this.line.setEndX(x);
        this.line.setEndY(y);
        this.circle.setCenterX(x);
        this.circle.setCenterY(y);
    }

    public boolean isLinkComplete() {
        return this.origin != null && this.target != null;
    }

    public boolean getValid() {
        return this.valid.get();
    }

    public BooleanProperty validProperty() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid.set(valid);
    }
}

