/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.canvas;

import be.iminds.ilabt.jfed.experimenter_gui.canvas.CanvasNode;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.util.ImageSize;
import be.iminds.ilabt.jfed.experimenter_gui.util.ImageUtil;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;

public class TestbedAwareCanvasNode
extends CanvasNode {
    private final TestbedInfoSource testbedInfoSource;
    private final JFedGuiConfig config;
    protected final ObjectProperty<GeniUrn> componentManagerId = new SimpleObjectProperty();

    public TestbedAwareCanvasNode(TestbedInfoSource testbedInfoSource, JFedGuiConfig config) {
        this.componentManagerId.addListener(obj -> this.updateTestbed());
        this.testbedInfoSource = testbedInfoSource;
        this.config = config;
    }

    private void updateTestbed() {
        if (this.componentManagerId.get() != null) {
            Server server = this.testbedInfoSource.getByUrnExact((GeniUrn)this.componentManagerId.get());
            if (server != null) {
                this.tooltipText.setValue(server.getName());
                Color serverColor = this.config.getColor(server);
                if (serverColor != null) {
                    this.color.setValue((Object)serverColor);
                } else {
                    this.color.setValue((Object)Color.TRANSPARENT);
                }
                Image logoImage = ImageUtil.getTestbedDescriptionImage(server, ImageSize.SMALL);
                this.logo.setValue((Object)logoImage);
            } else {
                this.color.setValue((Object)Color.TRANSPARENT);
            }
        } else {
            this.logo.setValue(null);
            this.color.setValue((Object)Color.TRANSPARENT);
        }
    }
}

