/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec;

import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.AddressPoolCanvasNode;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.DelayRspecCanvasNode;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.RspecCanvasNode;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.RspecChannelCanvasNode;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.DelayRspecNode;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXAddressPool;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecChannel;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CanvasNodeFactory {
    private final TestbedInfoSource testbedInfoSource;
    private final JFedGuiConfig config;

    @Inject
    public CanvasNodeFactory(TestbedInfoSource testbedInfoSource, JFedGuiConfig config) {
        this.testbedInfoSource = testbedInfoSource;
        this.config = config;
    }

    @Nonnull
    public RspecCanvasNode createRspecCanvasNode(@Nonnull FXRspecNode node) {
        if (node instanceof DelayRspecNode) {
            return new DelayRspecCanvasNode((DelayRspecNode)node, this.testbedInfoSource, this.config);
        }
        return new RspecCanvasNode(node, this.testbedInfoSource, this.config);
    }

    @Nonnull
    public RspecChannelCanvasNode createRspecChannelCanvasNode(FXRspecChannel rspecChannel) {
        return new RspecChannelCanvasNode(rspecChannel, this.testbedInfoSource, this.config);
    }

    @Nonnull
    public AddressPoolCanvasNode createAddressPoolCanvasNode(FXAddressPool addressPool) {
        return new AddressPoolCanvasNode(addressPool, this.testbedInfoSource, this.config);
    }
}

