/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec;

import be.iminds.ilabt.jfed.experimenter_gui.canvas.ExperimentCanvas;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.AddressPoolCanvasNode;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.CanvasNodeFactory;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.RspecCanvasLink;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.RspecCanvasNode;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.RspecChannelCanvasNode;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXAddressPool;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecChannel;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecLink;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelRspecToCanvasBinding {
    private static final Logger LOG = LoggerFactory.getLogger(ModelRspecToCanvasBinding.class);
    @Nonnull
    protected final FXModelRspec model;
    @Nonnull
    private final ExperimentCanvas canvas;
    @Nonnull
    private final JFedGuiConfig config;
    @Nonnull
    private final CanvasNodeFactory canvasNodeFactory;
    private final Map<FXRspecNode, RspecCanvasNode> nodes = new HashMap<FXRspecNode, RspecCanvasNode>();
    private final Map<FXRspecLink, RspecCanvasLink> links = new HashMap<FXRspecLink, RspecCanvasLink>();
    private final Map<FXRspecChannel, RspecChannelCanvasNode> channels = new HashMap<FXRspecChannel, RspecChannelCanvasNode>();
    private final Map<FXAddressPool, AddressPoolCanvasNode> addressPools = new HashMap<FXAddressPool, AddressPoolCanvasNode>();
    private final ListChangeListener<FXRspecNode> rspecNodeListChangeListener = change -> {
        while (change.next()) {
            if (change.wasAdded()) {
                change.getAddedSubList().forEach(this::addNodeToCanvas);
            }
            if (!change.wasRemoved()) continue;
            change.getRemoved().forEach(this::removeNodeFromCanvas);
        }
    };
    private final ListChangeListener<FXRspecLink> rspecLinkListChangeListener = change -> {
        while (change.next()) {
            if (change.wasAdded()) {
                change.getAddedSubList().forEach(this::addLinkToCanvas);
            }
            if (!change.wasRemoved()) continue;
            change.getRemoved().forEach(this::removeLinkFromCanvas);
        }
    };
    private final ListChangeListener<FXRspecChannel> rspecChannelListChangeListener = change -> {
        while (change.next()) {
            if (change.wasAdded()) {
                change.getAddedSubList().forEach(this::addChannelToCanvas);
            }
            if (!change.wasRemoved()) continue;
            change.getRemoved().forEach(this::removeChannelFromCanvas);
        }
    };
    private final ListChangeListener<FXAddressPool> addressPoolListChangeListener = change -> {
        while (change.next()) {
            if (change.wasAdded()) {
                change.getAddedSubList().forEach(this::addAddressPoolToCanvas);
            }
            if (!change.wasRemoved()) continue;
            change.getRemoved().forEach(this::removeAddressPoolFromCanvas);
        }
    };

    private FXRspecNode findDedicatedConnectionNode(String urn) {
        for (FXRspecNode node : this.model.getNodes()) {
            if (!Objects.equals(urn, node.getComponentManagerId())) continue;
            return node;
        }
        return null;
    }

    public ModelRspecToCanvasBinding(@Nonnull FXModelRspec model, @Nonnull ExperimentCanvas canvas, @Nonnull JFedGuiConfig config, @Nonnull CanvasNodeFactory canvasNodeFactory) {
        this.model = model;
        this.canvas = canvas;
        this.config = config;
        this.canvasNodeFactory = canvasNodeFactory;
        for (FXRspecNode node : model.getNodes()) {
            ResourceClass resourceClass;
            assert (node != null);
            if (node.getResourceClassId() == null && (resourceClass = this.config.findBestResourceClass((RspecNode)node)) != null) {
                node.setResourceClassId((String)resourceClass.getId());
            }
            this.addNodeToCanvas(node);
        }
        model.getLinks().forEach(this::addLinkToCanvas);
        model.getChannels().forEach(this::addChannelToCanvas);
        model.getAddressPools().forEach(this::addAddressPoolToCanvas);
        model.getNodes().addListener((ListChangeListener)new WeakListChangeListener(this.rspecNodeListChangeListener));
        model.getLinks().addListener((ListChangeListener)new WeakListChangeListener(this.rspecLinkListChangeListener));
        model.getChannels().addListener((ListChangeListener)new WeakListChangeListener(this.rspecChannelListChangeListener));
        model.getAddressPools().addListener((ListChangeListener)new WeakListChangeListener(this.addressPoolListChangeListener));
    }

    private void addNodeToCanvas(@Nonnull FXRspecNode rspecNode) {
        RspecCanvasNode newNode = this.canvasNodeFactory.createRspecCanvasNode(rspecNode);
        this.nodes.put(rspecNode, newNode);
        this.canvas.addNode(newNode);
    }

    private void addLinkToCanvas(@Nonnull FXRspecLink rspecLink) {
        RspecCanvasLink newLink = new RspecCanvasLink(rspecLink, this);
        this.links.put(rspecLink, newLink);
    }

    private void removeLinkFromCanvas(@Nonnull FXRspecLink rspecLink) {
        RspecCanvasLink rspecCanvasLink = this.links.get(rspecLink);
        rspecCanvasLink.remove();
        this.links.remove(rspecLink);
    }

    private void addChannelToCanvas(@Nonnull FXRspecChannel rspecChannel) {
        RspecChannelCanvasNode newChannel = this.canvasNodeFactory.createRspecChannelCanvasNode(rspecChannel);
        this.channels.put(rspecChannel, newChannel);
        this.canvas.addNode(newChannel);
    }

    private void removeChannelFromCanvas(@Nonnull FXRspecChannel rspecChannel) {
        RspecChannelCanvasNode rspecChannelCanvasNode = this.channels.remove(rspecChannel);
        this.canvas.removeNode(rspecChannelCanvasNode);
    }

    public AddressPoolCanvasNode getAddressPoolCanvasNode(@Nonnull FXAddressPool addressPool) {
        return this.addressPools.get(addressPool);
    }

    private void addAddressPoolToCanvas(@Nonnull FXAddressPool addressPool) {
        AddressPoolCanvasNode newAddressPoolCanvasNode = this.canvasNodeFactory.createAddressPoolCanvasNode(addressPool);
        this.addressPools.put(addressPool, newAddressPoolCanvasNode);
        this.canvas.addNode(newAddressPoolCanvasNode);
    }

    private void removeAddressPoolFromCanvas(@Nonnull FXAddressPool addressPool) {
        AddressPoolCanvasNode addressPoolCanvasNode = this.addressPools.remove(addressPool);
        this.canvas.removeNode(addressPoolCanvasNode);
    }

    private void removeNodeFromCanvas(@Nonnull FXRspecNode rspecNode) {
        RspecCanvasNode rspecCanvasNode = this.nodes.remove(rspecNode);
        this.canvas.removeNode(rspecCanvasNode);
    }

    @Nullable
    public RspecCanvasNode getRspecCanvasNode(@Nonnull FXRspecNode node) {
        return this.nodes.get(node);
    }

    @Nullable
    public RspecCanvasLink getRspecCanvasLink(@Nonnull FXRspecLink link) {
        return this.links.get(link);
    }

    @Nonnull
    public FXModelRspec getModelRspec() {
        return this.model;
    }

    @Nonnull
    public ExperimentCanvas getExperimentCanvas() {
        return this.canvas;
    }
}

