/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec;

import be.iminds.ilabt.jfed.experimenter_gui.canvas.CanvasLink;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.ExperimentCanvas;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.NewLinkTarget;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.ModelRspecToCanvasBinding;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.RspecCanvasNode;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecInterface;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecLink;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.paint.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RspecCanvasLink
implements ListChangeListener<FXRspecInterface> {
    private static final Logger LOG = LoggerFactory.getLogger(RspecCanvasLink.class);
    private static final String LINK_CENTER_STYLECLASS = "link-center";
    private static final String IMPAIRED_LINK_CENTER_STYLECLASS = "impaired-link-center";
    private static final String SHARED_LINK_CENTER_STYLECLASS = "shared-link-center";
    @Nonnull
    private final FXRspecLink link;
    @Nonnull
    private final ModelRspecToCanvasBinding binding;
    @Nonnull
    private final ExperimentCanvas experimentCanvas;
    @Nonnull
    private final LinkCenter linkCenter;
    private final Map<FXRspecInterface, InterfaceLink> ifaceLinks = new HashMap<FXRspecInterface, InterfaceLink>();
    private final InvalidationListener layoutListener = observable -> this.updateLayout();
    private double centerX;
    private double centerY;

    public RspecCanvasLink(@Nonnull FXRspecLink link, @Nonnull ModelRspecToCanvasBinding binding) {
        this.link = link;
        this.binding = binding;
        this.experimentCanvas = binding.getExperimentCanvas();
        this.linkCenter = new LinkCenter();
        this.experimentCanvas.addLinkCenter(this.linkCenter);
        link.getInterfaces().forEach(this::addInterface);
        link.getInterfaces().addListener((ListChangeListener)this);
        link.getLinkTypes().addListener(c -> {
            for (CanvasLink canvasLink : this.ifaceLinks.values()) {
                if (link.getLinkTypes().isEmpty()) {
                    canvasLink.setLinkType("lan");
                    continue;
                }
                canvasLink.setLinkType((String)link.getLinkTypes().get(0));
            }
        });
        link.getComponentManagerUrns().addListener(c -> this.updateStitched((List<? extends GeniUrn>)c.getList()));
        this.updateStitched((List<? extends GeniUrn>)link.getComponentManagerUrns());
        this.experimentCanvas.registerRspecCanvasLink(this);
    }

    private void updateStitched(List<? extends GeniUrn> cms) {
        HashSet<? extends GeniUrn> urns = new HashSet<GeniUrn>(cms);
        for (CanvasLink canvasLink : this.ifaceLinks.values()) {
            canvasLink.setStitched(urns.size() > 1);
        }
        System.out.println("updateStitched urns=" + String.valueOf(urns));
    }

    private void addInterface(@Nonnull FXRspecInterface iface) {
        assert (!this.ifaceLinks.containsKey(iface));
        RspecCanvasNode rspecCanvasNode = this.binding.getRspecCanvasNode(iface.getNode());
        assert (rspecCanvasNode != null);
        if (rspecCanvasNode == null) {
            throw new RuntimeException("Could not add interface because no canvas node found in binding");
        }
        rspecCanvasNode.layoutXProperty().addListener(this.layoutListener);
        rspecCanvasNode.layoutYProperty().addListener(this.layoutListener);
        rspecCanvasNode.boundsInLocalProperty().addListener(this.layoutListener);
        InterfaceLink canvasLink = new InterfaceLink(iface, rspecCanvasNode, this.linkCenter);
        if (!this.link.getLinkTypes().isEmpty()) {
            canvasLink.setLinkType((String)this.link.getLinkTypes().get(0));
        }
        this.ifaceLinks.put(iface, canvasLink);
        this.experimentCanvas.addLink(canvasLink);
        this.updateLayout();
    }

    private void removeInterface(@Nonnull FXRspecInterface iface) {
        InterfaceLink canvasLink = this.ifaceLinks.get(iface);
        RspecCanvasNode rspecCanvasNode = canvasLink.getNodeA();
        rspecCanvasNode.layoutXProperty().removeListener(this.layoutListener);
        rspecCanvasNode.layoutYProperty().removeListener(this.layoutListener);
        rspecCanvasNode.boundsInLocalProperty().removeListener(this.layoutListener);
        this.experimentCanvas.removeLink(canvasLink);
        this.ifaceLinks.remove(iface);
        this.updateLayout();
    }

    private void updateLayout() {
        if (this.ifaceLinks.isEmpty()) {
            return;
        }
        this.centerX = 0.0;
        this.centerY = 0.0;
        for (InterfaceLink ntlcLink : this.ifaceLinks.values()) {
            RspecCanvasNode node = ntlcLink.getNodeA();
            this.centerX += NewLinkTarget.getCenterX((Node)node);
            this.centerY += NewLinkTarget.getCenterY((Node)node);
        }
        this.centerX /= (double)this.ifaceLinks.size();
        this.centerY /= (double)this.ifaceLinks.size();
        if (this.ifaceLinks.size() <= 1) {
            this.centerY += 100.0;
        }
        NewLinkTarget.setCenterX(this.centerX, (Node)this.linkCenter);
        NewLinkTarget.setCenterY(this.centerY, (Node)this.linkCenter);
    }

    public void remove() {
        this.experimentCanvas.unregisterRspecCanvasLink(this);
        this.experimentCanvas.removeLinkCenter(this.linkCenter);
        for (InterfaceLink ntlcLink : this.ifaceLinks.values()) {
            this.experimentCanvas.removeLink(ntlcLink);
        }
        this.link.getInterfaces().removeListener((ListChangeListener)this);
    }

    public void onChanged(ListChangeListener.Change<? extends FXRspecInterface> change) {
        LOG.trace("Detected interface changes on link {}", (Object)this.link.getUniqueId());
        while (change.next()) {
            LOG.trace("Received interface change on link {}: {}", (Object)this.link.getUniqueId(), change);
            if (change.wasAdded()) {
                change.getAddedSubList().forEach(iface -> LOG.trace("iface {} was added to rspecCanvasLink {}", (Object)iface.getClientId(), (Object)this.getRspecLink().getClientId()));
                change.getAddedSubList().forEach(this::addInterface);
            }
            if (!change.wasRemoved()) continue;
            change.getRemoved().forEach(iface -> LOG.trace("iface {} was removed to rspecCanvasLink {}", (Object)iface.getClientId(), (Object)this.getRspecLink().getClientId()));
            change.getRemoved().forEach(this::removeInterface);
        }
    }

    public double getCenterX() {
        return this.centerX;
    }

    public double getCenterY() {
        return this.centerY;
    }

    @Nonnull
    public FXRspecLink getRspecLink() {
        return this.link;
    }

    @Nonnull
    public Button getLinkCenter() {
        return this.linkCenter;
    }

    @Nonnull
    public Collection<InterfaceLink> getInterfaceLinks() {
        return this.ifaceLinks.values();
    }

    @Nullable
    public InterfaceLink getInterfaceLinkByRspecInterface(@Nonnull FXRspecInterface iface) {
        return this.ifaceLinks.get(iface);
    }

    public class LinkCenter
    extends Button
    implements NewLinkTarget {
        private boolean hasImpairedLook = false;
        private boolean hasAutoSharedLook = false;
        private boolean hasAddToSharedLook = false;
        @Nonnull
        private final Node createSharedGraphic = GlyphUtils.createSmallGlyph((FontAwesome.Glyph)FontAwesome.Glyph.USERS, (Color)Color.BLACK);
        @Nonnull
        private final Node addTosharedGraphic = GlyphUtils.createSmallGlyph((FontAwesome.Glyph)FontAwesome.Glyph.USER_PLUS, (Color)Color.BLACK);

        public LinkCenter() {
            this.updateLinkText();
            RspecCanvasLink.this.link.clientIdProperty().addListener((ob, ov, nw) -> this.updateLinkText());
            RspecCanvasLink.this.link.getLinkTypes().addListener(c -> this.updateLinkText());
            RspecCanvasLink.this.link.getComponentManagerUrns().addListener(c -> this.updateLinkText());
            this.getStyleClass().add((Object)RspecCanvasLink.LINK_CENTER_STYLECLASS);
            this.setOnAction(actionEvent -> this.onLinkCenterClicked());
            this.layoutBoundsProperty().addListener(observable -> RspecCanvasLink.this.updateLayout());
            this.focusedProperty().addListener((observableValue, oldValue, newValue) -> {
                for (CanvasLink canvasLink : RspecCanvasLink.this.ifaceLinks.values()) {
                    canvasLink.setSelected((boolean)newValue);
                }
            });
            RspecCanvasLink.this.link.impairedProperty().addListener(observable -> {
                LOG.debug("Link is impaired? {}", (Object)RspecCanvasLink.this.link.isImpaired());
                if (RspecCanvasLink.this.link.isImpaired() != this.hasImpairedLook) {
                    if (RspecCanvasLink.this.link.isImpaired()) {
                        this.getStyleClass().add((Object)RspecCanvasLink.IMPAIRED_LINK_CENTER_STYLECLASS);
                        this.hasImpairedLook = true;
                    } else {
                        this.getStyleClass().remove((Object)RspecCanvasLink.IMPAIRED_LINK_CENTER_STYLECLASS);
                        this.getStyleClass().remove((Object)RspecCanvasLink.LINK_CENTER_STYLECLASS);
                        this.getStyleClass().add((Object)RspecCanvasLink.LINK_CENTER_STYLECLASS);
                        this.hasImpairedLook = false;
                    }
                }
            });
            Runnable updateGraphic = () -> {
                if (this.hasAutoSharedLook) {
                    this.setGraphic(this.createSharedGraphic);
                } else if (this.hasAddToSharedLook) {
                    this.setGraphic(this.addTosharedGraphic);
                } else {
                    this.setGraphic(null);
                }
            };
            ListChangeListener autoShareLanListener = change -> {
                boolean shared = !RspecCanvasLink.this.link.getAutoShareLanNames().isEmpty();
                LOG.debug("Link is auto shared? {}", (Object)shared);
                if (shared != this.hasAutoSharedLook) {
                    if (shared) {
                        this.hasAutoSharedLook = true;
                    } else {
                        this.getStyleClass().remove((Object)RspecCanvasLink.LINK_CENTER_STYLECLASS);
                        this.getStyleClass().add((Object)RspecCanvasLink.LINK_CENTER_STYLECLASS);
                        this.hasAutoSharedLook = false;
                    }
                    updateGraphic.run();
                }
            };
            RspecCanvasLink.this.link.getAutoShareLanNames().addListener(autoShareLanListener);
            autoShareLanListener.onChanged(null);
            ChangeListener addToShareLanListener = (observable, oldValue, newValue) -> {
                boolean shared = RspecCanvasLink.this.link.getSharedLan() != null;
                LOG.debug("Link connects to shared? {}", (Object)shared);
                if (shared != this.hasAddToSharedLook) {
                    if (shared) {
                        this.hasAddToSharedLook = true;
                    } else {
                        this.getStyleClass().remove((Object)RspecCanvasLink.LINK_CENTER_STYLECLASS);
                        this.getStyleClass().add((Object)RspecCanvasLink.LINK_CENTER_STYLECLASS);
                        this.hasAddToSharedLook = false;
                    }
                    updateGraphic.run();
                }
            };
            RspecCanvasLink.this.link.sharedLanProperty().addListener(addToShareLanListener);
            addToShareLanListener.changed(null, null, null);
            updateGraphic.run();
        }

        private void updateLinkText() {
            boolean multiSiteLink;
            boolean bl = multiSiteLink = new HashSet(RspecCanvasLink.this.link.getComponentManagerUrns()).size() > 1;
            if (RspecCanvasLink.this.link.getLinkTypes().isEmpty() || RspecCanvasLink.this.link.getLinkTypes().equals(Collections.singletonList("lan"))) {
                if (multiSiteLink) {
                    this.setText(RspecCanvasLink.this.link.getClientId() + " (stitched)");
                } else {
                    this.setText(RspecCanvasLink.this.link.getClientId());
                }
            } else {
                Object typeList = RspecCanvasLink.this.link.getLinkTypes().stream().map(s -> s.replace("-tunnel", "")).collect(Collectors.joining(", "));
                if (multiSiteLink) {
                    typeList = "multi-site " + (String)typeList;
                }
                this.setText(RspecCanvasLink.this.link.getClientId() + " (" + (String)typeList + ")");
            }
        }

        @Nonnull
        public FXRspecLink getRspecLink() {
            return RspecCanvasLink.this.link;
        }

        private void onLinkCenterClicked() {
            RspecCanvasLink.this.experimentCanvas.getSelectionProvider().setSelectedObject(RspecCanvasLink.this);
        }

        @Nonnull
        public RspecCanvasLink getRspecCanvasLink() {
            return RspecCanvasLink.this;
        }

        @Override
        @Nonnull
        public Point2D getCenterPosition() {
            return new Point2D(RspecCanvasLink.this.centerX, RspecCanvasLink.this.centerY);
        }

        @Override
        @Nonnull
        public Bounds getCanvasBounds() {
            return ExperimentCanvas.calculateBoundsInCanvas((Node)RspecCanvasLink.this.linkCenter);
        }
    }

    public class InterfaceLink
    extends CanvasLink {
        @Nonnull
        private final FXRspecInterface rspecInterface;

        public InterfaceLink(@Nonnull FXRspecInterface rspecInterface, @Nonnull RspecCanvasNode nodeA, Button nodeB) {
            super((Node)nodeA, (Node)nodeB);
            this.rspecInterface = rspecInterface;
        }

        @Nonnull
        public Button getNodeB() {
            return (Button)super.getNodeB();
        }

        @Nonnull
        public RspecCanvasNode getNodeA() {
            return (RspecCanvasNode)super.getNodeA();
        }

        @Nonnull
        public FXRspecInterface getRspecInterface() {
            return this.rspecInterface;
        }
    }
}

