/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec;

import be.iminds.ilabt.jfed.experimenter_gui.canvas.NewLinkTarget;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.TestbedAwareCanvasNode;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.util.ImageSize;
import be.iminds.ilabt.jfed.experimenter_gui.util.ImageUtil;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javax.annotation.Nonnull;

public class RspecCanvasNode
extends TestbedAwareCanvasNode
implements NewLinkTarget {
    private final FXRspecNode node;

    public RspecCanvasNode(@Nonnull FXRspecNode node, @Nonnull TestbedInfoSource testbedInfoSource, @Nonnull JFedGuiConfig config) {
        super(testbedInfoSource, config);
        assert (node != null);
        this.node = node;
        this.setImage(ImageUtil.getRspecNodeImage(config, node, ImageSize.SMALL));
        this.idProperty().bind((ObservableValue)node.clientIdProperty());
        this.textProperty().bind((ObservableValue)node.clientIdProperty());
        this.layoutXProperty().bindBidirectional((Property)node.editorXProperty());
        this.layoutYProperty().bindBidirectional((Property)node.editorYProperty());
        this.translateXProperty().bind((ObservableValue)this.widthProperty().multiply(-0.5));
        this.translateYProperty().bind((ObservableValue)this.heightProperty().multiply(-0.5));
        if (node.getEditorX() < 0.0 && node.getEditorY() < 0.0 && node.getFlackEditorX() >= 0.0) {
            node.setEditorX(node.getFlackEditorX());
            node.setEditorY(node.getFlackEditorY());
        }
        node.resourceClassIdProperty().addListener(observable -> this.setImage(ImageUtil.getRspecNodeImage(config, this.node, ImageSize.SMALL)));
        this.componentManagerId.bind((ObservableValue)node.componentManagerIdProperty());
    }

    @Nonnull
    public FXRspecNode getRspecNode() {
        return this.node;
    }

    @Override
    public Point2D getCenterPosition() {
        return new Point2D(NewLinkTarget.getCenterX((Node)this), NewLinkTarget.getCenterY((Node)this));
    }
}

