/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.connectivity_tester;

import be.iminds.ilabt.jfed.connectivity_tester.ConnectivityTest;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXML;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectivityTestPane
extends GridPane {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectivityTestPane.class);
    private final ObjectProperty<ConnectivityTest.ConnectivityTestResult> result = new SimpleObjectProperty();
    @FXML
    private TextField statusTextField;
    @FXML
    private TextArea messageTextArea;
    @FXML
    private TextArea exceptionTextArea;

    public ConnectivityTestPane() {
        FXMLUtil.injectFXML((Object)((Object)this));
    }

    @FXML
    private void initialize() {
        this.result.addListener(observable -> {
            ConnectivityTest.ConnectivityTestResult connectivityTestResult = (ConnectivityTest.ConnectivityTestResult)this.result.get();
            if (connectivityTestResult != null) {
                this.statusTextField.setText(connectivityTestResult.getStatus().toString());
                this.messageTextArea.setText(connectivityTestResult.getMessage());
                this.exceptionTextArea.setText(connectivityTestResult.getExceptionString());
                this.exceptionTextArea.setDisable(connectivityTestResult.getException() == null);
            } else {
                this.statusTextField.setText("");
                this.messageTextArea.setText("");
                this.exceptionTextArea.setText("");
            }
        });
    }

    public ConnectivityTest.ConnectivityTestResult getResult() {
        return (ConnectivityTest.ConnectivityTestResult)this.result.get();
    }

    public ObjectProperty<ConnectivityTest.ConnectivityTestResult> resultProperty() {
        return this.result;
    }

    public void setResult(ConnectivityTest.ConnectivityTestResult result) {
        this.result.set((Object)result);
    }
}

