/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.connectivity_tester;

import be.iminds.ilabt.jfed.connectivity_tester.ConnectivityTest;
import be.iminds.ilabt.jfed.connectivity_tester.ConnectivityTestSuite;
import be.iminds.ilabt.jfed.experimenter_gui.connectivity_tester.ConnectivityTestTask;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.util.common.ThreadFactoryUtil;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConnectivityTester {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.systemDefault());
    private static final Logger LOG = LoggerFactory.getLogger(ConnectivityTester.class);
    private final ObservableList<ConnectivityTestTask> testTasks = FXCollections.observableArrayList();
    private final Map<ConnectivityTest, ConnectivityTest.ConnectivityTestResult> testResults = new ConcurrentHashMap<ConnectivityTest, ConnectivityTest.ConnectivityTestResult>();
    private final ObjectProperty<Instant> testsStartDate = new SimpleObjectProperty();
    private final ObjectProperty<Instant> testsEndDate = new SimpleObjectProperty();
    private final BooleanProperty testsActive = new SimpleBooleanProperty(false);
    private final BooleanProperty testsFinished = new SimpleBooleanProperty(false);
    private final GeniUserProvider geniUserProvider;
    private final ConnectivityTestSuite connectivityTestSuite;

    @Inject
    ConnectivityTester(GeniUserProvider geniUserProvider, ConnectivityTestSuite connectivityTestSuite) {
        this.geniUserProvider = geniUserProvider;
        this.connectivityTestSuite = connectivityTestSuite;
    }

    public ObservableList<ConnectivityTestTask> getTestTasks() {
        return this.testTasks;
    }

    public Map<ConnectivityTest, ConnectivityTest.ConnectivityTestResult> getTestResults() {
        return this.testResults;
    }

    public Instant getTestsStartDate() {
        return (Instant)this.testsStartDate.get();
    }

    public ObjectProperty<Instant> testsStartDateProperty() {
        return this.testsStartDate;
    }

    public Instant getTestsEndDate() {
        return (Instant)this.testsEndDate.get();
    }

    public ObjectProperty<Instant> testsEndDateProperty() {
        return this.testsEndDate;
    }

    public boolean getTestsActive() {
        return this.testsActive.get();
    }

    public BooleanProperty testsActiveProperty() {
        return this.testsActive;
    }

    public boolean startTests() {
        if (this.testsActive.get() || this.testsFinished.get()) {
            return false;
        }
        this.testsActive.setValue(Boolean.valueOf(true));
        this.testsStartDate.setValue((Object)Instant.now());
        this.testsEndDate.setValue(null);
        new Thread(() -> {
            ExecutorService es = Executors.newFixedThreadPool(5, ThreadFactoryUtil.getFactory((String)"ConnectivityTester"));
            List tests = this.connectivityTestSuite.getTests();
            ArrayList<ConnectivityTestTask> tasks = new ArrayList<ConnectivityTestTask>();
            for (ConnectivityTest test : tests) {
                if (test.isLoginRequired() && (this.geniUserProvider == null || !this.geniUserProvider.isUserLoggedIn())) continue;
                ConnectivityTestTask ctt = new ConnectivityTestTask(test);
                ctt.setOnSucceeded(event -> {
                    if (ctt.getValue() != null) {
                        this.testResults.put(test, (ConnectivityTest.ConnectivityTestResult)ctt.getValue());
                    } else {
                        LOG.warn("ConnectivityTestTask ctt.getValue() == null for test " + test.getName());
                    }
                });
                tasks.add(ctt);
            }
            Platform.runLater(() -> this.testTasks.addAll((Collection)tasks));
            LOG.info("Starting {} tests", (Object)tasks.size());
            tasks.forEach(es::submit);
            es.submit(() -> {
                LOG.info("Finished {} tests", (Object)tasks.size());
                Platform.runLater(() -> {
                    this.testsEndDate.setValue((Object)Instant.now());
                    this.testsActive.setValue(Boolean.valueOf(false));
                    this.testsFinished.setValue(Boolean.valueOf(true));
                });
            });
            es.shutdown();
        }).start();
        return true;
    }

    public boolean getTestsFinished() {
        return this.testsFinished.get();
    }

    public BooleanProperty testsFinishedProperty() {
        return this.testsFinished;
    }

    public boolean restartTests() {
        if (this.testsActive.get()) {
            return false;
        }
        this.testTasks.clear();
        this.testResults.clear();
        this.testsFinished.set(false);
        this.startTests();
        return true;
    }

    public void saveResultsToFile(File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            writer.write(String.format("========================================%n==  jFed Connectivity Tester Results  ==%n========================================%n%n", new Object[0]));
            writer.write(String.format("Tests started on: %s%n", DATE_TIME_FORMATTER.format(ZonedDateTime.ofInstant((Instant)this.testsStartDate.get(), ZoneId.systemDefault()))));
            writer.write(String.format("Tests ended on: %s%n", DATE_TIME_FORMATTER.format(ZonedDateTime.ofInstant((Instant)this.testsEndDate.get(), ZoneId.systemDefault()))));
            for (Map.Entry<ConnectivityTest, ConnectivityTest.ConnectivityTestResult> entry : this.testResults.entrySet()) {
                writer.write(String.format("%n%s%n%n", Strings.repeat((String)"-", (int)30)));
                writer.write(String.format("Test name: %s%n", entry.getKey().getName()));
                ConnectivityTest.ConnectivityTestResult result = entry.getValue();
                if (result != null) {
                    writer.write(String.format("Status: %s%n", result.getStatus()));
                    if (result.getMessage() != null) {
                        writer.write(String.format("Message: %s%n", result.getMessage()));
                    }
                    if (result.getException() != null) {
                        writer.write(String.format("Exception: %s%n", result.getMessage()));
                    }
                } else {
                    writer.write(String.format("NO RESULT BECAUSE OF INTERNAL FAILURE%n", new Object[0]));
                }
                writer.flush();
            }
            writer.close();
        }
        catch (IOException ex) {
            LOG.error("Error while saving connectivity test", (Throwable)ex);
            throw ex;
        }
        LOG.debug("Saved connectivity test results to {}", (Object)file);
    }
}

