/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.connectivity_tester;

import be.iminds.ilabt.jfed.connectivity_tester.ConnectivityTest;
import be.iminds.ilabt.jfed.experimenter_gui.connectivity_tester.ConnectivityTestPane;
import be.iminds.ilabt.jfed.experimenter_gui.connectivity_tester.ConnectivityTestTask;
import be.iminds.ilabt.jfed.experimenter_gui.connectivity_tester.ConnectivityTester;
import be.iminds.ilabt.jfed.experimenter_gui.ui.status.TaskStatusIndicator;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import java.io.File;
import java.io.IOException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.Pane;
import javafx.stage.FileChooser;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectivityTesterController {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectivityTesterController.class);
    private static final String TESTRESULT_EXTENSION = ".txt";
    private static final DateTimeFormatter FILE_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm").withZone(ZoneId.systemDefault());
    private final ConnectivityTester connectivityTester;
    private final JFedHLPreferences jFedPreferences;
    @FXML
    public ConnectivityTestPane connectivityTestPane;
    @FXML
    private ListView<ConnectivityTestTask> testsList;
    @FXML
    private Pane testsAccordion;
    @FXML
    private Button saveButton;
    @FXML
    private Button restartButton;

    @Inject
    public ConnectivityTesterController(ConnectivityTester connectivityTester, JFedHLPreferences jFedPreferences) {
        this.connectivityTester = connectivityTester;
        this.jFedPreferences = jFedPreferences;
    }

    @FXML
    public void initialize() {
        this.restartButton.disableProperty().bind((ObservableValue)this.connectivityTester.testsFinishedProperty().not());
        this.saveButton.disableProperty().bind((ObservableValue)this.connectivityTester.testsFinishedProperty().not());
        this.testsList.setCellFactory(param -> new ConnectivityTestTaskListCell());
        this.testsList.setItems(this.connectivityTester.getTestTasks());
        this.connectivityTestPane.visibleProperty().bind((ObservableValue)this.testsList.getSelectionModel().selectedItemProperty().isNotNull());
        this.connectivityTestPane.managedProperty().bind((ObservableValue)this.connectivityTestPane.visibleProperty());
        this.connectivityTestPane.resultProperty().bind((ObservableValue)new ObjectBinding<ConnectivityTest.ConnectivityTestResult>(){
            {
                this.bind(new Observable[]{ConnectivityTesterController.this.testsList.getSelectionModel().selectedItemProperty()});
            }

            protected ConnectivityTest.ConnectivityTestResult computeValue() {
                if (ConnectivityTesterController.this.testsList.getSelectionModel().getSelectedItem() != null) {
                    return (ConnectivityTest.ConnectivityTestResult)((ConnectivityTestTask)((Object)ConnectivityTesterController.this.testsList.getSelectionModel().getSelectedItem())).getValue();
                }
                return null;
            }
        });
    }

    @FXML
    private void onRestartAction() {
        this.connectivityTester.restartTests();
    }

    @FXML
    private void onSaveAction() {
        File file;
        File dir;
        FileChooser fc = new FileChooser();
        fc.setTitle("Save Connectivity Test Result");
        fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Text file (*..txt)", new String[]{"*.txt"}));
        fc.setInitialFileName("connectivity-test-" + FILE_DATE_TIME_FORMATTER.format(this.connectivityTester.getTestsStartDate()) + TESTRESULT_EXTENSION);
        if (System.getProperty("user.home") != null) {
            fc.setInitialDirectory(new File(System.getProperty("user.home")));
        }
        if (this.jFedPreferences.containsPreference((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST) && (dir = new File(this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST))).exists()) {
            fc.setInitialDirectory(dir);
        }
        if ((file = fc.showSaveDialog(this.saveButton.getScene().getWindow())) == null) {
            return;
        }
        this.jFedPreferences.setString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST, file.getParentFile().getAbsolutePath());
        if (!file.getAbsolutePath().endsWith(TESTRESULT_EXTENSION)) {
            file = new File(file.getAbsolutePath() + TESTRESULT_EXTENSION);
        }
        try {
            this.connectivityTester.saveResultsToFile(file);
            JFDialogs.create().owner(this.saveButton.getScene().getWindow()).message(String.format("The connectivity test results were saved to '%s'", file.toString())).masthead("Successfully saved connectivity test results").title(null).showInformation();
        }
        catch (IOException e) {
            JFDialogs.create().owner(this.saveButton.getScene().getWindow()).message("An error occurred while saving the connectivity test: " + e.getMessage()).masthead("Saving connectivity test results failed").title("Saving connectivity test results failed").showException((Throwable)e);
        }
    }

    public ConnectivityTester getConnectivityTester() {
        return this.connectivityTester;
    }

    private static class ConnectivityTestTaskListCell
    extends ListCell<ConnectivityTestTask> {
        private final TaskStatusIndicator taskStatusIndicator = new TaskStatusIndicator();

        private ConnectivityTestTaskListCell() {
            this.setAlignment(Pos.CENTER_LEFT);
            this.setContentDisplay(ContentDisplay.LEFT);
        }

        protected void updateItem(final ConnectivityTestTask item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.taskStatusIndicator.statusProperty().unbind();
            if (!empty) {
                ObjectBinding<TaskStatusIndicator.Status> statusBinding = new ObjectBinding<TaskStatusIndicator.Status>(){
                    {
                        this.bind(new Observable[]{item.valueProperty()});
                    }

                    protected TaskStatusIndicator.Status computeValue() {
                        if (item.getValue() == null) {
                            return TaskStatusIndicator.Status.INACTIVE;
                        }
                        if (((ConnectivityTest.ConnectivityTestResult)item.getValue()).getStatus() == null) {
                            return TaskStatusIndicator.Status.FAILED;
                        }
                        switch (((ConnectivityTest.ConnectivityTestResult)item.getValue()).getStatus()) {
                            case SUCCEEDED: {
                                return TaskStatusIndicator.Status.SUCCESS;
                            }
                            case FAILED: {
                                return TaskStatusIndicator.Status.FAILED;
                            }
                            case WARNING: {
                                return TaskStatusIndicator.Status.WARNING;
                            }
                            case SKIPPED: {
                                return TaskStatusIndicator.Status.INACTIVE;
                            }
                        }
                        throw new RuntimeException("Unexpected status: " + String.valueOf(((ConnectivityTest.ConnectivityTestResult)item.getValue()).getStatus()));
                    }
                };
                this.taskStatusIndicator.statusProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)item.runningProperty()).then((Object)TaskStatusIndicator.Status.BUSY).otherwise((ObservableObjectValue)statusBinding));
                this.setGraphic((Node)this.taskStatusIndicator);
                this.setText(item.getTest().getName());
            } else {
                this.setGraphic(null);
                this.setText(null);
            }
        }
    }
}

