/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.debug;

import be.iminds.ilabt.jfed.highlevel.controller.JavaFXTaskThread;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsCache;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.SfaConnectionPool;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import javafx.fxml.FXML;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javax.inject.Inject;

public class DebugGUIController
extends BorderPane {
    private final JavaFXTaskThread javaFXTaskThread;
    private final ApiCallDetailsCache apiCallDetailsCache;
    private final SfaConnectionPool sfaConnectionPool;
    private final SfaModel sfaModel;
    private Stage debugStage;

    @Inject
    public DebugGUIController(JavaFXTaskThread javaFXTaskThread, ApiCallDetailsCache apiCallDetailsCache, SfaConnectionPool sfaConnectionPool, SfaModel sfaModel) {
        this.javaFXTaskThread = javaFXTaskThread;
        this.apiCallDetailsCache = apiCallDetailsCache;
        this.sfaConnectionPool = sfaConnectionPool;
        this.sfaModel = sfaModel;
    }

    @FXML
    private void onClearCallsAction() {
        int callsCount = this.javaFXTaskThread.getCallsCount();
        int oldFxTaskExecutions = this.javaFXTaskThread.getAllTasks().size();
        for (JavaFXTaskThread.FXTaskExecution fxTaskExecution : this.javaFXTaskThread.getAllTasks()) {
            callsCount += fxTaskExecution.getApiCallHistory().size();
        }
        this.apiCallDetailsCache.clear();
        this.javaFXTaskThread.clear();
        int newFxTaskExecutions = this.javaFXTaskThread.getAllTasks().size();
        System.gc();
        JFDialogs.create().owner(this.getScene().getWindow()).message(String.format("Successfully cleared %d calls and %d fxTaskExecutions from cache", callsCount, oldFxTaskExecutions - newFxTaskExecutions)).masthead(null).title(null).showInformation();
    }

    @FXML
    private void onClearConnectionPoolAction() {
        int poolSize = this.sfaConnectionPool.size();
        this.sfaConnectionPool.clear();
        System.gc();
        JFDialogs.create().owner(this.getScene().getWindow()).message(String.format("Successfully cleared %d connections from connection pool", poolSize)).masthead(null).title(null).showInformation();
    }

    @FXML
    private void onClearSfaModelAction() {
        this.sfaModel.clear();
        System.gc();
        JFDialogs.create().owner(this.getScene().getWindow()).message("Successfully cleared SfaModel").masthead(null).title(null).showInformation();
    }
}

