/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.debug;

import be.iminds.ilabt.jfed.experimenter_gui.debug.LogViewAppender;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import java.text.SimpleDateFormat;
import java.util.Collection;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.text.Text;
import javafx.util.Duration;

class LogView
extends ListView<ILoggingEvent> {
    private static final int MAX_ENTRIES = 10000;
    private static final PseudoClass trace = PseudoClass.getPseudoClass((String)"trace");
    private static final PseudoClass debug = PseudoClass.getPseudoClass((String)"debug");
    private static final PseudoClass info = PseudoClass.getPseudoClass((String)"info");
    private static final PseudoClass warn = PseudoClass.getPseudoClass((String)"warn");
    private static final PseudoClass error = PseudoClass.getPseudoClass((String)"error");
    private static final SimpleDateFormat timestampFormatter = new SimpleDateFormat("HH:mm:ss.SSS");
    private final BooleanProperty showTimestamp = new SimpleBooleanProperty(true);
    private final BooleanProperty showLevel = new SimpleBooleanProperty(false);
    private final BooleanProperty showThreadname = new SimpleBooleanProperty(false);
    private final ObjectProperty<Level> filterLevel = new SimpleObjectProperty(null);
    private final StringProperty textFilter = new SimpleStringProperty();
    private final BooleanProperty tail = new SimpleBooleanProperty(false);
    private final BooleanProperty paused = new SimpleBooleanProperty(false);
    private final DoubleProperty refreshRate = new SimpleDoubleProperty(60.0);
    private final ObservableList<ILoggingEvent> logItems = FXCollections.observableArrayList();

    public BooleanProperty showTimeStampProperty() {
        return this.showTimestamp;
    }

    public boolean getShowLevel() {
        return this.showLevel.get();
    }

    public BooleanProperty showLevelProperty() {
        return this.showLevel;
    }

    public boolean getShowThreadname() {
        return this.showThreadname.get();
    }

    public BooleanProperty showThreadnameProperty() {
        return this.showThreadname;
    }

    public boolean getShowTimestamp() {
        return this.showTimestamp.get();
    }

    public BooleanProperty showTimestampProperty() {
        return this.showTimestamp;
    }

    public ObjectProperty<Level> filterLevelProperty() {
        return this.filterLevel;
    }

    public String getTextFilter() {
        return (String)this.textFilter.get();
    }

    public StringProperty textFilterProperty() {
        return this.textFilter;
    }

    public void setTextFilter(String textFilter) {
        this.textFilter.set((Object)textFilter);
    }

    public BooleanProperty tailProperty() {
        return this.tail;
    }

    public BooleanProperty pausedProperty() {
        return this.paused;
    }

    public DoubleProperty refreshRateProperty() {
        return this.refreshRate;
    }

    public LogView(LogViewAppender logViewAppender) {
        this.getStyleClass().add((Object)"log-view");
        Timeline logTransfer = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), event -> {
            logViewAppender.drainTo((Collection<ILoggingEvent>)this.logItems);
            if (this.logItems.size() > 10000) {
                this.logItems.remove(0, this.logItems.size() - 10000);
            }
            if (this.tail.get()) {
                this.scrollTo(this.logItems.size());
            }
        }, new KeyValue[0])});
        logTransfer.setCycleCount(-1);
        logTransfer.rateProperty().bind((ObservableValue)this.refreshRateProperty());
        this.pausedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue() && logTransfer.getStatus() == Animation.Status.RUNNING) {
                logTransfer.pause();
            }
            if (!newValue.booleanValue() && logTransfer.getStatus() == Animation.Status.PAUSED && this.getParent() != null) {
                logTransfer.play();
            }
        });
        this.parentProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == null) {
                logTransfer.pause();
            } else if (!this.paused.get()) {
                logTransfer.play();
            }
        });
        this.filterLevel.addListener(observable -> this.refreshView());
        this.textFilter.addListener(observable -> this.refreshView());
        this.filterLevel.set((Object)Level.DEBUG);
        this.setCellFactory(param -> new ListCell<ILoggingEvent>(){
            final Text text = new Text();
            {
                LogView.this.showTimestamp.addListener(observable -> this.updateItem((ILoggingEvent)this.getItem(), this.isEmpty()));
                this.text.getStyleClass().add((Object)"log-event");
                this.text.wrappingWidthProperty().bind((ObservableValue)this.widthProperty());
                this.setGraphic((Node)this.text);
                this.prefWidthProperty().bind((ObservableValue)LogView.this.widthProperty().subtract(3));
            }

            protected void updateItem(ILoggingEvent item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.text.setText(null);
                    return;
                }
                StringBuilder sb = new StringBuilder();
                if (LogView.this.showTimestamp.get()) {
                    sb.append(timestampFormatter.format(item.getTimeStamp())).append(" ");
                }
                if (LogView.this.showThreadname.get()) {
                    sb.append("[").append(item.getThreadName()).append("] ");
                }
                if (LogView.this.showLevel.get()) {
                    sb.append(item.getLevel().toString()).append("\t ");
                }
                if (item.getLoggerName() != null) {
                    sb.append(item.getLoggerName()).append(" ");
                }
                sb.append(item.getFormattedMessage());
                if (item.getThrowableProxy() != null) {
                    sb.append("\n").append(ThrowableProxyUtil.asString((IThrowableProxy)item.getThrowableProxy()));
                }
                this.text.setText(sb.toString());
                this.text.pseudoClassStateChanged(trace, item.getLevel() == Level.TRACE);
                this.text.pseudoClassStateChanged(debug, item.getLevel() == Level.DEBUG);
                this.text.pseudoClassStateChanged(info, item.getLevel() == Level.INFO);
                this.text.pseudoClassStateChanged(warn, item.getLevel() == Level.WARN);
                this.text.pseudoClassStateChanged(error, item.getLevel() == Level.ERROR);
            }
        });
        this.showTimestamp.addListener(observable -> this.refreshView());
        this.showThreadname.addListener(observable -> this.refreshView());
        this.showLevel.addListener(observable -> this.refreshView());
    }

    private void refreshView() {
        this.setItems(null);
        this.setItems((ObservableList)new FilteredList(this.logItems, loggingEvent -> {
            if (!loggingEvent.getLevel().isGreaterOrEqual((Level)this.filterLevel.get())) {
                return false;
            }
            if (((String)this.textFilter.get()).isEmpty()) {
                return true;
            }
            return loggingEvent.getLoggerName().toLowerCase().contains(((String)this.textFilter.get()).toLowerCase()) || loggingEvent.getFormattedMessage().toLowerCase().contains(((String)this.textFilter.get()).toLowerCase());
        }));
    }
}

