/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.debug;

import be.iminds.ilabt.jfed.experimenter_gui.debug.LogView;
import be.iminds.ilabt.jfed.experimenter_gui.debug.LogViewAppender;
import be.iminds.ilabt.jfed.highlevel.util.ExecuteOnNotNull;
import be.iminds.ilabt.jfed.logging.JFedLoggerManager;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.util.StageUtils;
import ch.qos.logback.classic.Level;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LogViewer {
    private static final Logger LOG = LoggerFactory.getLogger(LogViewer.class);
    private final VBox layout;
    private final LogView logView;
    private final ChoiceBox<Level> filterLevel;
    private final CheckBox showTimestamp;
    private final CheckBox showThreadname;
    private final CheckBox showLevel;
    private final TextField filterTextField;
    private final ToggleButton tail;
    private final ToggleButton pause;
    private final HBox controls;
    private Stage stage;

    @Inject
    public LogViewer(JFedLoggerManager jFedLoggerManager) {
        LogViewAppender logViewAppender = new LogViewAppender(jFedLoggerManager.getBugReportMemoryAppender().getListCopy());
        LogViewer.registerLogViewAppender(logViewAppender);
        this.logView = new LogView(logViewAppender);
        this.logView.setPrefWidth(400.0);
        this.showTimestamp = new CheckBox("Show Timestamp");
        this.logView.showTimeStampProperty().bind((ObservableValue)this.showTimestamp.selectedProperty());
        this.showThreadname = new CheckBox("Show Threadname");
        this.logView.showThreadnameProperty().bind((ObservableValue)this.showThreadname.selectedProperty());
        this.showLevel = new CheckBox("Show Level");
        this.logView.showLevelProperty().bind((ObservableValue)this.showLevel.selectedProperty());
        Pane filler = new Pane();
        HBox.setHgrow((Node)filler, (Priority)Priority.ALWAYS);
        this.tail = new ToggleButton("Tail");
        this.tail.setGraphic((Node)GlyphUtils.createSmallGlyph((FontAwesome.Glyph)FontAwesome.Glyph.ANGLE_DOUBLE_DOWN));
        this.logView.tailProperty().bind((ObservableValue)this.tail.selectedProperty());
        this.pause = new ToggleButton("Pause");
        this.pause.setGraphic((Node)GlyphUtils.createSmallGlyph((FontAwesome.Glyph)FontAwesome.Glyph.PAUSE, (Color)Color.ORANGE));
        this.logView.pausedProperty().bind((ObservableValue)this.pause.selectedProperty());
        this.controls = new HBox(10.0, new Node[]{this.showTimestamp, this.showThreadname, this.showLevel, filler, this.tail, this.pause});
        this.controls.setMinHeight(Double.NEGATIVE_INFINITY);
        this.filterLevel = new ChoiceBox();
        this.filterLevel.getItems().addAll((Object[])new Level[]{Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE, Level.ALL});
        this.filterLevel.getSelectionModel().select((Object)Level.DEBUG);
        this.logView.filterLevelProperty().bind((ObservableValue)this.filterLevel.getSelectionModel().selectedItemProperty());
        this.filterTextField = new TextField();
        this.logView.textFilterProperty().bind((ObservableValue)this.filterTextField.textProperty());
        HBox filters = new HBox(10.0, new Node[]{new Label("Level:"), this.filterLevel, new Label("Filter: "), this.filterTextField});
        this.layout = new VBox(10.0, new Node[]{this.controls, this.logView, filters});
        VBox.setVgrow((Node)this.logView, (Priority)Priority.ALWAYS);
        new ExecuteOnNotNull<Scene>(this.logView.sceneProperty()){

            public void run() {
                LogViewer.this.logView.prefWidthProperty().bind((ObservableValue)LogViewer.this.logView.getScene().widthProperty().subtract(5));
            }
        };
    }

    public void show() {
        if (this.stage == null) {
            LOG.debug("Creating a new stage for LogViewer");
            Scene scene = new Scene((Parent)this.layout);
            scene.getStylesheets().add((Object)LogViewer.class.getResource("log-view.css").toExternalForm());
            scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.L, new KeyCombination.Modifier[]{KeyCodeCombination.CONTROL_DOWN}), () -> this.filterLevel.requestFocus());
            scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.F, new KeyCombination.Modifier[]{KeyCodeCombination.CONTROL_DOWN}), () -> ((TextField)this.filterTextField).requestFocus());
            scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCodeCombination.CONTROL_DOWN}), () -> ((ToggleButton)this.pause).fire());
            scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.T, new KeyCombination.Modifier[]{KeyCodeCombination.CONTROL_DOWN}), () -> ((ToggleButton)this.tail).fire());
            scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.F5, new KeyCombination.Modifier[0]), () -> ((CheckBox)this.showTimestamp).fire());
            scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.F6, new KeyCombination.Modifier[0]), () -> ((CheckBox)this.showThreadname).fire());
            scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.F7, new KeyCombination.Modifier[0]), () -> ((CheckBox)this.showLevel).fire());
            this.stage = new Stage();
            this.stage.setTitle("jFed Log Viewer");
            StageUtils.setJFedStageIcons((Stage)this.stage);
            this.stage.setWidth(800.0);
            this.stage.setHeight(600.0);
            this.stage.setScene(scene);
        }
        LOG.debug("Showing the new stage");
        this.stage.show();
    }

    private static void registerLogViewAppender(LogViewAppender logViewAppender) {
        Logger rootLogger = LoggerFactory.getLogger((String)"ROOT");
        if (!(rootLogger instanceof ch.qos.logback.classic.Logger)) {
            LOG.error("rootLogger is not instance of ch.qos.logback.classic.Logger but of " + rootLogger.getClass().getName());
            System.out.println("NOTE: logging cannot be modified by jFed: rootLogger is not instance of ch.qos.logback.classic.Logger but of " + rootLogger.getClass().getName());
            return;
        }
        ch.qos.logback.classic.Logger logbackRootLogger = (ch.qos.logback.classic.Logger)rootLogger;
        logViewAppender.setContext((Context)logbackRootLogger.getLoggerContext());
        logbackRootLogger.addAppender((Appender)logViewAppender);
        logViewAppender.start();
        LOG.debug("Registered logViewAppender on the rootLogger");
    }
}

