/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.dialogs;

import be.iminds.ilabt.jfed.experiment.util.ExperimentRestoreInformation;
import be.iminds.ilabt.jfed.experimenter_gui.events.StartExperimentEvent;
import be.iminds.ilabt.jfed.experimenter_gui.reservations.StartEndDurationPane;
import be.iminds.ilabt.jfed.experimenter_gui.util.BrowserUtil;
import be.iminds.ilabt.jfed.experimenter_gui.util.ui.UIUtils;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.ListSubAuthoritiesTask;
import be.iminds.ilabt.jfed.highlevel.tasks.UserAuthorityGetVersionTask;
import be.iminds.ilabt.jfed.highlevel.util.ExecuteOnNotNull;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import com.google.common.eventbus.EventBus;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.controlsfx.control.textfield.TextFields;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.validation.ValidationMessage;
import org.controlsfx.validation.ValidationResult;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import org.controlsfx.validation.decoration.GraphicValidationDecoration;
import org.controlsfx.validation.decoration.ValidationDecoration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateReservationDialog
extends GridPane {
    private static final Logger LOG = LoggerFactory.getLogger(CreateReservationDialog.class);
    private static final Duration MINIMUM_SLICE_DURATION = Duration.ofMinutes(1L);
    @Nonnull
    private final RequestRspecSource requestRspecSource;
    @Nonnull
    private final HighLevelTaskFactory hltf;
    @Nonnull
    private final UserAuthorityGetVersionTask getVersionTask;
    @Nonnull
    private final Map<String, Slice> slices = new HashMap<String, Slice>();
    @Nonnull
    private final GeniUserProvider geniUserProvider;
    @Nonnull
    private final SfaModel sfaModel;
    @Nonnull
    private final EventBus eventBus;
    @Nonnull
    private final BrowserUtil browserUtil;
    @Nonnull
    private final AuthorityFinder authorityFinder;
    @FXML
    protected TextField nameTextField;
    @FXML
    protected Label subAuthLabel;
    @FXML
    protected CheckBox subAuthCheckBox;
    @FXML
    protected ProgressBar subAuthFetchProgressBar;
    @FXML
    protected ComboBox<String> subAuthComboBox;
    @FXML
    protected Button refreshSubAuthButton;
    @FXML
    protected StartEndDurationPane startEndDurationPane;
    @FXML
    protected Button showCalendarButton;
    private final Dialog dialog;
    private final ValidationSupport validationSupport;
    private final Validator<String> sliceNameValidator = (control, sliceName) -> {
        ValidationResult result = new ValidationResult();
        if (sliceName == null) {
            result.add(ValidationMessage.error((Control)control, (String)"Experiment name cannot be empty!"));
            return result;
        }
        if (sliceName.length() == 0) {
            result.add(ValidationMessage.error((Control)control, (String)"Experiment name cannot be empty!"));
        } else if (sliceName.length() > this.getMaximumSliceNameLength()) {
            result.add(ValidationMessage.error((Control)control, (String)String.format("Experiment name cannot be longer than %d characters", this.getMaximumSliceNameLength())));
        }
        for (char c : sliceName.toCharArray()) {
            boolean validChar;
            boolean bl = validChar = c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
            if (validChar) continue;
            result.add(ValidationMessage.error((Control)control, (String)String.format("Experiment name may not contain the character '%c'. Only characters [a-zA-Z0-9] are allowed", Character.valueOf(c))));
        }
        return result;
    };

    public CreateReservationDialog(@Nullable Window parentWindow, @Nonnull RequestRspecSource requestRspecSource, @Nonnull HighLevelTaskFactory hltf, @Nonnull GeniUserProvider geniUserProvider, @Nonnull SfaModel sfaModel, @Nonnull EventBus eventBus, @Nonnull BrowserUtil browserUtil, @Nonnull AuthorityFinder authorityFinder) {
        this.requestRspecSource = requestRspecSource;
        this.hltf = hltf;
        this.geniUserProvider = geniUserProvider;
        this.sfaModel = sfaModel;
        this.eventBus = eventBus;
        this.browserUtil = browserUtil;
        this.authorityFinder = authorityFinder;
        FXMLUtil.injectFXML((Object)((Object)this));
        this.validationSupport = new ValidationSupport();
        this.validationSupport.registerValidator((Control)this.nameTextField, false, this.sliceNameValidator);
        this.validationSupport.registerValidator(this.subAuthComboBox, Validator.createPredicateValidator(s -> !this.subAuthCheckBox.isSelected() || !this.subAuthComboBox.getSelectionModel().isEmpty(), (String)"Please choose a project in which this experiment should be run!"));
        TextFields.bindAutoCompletion((TextField)this.nameTextField, this.getActiveSliceNames());
        this.validationSupport.registerValidator((Control)this.startEndDurationPane.getEndTimeTextField(), false, (control, o) -> {
            ValidationResult validationResult = new ValidationResult();
            validationResult.addErrorIf((Control)this.startEndDurationPane.getEndTimeTextField(), "Reservation end time must come after start time!", this.startEndDurationPane.getEndDateTime().isBefore(this.startEndDurationPane.getStartDateTime()));
            return validationResult;
        });
        this.validationSupport.registerValidator((Control)this.startEndDurationPane.getEndDatePicker(), false, (control, o) -> {
            ValidationResult validationResult = new ValidationResult();
            validationResult.addErrorIf((Control)this.startEndDurationPane.getEndDatePicker(), "Reservation end time must be in the future!", this.startEndDurationPane.getEndDateTime().isBefore(LocalDateTime.now()));
            return validationResult;
        });
        this.validationSupport.setValidationDecorator((ValidationDecoration)new GraphicValidationDecoration());
        this.subAuthCheckBox.selectedProperty().addListener(observable -> {
            if (this.subAuthCheckBox.isSelected()) {
                this.enableSubAuthoritiesList();
            } else {
                this.disableSubAuthoritiesList();
            }
        });
        this.initializeSubAuthorities();
        InvalidationListener sliceNameInvalidationListener = observable -> {
            String sliceName = this.nameTextField.getText();
            if (this.slices.containsKey(sliceName)) {
                this.showFixedSliceDetails(this.slices.get(sliceName));
            } else {
                this.enableSliceDetailsEditing();
            }
        };
        this.nameTextField.textProperty().addListener(sliceNameInvalidationListener);
        this.dialog = new Dialog();
        this.dialog.initOwner(parentWindow);
        this.dialog.setTitle("Create an experiment reservation");
        this.dialog.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.CALENDAR, (Color)Color.ORANGERED));
        this.dialog.setHeaderText("Enter experiment reservation details");
        this.dialog.getDialogPane().setContent((Node)UIUtils.wrapWithDecorationPane((Node)this));
        ButtonType startExperimentButtonType = new ButtonType("Create Reservation", ButtonBar.ButtonData.OK_DONE);
        this.dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{startExperimentButtonType, ButtonType.CANCEL});
        Button startButton = (Button)this.dialog.getDialogPane().lookupButton(startExperimentButtonType);
        startButton.disableProperty().bind((ObservableValue)this.validationSupport.invalidProperty());
        startButton.addEventFilter(ActionEvent.ACTION, event -> {
            this.checkAndStartExperiment();
            event.consume();
        });
        this.nameTextField.setOnAction(ae -> this.checkAndStartExperiment());
        this.getVersionTask = this.hltf.getUserAuthorityGetVersionTask();
        if (!this.getVersionTask.isKnown()) {
            LOG.debug("CreateSliceDialog: getVersion not known. Requesting.");
            this.hltf.submitTask((Task)this.getVersionTask);
        }
        List cmUrns = requestRspecSource.getAllComponentManagerUrns();
        ArrayList<URL> reservationPages = new ArrayList<URL>();
        for (GeniUrn cmUrn : cmUrns) {
            Server auth = this.authorityFinder.findByUrn(cmUrn, AuthorityFinder.Purpose.CREATE_SLIVER);
            URL reservationPage = ApiInfo.findUrl((Server)auth, (ApiInfo.ApiName)ApiInfo.ApiName.FED4FIRE_RESERVATION_CALENDER_PAGE, (int)1);
            if (reservationPage == null) continue;
            reservationPages.add(reservationPage);
        }
        this.showCalendarButton.setDisable(reservationPages.isEmpty());
        this.showCalendarButton.setOnAction(event -> reservationPages.forEach(page -> this.browserUtil.openUrlInBrowser((URL)page)));
        new ExecuteOnNotNull<Scene>(this.sceneProperty()){

            public void run() {
                CreateReservationDialog.this.nameTextField.requestFocus();
            }
        };
    }

    private ObservableList<String> getActiveSliceNames() {
        ObservableList sliceNames = FXCollections.observableArrayList();
        for (Slice slice : this.sfaModel.getSlices()) {
            LOG.debug("CreateSliceDialog slice list checks " + slice.getUrnString() + " exp=" + String.valueOf(slice.getExpirationDate()));
            if (slice.getExpirationDate() == null || Duration.between(Instant.now(), slice.getExpirationDate()).compareTo(MINIMUM_SLICE_DURATION) > 0) {
                sliceNames.add((Object)slice.getName());
                this.slices.put(slice.getName(), slice);
                continue;
            }
            LOG.debug("CreateSliceDialog skips slice " + slice.getUrnString() + " because duration is less than " + String.valueOf(MINIMUM_SLICE_DURATION) + "   (duration=" + String.valueOf(Duration.between(Instant.now(), slice.getExpirationDate())) + ")");
        }
        return sliceNames;
    }

    private void showFixedSliceDetails(Slice slice) {
        if (slice.getSubAuthorityName() != null) {
            this.subAuthCheckBox.setSelected(true);
            this.subAuthComboBox.setValue((Object)slice.getSubAuthorityName());
        } else {
            this.subAuthCheckBox.setSelected(false);
            this.subAuthComboBox.setValue(null);
        }
        this.subAuthCheckBox.setDisable(true);
        this.subAuthComboBox.setDisable(true);
    }

    private void enableSliceDetailsEditing() {
        this.subAuthCheckBox.setDisable(false);
        this.subAuthComboBox.setDisable(false);
    }

    private int getMaximumSliceNameLength() {
        if (this.requestRspecSource.isXmlBased()) {
            return 8;
        }
        FXModelRspec fxModelRspec = (FXModelRspec)this.requestRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        int nodeNameAndTestBedAuthorityLength = fxModelRspec == null ? 15 : fxModelRspec.getNodes().stream().mapToInt(rspecNode -> {
            int totalLength = 0;
            if (rspecNode.getClientId() != null) {
                totalLength += rspecNode.getClientId().length();
            }
            if (rspecNode.getComponentManagerId() != null) {
                totalLength += rspecNode.getComponentManagerId().getEncodedTopLevelAuthority().length();
            }
            return totalLength;
        }).max().orElse(15);
        int maxLength = 60;
        maxLength -= nodeNameAndTestBedAuthorityLength;
        Server userAuthServer = this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer();
        maxLength = userAuthServer != null ? (maxLength -= userAuthServer.getDefaultComponentManagerAsGeniUrn().getEncodedTopLevelAuthority().length()) : (maxLength -= 15);
        return maxLength;
    }

    private void initializeSubAuthorities() {
        if (this.sfaModel.getSubAuthoritySupport() == UserAndSliceApiWrapper.SubAuthoritySupport.SUB_AUTHORITY_FORBIDDEN) {
            this.subAuthCheckBox.setSelected(false);
            this.subAuthCheckBox.setDisable(true);
            this.subAuthFetchProgressBar.setVisible(false);
            this.subAuthComboBox.setDisable(true);
            this.subAuthComboBox.setItems(FXCollections.observableArrayList((Object[])new String[]{"Not supported"}));
            this.refreshSubAuthButton.setDisable(true);
        } else {
            this.subAuthCheckBox.setSelected(true);
            if (this.sfaModel.getSubAuthoritySupport() == UserAndSliceApiWrapper.SubAuthoritySupport.SUB_AUTHORITY_MANDATORY) {
                this.subAuthCheckBox.setDisable(true);
            } else {
                this.subAuthCheckBox.setDisable(false);
            }
            this.enableSubAuthoritiesList();
        }
    }

    private void showSubAuthoritiesList() {
        if (!this.subAuthCheckBox.isSelected()) {
            LOG.warn("unexpected: showSubAuthoritiesList() called while subAuthCheckBox.isSelected()=" + !this.subAuthCheckBox.isSelected());
            return;
        }
        ArrayList subAuthNames = new ArrayList(this.sfaModel.getLoggedInUserSubAuthorityNames());
        Collections.sort(subAuthNames);
        this.subAuthComboBox.setItems(FXCollections.observableList(subAuthNames));
        this.subAuthComboBox.setDisable(false);
        if (!this.subAuthComboBox.getItems().isEmpty()) {
            this.subAuthComboBox.getSelectionModel().selectFirst();
        }
        if (this.subAuthComboBox.getItems().isEmpty() && this.sfaModel.getSubAuthoritySupport() == UserAndSliceApiWrapper.SubAuthoritySupport.SUB_AUTHORITY_MANDATORY) {
            JFDialogs.create().owner(this.subAuthComboBox).message("Selecting a project is mandatory for your experiment, but jFed did not receive any candidates. Please contact your support team.").masthead("No projects available").showError();
        }
        this.subAuthFetchProgressBar.setVisible(false);
        this.refreshSubAuthButton.setDisable(false);
    }

    private void disableSubAuthoritiesList() {
        this.subAuthLabel.setDisable(true);
        this.subAuthComboBox.getSelectionModel().clearSelection();
        this.subAuthComboBox.getItems().clear();
        this.subAuthComboBox.setDisable(true);
        this.subAuthFetchProgressBar.setVisible(false);
        this.refreshSubAuthButton.setDisable(true);
    }

    private void enableSubAuthoritiesList() {
        this.subAuthLabel.setDisable(false);
        if (this.shouldRefreshSubAuthorities()) {
            this.refreshSubAuthoritiesList();
        } else {
            this.showSubAuthoritiesList();
        }
    }

    private boolean shouldRefreshSubAuthorities() {
        ListSubAuthoritiesTask listSubAuthoritiesTask = this.hltf.listSubAuthorities();
        return listSubAuthoritiesTask.newExecutionNeeded();
    }

    @FXML
    private void refreshSubAuthoritiesList() {
        this.subAuthComboBox.setItems(FXCollections.emptyObservableList());
        this.subAuthComboBox.setDisable(true);
        this.subAuthFetchProgressBar.setVisible(true);
        this.refreshSubAuthButton.setDisable(true);
        ListSubAuthoritiesTask listSubAuthoritiesTask = this.hltf.listSubAuthorities();
        listSubAuthoritiesTask.addCallback((task, taskExecution, state) -> Platform.runLater(this::showSubAuthoritiesList));
        this.hltf.submitTask((Task)listSubAuthoritiesTask);
    }

    public void showDialog() {
        this.dialog.show();
    }

    private void createReservation() {
        this.dialog.hide();
        String sliceName = this.nameTextField.getText();
        String subAuthName = this.subAuthCheckBox.isSelected() ? (String)this.subAuthComboBox.getValue() : null;
        Instant startInstant = ZonedDateTime.of(this.startEndDurationPane.getStartDateTime(), ZoneId.systemDefault()).toInstant();
        Instant endInstant = ZonedDateTime.of(this.startEndDurationPane.getEndDateTime(), ZoneId.systemDefault()).toInstant();
        this.eventBus.post((Object)new StartExperimentEvent(sliceName, subAuthName, startInstant, endInstant, this.requestRspecSource, false, false, false));
    }

    public void checkAndStartExperiment() {
        if (this.validationSupport.isInvalid().booleanValue()) {
            LOG.warn("Cannot start because validationSupport is currently invalid");
            return;
        }
        LOG.info("Trying to make a reservation with sliceName '{}' from {} until {}", new Object[]{this.nameTextField.getText(), this.startEndDurationPane.getStartDateTime(), this.startEndDurationPane.getEndDateTime()});
        String sliceName = this.nameTextField.getText();
        if (this.slices.containsKey(sliceName)) {
            ExperimentRestoreInformation sri;
            Slice slice = this.slices.get(sliceName);
            while (!this.getVersionTask.isKnown()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.getVersionTask.isSupportSliverRegistration() && ExperimentRestoreInformation.exists((GeniUrn)slice.getUrn()) && (sri = new ExperimentRestoreInformation(slice.getUrn())).getExpirationTime() != null && sri.getExpirationTime().isAfter(Instant.now()) && JFDialogs.create().message(String.format("There currently exists a recovery file for slice %s. By re-using this slice, this backup will be overwritten. Are you sure you want to continue?", sliceName)).masthead("Slice Recovery Data").title("Slice Recovery Data").buttonTypes(new ButtonType[]{ButtonType.YES, ButtonType.NO}).showConfirm().filter(r -> r != ButtonType.YES).isPresent()) {
                return;
            }
        }
        this.createReservation();
    }
}

