/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.dialogs;

import be.iminds.ilabt.jfed.espec.bundle.ESpecBundle;
import be.iminds.ilabt.jfed.espec.filefetcher.FileFetcher;
import be.iminds.ilabt.jfed.espec.model.ExperimentSpecification;
import be.iminds.ilabt.jfed.espec.model.RspecSpec;
import be.iminds.ilabt.jfed.experiment.CapabilityChecker;
import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experimenter_gui.TriggeredMessageHandler;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.CreateReservationDialog;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.DialogsFactory;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.EditSshKeysDialog;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.LinkTestDialog;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.RebootDialog;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.RenewSliceDialog;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.ShareSliceDialog;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.StartExperimentDialog;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.TerminateSliceDialog;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.UnshareSliceDialog;
import be.iminds.ilabt.jfed.experimenter_gui.renew_report.RenewReportDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ExperimentViewControllerFactory;
import be.iminds.ilabt.jfed.experimenter_gui.util.BrowserUtil;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TriggeredMessage;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.highlevel.jobs.TestLinksJob;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticAggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.rspec.generator.RSpecGeneratorFactory;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.rspec_source.ImmutableRequestRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.ui.javafx.GuiceFXMLUtil;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import com.google.common.eventbus.EventBus;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DialogsFactoryImpl
implements DialogsFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DialogsFactoryImpl.class);
    private final GuiceFXMLUtil guiceFXMLUtil;
    private final EventBus eventBus;
    private final GeniUserProvider geniUserProvider;
    private final SfaModel sfaModel;
    private final HighLevelTaskFactory hltf;
    private final ExperimentViewControllerFactory experimentViewControllerFactory;
    private final JFedHLPreferences jFedPreferences;
    private final AutomaticAggregateManagerWrapper.AutomaticAggregateManagerWrapperFactory automaticAggregateManagerWrapperFactory;
    private final AuthorityFinder authorityFinder;
    private final BrowserUtil browserUtil;
    private final Provider<CapabilityChecker> capabilityCheckerProvider;
    private final TriggeredMessageHandler triggeredMessageHandler;
    private final RSpecGeneratorFactory rSpecGeneratorFactory;
    private final RenewReportDialogFactory renewReportDialogFactory;

    @Inject
    public DialogsFactoryImpl(GuiceFXMLUtil guiceFXMLUtil, EventBus eventBus, GeniUserProvider geniUserProvider, SfaModel sfaModel, HighLevelTaskFactory hltf, ExperimentViewControllerFactory experimentViewControllerFactory, JFedHLPreferences jFedPreferences, AutomaticAggregateManagerWrapper.AutomaticAggregateManagerWrapperFactory automaticAggregateManagerWrapperFactory, AuthorityFinder authorityFinder, BrowserUtil browserUtil, Provider<CapabilityChecker> capabilityCheckerProvider, TriggeredMessageHandler triggeredMessageHandler, RSpecGeneratorFactory rSpecGeneratorFactory, RenewReportDialogFactory renewReportDialogFactory) {
        this.guiceFXMLUtil = guiceFXMLUtil;
        this.eventBus = eventBus;
        this.geniUserProvider = geniUserProvider;
        this.sfaModel = sfaModel;
        this.hltf = hltf;
        this.experimentViewControllerFactory = experimentViewControllerFactory;
        this.jFedPreferences = jFedPreferences;
        this.automaticAggregateManagerWrapperFactory = automaticAggregateManagerWrapperFactory;
        this.authorityFinder = authorityFinder;
        this.browserUtil = browserUtil;
        this.capabilityCheckerProvider = capabilityCheckerProvider;
        this.triggeredMessageHandler = triggeredMessageHandler;
        this.rSpecGeneratorFactory = rSpecGeneratorFactory;
        this.renewReportDialogFactory = renewReportDialogFactory;
    }

    @Override
    public void showCreateSliceDialog(@Nullable Window parentWindow, @Nonnull ESpecBundle eSpecBundle) {
        ExperimentSpecification eSpec = eSpecBundle.getExperimentSpecification();
        String requestRspec = null;
        try {
            requestRspec = new String(new FileFetcher(((RspecSpec)eSpec.getRspecs().get(0)).getSource(), eSpecBundle, this.rSpecGeneratorFactory, this.jFedPreferences.getGitAuthPreferences(this.geniUserProvider.getLoggedInGeniUser())).fetchBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOG.error("Failed to load RSpec " + String.valueOf(((RspecSpec)eSpec.getRspecs().get(0)).getSource()) + " in ExperimentSpecification (bundle=" + String.valueOf(eSpecBundle) + ")", (Throwable)e);
            new Alert(Alert.AlertType.ERROR, "Failed to load RSpec in ExperimentSpecification. Will abort.", new ButtonType[0]).show();
            return;
        }
        ImmutableRequestRspecSource requestRspecSource = new ImmutableRequestRspecSource(requestRspec, ModelRspecType.BASIC);
        this.triggerShowCreateSliceDialogMessages((RequestRspecSource)requestRspecSource);
        new StartExperimentDialog(this.guiceFXMLUtil, parentWindow, (RequestRspecSource)requestRspecSource, eSpecBundle, this.authorityFinder, this.geniUserProvider, this.eventBus).show();
    }

    @Override
    public void showCreateSliceDialog(@Nullable Window parentWindow, @Nonnull RequestRspecSource requestRspecSource) {
        this.triggerShowCreateSliceDialogMessages(requestRspecSource);
        new StartExperimentDialog(this.guiceFXMLUtil, parentWindow, requestRspecSource, null, this.authorityFinder, this.geniUserProvider, this.eventBus).show();
    }

    private void triggerShowCreateSliceDialogMessages(@Nonnull RequestRspecSource requestRspecSource) {
        try {
            HashSet<Server> involvedServers = new HashSet<Server>();
            List compManUrns = requestRspecSource.getAllComponentManagerUrns();
            for (GeniUrn geniUrn : compManUrns) {
                Server server = this.authorityFinder.findByAnyUrn(geniUrn, AuthorityFinder.Purpose.STATUS);
                if (server == null) continue;
                involvedServers.add(server);
            }
            this.triggeredMessageHandler.onEvent(TriggeredMessage.GuiTrigger.RUN_EXPERIMENT, new ArrayList<Server>(involvedServers));
        }
        catch (Exception e) {
            LOG.warn("Exception processing TriggeredMessage (will be ignored)", (Throwable)e);
        }
    }

    @Override
    public void showRebootDialog(@Nullable Window parentWindow, @Nonnull ExperimentController experimentController) {
        new RebootDialog(parentWindow, experimentController, this.automaticAggregateManagerWrapperFactory).showDialog();
    }

    @Override
    public void showEditSshKeysDialog(@Nullable Window parentWindow, @Nonnull ExperimentController experimentController) {
        new EditSshKeysDialog(parentWindow, experimentController, this.geniUserProvider, this.sfaModel, this.jFedPreferences, (CapabilityChecker)this.capabilityCheckerProvider.get()).showDialog();
    }

    @Override
    public void showShareSliceDialog(@Nullable Window parentWindow, @Nonnull ExperimentController experimentController) {
        new ShareSliceDialog(parentWindow, experimentController, this.geniUserProvider, this.sfaModel, this.hltf).showDialog();
    }

    @Override
    public void showUnshareSliceDialog(@Nullable Window parentWindow, @Nonnull ExperimentController experimentController) {
        new UnshareSliceDialog(parentWindow, experimentController, this.geniUserProvider, this.sfaModel, this.hltf).showDialog();
    }

    @Override
    public void showCreateReservationDialog(@Nullable Window parentWindow, @Nonnull RequestRspecSource requestRspecSource) {
        new CreateReservationDialog(parentWindow, requestRspecSource, this.hltf, this.geniUserProvider, this.sfaModel, this.eventBus, this.browserUtil, this.authorityFinder).showDialog();
    }

    @Override
    public void showRenewSliceDialog(@Nullable Window parentWindow, @Nonnull ExperimentController experimentController) {
        new RenewSliceDialog(parentWindow, experimentController, this.authorityFinder, this.renewReportDialogFactory, this.sfaModel).showDialog();
    }

    @Override
    public void showTerminateSliceDialog(@Nullable Window parentWindow, @Nonnull ExperimentController experimentController) {
        new TerminateSliceDialog(parentWindow, experimentController).showDialog();
    }

    @Override
    public void showLinkTestDialog(@Nullable Window parentWindow, @Nonnull List<TestLinksJob.LinkTestReport> reports) {
        new LinkTestDialog(parentWindow, reports).showDialog();
    }
}

