/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.dialogs;

import be.iminds.ilabt.jfed.experiment.CapabilityChecker;
import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.UserSpecHelper;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.PuTTYFilesKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.parser.extensions.UserSpecParser;
import be.iminds.ilabt.jfed.rspec.parser.extensions.UserSpecWriter;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.common.Pair;
import be.iminds.ilabt.jfed.util.library.PublicKeyConvertor;
import com.google.common.base.Joiner;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextArea;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditSshKeysDialog
extends VBox {
    private static final Logger LOG = LoggerFactory.getLogger(EditSshKeysDialog.class);
    @Nullable
    private final Window parentWindow;
    @Nonnull
    private final Slice slice;
    @Nonnull
    private final ExperimentController experimentController;
    private final boolean hasSupportingAuthorities;
    @Nonnull
    private final GeniUserProvider geniUserProvider;
    @Nonnull
    private final SfaModel sfaModel;
    @Nonnull
    private final JFedHLPreferences jFedPreferences;
    @Nonnull
    private final CapabilityChecker capabilityChecker;
    @FXML
    private TextArea xmlUsersField;
    @FXML
    private Label informationLabel;
    @FXML
    private Button fetchSshKeysButton;
    @FXML
    private ProgressBar fetchSshKeysProgressBar;
    private final Dialog<ButtonType> dialog;

    public static Pair<Boolean, List<String>> findUnsupportedAuthorityNames(@Nonnull ExperimentController experimentController, @Nonnull CapabilityChecker capabilityChecker) {
        ArrayList<String> unsupportedAuthorityNames = new ArrayList<String>();
        boolean supported = false;
        for (ExperimentPart experimentPart : experimentController.getExperiment().getPartsListCopy()) {
            if (capabilityChecker.supportsEditSSHKeys(experimentPart)) {
                supported = true;
                continue;
            }
            boolean showInHelpMessage = true;
            if (experimentPart instanceof SfaExperimentPart && ((SfaExperimentPart)experimentPart).getConnectSfaAuthority().isEdgeVlan()) {
                showInHelpMessage = false;
            }
            if (!showInHelpMessage) continue;
            unsupportedAuthorityNames.add(experimentPart.getName());
        }
        return new Pair((Object)supported, unsupportedAuthorityNames);
    }

    EditSshKeysDialog(@Nullable Window parentWindow, @Nonnull ExperimentController experimentController, @Nonnull GeniUserProvider geniUserProvider, @Nonnull SfaModel sfaModel, @Nonnull JFedHLPreferences jFedPreferences, @Nonnull CapabilityChecker capabilityChecker) {
        boolean supported;
        this.parentWindow = parentWindow;
        this.experimentController = experimentController;
        this.geniUserProvider = geniUserProvider;
        this.sfaModel = sfaModel;
        this.jFedPreferences = jFedPreferences;
        this.capabilityChecker = capabilityChecker;
        Experiment experiment = this.experimentController.getExperiment();
        if (experiment.getSliceOrNull() == null) {
            throw new IllegalArgumentException("Can't create RenewSliceDialog if there experiment has slice == null");
        }
        this.slice = experiment.getSliceOrNull();
        FXMLUtil.injectFXML((Object)((Object)this));
        EditSshKeysDialog.setVgrow((Node)this.xmlUsersField, (Priority)Priority.ALWAYS);
        this.dialog = new Dialog();
        this.dialog.initOwner(parentWindow);
        this.dialog.setTitle("Edit SSH-keys");
        this.dialog.setHeaderText("Edit SSH-keys");
        this.dialog.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.GROUP, (Color)Color.BLUE));
        this.dialog.getDialogPane().setContent((Node)this);
        ButtonType editSSHKeysButtonType = new ButtonType("Edit SSH Keys", ButtonBar.ButtonData.OK_DONE);
        this.dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{editSSHKeysButtonType, ButtonType.CANCEL});
        Node editSSHKeysButton = this.dialog.getDialogPane().lookupButton(editSSHKeysButtonType);
        editSSHKeysButton.addEventFilter(ActionEvent.ACTION, event -> {
            if (!this.isValidInput()) {
                event.consume();
            }
        });
        this.dialog.resultProperty().addListener(observable -> {
            if (this.dialog.getResult() == editSSHKeysButtonType) {
                this.onEditSshKeysAction();
            }
        });
        Pair<Boolean, List<String>> help = EditSshKeysDialog.findUnsupportedAuthorityNames(experimentController, capabilityChecker);
        List unsupportedAuthorityNames = (List)help.getValue();
        this.hasSupportingAuthorities = supported = ((Boolean)help.getKey()).booleanValue();
        if (!unsupportedAuthorityNames.isEmpty()) {
            this.informationLabel.setText(this.informationLabel.getText() + "\n- " + Joiner.on((String)", ").join((Iterable)unsupportedAuthorityNames) + (unsupportedAuthorityNames.size() == 1 ? " does" : " do") + " not support editing SSH-keys");
        }
        String initialXml = this.constructInitialSshKeysXml();
        this.xmlUsersField.setText(initialXml);
        this.fetchSshKeysButton.managedProperty().bind((ObservableValue)this.fetchSshKeysButton.visibleProperty());
        Server userAuthority = this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer();
        boolean canRequestProjectMemberSshKeys = userAuthority == null ? false : userAuthority.hasFlag(Server.Flag.featureFedMaRequestMemberSshKey);
        this.fetchSshKeysButton.setVisible(canRequestProjectMemberSshKeys);
        this.fetchSshKeysProgressBar.visibleProperty().bind((ObservableValue)this.fetchSshKeysButton.disabledProperty());
    }

    public static List<UserSpec> getBestCurrentUserSpec(@Nonnull SfaModel sfaModel, @Nonnull JFedHLPreferences jFedPreferences, @Nonnull GeniUserProvider geniUserProvider, @Nonnull Slice slice) {
        if (sfaModel.getUserKeys() == null || sfaModel.getUserKeys().isEmpty()) {
            PuTTYFilesKeyInfo sshKeyInfo;
            PuTTYFilesKeyInfo overrideSshKeyInfo = jFedPreferences.getCustomSshKeyInfo();
            if (overrideSshKeyInfo != null) {
                LOG.info("getBestCurrentUserSpec: The preferences are overriding the SSH key used (" + overrideSshKeyInfo.getClass().getName() + ").");
                sshKeyInfo = overrideSshKeyInfo;
            } else {
                LOG.info("getBestCurrentUserSpec: The user's SSH key will be used.");
                GeniUser geniUser = geniUserProvider.getLoggedInGeniUser();
                sshKeyInfo = SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)geniUser);
            }
            String pemPublicKey = PublicKeyConvertor.fromPublicKey((PublicKey)sshKeyInfo.getPublicKey()).withComment(geniUserProvider.getLoggedInGeniUser().getUserUrn().getResourceName()).getOpensshFormString();
            sfaModel.addUserKey(pemPublicKey);
        }
        return slice.getRequestRspec() == null ? Collections.emptyList() : UserSpecHelper.getMergedUserSpecs((GeniUserProvider)geniUserProvider, (SfaModel)sfaModel, (ModelRspec)((FXModelRspec)slice.getRequestRspec().getModelRspec(ModelRspecType.FX, new ProgressHandler[0])));
    }

    private String constructInitialSshKeysXml() {
        try {
            List<UserSpec> userSpecs = EditSshKeysDialog.getBestCurrentUserSpec(this.sfaModel, this.jFedPreferences, this.geniUserProvider, this.slice);
            return this.userSpecToXml(userSpecs);
        }
        catch (Exception e) {
            LOG.error("Something went wrong trying to get initialXml for EditSshKeysDialog: " + e.getMessage(), (Throwable)e);
            return "<jfed-ssh-keys:user-ssh-keys user=\"urn:publicid:IDN+example.com+user+tester\">\n    <jfed-ssh-keys:sshkey>ssh-rsa key1</jfed-ssh-keys:sshkey>\n    <jfed-ssh-keys:sshkey>ssh-rsa-key2</jfed-ssh-keys:sshkey>\n</jfed-ssh-keys:user-ssh-keys>\n";
        }
    }

    public void showDialog() {
        if (!this.hasSupportingAuthorities()) {
            LOG.debug("No authorities support editing SSH-keys. Showing info message");
            JFDialogs.create().owner(this.parentWindow).message("This experiment doesn't contain any resources that support editing SSH-keys.").masthead("Editing SSH-keys is unavailable").showWarning();
            return;
        }
        this.dialog.show();
    }

    private List<UserSpec> xmlToUserSpec(String xml) {
        try {
            UserSpecParser userSpecParser = new UserSpecParser(xml);
            return userSpecParser.call();
        }
        catch (Exception e) {
            LOG.error("ERROR parsing XML RSpec: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String userSpecToXml(List<UserSpec> userSpecList) {
        try {
            UserSpecWriter userSpecWriter = new UserSpecWriter(userSpecList);
            return userSpecWriter.call();
        }
        catch (Exception e) {
            LOG.error("ERROR parsing XML RSpec: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private boolean isValidInput() {
        String xmlUserSpecs = this.xmlUsersField.getText();
        List<UserSpec> userspec = this.xmlToUserSpec(xmlUserSpecs);
        if (userspec == null || userspec.isEmpty()) {
            JFDialogs.create().owner(this.parentWindow).message("The provided XML could not be parsed, or doesn't contain any SSH-keys. Please check your input.").masthead("Cannot update SSH-keys!").showError();
            return false;
        }
        return true;
    }

    public void onEditSshKeysAction() {
        if (this.isValidInput()) {
            String xmlUserSpecs = this.xmlUsersField.getText();
            List<UserSpec> userspec = this.xmlToUserSpec(xmlUserSpecs);
            assert (userspec != null && !userspec.isEmpty());
            this.experimentController.updateSshKeys(userspec);
        }
    }

    public boolean hasSupportingAuthorities() {
        return this.hasSupportingAuthorities;
    }

    @FXML
    private void fetchSshKeys() {
        this.fetchSshKeysButton.setDisable(true);
        CompletableFuture newUserSpecs = this.experimentController.fetchSliceMemberSshKeys();
        newUserSpecs.whenCompleteAsync(new BiConsumer<Collection<UserSpec>, Throwable>(){

            @Override
            public void accept(Collection<UserSpec> result, Throwable throwable) {
                if (throwable != null) {
                    LOG.error("Fetching SSH keys of slice members failed, skipping processing", throwable);
                }
                if (result != null) {
                    EditSshKeysDialog.this.insertSshKeysIntoEditor(result);
                } else {
                    LOG.warn("Unexpected: got null as result from fetchSliceMemberSshKeys");
                }
                EditSshKeysDialog.this.fetchSshKeysButton.setDisable(false);
            }
        }, Platform::runLater);
    }

    private void insertSshKeysIntoEditor(Collection<UserSpec> newUserSpecs) {
        Optional answer;
        String xmlUserSpecs = this.xmlUsersField.getText();
        List<UserSpec> currentUserSpec = this.xmlToUserSpec(xmlUserSpecs);
        if (newUserSpecs == null && (answer = JFDialogs.create().owner(this.parentWindow).message("The current XML could not be parsed. Inserting new SSH keys will incur data loss. Do you want to continue?").masthead("Cannot update SSH-keys!").buttonTypes(new ButtonType[]{ButtonType.YES, ButtonType.NO}).showWarning()).orElse(ButtonType.NO) != ButtonType.YES) {
            return;
        }
        List userSpecs = UserSpecHelper.mergeUserSpecs(currentUserSpec, newUserSpecs);
        this.xmlUsersField.setText(this.userSpecToXml(userSpecs));
    }
}

