/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.dialogs;

import be.iminds.ilabt.jfed.experimenter_gui.dialogs.JFedBrowser;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.SfaConnectionPool;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.preferences.ProxyPreferencesManager;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.common.TimeUtil;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GDPRDialog
extends JFedBrowser {
    private static final Logger LOG = LoggerFactory.getLogger(GDPRDialog.class);
    private Testbed testbed;
    @FXML
    protected Label untilLabel;
    protected Boolean tcApproved = null;
    protected Boolean tcDeclined = null;
    protected Instant approvedUntil = null;

    @Inject
    public GDPRDialog(@Nonnull GeniUserProvider geniUserProvider, @Nonnull SfaConnectionPool connectionPool, @Nonnull JFedTrustStore trustStore, @Nonnull JFedPreferences preferences, @Nonnull ProxyPreferencesManager proxyPreferencesManager) {
        super(geniUserProvider, connectionPool, trustStore, preferences, proxyPreferencesManager);
    }

    private void checkUntil() {
        if (this.approvedUntil != null && this.approvedUntil.isBefore(Instant.now())) {
            LOG.error("Approval is in the past");
            this.tcApproved = false;
        }
    }

    private void updateUntilView() {
        this.untilLabel.setVisible(this.approvedUntil != null);
        if (this.approvedUntil != null) {
            this.untilLabel.setText("Approved until " + RFC3339Util.instantToRFC3339String((Instant)this.approvedUntil) + " (" + TimeUtil.calcIn((Instant)this.approvedUntil) + ")");
        }
    }

    @Nullable
    public Boolean hasApproved() {
        return this.tcApproved;
    }

    @Nullable
    public Boolean hasDeclined() {
        return this.tcDeclined;
    }

    @Nullable
    public Instant getApprovedUntil() {
        return this.approvedUntil;
    }

    public void setTestbed(Testbed testbed) {
        this.testbed = testbed;
        this.loadPageWhenReady();
    }

    @Override
    @FXML
    protected void initialize() {
        super.initialize();
    }

    @Override
    protected void loadPageWhenReady() {
        if (!this.initialized) {
            return;
        }
        if (this.testbed == null) {
            return;
        }
        Platform.runLater(this::registerJsBridge);
        this.loadPage();
    }

    @Override
    protected Object makeJavascriptBridge() {
        return new GDPRDialogJavaScriptBridge(this);
    }

    protected void loadPage() {
        if (this.testbed.getGdprInfo() == null) {
            LOG.warn("Cannot show Terms & Conditions page for Testbed without gdprInfo");
            return;
        }
        String gdprUrl = this.testbed.getGdprInfo().getGrpdUrl();
        if (gdprUrl == null) {
            LOG.warn("Cannot show Terms & Conditions page for Testbed without gdprInfo.grpdUrl");
            return;
        }
        this.headerLabel.setText("Terms & Conditions for " + this.testbed.getLongName());
        this.webEngine.load(gdprUrl);
        this.urlText.setValue(gdprUrl);
    }

    public static class GDPRDialogJavaScriptBridge
    extends JFedBrowser.JavaScriptBridge {
        @Nonnull
        private final GDPRDialog gdprDialog;

        public GDPRDialogJavaScriptBridge(@Nonnull GDPRDialog gdprDialog) {
            super(gdprDialog);
            this.gdprDialog = gdprDialog;
        }

        @Override
        public void approve() {
            LOG.debug("GDPRDialogJavaScriptBridge.approve");
            this.gdprDialog.tcApproved = true;
            this.gdprDialog.approvedUntil = null;
            this.gdprDialog.tcDeclined = null;
            this.gdprDialog.checkUntil();
            this.gdprDialog.updateUntilView();
        }

        @Override
        public void approveWithDateInMillisecondsSinceEpoch(long dateInMsSinceEpoch) {
            LOG.debug("GDPRDialogJavaScriptBridge.approveWithDateInMillisecondsSinceEpoch(" + dateInMsSinceEpoch + ")");
            Instant instant = Instant.ofEpochMilli(dateInMsSinceEpoch);
            this.gdprDialog.tcApproved = true;
            this.gdprDialog.approvedUntil = instant;
            this.gdprDialog.tcDeclined = null;
            this.gdprDialog.checkUntil();
            this.gdprDialog.updateUntilView();
        }

        @Override
        public void approveDaysFromNow(int daysFromNow) {
            LOG.debug("GDPRDialogJavaScriptBridge.approveDaysFromNow(" + daysFromNow + ")");
            Instant instant = Instant.now().plus(Duration.ofDays(daysFromNow));
            this.gdprDialog.tcApproved = true;
            this.gdprDialog.approvedUntil = instant;
            this.gdprDialog.tcDeclined = null;
            this.gdprDialog.checkUntil();
            this.gdprDialog.updateUntilView();
        }

        @Override
        public void approveWithDateISO8601(@Nullable String dateString) {
            LOG.debug("GDPRDialogJavaScriptBridge.approveWithDateISO8601(\"" + dateString + "\")");
            this.gdprDialog.tcApproved = true;
            try {
                this.gdprDialog.approvedUntil = dateString == null || dateString.trim().isEmpty() || dateString.trim().equals("null") || dateString.trim().equals("undefined") ? null : RFC3339Util.iso8601StringToDate((String)dateString).toInstant();
            }
            catch (ParseException e) {
                LOG.debug("GDPRDialogJavaScriptBridge.approve date parse error", (Throwable)e);
            }
            this.gdprDialog.tcDeclined = null;
            this.gdprDialog.checkUntil();
            this.gdprDialog.updateUntilView();
        }

        @Override
        public void decline() {
            LOG.debug("GDPRDialogJavaScriptBridge.decline");
            this.gdprDialog.tcApproved = null;
            this.gdprDialog.approvedUntil = null;
            this.gdprDialog.tcDeclined = true;
            this.gdprDialog.checkUntil();
            this.gdprDialog.updateUntilView();
        }

        @Override
        public void close() {
            LOG.debug("GDPRDialogJavaScriptBridge.close");
            Window stage = this.gdprDialog.scene.getWindow();
            stage.hide();
        }
    }
}

