/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.dialogs;

import be.iminds.ilabt.jfed.experimenter_gui.dialogs.GDPRDialog;
import be.iminds.ilabt.jfed.experimenter_gui.ui.AbstractDialogFactory;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import java.net.URL;
import java.time.Instant;
import java.util.Objects;
import javafx.fxml.FXMLLoader;
import javafx.stage.Stage;
import javafx.util.Pair;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class GDPRDialogFactory {
    private final AbstractDialogFactory dialogFactory;

    @Inject
    public GDPRDialogFactory(Provider<FXMLLoader> loaderProvider, @Named(value="parentStage") Provider<Stage> parentStageProvider) {
        this.dialogFactory = new AbstractDialogFactory(loaderProvider, parentStageProvider){

            @Override
            protected String getTitle() {
                return "Terms & Conditions";
            }

            @Override
            protected URL getFxmlLocation() {
                return GDPRDialogFactory.class.getResource("GDPRDialog.fxml");
            }
        };
    }

    @Nonnull
    public Pair<Boolean, Instant> showDialog(@Nonnull Testbed testbed) {
        AbstractDialogFactory.StageAndController stageAndController = this.dialogFactory.createStage();
        GDPRDialog controller = (GDPRDialog)stageAndController.getController();
        controller.setTestbed(testbed);
        stageAndController.getStage().showAndWait();
        Boolean resBool = controller.hasApproved();
        if (resBool == null && Objects.equals(controller.hasDeclined(), Boolean.TRUE)) {
            resBool = false;
        }
        return new Pair((Object)resBool, (Object)controller.getApprovedUntil());
    }
}

