/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.dialogs;

import be.iminds.ilabt.jfed.experimenter_gui.dialogs.URLStreamFactoryCustomizer;
import be.iminds.ilabt.jfed.experimenter_gui.ui.SceneAwareController;
import be.iminds.ilabt.jfed.experimenter_gui.util.RemovingInputStream;
import be.iminds.ilabt.jfed.lowlevel.connection.BasicConnectionBuilderFactory;
import be.iminds.ilabt.jfed.lowlevel.connection.BasicHttpConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.ConnectionBuilder;
import be.iminds.ilabt.jfed.lowlevel.connection.HttpConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.SfaConnectionPool;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.preferences.ProxyPreferencesManager;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.common.ThreadFactoryUtil;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import com.sun.javafx.webkit.WebConsoleListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.nio.charset.StandardCharsets;
import java.security.Permission;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.concurrent.Worker;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import netscape.javascript.JSObject;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JFedBrowser
implements SceneAwareController {
    public static boolean JFED_BROWSER_WORKS = false;
    private static final Logger LOG = LoggerFactory.getLogger(JFedBrowser.class);
    @Nonnull
    private final GeniUserProvider geniUserProvider;
    @Nonnull
    private final SfaConnectionPool connectionPool;
    @Nonnull
    private final JFedTrustStore trustStore;
    @Nonnull
    private final JFedTrustStore systemTrustStore;
    @Nonnull
    private final JFedPreferences preferences;
    @Nonnull
    private final ProxyPreferencesManager proxyPreferencesManager;
    @FXML
    protected Parent centerBox;
    @FXML
    protected WebView webView;
    @FXML
    protected Label headerLabel;
    @FXML
    @Nullable
    protected Label messageLabel;
    @FXML
    @Nullable
    protected CheckBox useSecureSsl;
    @FXML
    @Nullable
    protected TextField urlField;
    @FXML
    @Nullable
    protected ProgressIndicator loadingPageProgressIndicator;
    @FXML
    @Nullable
    protected ListView<String> messageList;
    @FXML
    @Nullable
    protected Label firebugLabel;
    protected WebEngine webEngine;
    protected boolean initialized;
    protected String initialUrl = null;
    protected Scene scene;
    protected Stage stage;
    protected int jsBridgeBackoff = 1;
    protected boolean forceCloseMessages = false;
    protected StringProperty urlText = new SimpleStringProperty("");
    protected BooleanProperty pageLoading = new SimpleBooleanProperty(true);
    protected boolean injectedFirebug = false;
    protected final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, ThreadFactoryUtil.getFactory((String)"JFedBrowser"));
    protected Future nextRegisterJsBridge = null;
    protected Object jFedBridge = null;
    private final Executor myHttpCLientExecutor = Executors.newSingleThreadExecutor();
    private static final boolean logAll = false;

    @Override
    public void registerScene(Scene scene) {
        this.scene = scene;
        this.stage = (Stage)scene.getWindow();
        LOG.debug("Loaded accelerators");
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.F12, new KeyCombination.Modifier[0]), this::openFirebug);
    }

    public void setInitialUrl(@Nullable String initialUrl) {
        this.initialUrl = initialUrl == null ? "https://www.wall2.ilabt.iminds.be:12369/ilabt/1.0/userprojects.php" : initialUrl;
        this.loadPageWhenReady();
    }

    private void clearMessage() {
        assert (this.initialized);
        if (this.messageLabel == null) {
            return;
        }
        Platform.runLater(() -> this.messageLabel.setVisible(false));
    }

    private void showMessage(@Nonnull String message) {
        assert (this.initialized);
        if (this.messageLabel == null && this.messageList == null) {
            LOG.debug("No label in this browser to show message: " + message);
            return;
        }
        Platform.runLater(() -> {
            assert (this.initialized);
            if (this.messageLabel != null) {
                this.messageLabel.setText(message);
                this.messageLabel.setVisible(true);
            }
            if (this.messageList != null) {
                this.messageList.getItems().add((Object)message);
            }
            if (this.useSecureSsl != null) {
                this.updateUseSecureSsl();
            }
        });
    }

    private void showMessage(@Nonnull String message, @Nonnull Throwable e) {
        this.showMessage(message + " " + e.getMessage());
    }

    private void showMessage(@Nonnull Throwable e) {
        this.showMessage("Error: " + e.getMessage());
    }

    private void updateUseSecureSsl() {
        assert (this.initialized);
        assert (this.useSecureSsl != null);
        Platform.runLater(() -> {
            if (this.useSecureSsl.isSelected()) {
                this.useSecureSsl.setVisible(true);
            } else if (this.messageLabel != null && this.messageLabel.getText() != null && this.messageLabel.getText().contains("unable to find valid certification path")) {
                this.useSecureSsl.setVisible(true);
            } else {
                this.useSecureSsl.setVisible(false);
            }
        });
    }

    @Inject
    public JFedBrowser(@Nonnull GeniUserProvider geniUserProvider, @Nonnull SfaConnectionPool connectionPool, @Nonnull JFedTrustStore trustStore, @Nonnull JFedPreferences preferences, @Nonnull ProxyPreferencesManager proxyPreferencesManager) {
        this.geniUserProvider = geniUserProvider;
        this.connectionPool = connectionPool;
        this.trustStore = trustStore;
        this.systemTrustStore = new JFedTrustStore();
        this.preferences = preferences;
        this.proxyPreferencesManager = proxyPreferencesManager;
    }

    @FXML
    protected void initialize() {
        this.webEngine = this.webView.getEngine();
        URLStreamFactoryCustomizer.useDedicatedProxyForWebkit(new MyHttpUrlStreamHandler(), "https,http");
        this.initialized = true;
        if (this.headerLabel != null) {
            this.headerLabel.setText("JFed browser with SSL-client authentication for user " + this.geniUserProvider.getLoggedInGeniUser().getUserUrn().getEncodedResourceName() + (this.proxyPreferencesManager.isProxyEnabledForJfed() ? " using jFed proxy" : ""));
        }
        LOG.debug("Opening JFed browser with SSL-client authentication for user " + this.geniUserProvider.getLoggedInGeniUser().getUserUrn().getEncodedResourceName() + (this.proxyPreferencesManager.isProxyEnabledForJfed() ? " using jFed proxy" : ""));
        if (this.urlField != null) {
            this.urlField.textProperty().bindBidirectional((Property)this.urlText);
        }
        this.urlText.addListener((observableValue, s, t1) -> LOG.debug("urlText changed from \"" + s + "\" to \"" + t1 + "\""));
        if (this.loadingPageProgressIndicator != null) {
            this.loadingPageProgressIndicator.setProgress(-1.0);
            this.loadingPageProgressIndicator.visibleProperty().bind((ObservableValue)this.pageLoading);
        }
        if (this.messageList != null) {
            this.messageList.setItems(FXCollections.observableArrayList());
            this.messageList.getItems().addListener(c -> this.messageList.setVisible(!c.getList().isEmpty() && !this.forceCloseMessages));
        }
        this.webEngine.getLoadWorker().stateProperty().addListener((ov, oldState, newState) -> {
            if (newState == Worker.State.SUCCEEDED) {
                LOG.debug("Webengine successfully loaded site.");
                String webEnLoc = this.webEngine.getLocation();
                Platform.runLater(() -> {
                    this.pageLoading.setValue(Boolean.valueOf(false));
                    if (webEnLoc != null && !webEnLoc.isBlank()) {
                        this.urlText.setValue(webEnLoc);
                    }
                });
                this.jsBridgeBackoff = 1;
                this.registerJsBridge();
            }
            if (newState == Worker.State.RUNNING || newState == Worker.State.SCHEDULED || newState == Worker.State.READY) {
                this.pageLoading.setValue(Boolean.valueOf(true));
            }
            if (newState == Worker.State.FAILED || newState == Worker.State.CANCELLED) {
                this.pageLoading.setValue(Boolean.valueOf(false));
            }
        });
        WebConsoleListener.setDefaultListener((webView, message, lineNumber, sourceId) -> {
            LOG.debug("[Webengine message] " + message + "[at " + lineNumber + "]");
            if (this.messageList != null) {
                Platform.runLater(() -> this.messageList.getItems().add((Object)(message + "[at " + lineNumber + "]")));
            }
        });
        this.loadPageWhenReady();
        if (this.useSecureSsl != null) {
            this.useSecureSsl.selectedProperty().addListener((obsval, oldVal, newVal) -> {
                if (oldVal != newVal) {
                    this.onUrlAction();
                }
            });
        }
    }

    public void closeMessages() {
        assert (this.initialized);
        this.forceCloseMessages = true;
        if (this.messageList == null) {
            return;
        }
        this.messageList.setVisible(!this.messageList.getItems().isEmpty() && !this.forceCloseMessages);
    }

    protected void openFirebug() {
        String firebugScript;
        if (this.injectedFirebug) {
            LOG.warn("Not injecting firebug again.");
            return;
        }
        try {
            firebugScript = IOUtils.resourceToString((String)"firebug-lite.js", this.getClass());
        }
        catch (IOException e) {
            this.showMessage("Error loading firebug-lite.js", e);
            throw new RuntimeException("Error loading firebug-lite.js", e);
        }
        LOG.debug("Injecting firebug");
        this.showMessage("Injecting firebug...");
        this.webEngine.executeScript(firebugScript);
        this.injectedFirebug = true;
        this.showMessage("Injected firebug.");
        if (this.firebugLabel != null) {
            this.firebugLabel.setVisible(false);
        }
    }

    public void onUrlAction() {
        this.loadPage(this.urlText.getValue());
    }

    public void close() {
        this.webEngine.getLoadWorker().cancel();
    }

    protected void loadPageWhenReady() {
        if (!this.initialized) {
            return;
        }
        if (this.initialUrl == null) {
            return;
        }
        Platform.runLater(() -> {
            this.urlText.setValue(this.initialUrl);
            this.onUrlAction();
        });
    }

    protected void loadPage(@Nonnull String urlString) {
        this.clearMessage();
        this.pageLoading.setValue(Boolean.valueOf(true));
        this.webEngine.load(urlString);
        this.jsBridgeBackoff = 1;
        Platform.runLater(this::registerJsBridge);
    }

    public void back() {
        this.clearMessage();
        this.webEngine.executeScript("history.back()");
    }

    public void forward() {
        this.clearMessage();
        this.webEngine.executeScript("history.forward()");
    }

    public void reload() {
        this.clearMessage();
        this.pageLoading.setValue(Boolean.valueOf(true));
        this.webEngine.reload();
        this.registerJsBridge();
    }

    protected synchronized void registerJsBridgeLater() {
        int multi;
        Future snapshotOfFuture = this.nextRegisterJsBridge;
        if (snapshotOfFuture != null) {
            snapshotOfFuture.cancel(false);
        }
        if ((multi = this.jsBridgeBackoff) < 1) {
            multi = 1;
        }
        if (multi > 4) {
            multi = 4;
        }
        multi = 1 << multi - 1;
        this.nextRegisterJsBridge = this.scheduler.schedule(() -> Platform.runLater(this::registerJsBridge), 250L * (long)multi, TimeUnit.MILLISECONDS);
    }

    protected void registerJsBridge() {
        JSObject win;
        Object existing;
        JSObject document;
        Future snapshotOfFuture = this.nextRegisterJsBridge;
        if (snapshotOfFuture != null) {
            snapshotOfFuture.cancel(false);
        }
        if ((document = (JSObject)this.webEngine.executeScript("document")) == null) {
            this.registerJsBridgeLater();
            return;
        }
        String readyState = (String)document.getMember("readyState");
        if (readyState == null) {
            this.registerJsBridgeLater();
            return;
        }
        if (!readyState.equals("complete") && !readyState.equals("interactive")) {
            this.registerJsBridgeLater();
            return;
        }
        if (this.jFedBridge == null) {
            this.jFedBridge = this.makeJavascriptBridge();
        }
        if ((existing = (win = (JSObject)this.webEngine.executeScript("window")).getMember("jfed")) != this.jFedBridge) {
            LOG.debug("registerJsBridge() -> Registering jFed in javascript");
            win.setMember("jfed", this.jFedBridge);
            this.jsBridgeBackoff = 1;
            this.registerJsBridgeLater();
        } else {
            ++this.jsBridgeBackoff;
            this.registerJsBridgeLater();
        }
    }

    protected Object makeJavascriptBridge() {
        return new JavaScriptBridge(this);
    }

    public HttpClientBuilder getHttpClientBuilder(@Nonnull URL url) {
        HttpConnection con;
        BasicConnectionBuilderFactory connectionBuilderFactory = new BasicConnectionBuilderFactory();
        ConnectionBuilder connectionBuilder = connectionBuilderFactory.createConnectionBuilder();
        if (Objects.equals(url.getProtocol(), "https")) {
            if (!this.geniUserProvider.isUserLoggedIn()) {
                LOG.debug("Connection for \"" + String.valueOf(url) + "\" will not use auth because NO USER LOGGED IN");
                return null;
            }
            GeniUser user = this.geniUserProvider.getLoggedInGeniUser();
            JFedTrustStore conTrustStore = new JFedTrustStore(this.trustStore);
            connectionBuilder.useHttps(conTrustStore, null);
            connectionBuilder.useSslClientAuthentication(user.getClientCertificateChain(), user.getPrivateKey());
            LOG.debug("Connection for \"" + String.valueOf(url) + "\" will use SSL client auth for user " + user.getUserUrnString());
            if (this.useSecureSsl != null && this.useSecureSsl.isSelected()) {
                LOG.warn("Allowing all SSL certificates");
                connectionBuilder.setHackAllowAllServerCertificates(true);
            }
        } else {
            assert (Objects.equals(url.getProtocol(), "http"));
            connectionBuilder.useHttp();
            connectionBuilder.useNoAuthentication();
            LOG.debug("Connection for \"" + String.valueOf(url) + "\" will not use auth because of HTTP");
        }
        connectionBuilder.setProxy((JFedConnection.ProxyInfo)this.proxyPreferencesManager.getProxySettings((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_JFED, Collections.emptyList(), this.geniUserProvider.isUserLoggedIn() ? this.geniUserProvider.getLoggedInGeniUser() : null), false);
        connectionBuilder.setDebugInfo(JFedConnection.DebugInfo.createWithAllNull());
        connectionBuilder.setUrl(url);
        try {
            con = connectionBuilder.buildHttpConnection();
        }
        catch (JFedException e) {
            this.showMessage("Error building connection", e);
            LOG.error("Error building connection", (Throwable)e);
            return null;
        }
        HttpClientBuilder httpClientBuilder = ((BasicHttpConnection)con).getClientBuilder();
        return httpClientBuilder;
    }

    public class MyHttpUrlStreamHandler
    extends URLStreamHandler {
        @Override
        protected HttpURLConnection openConnection(URL u) {
            MyURLConnection q = new MyURLConnection(u);
            return q;
        }
    }

    public static class JavaScriptBridge {
        @Nonnull
        protected final JFedBrowser browser;

        public JavaScriptBridge(@Nonnull JFedBrowser browser) {
            this.browser = browser;
        }

        public void approve() {
            LOG.debug("JavaScriptBridge.approve");
            Platform.runLater(() -> this.browser.messageList.getItems().add((Object)"-> jfed.approve called"));
        }

        public void approveWithDateInMillisecondsSinceEpoch(long dateInMsSinceEpoch) {
            Instant instant = Instant.ofEpochMilli(dateInMsSinceEpoch);
            String dateAsString = RFC3339Util.instantToRFC3339String((Instant)instant, (boolean)true, (boolean)false, (boolean)true);
            LOG.debug("GDPRDialogJavaScriptBridge.approveWithDateInMillisecondsSinceEpoch(" + dateInMsSinceEpoch + ") -> " + dateAsString);
            Platform.runLater(() -> this.browser.messageList.getItems().add((Object)("-> jfed.approveWithDateInMillisecondsSinceEpoch(" + dateInMsSinceEpoch + ") -> processed date: " + dateAsString)));
        }

        public void approveDaysFromNow(int daysFromNow) {
            Instant instant = Instant.now().plus(Duration.ofDays(daysFromNow));
            String dateAsString = RFC3339Util.instantToRFC3339String((Instant)instant, (boolean)true, (boolean)false, (boolean)true);
            LOG.debug("GDPRDialogJavaScriptBridge.approveDaysFromNow(" + daysFromNow + ") -> " + dateAsString);
            Platform.runLater(() -> this.browser.messageList.getItems().add((Object)("-> jfed.approveDaysFromNow(" + daysFromNow + ") -> processed date: " + dateAsString)));
        }

        public void approveWithDateISO8601(@Nullable String dateString) {
            try {
                Instant date = dateString == null || dateString.trim().isEmpty() || dateString.trim().equals("null") || dateString.trim().equals("undefined") ? null : RFC3339Util.iso8601StringToDate((String)dateString).toInstant();
                String dateAsString = date == null ? null : RFC3339Util.instantToRFC3339String(date, (boolean)true, (boolean)false, (boolean)true);
                LOG.debug("GDPRDialogJavaScriptBridge.approveWithDateISO8601(\"" + dateString + "\") -> " + dateAsString);
                Platform.runLater(() -> this.browser.messageList.getItems().add((Object)("-> jfed.approveWithDateISO8601(" + (String)(dateString == null ? dateString : "\"" + dateString + "\"") + ") -> processed date: " + dateAsString)));
            }
            catch (ParseException e) {
                LOG.warn("GDPRDialogJavaScriptBridge.approveWithDateISO8601(\"" + dateString + "\") date parse failed ", (Throwable)e);
                Platform.runLater(() -> this.browser.messageList.getItems().add((Object)("-> jfed.approveWithDateISO8601(\"" + dateString + "\") -> DATE PARSE FAILED")));
            }
        }

        public void decline() {
            LOG.debug("JavaScriptBridge.decline");
            Platform.runLater(() -> this.browser.messageList.getItems().add((Object)"-> jfed.decline called"));
        }

        public void close() {
            LOG.debug("JavaScriptBridge.close");
            Platform.runLater(() -> this.browser.messageList.getItems().add((Object)"-> jfed.close called"));
        }
    }

    public class MyURLConnection
    extends HttpURLConnection {
        private final HttpClientBuilder httpClientBuilder;
        private HttpClient httpClient;
        private HttpUriRequest httpCall;
        private HttpResponse response;
        private final PipedOutputStream requestOutputStream;
        private final PipedInputStream requestInternalPipedInputStream;
        private final URI uri;
        private boolean responseError;

        protected MyURLConnection(URL url) {
            super(url);
            this.responseError = false;
            try {
                this.uri = url.toURI();
            }
            catch (URISyntaxException e) {
                JFedBrowser.this.showMessage("Error creating URI from URL for \"" + url.toExternalForm() + "\"");
                throw new RuntimeException("Error creating URI from URL for \"" + url.toExternalForm() + "\"", e);
            }
            this.httpClientBuilder = JFedBrowser.this.getHttpClientBuilder(url);
            this.requestOutputStream = new PipedOutputStream();
            this.requestInternalPipedInputStream = new PipedInputStream();
        }

        @Override
        public void disconnect() {
            try {
                if (this.httpCall != null) {
                    this.httpCall.abort();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.response != null && this.response instanceof CloseableHttpResponse) {
                    ((CloseableHttpResponse)this.response).close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.httpClient != null && this.httpClient instanceof CloseableHttpClient) {
                    ((CloseableHttpClient)this.httpClient).close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.requestInternalPipedInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.requestOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public boolean usingProxy() {
            return false;
        }

        @Override
        public void connect() throws IOException {
            Map<String, List<String>> requestHeaders;
            if (this.connected) {
                return;
            }
            this.httpClientBuilder.setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(this.getConnectTimeout()).setSocketTimeout(this.getReadTimeout()).build());
            this.httpClient = this.httpClientBuilder.build();
            switch (this.method.toUpperCase()) {
                case "GET": {
                    this.httpCall = new HttpGet(this.uri);
                    break;
                }
                case "POST": {
                    this.httpCall = new HttpPost(this.uri);
                    break;
                }
                case "PUT": {
                    this.httpCall = new HttpPut(this.uri);
                    break;
                }
                case "DELETE": {
                    this.httpCall = new HttpDelete(this.uri);
                    break;
                }
                case "HEAD": {
                    this.httpCall = new HttpHead(this.uri);
                    break;
                }
                case "OPTIONS": {
                    this.httpCall = new HttpOptions(this.uri);
                    break;
                }
                case "TRACE": {
                    this.httpCall = new HttpTrace(this.uri);
                    break;
                }
                default: {
                    throw new ProtocolException("Unsupported HTTP method: " + this.method);
                }
            }
            boolean onThread = false;
            if (this.httpCall instanceof HttpEntityEnclosingRequestBase) {
                BasicHttpEntity requestEntity = new BasicHttpEntity();
                long contentLenToSet = 0L;
                if (this.fixedContentLength != -1) {
                    contentLenToSet = this.fixedContentLength;
                }
                if (this.fixedContentLengthLong != -1L) {
                    contentLenToSet = this.fixedContentLengthLong;
                }
                if (super.getRequestProperties().containsKey("Content-Length")) {
                    contentLenToSet = Long.parseLong(super.getRequestProperty("Content-Length"));
                }
                requestEntity.setContentLength(contentLenToSet);
                if (contentLenToSet > 0L) {
                    requestEntity.setContent((InputStream)this.requestInternalPipedInputStream);
                    requestEntity.setChunked(this.chunkLength != -1);
                } else {
                    requestEntity.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
                }
                this.requestOutputStream.connect(this.requestInternalPipedInputStream);
                ((HttpEntityEnclosingRequestBase)this.httpCall).setEntity((HttpEntity)requestEntity);
                onThread = true;
            }
            if (this.ifModifiedSince > 0L) {
                Instant sinceDate = Instant.ofEpochMilli(this.ifModifiedSince);
                this.httpCall.setHeader("If-Modified-Since", DateTimeFormatter.RFC_1123_DATE_TIME.format(sinceDate));
            }
            if ((requestHeaders = this.getRequestProperties()) != null) {
                for (Map.Entry<String, List<String>> requestHeader : requestHeaders.entrySet()) {
                    if (requestHeader.getKey().equalsIgnoreCase("Content-length")) {
                        LOG.warn("Skipping explicitly set content-length header: " + requestHeader.getValue().stream().collect(Collectors.joining(",")));
                        continue;
                    }
                    this.httpCall.setHeader(requestHeader.getKey(), requestHeader.getValue().stream().collect(Collectors.joining(",")));
                }
            }
            this.connected = true;
            if (!onThread) {
                try {
                    this.response = this.httpClient.execute(this.httpCall);
                }
                catch (Throwable e) {
                    this.responseError = true;
                    LOG.debug("connect() failed for " + this.httpCall.getURI().toASCIIString(), e);
                    JFedBrowser.this.showMessage(e);
                    throw e;
                }
            } else {
                Runnable exRun = () -> {
                    try {
                        this.response = this.httpClient.execute(this.httpCall);
                        LOG.debug("connect() finished in background thread");
                    }
                    catch (Throwable e) {
                        this.responseError = true;
                        JFedBrowser.this.showMessage(e);
                        LOG.error("connect() in background thread: Error calling httpClient.execute(httpCall)  (will mark connection as failed and ignore)", e);
                    }
                };
                JFedBrowser.this.myHttpCLientExecutor.execute(exRun);
                LOG.debug("finishing connect() in background thread");
            }
        }

        @Override
        public String getHeaderField(String name) {
            this.waitForResponse();
            if (this.response == null || !this.response.containsHeader(name)) {
                return null;
            }
            return this.response.getLastHeader(name).getValue();
        }

        @Override
        public String getContentType() {
            this.waitForResponse();
            if (this.response == null || !this.response.containsHeader("Content-Type")) {
                return null;
            }
            return this.response.getLastHeader("Content-Type").getValue();
        }

        @Override
        public int getContentLength() {
            this.waitForResponse();
            if (this.response == null || this.response.getEntity() == null) {
                return -1;
            }
            return (int)this.response.getEntity().getContentLength();
        }

        @Override
        public long getContentLengthLong() {
            this.waitForResponse();
            if (this.response == null || this.response.getEntity() == null) {
                return -1L;
            }
            return this.response.getEntity().getContentLength();
        }

        @Override
        public boolean getDoInput() {
            return super.getDoInput();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            this.waitForResponse();
            if (this.response == null || this.response.getEntity() == null || this.response.getEntity().getContent() == null) {
                LOG.debug("getInputStream() for " + this.httpCall.getURI().toASCIIString() + "  -> empty InputStream");
                return new ByteArrayInputStream(new byte[0]);
            }
            return new UnsupportedIntegrityRemovingInputStream(this.response.getEntity().getContent());
        }

        private void waitForResponse() {
            if (!this.connected) {
                throw new IllegalStateException("must call connect() before waitForResponse() (for " + this.method.toUpperCase() + " " + this.url.toExternalForm() + ")");
            }
            while (this.response == null && !this.responseError) {
                try {
                    LOG.debug("waitForResponse() is waiting (for " + this.method.toUpperCase() + " " + this.url.toExternalForm() + ")");
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return new DebugOutputStream(this.requestOutputStream);
        }

        @Override
        public Permission getPermission() throws IOException {
            return super.getPermission();
        }

        @Override
        public String getHeaderFieldKey(int i) {
            return super.getHeaderFieldKey(i);
        }

        @Override
        public void setFixedLengthStreamingMode(int i) {
            super.setFixedLengthStreamingMode(i);
        }

        @Override
        public void setFixedLengthStreamingMode(long l) {
            super.setFixedLengthStreamingMode(l);
        }

        @Override
        public void setChunkedStreamingMode(int i) {
            super.setChunkedStreamingMode(i);
        }

        @Override
        public String getHeaderField(int i) {
            return super.getHeaderField(i);
        }

        @Override
        public void setInstanceFollowRedirects(boolean b) {
            super.setInstanceFollowRedirects(b);
            if (!b) {
                this.httpClientBuilder.disableRedirectHandling();
            }
        }

        @Override
        public boolean getInstanceFollowRedirects() {
            return super.getInstanceFollowRedirects();
        }

        @Override
        public void setRequestMethod(String s) throws ProtocolException {
            super.setRequestMethod(s);
        }

        @Override
        public String getRequestMethod() {
            return super.getRequestMethod();
        }

        @Override
        public int getResponseCode() throws IOException {
            this.waitForResponse();
            if (this.response == null || this.response.getStatusLine() == null) {
                return -1;
            }
            return this.response.getStatusLine().getStatusCode();
        }

        @Override
        public String getResponseMessage() throws IOException {
            this.waitForResponse();
            if (this.response == null || this.response.getStatusLine() == null) {
                return null;
            }
            return this.response.getStatusLine().getReasonPhrase();
        }

        @Override
        public long getHeaderFieldDate(String s, long l) {
            return super.getHeaderFieldDate(s, l);
        }

        @Override
        public InputStream getErrorStream() {
            this.waitForResponse();
            return null;
        }

        @Override
        public void setConnectTimeout(int i) {
            super.setConnectTimeout(i);
        }

        @Override
        public int getConnectTimeout() {
            return super.getConnectTimeout();
        }

        @Override
        public void setReadTimeout(int i) {
            super.setReadTimeout(i);
        }

        @Override
        public int getReadTimeout() {
            return super.getReadTimeout();
        }

        @Override
        public URL getURL() {
            return super.getURL();
        }

        @Override
        public String getContentEncoding() {
            return super.getContentEncoding();
        }

        @Override
        public long getExpiration() {
            return super.getExpiration();
        }

        @Override
        public long getDate() {
            return super.getDate();
        }

        @Override
        public long getLastModified() {
            return super.getLastModified();
        }

        @Override
        public Map<String, List<String>> getHeaderFields() {
            this.waitForResponse();
            if (this.response == null || this.response.getAllHeaders() == null) {
                return Collections.emptyMap();
            }
            HashMap<String, List<String>> res = new HashMap<String, List<String>>();
            for (Header header : this.response.getAllHeaders()) {
                res.put(header.getName(), Arrays.asList(header.getValue().split(",")));
            }
            return Collections.unmodifiableMap(res);
        }

        @Override
        public int getHeaderFieldInt(String s, int i) {
            return super.getHeaderFieldInt(s, i);
        }

        @Override
        public long getHeaderFieldLong(String s, long l) {
            return super.getHeaderFieldLong(s, l);
        }

        @Override
        public Object getContent() throws IOException {
            return super.getContent();
        }

        public Object getContent(Class[] classes) throws IOException {
            return super.getContent(classes);
        }

        @Override
        public void setDoInput(boolean b) {
            super.setDoInput(b);
        }

        @Override
        public void setDoOutput(boolean b) {
            super.setDoOutput(b);
        }

        @Override
        public boolean getDoOutput() {
            return super.getDoOutput();
        }

        @Override
        public void setAllowUserInteraction(boolean b) {
            super.setAllowUserInteraction(b);
        }

        @Override
        public boolean getAllowUserInteraction() {
            return super.getAllowUserInteraction();
        }

        @Override
        public void setUseCaches(boolean b) {
            super.setUseCaches(b);
        }

        @Override
        public boolean getUseCaches() {
            return super.getUseCaches();
        }

        @Override
        public void setIfModifiedSince(long l) {
            super.setIfModifiedSince(l);
        }

        @Override
        public long getIfModifiedSince() {
            return super.getIfModifiedSince();
        }

        @Override
        public boolean getDefaultUseCaches() {
            return super.getDefaultUseCaches();
        }

        @Override
        public void setDefaultUseCaches(boolean b) {
            super.setDefaultUseCaches(b);
        }

        @Override
        public void setRequestProperty(String s, String s1) {
            super.setRequestProperty(s, s1);
        }

        @Override
        public void addRequestProperty(String s, String s1) {
            super.addRequestProperty(s, s1);
        }

        @Override
        public String getRequestProperty(String s) {
            return super.getRequestProperty(s);
        }

        @Override
        public Map<String, List<String>> getRequestProperties() {
            return super.getRequestProperties();
        }

        private class UnsupportedIntegrityRemovingInputStream
        extends RemovingInputStream {
            public UnsupportedIntegrityRemovingInputStream(InputStream in) {
                super(in, "integrity=\"sha384", '\"', 100);
            }
        }

        private class DebugInputStream
        extends InputStream {
            private final URI uri;
            private final InputStream delegate;

            public DebugInputStream(URI uri, InputStream delegate) {
                this.uri = uri;
                this.delegate = delegate;
            }

            @Override
            public int read() throws IOException {
                try {
                    int res = this.delegate.read();
                    LOG.debug("inputstream.read() for " + this.uri.toASCIIString() + " returns " + res);
                    return res;
                }
                catch (IOException e) {
                    LOG.debug("Exception in inputstream.read() for " + this.uri.toASCIIString(), (Throwable)e);
                    throw e;
                }
            }

            @Override
            public int read(@NotNull byte[] b) throws IOException {
                try {
                    int res = this.delegate.read(b);
                    LOG.debug("inputstream.read(byte[] b (length=" + b.length + ") ) for " + this.uri.toASCIIString() + " returns " + res);
                    return res;
                }
                catch (IOException e) {
                    LOG.debug("Exception in inputstream.read(byte[] b (length=" + b.length + ") ) for " + this.uri.toASCIIString(), (Throwable)e);
                    throw e;
                }
            }

            @Override
            public int read(@NotNull byte[] b, int off, int len) throws IOException {
                try {
                    int res = this.delegate.read(b, off, len);
                    LOG.debug("inputstream.read(byte[] b, int off=" + off + ", int len=" + len + ") for " + this.uri.toASCIIString() + " returns " + res);
                    return res;
                }
                catch (IOException e) {
                    LOG.debug("Exception in inputstream.read(byte[] b, int off=" + off + ", int len=" + len + ") for " + this.uri.toASCIIString(), (Throwable)e);
                    throw e;
                }
            }

            @Override
            public byte[] readAllBytes() throws IOException {
                try {
                    byte[] res = this.delegate.readAllBytes();
                    LOG.debug("inputstream.readAllBytes() for " + this.uri.toASCIIString() + " returns byte[] with len " + res.length);
                    return res;
                }
                catch (IOException e) {
                    LOG.debug("Exception in inputstream.readAllBytes() for " + this.uri.toASCIIString(), (Throwable)e);
                    throw e;
                }
            }

            @Override
            public byte[] readNBytes(int len) throws IOException {
                try {
                    byte[] res = this.delegate.readNBytes(len);
                    LOG.debug("inputstream.readNBytes(int len=" + len + ") for " + this.uri.toASCIIString() + " returns byte[] with len " + res.length);
                    return res;
                }
                catch (IOException e) {
                    LOG.debug("Exception in inputstream.readNBytes(int len=" + len + ") for " + this.uri.toASCIIString(), (Throwable)e);
                    throw e;
                }
            }

            @Override
            public int readNBytes(byte[] b, int off, int len) throws IOException {
                try {
                    int res = this.delegate.readNBytes(b, off, len);
                    LOG.debug("inputstream.readNBytes(byte[] b, int off=" + off + ", int len=" + len + ") for " + this.uri.toASCIIString() + " returns " + res);
                    return res;
                }
                catch (IOException e) {
                    LOG.debug("Exception in inputstream.readNBytes(byte[] b, int off=" + off + ", int len=" + len + ") for " + this.uri.toASCIIString(), (Throwable)e);
                    throw e;
                }
            }

            @Override
            public long skip(long n) throws IOException {
                try {
                    long res = this.delegate.skip(n);
                    LOG.debug("inputstream.skip(long n=" + n + ") for " + this.uri.toASCIIString() + " returns " + res);
                    return res;
                }
                catch (IOException e) {
                    LOG.debug("Exception in inputstream.skip(long n=" + n + ") for " + this.uri.toASCIIString(), (Throwable)e);
                    throw e;
                }
            }

            @Override
            public int available() throws IOException {
                try {
                    int res = this.delegate.available();
                    LOG.debug("inputstream.available() for " + this.uri.toASCIIString() + " returns " + res);
                    return res;
                }
                catch (IOException e) {
                    LOG.debug("Exception in inputstream.available() for " + this.uri.toASCIIString(), (Throwable)e);
                    throw e;
                }
            }

            @Override
            public void close() throws IOException {
                try {
                    LOG.debug("inputstream.close() for " + this.uri.toASCIIString());
                    this.delegate.close();
                }
                catch (IOException e) {
                    LOG.debug("Exception in inputstream.close() for " + this.uri.toASCIIString(), (Throwable)e);
                    throw e;
                }
            }

            @Override
            public synchronized void mark(int readlimit) {
                LOG.debug("inputstream.mark(" + readlimit + ") for " + this.uri.toASCIIString());
                this.delegate.mark(readlimit);
            }

            @Override
            public synchronized void reset() throws IOException {
                try {
                    LOG.debug("inputstream.reset() for " + this.uri.toASCIIString());
                    this.delegate.reset();
                }
                catch (IOException e) {
                    LOG.debug("Exception in inputstream.reset() for " + this.uri.toASCIIString(), (Throwable)e);
                    throw e;
                }
            }

            @Override
            public boolean markSupported() {
                return this.delegate.markSupported();
            }

            @Override
            public long transferTo(OutputStream out) throws IOException {
                try {
                    long res = this.delegate.transferTo(out);
                    LOG.debug("inputstream.transferTo(OutputStream out) for " + this.uri.toASCIIString() + " returns " + res);
                    return res;
                }
                catch (IOException e) {
                    LOG.debug("Exception in inputstream.transferTo(OutputStream out) for " + this.uri.toASCIIString(), (Throwable)e);
                    throw e;
                }
            }
        }
    }

    private static class DebugOutputStream
    extends OutputStream {
        private final OutputStream delegate;

        private DebugOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public void write(int b) throws IOException {
            LOG.debug("write(b=" + b + ")");
            this.delegate.write(b);
        }

        @Override
        public void write(@NotNull byte[] b) throws IOException {
            if (b.length < 200) {
                String s = new String(b, StandardCharsets.UTF_8);
                LOG.debug("write(b='" + s + "')");
            } else {
                LOG.debug("write(b[].length=" + b.length + ")");
            }
            this.delegate.write(b);
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) throws IOException {
            if (len < 200) {
                String s = new String(b, off, len, StandardCharsets.UTF_8);
                LOG.debug("write(b='" + s + "', off=" + off + ", len=" + len + ")");
            } else {
                LOG.debug("write(b[].length=" + b.length + ", off=" + off + ", len=" + len + ")");
            }
            this.delegate.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            LOG.debug("flush()");
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            LOG.debug("close()");
            this.delegate.close();
        }
    }
}

