/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.dialogs;

import be.iminds.ilabt.jfed.experimenter_gui.dialogs.DialogsFactory;
import be.iminds.ilabt.jfed.highlevel.jobs.TestLinksJob;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.ui.javafx.util.InformationLabel;
import java.util.List;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Window;
import javafx.util.Pair;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.controlsfx.glyphfont.FontAwesome;

public class LinkTestDialog
extends VBox {
    @Nullable
    private final Window parentWindow;
    private final Dialog<Void> dialog;
    @Nonnull
    private final ObservableList<TestLinksJob.LinkTestReport> reports = FXCollections.observableArrayList();
    @Nonnull
    private DialogsFactory dialogFactory;
    @FXML
    private TableView<TestLinksJob.LinkTestReport> linkTestTableView;
    @FXML
    private TableColumn<TestLinksJob.LinkTestReport, String> nodeTableColumn;
    @FXML
    private TableColumn<TestLinksJob.LinkTestReport, String> linkToTableColumn;
    @FXML
    private TableColumn<TestLinksJob.LinkTestReport, String> ifaceTableColumn;
    @FXML
    private TableColumn<TestLinksJob.LinkTestReport, Pair<Boolean, String>> connectivityTableColumn;
    @FXML
    private TableColumn<TestLinksJob.LinkTestReport, Pair<Boolean, String>> speedHeaderColumn;
    @FXML
    private TableColumn<TestLinksJob.LinkTestReport, Pair<Boolean, String>> bwTableColumn;
    @FXML
    private TableColumn<TestLinksJob.LinkTestReport, Pair<Boolean, String>> linkSpeedTableColumn;
    @FXML
    private TableColumn<TestLinksJob.LinkTestReport, Number> expectedSpeedColumn;
    @FXML
    private InformationLabel sliceTerminationLabel;

    LinkTestDialog(@Nullable Window parentWindow, @Nonnull List<TestLinksJob.LinkTestReport> reports) {
        this.parentWindow = parentWindow;
        this.reports.addAll(reports);
        FXMLUtil.injectFXML((Object)((Object)this));
        DialogPane dialogPane = new DialogPane();
        dialogPane.setHeaderText("Link Test Results");
        dialogPane.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.STETHOSCOPE, (Color)Color.BLUE));
        dialogPane.setContent((Node)this);
        dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CLOSE});
        this.dialog = new Dialog();
        if (parentWindow != null) {
            this.dialog.initOwner(parentWindow);
        }
        this.dialog.setDialogPane(dialogPane);
        this.dialog.setTitle("Link Test Results");
        this.dialog.setResizable(true);
    }

    @FXML
    private void initialize() {
        double lastColumnWidth = this.connectivityTableColumn.getWidth() + this.ifaceTableColumn.getWidth() + this.speedHeaderColumn.getWidth();
        DoubleBinding dividableWidth = this.linkTestTableView.widthProperty().subtract(lastColumnWidth).subtract(5);
        this.nodeTableColumn.prefWidthProperty().bind((ObservableValue)dividableWidth.multiply(0.5));
        this.linkToTableColumn.prefWidthProperty().bind((ObservableValue)dividableWidth.multiply(0.5));
        this.linkTestTableView.setItems(this.reports);
        this.linkTestTableView.setPrefHeight((double)(26 + this.reports.size() * 25));
        this.nodeTableColumn.setCellValueFactory(t -> ((TestLinksJob.LinkTestReport)t.getValue()).getFrom().clientIdProperty());
        this.linkToTableColumn.setCellValueFactory(t -> ((TestLinksJob.LinkTestReport)t.getValue()).getTo().clientIdProperty());
        this.ifaceTableColumn.setCellValueFactory(t -> new SimpleStringProperty(((TestLinksJob.LinkTestReport)t.getValue()).getIfaceDevName()));
        this.connectivityTableColumn.setCellValueFactory(t -> new SimpleObjectProperty((Object)new Pair((Object)((TestLinksJob.LinkTestReport)t.getValue()).isConnectivityOk(), null)));
        this.bwTableColumn.setCellValueFactory(t -> new SimpleObjectProperty((Object)new Pair((Object)((TestLinksJob.LinkTestReport)t.getValue()).isThroughputOk(), (Object)("" + ((TestLinksJob.LinkTestReport)t.getValue()).getActualThroughput_mbps()))));
        this.expectedSpeedColumn.setCellValueFactory(t -> new SimpleIntegerProperty(((TestLinksJob.LinkTestReport)t.getValue()).getExpectedLinkSpeed_mbps()));
        this.linkSpeedTableColumn.setCellValueFactory(t -> new SimpleObjectProperty((Object)new Pair((Object)((TestLinksJob.LinkTestReport)t.getValue()).isLinkSpeedSettingOk(), (Object)("" + ((TestLinksJob.LinkTestReport)t.getValue()).getActualLinkSpeedSetting_mbps()))));
        this.connectivityTableColumn.setCellFactory(col -> new SummaryTableCell());
        this.bwTableColumn.setCellFactory(col -> new SummaryTableCell());
        this.linkSpeedTableColumn.setCellFactory(col -> new SummaryTableCell());
        this.linkTestTableView.getSelectionModel().selectedItemProperty().addListener((o, oldSelected, newSelected) -> {
            if (newSelected != null) {
                JFDialogs.create().owner(this.getScene().getWindow()).message(newSelected.getDebug()).showInformation();
            }
        });
    }

    public void showDialog() {
        this.dialog.showAndWait();
    }

    private static class SummaryTableCell
    extends TableCell<TestLinksJob.LinkTestReport, Pair<Boolean, String>> {
        private final Label summaryLabel = new Label();

        private SummaryTableCell() {
        }

        public void updateItem(Pair<Boolean, String> item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setGraphic(null);
            } else {
                this.summaryLabel.setGraphic((Node)((Boolean)item.getKey() != false ? GlyphUtils.createSmallGlyph((FontAwesome.Glyph)FontAwesome.Glyph.THUMBS_UP, (Color)Color.GREEN) : GlyphUtils.createSmallGlyph((FontAwesome.Glyph)FontAwesome.Glyph.THUMBS_DOWN, (Color)Color.RED)));
                this.summaryLabel.setText((String)item.getValue());
                this.setGraphic((Node)this.summaryLabel);
            }
        }
    }
}

