/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.dialogs;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.events.OpenESpecEvent;
import be.iminds.ilabt.jfed.experimenter_gui.ext_requests.JFedEnvironment;
import be.iminds.ilabt.jfed.experimenter_gui.util.BrowserUtil;
import be.iminds.ilabt.jfed.git.GitFetcherCommandBuilder;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.StackPane;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenESpecController
extends StackPane {
    private static final Logger LOG = LoggerFactory.getLogger(OpenESpecController.class);
    @Nonnull
    private final HighLevelTaskFactory hltf;
    @Nonnull
    private final GeniUserProvider geniUserProvider;
    @Nonnull
    private final SfaModel sfaModel;
    @Nonnull
    private final JFedEnvironment environment;
    @Nonnull
    private final JFedGuiConfig config;
    @Nonnull
    private final JFedHLPreferences preferences;
    @Nonnull
    private final JFedGuiConfig guiConfig;
    private EventHandler<ActionEvent> actionEventHandler;
    private ObjectBinding<OpenESpecEvent.ESpecSource> especSource;
    private BooleanBinding valid;
    @Nonnull
    private final BrowserUtil browserUtil;
    @FXML
    protected ToggleGroup sourceToggleGroup;
    @FXML
    protected RadioButton archiveSourceButton;
    @FXML
    protected RadioButton dirSourceButton;
    @FXML
    protected RadioButton urlSourceButton;
    @FXML
    protected RadioButton gitSourceButton;
    @FXML
    protected TextField openArchiveTextField;
    @FXML
    protected TextField openDirTextField;
    @FXML
    protected TextField openURLTextField;
    @FXML
    protected TextField openGitRepoTextField;
    @FXML
    protected TextField openGitDirTextField;
    @FXML
    protected TextField openGitBranchTextField;
    @FXML
    protected CheckBox useGitDirCheckBox;
    @FXML
    protected CheckBox useGitBranchCheckBox;
    @FXML
    private Button especDocumentationButton;

    @Inject
    OpenESpecController(@Nonnull HighLevelTaskFactory hltf, @Nonnull GeniUserProvider geniUserProvider, @Nonnull SfaModel sfaModel, @Nonnull JFedEnvironment environment, @Nonnull JFedGuiConfig config, @Nonnull JFedHLPreferences preferences, @Nonnull JFedGuiConfig guiConfig, @Nonnull BrowserUtil browserUtil) {
        this.hltf = hltf;
        this.geniUserProvider = geniUserProvider;
        this.sfaModel = sfaModel;
        this.environment = environment;
        this.config = config;
        this.preferences = preferences;
        this.guiConfig = guiConfig;
        this.browserUtil = browserUtil;
    }

    @FXML
    public void initialize() {
        EventHandler eventPasser = event -> {
            if (this.actionEventHandler != null) {
                this.actionEventHandler.handle(event);
            }
        };
        this.openArchiveTextField.setOnAction(eventPasser);
        this.openDirTextField.setOnAction(eventPasser);
        this.openURLTextField.setOnAction(eventPasser);
        this.openGitRepoTextField.setOnAction(eventPasser);
        String initialEspec = this.preferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_LAST_OPENED_ESPEC);
        if (initialEspec == null) {
            initialEspec = this.guiConfig.getStringFlag("defaultESpecUrl");
        }
        if (initialEspec != null && !initialEspec.trim().isEmpty()) {
            if (initialEspec.startsWith("git ") || initialEspec.startsWith("github ")) {
                this.gitSourceButton.setSelected(true);
                Optional help = GitFetcherCommandBuilder.fromString((String)initialEspec);
                if (help.isPresent()) {
                    this.openGitRepoTextField.setText(((GitFetcherCommandBuilder)help.get()).getGitUrl());
                    if (((GitFetcherCommandBuilder)help.get()).getBranch() != null && !((GitFetcherCommandBuilder)help.get()).getBranch().trim().isEmpty()) {
                        this.useGitBranchCheckBox.setSelected(true);
                        this.openGitBranchTextField.setText(((GitFetcherCommandBuilder)help.get()).getBranch());
                    } else {
                        this.useGitBranchCheckBox.setSelected(false);
                    }
                    if (((GitFetcherCommandBuilder)help.get()).getRepoSubDir() != null && !((GitFetcherCommandBuilder)help.get()).getRepoSubDir().trim().isEmpty()) {
                        this.useGitDirCheckBox.setSelected(true);
                        this.openGitDirTextField.setText(((GitFetcherCommandBuilder)help.get()).getRepoSubDir());
                    } else {
                        this.useGitDirCheckBox.setSelected(false);
                    }
                }
            } else if (initialEspec.startsWith("http")) {
                this.urlSourceButton.setSelected(true);
                this.openURLTextField.setText(initialEspec);
            } else if (initialEspec.endsWith("/") || new File(initialEspec).isDirectory()) {
                this.dirSourceButton.setSelected(true);
                this.openDirTextField.setText(initialEspec);
            } else {
                this.archiveSourceButton.setSelected(true);
                this.openArchiveTextField.setText(initialEspec);
            }
        }
        this.especDocumentationButton.setOnAction(event -> {
            LOG.info("Clicked documentation button to ESpec documentation at https://jfed.ilabt.imec.be/espec/");
            this.browserUtil.openUrlInBrowser("https://jfed.ilabt.imec.be/espec/");
        });
        this.especSource = Bindings.createObjectBinding(this::getESpecSource, (Observable[])new Observable[]{this.sourceToggleGroup.selectedToggleProperty()});
        BooleanBinding archiveBooleanBinding = Bindings.createBooleanBinding(() -> {
            if (this.openArchiveTextField.getText() == null || this.openArchiveTextField.getText().trim().isEmpty()) {
                return false;
            }
            return new File(this.openArchiveTextField.getText()).exists();
        }, (Observable[])new Observable[]{this.openArchiveTextField.textProperty()});
        BooleanBinding dirBooleanBinding = Bindings.createBooleanBinding(() -> {
            if (this.openDirTextField.getText() == null || this.openDirTextField.getText().trim().isEmpty()) {
                return false;
            }
            return new File(this.openDirTextField.getText()).isDirectory();
        }, (Observable[])new Observable[]{this.openDirTextField.textProperty()});
        BooleanBinding urlBooleanBinding = Bindings.createBooleanBinding(() -> {
            if (this.openURLTextField.getText() == null || this.openURLTextField.getText().trim().isEmpty()) {
                return false;
            }
            try {
                new URL(this.openURLTextField.getText());
                return true;
            }
            catch (MalformedURLException e) {
                return false;
            }
        }, (Observable[])new Observable[]{this.openURLTextField.textProperty()});
        BooleanBinding gitBooleanBinding = Bindings.createBooleanBinding(() -> {
            if (this.openGitRepoTextField.getText() == null || this.openGitRepoTextField.getText().trim().isEmpty()) {
                return false;
            }
            if (this.useGitBranchCheckBox.isSelected() && (this.openGitBranchTextField.getText() == null || this.openGitBranchTextField.getText().trim().isEmpty())) {
                return false;
            }
            if (this.useGitDirCheckBox.isSelected() && (this.openGitDirTextField.getText() == null || this.openGitDirTextField.getText().trim().isEmpty())) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.openGitRepoTextField.textProperty(), this.useGitBranchCheckBox.selectedProperty(), this.openGitBranchTextField.textProperty(), this.useGitDirCheckBox.selectedProperty(), this.openGitDirTextField.textProperty()});
        this.valid = Bindings.when((ObservableBooleanValue)Bindings.equal(this.especSource, (Object)((Object)OpenESpecEvent.ESpecSource.ARCHIVE))).then((ObservableBooleanValue)archiveBooleanBinding).otherwise((ObservableBooleanValue)Bindings.when((ObservableBooleanValue)Bindings.equal(this.especSource, (Object)((Object)OpenESpecEvent.ESpecSource.DIR))).then((ObservableBooleanValue)dirBooleanBinding).otherwise((ObservableBooleanValue)Bindings.when((ObservableBooleanValue)Bindings.equal(this.especSource, (Object)((Object)OpenESpecEvent.ESpecSource.URL))).then((ObservableBooleanValue)urlBooleanBinding).otherwise((ObservableBooleanValue)Bindings.when((ObservableBooleanValue)Bindings.equal(this.especSource, (Object)((Object)OpenESpecEvent.ESpecSource.GIT))).then((ObservableBooleanValue)gitBooleanBinding).otherwise(false))));
    }

    @Nullable
    private static File sanitizeFolder(@Nullable String folderPath) {
        File dirFile = null;
        if (folderPath != null) {
        } else {
            return null;
        }
        for (dirFile = new File(folderPath); dirFile != null && !dirFile.exists() && dirFile.getParentFile() != null; dirFile = dirFile.getParentFile()) {
        }
        while (dirFile != null && !dirFile.isDirectory()) {
            dirFile = dirFile.getParentFile();
        }
        return dirFile;
    }

    @FXML
    public void openArchiveAction() {
        FileChooser fc = new FileChooser();
        fc.setTitle("Open Experiment Specification");
        String initialDir = this.preferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_LAST_OPENED_ESPEC);
        if (initialDir == null && this.preferences.hasKey((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_ESPEC_FILE_DIR)) {
            initialDir = this.preferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_ESPEC_FILE_DIR);
        }
        if (initialDir == null && this.preferences.hasKey((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_ESPEC_DIR_DIR)) {
            initialDir = this.preferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_ESPEC_DIR_DIR);
        }
        if (initialDir == null && System.getProperty("user.home") != null) {
            initialDir = System.getProperty("user.home");
        }
        fc.setInitialDirectory(OpenESpecController.sanitizeFolder(initialDir));
        File file = fc.showOpenDialog(this.openArchiveTextField.getScene().getWindow());
        if (file != null) {
            this.openArchiveTextField.setText(file.getPath());
            if (file.getParentFile() != null) {
                this.preferences.setString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_ESPEC_FILE_DIR, file.getParentFile().getPath());
            }
        }
    }

    @FXML
    public void openDirAction() {
        DirectoryChooser dc = new DirectoryChooser();
        dc.setTitle("Open Experiment Specification");
        String initialDir = this.preferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_LAST_OPENED_ESPEC);
        if (initialDir == null && this.preferences.hasKey((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_ESPEC_DIR_DIR)) {
            initialDir = this.preferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_ESPEC_DIR_DIR);
        }
        if (initialDir == null && this.preferences.hasKey((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_ESPEC_FILE_DIR)) {
            initialDir = this.preferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_ESPEC_FILE_DIR);
        }
        if (initialDir == null && System.getProperty("user.home") != null) {
            initialDir = System.getProperty("user.home");
        }
        dc.setInitialDirectory(OpenESpecController.sanitizeFolder(initialDir));
        File file = dc.showDialog(this.openDirTextField.getScene().getWindow());
        if (file != null) {
            this.openDirTextField.setText(file.getPath());
            this.preferences.setString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_ESPEC_DIR_DIR, file.getPath());
        }
    }

    private OpenESpecEvent.ESpecSource getESpecSource() {
        if (this.archiveSourceButton.isSelected()) {
            return OpenESpecEvent.ESpecSource.ARCHIVE;
        }
        if (this.dirSourceButton.isSelected()) {
            return OpenESpecEvent.ESpecSource.DIR;
        }
        if (this.urlSourceButton.isSelected()) {
            return OpenESpecEvent.ESpecSource.URL;
        }
        if (this.gitSourceButton.isSelected()) {
            return OpenESpecEvent.ESpecSource.GIT;
        }
        throw new IllegalStateException("Radiobuttons are not in an allowed state!");
    }

    public void setOnAction(EventHandler<ActionEvent> actionEventHandler) {
        this.actionEventHandler = actionEventHandler;
    }

    public boolean isValid() {
        return this.valid.get();
    }

    public BooleanBinding validProperty() {
        return this.valid;
    }

    @Nonnull
    public String getESpecSourceString() {
        switch (this.getESpecSource()) {
            case ARCHIVE: {
                return this.openArchiveTextField.getText();
            }
            case DIR: {
                return this.openDirTextField.getText();
            }
            case URL: {
                return this.openURLTextField.getText();
            }
            case GIT: {
                Object res = "git ";
                if (this.openGitRepoTextField.getText().contains("github")) {
                    res = "github ";
                }
                res = (String)res + this.openGitRepoTextField.getText();
                if (this.useGitBranchCheckBox.isSelected() || this.useGitDirCheckBox.isSelected()) {
                    res = this.useGitDirCheckBox.isSelected() ? (String)res + " " + this.openGitDirTextField.getText() : (String)res + " /";
                }
                if (this.useGitBranchCheckBox.isSelected()) {
                    res = (String)res + " " + this.openGitBranchTextField.getText();
                }
                return res;
            }
        }
        throw new IllegalStateException("Unhandled ESpec Source: " + String.valueOf((Object)this.getESpecSource()));
    }
}

