/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.dialogs;

import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.OpenESpecController;
import be.iminds.ilabt.jfed.experimenter_gui.events.OpenESpecEvent;
import be.iminds.ilabt.jfed.experimenter_gui.util.ui.UIUtils;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.GuiceFXMLUtil;
import com.google.common.eventbus.EventBus;
import java.net.MalformedURLException;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.paint.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenESpecDialog
extends Dialog<ButtonType> {
    private static final Logger LOG = LoggerFactory.getLogger(OpenESpecDialog.class);
    @Nonnull
    private final OpenESpecController controller;
    @Nonnull
    private final JFedPreferences jFedPreferences;
    @Nonnull
    private final AuthorityFinder authorityFinder;
    @Nonnull
    private final GeniUserProvider geniUserProvider;
    @Nonnull
    private final EventBus eventBus;
    @Nullable
    private ExperimentController experimentController;

    @Inject
    public OpenESpecDialog(@Nonnull GuiceFXMLUtil guiceFXMLUtil, @Nonnull JFedPreferences jFedPreferences, @Nonnull AuthorityFinder authorityFinder, @Nonnull GeniUserProvider geniUserProvider, @Nonnull EventBus eventBus) {
        this.jFedPreferences = jFedPreferences;
        this.authorityFinder = authorityFinder;
        this.geniUserProvider = geniUserProvider;
        this.eventBus = eventBus;
        GuiceFXMLUtil.Result result = guiceFXMLUtil.createFromFXML(OpenESpecController.class);
        this.controller = (OpenESpecController)((Object)result.getController());
        this.setTitle("Start Experiment using ESpec");
        this.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.FLASK, (Color)Color.CHOCOLATE));
        this.setHeaderText("Choose an ESpec");
        this.getDialogPane().setContent((Node)UIUtils.wrapWithDecorationPane((Node)result.getRoot()));
        this.setResizable(true);
        ButtonType openESpecAction = new ButtonType("Start ESpec", ButtonBar.ButtonData.OK_DONE);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{openESpecAction, ButtonType.CANCEL});
        Button openESpecButton = (Button)this.getDialogPane().lookupButton(openESpecAction);
        openESpecButton.disableProperty().bind((ObservableValue)this.controller.validProperty().not());
        EventHandler openESpecEventHandler = event -> {
            if (this.controller.isValid()) {
                this.openESpec();
            }
            event.consume();
        };
        openESpecButton.addEventFilter(ActionEvent.ACTION, openESpecEventHandler);
        this.controller.setOnAction((EventHandler<ActionEvent>)openESpecEventHandler);
    }

    private void openESpec() {
        this.hide();
        try {
            OpenESpecEvent openESpecEvent = new OpenESpecEvent(this.experimentController, this.controller.getESpecSourceString());
            LOG.info("User pressed \"Open Espec\" button: {}", (Object)openESpecEvent);
            this.eventBus.post((Object)openESpecEvent);
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_LAST_OPENED_ESPEC, this.controller.getESpecSourceString());
        }
        catch (MalformedURLException e) {
            LOG.error("User pressed \"Open Espec\" button, but caused MalformedURLException.", (Throwable)e);
        }
    }

    public void setExperimentController(ExperimentController experimentController) {
        this.experimentController = experimentController;
    }
}

