/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.dialogs;

import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticAggregateManagerWrapper;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.ui.javafx.util.InformationLabel;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.Dialog;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Window;
import javafx.util.Callback;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebootDialog
extends BorderPane {
    private static final Logger LOG = LoggerFactory.getLogger(RebootDialog.class);
    @Nullable
    private final Window parentStage;
    @Nonnull
    private final ExperimentController experimentController;
    @Nonnull
    private final AutomaticAggregateManagerWrapper.AutomaticAggregateManagerWrapperFactory automaticAggregateManagerWrapperFactory;
    @Nonnull
    private final Slice slice;
    private final TreeView<Rebootable> treeView;
    private final boolean hasRebootableItems;
    private final CheckBoxTreeItem<Rebootable> rootItem;

    public RebootDialog(@Nullable Window parent, @Nonnull ExperimentController experimentController, @Nonnull AutomaticAggregateManagerWrapper.AutomaticAggregateManagerWrapperFactory automaticAggregateManagerWrapperFactory) {
        if (experimentController.getExperiment().getSliceOrNull() == null) {
            throw new IllegalArgumentException("Can't create RenewSliceDialog if there experiment has slice == null");
        }
        this.parentStage = parent;
        this.experimentController = experimentController;
        this.automaticAggregateManagerWrapperFactory = automaticAggregateManagerWrapperFactory;
        this.slice = experimentController.getExperiment().getSliceOrNull();
        VBox center = new VBox(10.0);
        this.setCenter((Node)center);
        ArrayList<String> informations = new ArrayList<String>();
        boolean hasRebootableItems = false;
        this.treeView = new TreeView();
        this.treeView.setEditable(true);
        this.treeView.setCellFactory((Callback)new Callback<TreeView<Rebootable>, TreeCell<Rebootable>>(){

            public TreeCell<Rebootable> call(TreeView<Rebootable> rebootableTreeView) {
                return new CheckBoxTreeCell<Rebootable>(){

                    public void updateItem(Rebootable rebootable, boolean empty) {
                        super.updateItem((Object)rebootable, empty);
                        if (rebootable != null && !empty) {
                            this.setEditable(rebootable.isRebootable());
                        }
                    }
                };
            }
        });
        this.rootItem = new CheckBoxTreeItem((Object)new RebootableExperiment());
        this.rootItem.setExpanded(true);
        this.treeView.setRoot(this.rootItem);
        int itemsCount = 1;
        for (ExperimentPart experimentPart : experimentController.getExperiment().getPartsListCopy()) {
            if (!(experimentPart instanceof SfaExperimentPart)) continue;
            SfaExperimentPart sfaExperimentPart = (SfaExperimentPart)experimentPart;
            CheckBoxTreeItem authorityTreeItem = new CheckBoxTreeItem((Object)new RebootableExperimentPart(sfaExperimentPart));
            authorityTreeItem.setExpanded(true);
            assert (sfaExperimentPart.getSlivers() != null);
            for (Sliver sliver : sfaExperimentPart.getSlivers()) {
                Collection nodes = sliver.getNodes();
                if (nodes == null || nodes.isEmpty()) continue;
                RebootableSliver rebootableSliver = new RebootableSliver(sliver, nodes);
                if (rebootableSliver.isRebootable()) {
                    LOG.debug("RebootDialog: Found rebootable sliver: " + rebootableSliver.getSliver().getUrnString());
                    authorityTreeItem.getChildren().add((Object)new CheckBoxTreeItem((Object)rebootableSliver));
                    continue;
                }
                LOG.debug("RebootDialog: Found NON-rebootable sliver: " + rebootableSliver.getSliver().getUrnString());
            }
            LOG.debug("RebootDialog: " + experimentPart.getName() + " has " + authorityTreeItem.getChildren().size() + " rebootable resources");
            if (!authorityTreeItem.getChildren().isEmpty()) {
                this.rootItem.getChildren().add((Object)authorityTreeItem);
                hasRebootableItems = true;
                itemsCount += authorityTreeItem.getChildren().size() + 1;
                continue;
            }
            informations.add(String.format("%s does not have rebootable resources.", experimentPart.getName()));
        }
        this.rootItem.setSelected(true);
        this.treeView.setPrefWidth(100.0);
        this.treeView.setPrefHeight((double)Math.min(Math.max(1 + itemsCount * 35, 250), 800));
        center.getChildren().add(this.treeView);
        if (!informations.isEmpty()) {
            InformationLabel label = new InformationLabel(Joiner.on((String)"\n").join(informations));
            center.getChildren().add((Object)label);
        }
        this.hasRebootableItems = hasRebootableItems;
        LOG.debug("RebootDialog: final verdict: there are " + (hasRebootableItems ? " " : "no ") + "reboo.getDefaultComponentManagerUrn() in slice " + this.slice.getUrnString());
    }

    public void showDialog() {
        if (!this.hasRebootableItems) {
            JFDialogs.create().owner(this.parentStage).message("This experiment doesn't contain any resources that support rebooting.").masthead("Rebooting is unavailable").showWarning();
            return;
        }
        Dialog dialog = new Dialog();
        dialog.initOwner(this.parentStage);
        dialog.setTitle("Reboot experiment nodes");
        dialog.setHeaderText("Please select the testbeds on which the nodes must be rebooted");
        dialog.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.POWER_OFF, (Color)Color.RED));
        dialog.getDialogPane().setContent((Node)this);
        dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        Node okButton = dialog.getDialogPane().lookupButton(ButtonType.OK);
        okButton.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)Bindings.or((ObservableBooleanValue)this.rootItem.selectedProperty(), (ObservableBooleanValue)this.rootItem.indeterminateProperty())));
        Optional response = dialog.showAndWait();
        if (response.isPresent() && response.get() != ButtonType.OK) {
            return;
        }
        long numberOfSliversSelected = this.treeView.getRoot().getChildren().stream().flatMap(item -> item.getChildren().stream()).filter(item -> ((CheckBoxTreeItem)item).isSelected()).count();
        if (numberOfSliversSelected > 0L) {
            Alert confirmAlert = new Alert(Alert.AlertType.WARNING);
            confirmAlert.setContentText(String.format("You are about to reboot %d sliver(s). All data in memory WILL BE LOST. Are you sure that you want to continue?", numberOfSliversSelected));
            confirmAlert.setTitle("Rebooting slivers");
            confirmAlert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
            confirmAlert.setResizable(true);
            ButtonType rebootButtonType = new ButtonType("Reboot slivers", ButtonBar.ButtonData.OTHER);
            confirmAlert.getButtonTypes().setAll((Object[])new ButtonType[]{rebootButtonType, ButtonType.CANCEL});
            ((Button)confirmAlert.getDialogPane().lookupButton(ButtonType.CANCEL)).setDefaultButton(true);
            if (confirmAlert.showAndWait().orElse(ButtonType.CANCEL) == ButtonType.CANCEL) {
                return;
            }
        }
        for (TreeItem child : this.treeView.getRoot().getChildren()) {
            this.processTreeItem((CheckBoxTreeItem<Rebootable>)((CheckBoxTreeItem)child));
        }
    }

    private void processTreeItem(CheckBoxTreeItem<Rebootable> treeItem) {
        if (!treeItem.isIndeterminate() && treeItem.isSelected()) {
            ((Rebootable)treeItem.getValue()).reboot();
        } else {
            for (TreeItem child : treeItem.getChildren()) {
                this.processTreeItem((CheckBoxTreeItem<Rebootable>)((CheckBoxTreeItem)child));
            }
        }
    }

    private static class RebootableExperiment
    implements Rebootable {
        private RebootableExperiment() {
        }

        @Override
        public void reboot() {
        }

        @Override
        public boolean isRebootable() {
            return true;
        }

        public String toString() {
            return "All nodes";
        }
    }

    private class RebootableExperimentPart
    implements Rebootable {
        private final SfaExperimentPart experimentPart;
        private final boolean canReboot;

        private RebootableExperimentPart(SfaExperimentPart experimentPart) {
            this.experimentPart = experimentPart;
            this.canReboot = RebootDialog.this.automaticAggregateManagerWrapperFactory.create(experimentPart.getConnectSfaAuthority()).isRestartSupported();
        }

        public Server getAuthority() {
            return this.experimentPart.getConnectSfaAuthority();
        }

        @Override
        public boolean isRebootable() {
            return this.canReboot;
        }

        @Override
        public void reboot() {
            RebootDialog.this.experimentController.reboot((ExperimentPart)this.experimentPart);
        }

        public String toString() {
            return this.experimentPart.getName();
        }
    }

    private class RebootableSliver
    implements Rebootable {
        private final Sliver sliver;
        private final boolean canReboot;
        private final Collection<RspecNode> nodes;

        private RebootableSliver(Sliver sliver, Collection<RspecNode> nodes) {
            this.sliver = sliver;
            this.nodes = nodes;
            this.canReboot = RebootDialog.this.automaticAggregateManagerWrapperFactory.create(sliver.getServer()).isRestartSupported();
        }

        public Sliver getSliver() {
            return this.sliver;
        }

        @Override
        public boolean isRebootable() {
            return this.canReboot;
        }

        @Override
        public void reboot() {
            RebootDialog.this.experimentController.reboot(this.sliver);
        }

        public String toString() {
            return this.nodes.stream().map(rspecNode -> rspecNode.getClientId() != null ? rspecNode.getClientId() : "<NO ID>").collect(Collectors.joining(", "));
        }
    }

    private static interface Rebootable {
        public void reboot();

        public boolean isRebootable();
    }
}

