/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.dialogs;

import be.iminds.ilabt.jfed.experimenter_gui.tasks.FetchAllSlicesInfoTask;
import be.iminds.ilabt.jfed.experimenter_gui.tasks.TasksFactory;
import be.iminds.ilabt.jfed.experimenter_gui.ui.progressbar.TaskService;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.util.TimeUtils;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import javax.inject.Inject;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoverSliceController {
    private static final Logger LOG = LoggerFactory.getLogger(RecoverSliceController.class);
    private static final DateTimeFormatter EXPIRATION_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private static final String ALL_PROJECTS = "All projects";
    @FXML
    private TextField nameFilterTextField;
    @FXML
    private ComboBox<String> projectFilterComboBox;
    @FXML
    private TableView<Slice> slicesTableView;
    @FXML
    private TableColumn<Slice, Boolean> sliceHasSliversTableColumn;
    @FXML
    private TableColumn<Slice, String> sliceNameTableColumn;
    @FXML
    private TableColumn<Slice, String> subAuthTableColumn;
    @FXML
    private TableColumn<Slice, Instant> expirationTableColumn;
    @FXML
    private HBox initializingBox;
    @FXML
    private CheckBox showRawDateCheckBox;
    private BooleanProperty showRawDateProperty = new SimpleBooleanProperty(false);
    @FXML
    private ProgressIndicator refreshProgressIndicator;
    @FXML
    private Label refreshLabel;
    private final SfaModel sfaModel;
    private final HighLevelTaskFactory hltf;
    private final TasksFactory tasksFactory;
    private final TaskService taskService;
    private Consumer<MouseEvent> onDoubleClickEvent = null;
    private final EventHandler<MouseEvent> mouseEventEventHandler = mouseEvent -> {
        if (mouseEvent.getClickCount() == 2 && this.onDoubleClickEvent != null) {
            this.onDoubleClickEvent.accept((MouseEvent)mouseEvent);
        }
    };

    @Inject
    RecoverSliceController(SfaModel sfaModel, HighLevelTaskFactory hltf, TasksFactory tasksFactory, TaskService taskService) {
        this.sfaModel = sfaModel;
        this.hltf = hltf;
        this.tasksFactory = tasksFactory;
        this.taskService = taskService;
    }

    @FXML
    public void initialize() {
        SortedList sortedSlices = new SortedList(this.sfaModel.getSlices(), Comparator.comparing(Slice::getHasActiveSlivers, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(Slice::getName, String.CASE_INSENSITIVE_ORDER));
        FilteredList filteredAndSortedSlices = new FilteredList((ObservableList)sortedSlices);
        this.slicesTableView.setItems((ObservableList)filteredAndSortedSlices);
        this.slicesTableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.sliceNameTableColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((Slice)param.getValue()).getName()));
        this.sliceNameTableColumn.setCellFactory(sliceStringTableColumn -> new SliceStringTableCell());
        this.sliceHasSliversTableColumn.setCellValueFactory(t -> ((Slice)t.getValue()).hasActiveSliversProperty());
        this.sliceHasSliversTableColumn.setCellFactory((Callback)new Callback<TableColumn<Slice, Boolean>, TableCell<Slice, Boolean>>(){

            public TableCell<Slice, Boolean> call(TableColumn<Slice, Boolean> sliceStringTableColumn) {
                return new TableCell<Slice, Boolean>(){
                    {
                        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                        this.setAlignment(Pos.CENTER);
                        this.setOnMouseClicked(RecoverSliceController.this.mouseEventEventHandler);
                    }

                    protected void updateItem(Boolean hasActiveSlivers, boolean empty) {
                        super.updateItem((Object)hasActiveSlivers, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else if (Objects.equals(hasActiveSlivers, Boolean.FALSE)) {
                            this.setGraphic((Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.TIMES, (Color)Color.DARKGRAY));
                        } else if (Objects.equals(hasActiveSlivers, Boolean.TRUE)) {
                            this.setGraphic((Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.CHECK_SQUARE, (Color)Color.GREEN));
                        } else if (hasActiveSlivers == null) {
                            this.setGraphic((Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.QUESTION_CIRCLE, (Color)Color.BLACK));
                        }
                    }
                };
            }
        });
        this.subAuthTableColumn.setCellValueFactory(t -> new SimpleStringProperty(((Slice)t.getValue()).getSubAuthorityName()));
        this.subAuthTableColumn.setCellFactory(param -> new SliceStringTableCell());
        this.showRawDateCheckBox.selectedProperty().bindBidirectional((Property)this.showRawDateProperty);
        this.expirationTableColumn.setCellValueFactory(param -> ((Slice)param.getValue()).expirationDateProperty());
        Callback<TableColumn<Slice, Instant>, TableCell<Slice, Instant>> cellFactory = new Callback<TableColumn<Slice, Instant>, TableCell<Slice, Instant>>(){

            private String makeText(Instant expiration) {
                Duration duration = Duration.between(Instant.now(), expiration);
                if (RecoverSliceController.this.showRawDateProperty.get()) {
                    return EXPIRATION_TIME_FORMATTER.format(expiration.atZone(ZoneId.systemDefault()));
                }
                String humanDuration = TimeUtils.formatMillis((long)duration.toMillis(), (TimeUnit)TimeUnit.DAYS, (TimeUnit)TimeUnit.MINUTES, (int)2);
                return "in " + humanDuration;
            }

            public TableCell<Slice, Instant> call(TableColumn<Slice, Instant> param) {
                return new TableCell<Slice, Instant>(){

                    protected void updateItem(Instant item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        Slice slice = (Slice)this.getTableRow().getItem();
                        if (slice != null) {
                            if (item != null) {
                                this.setGraphic(null);
                                Duration duration = Duration.between(Instant.now(), item);
                                this.setText(this.makeText(item));
                                RecoverSliceController.this.showRawDateProperty.addListener((p, oldVal, newval) -> this.setText(this.makeText(item)));
                                if (duration.isNegative()) {
                                    this.setTextFill((Paint)Color.RED);
                                } else if (duration.toHours() < 12L) {
                                    this.setTextFill((Paint)Color.ORANGERED);
                                } else if (duration.toHours() < 24L) {
                                    this.setTextFill((Paint)Color.ORANGE);
                                } else if (duration.toDays() < 7L) {
                                    this.setTextFill((Paint)Color.GREEN);
                                } else {
                                    this.setTextFill((Paint)Color.DARKGREEN);
                                }
                                LOG.debug("Setting expiration time of {} to {}", (Object)slice.getName(), (Object)item);
                            } else {
                                ProgressIndicator progressIndicator = new ProgressIndicator(-1.0);
                                progressIndicator.setPrefSize(20.0, 20.0);
                                this.setGraphic((Node)progressIndicator);
                                this.setText(null);
                                LOG.debug("No expiration time available for {}", (Object)slice.getName());
                            }
                        } else {
                            this.setGraphic(null);
                            this.setText(null);
                        }
                    }
                };
            }
        };
        this.expirationTableColumn.setCellFactory((Callback)cellFactory);
        DoubleBinding safeWidth = this.slicesTableView.widthProperty().subtract(20);
        this.sliceHasSliversTableColumn.prefWidthProperty().bind((ObservableValue)safeWidth.multiply(0.1));
        this.sliceNameTableColumn.prefWidthProperty().bind((ObservableValue)safeWidth.multiply(0.4));
        this.subAuthTableColumn.prefWidthProperty().bind((ObservableValue)safeWidth.multiply(0.15));
        this.expirationTableColumn.prefWidthProperty().bind((ObservableValue)safeWidth.multiply(0.35));
        InvalidationListener filterListener = observable -> {
            String nameFilterText = this.nameFilterTextField.getText().trim().toLowerCase();
            String selectedProject = (String)this.projectFilterComboBox.getSelectionModel().getSelectedItem();
            filteredAndSortedSlices.setPredicate(slice -> !(!nameFilterText.isEmpty() && !slice.getName().toLowerCase().contains(nameFilterText) || selectedProject != null && !Objects.equals(ALL_PROJECTS, selectedProject) && !Objects.equals(selectedProject, slice.getSubAuthorityName())));
        };
        this.nameFilterTextField.textProperty().addListener(filterListener);
        this.projectFilterComboBox.getSelectionModel().selectedItemProperty().addListener(filterListener);
        this.sfaModel.getLoggedInUserSubAuthorityNames().addListener(obs -> {
            LOG.info("Subauthoritynames was updated!");
            this.updateProjectsList();
        });
        this.sfaModel.getSlices().addListener(obs -> {
            LOG.info("Slices was updated! Now {} items", (Object)this.sfaModel.getSlices().size());
            this.updateProjectsList();
        });
        this.updateProjectsList();
        javafx.concurrent.Task<Void> loadingTask = new javafx.concurrent.Task<Void>(){
            final Task resolveTask;
            {
                this.resolveTask = RecoverSliceController.this.hltf.resolveUserAndSlices();
            }

            protected Void call() throws Exception {
                while (this.resolveTask.isActive()) {
                    Thread.sleep(100L);
                }
                for (Slice slice : RecoverSliceController.this.sfaModel.getSlices()) {
                    while (RecoverSliceController.this.hltf.getAggregatesForSlice(slice).isActive()) {
                        Thread.sleep(100L);
                    }
                }
                return null;
            }

            protected void succeeded() {
                RecoverSliceController.this.initializingBox.setVisible(false);
            }
        };
        Thread thread = new Thread((Runnable)loadingTask);
        thread.setDaemon(true);
        thread.setName("Recover-Loading-Task");
        thread.start();
    }

    private void updateProjectsList() {
        ObservableList projects = FXCollections.observableArrayList();
        projects.add((Object)ALL_PROJECTS);
        projects.addAll((Collection)this.sfaModel.getLoggedInUserSubAuthorityNames().stream().sorted().collect(Collectors.toList()));
        this.projectFilterComboBox.setItems(projects);
        LOG.info("Updating project list with {} projects", (Object)projects.size());
        if (this.projectFilterComboBox.getSelectionModel().isEmpty()) {
            this.projectFilterComboBox.getSelectionModel().select((Object)ALL_PROJECTS);
        }
    }

    public void refreshSlicesList() {
        this.refreshProgressIndicator.visibleProperty().unbind();
        this.refreshLabel.textProperty().unbind();
        FetchAllSlicesInfoTask fetchAllSlicesInfoTask = this.tasksFactory.createFetchAllSlicesInfoTask();
        this.refreshProgressIndicator.visibleProperty().bind((ObservableValue)fetchAllSlicesInfoTask.runningProperty());
        this.refreshLabel.textProperty().bind((ObservableValue)fetchAllSlicesInfoTask.messageProperty());
        this.taskService.submitTask(fetchAllSlicesInfoTask);
    }

    public ObservableList<Slice> getSelectedSlices() {
        return this.slicesTableView.getSelectionModel().getSelectedItems();
    }

    public Consumer<MouseEvent> getOnDoubleClickEvent() {
        return this.onDoubleClickEvent;
    }

    public void setOnDoubleClickEvent(Consumer<MouseEvent> onDoubleClickEvent) {
        this.onDoubleClickEvent = onDoubleClickEvent;
    }

    private class SliceStringTableCell
    extends TableCell<Slice, String> {
        private SliceStringTableCell() {
            this.setOnMouseClicked(RecoverSliceController.this.mouseEventEventHandler);
        }

        protected void updateItem(String s, boolean b) {
            this.textFillProperty().unbind();
            this.setText(Objects.requireNonNullElse(s, ""));
            if (this.getTableRow().getItem() != null) {
                assert (this.getTableRow().getItem() != null);
                this.textFillProperty().bind((ObservableValue)new IsValueKnownPaintBinding((ObjectProperty<Boolean>)((Slice)this.getTableRow().getItem()).hasActiveSliversProperty()));
            }
        }
    }

    private static class IsValueKnownPaintBinding
    extends ObjectBinding<Paint> {
        private final ObjectProperty<Boolean> isKnownProperty;

        private IsValueKnownPaintBinding(ObjectProperty<Boolean> isKnownProperty) {
            this.isKnownProperty = isKnownProperty;
            this.bind(new Observable[]{isKnownProperty});
        }

        protected Paint computeValue() {
            if (Objects.equals(this.isKnownProperty.get(), Boolean.FALSE)) {
                return Color.GRAY;
            }
            return Color.BLACK;
        }
    }
}

